/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class RCMulticastServer {
    public static void main(String[] args) throws cMsgException {
        RCMulticastServer server = new RCMulticastServer();
        server.run();
    }

    public void run() throws cMsgException {
        System.out.println("Starting RC Multicast domain server");
        String UDL = "cMsg:rcm://45333/emutest";
        cMsg cmsg = new cMsg(UDL, "multicast listener", "udp trial");
        try {
            cmsg.connect();
        }
        catch (cMsgException e) {
            System.out.println(e.getMessage());
            return;
        }
        cmsg.start();
        MulticastCallback cb3 = new MulticastCallback();
        cmsg.subscribe("sub", "type", cb3, null);
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class RcServerReconnectThread
    extends Thread {
        String rcClientHost;
        String rcClientBroadcast;
        int rcClientTcpPort;

        RcServerReconnectThread(String host, String bcast, int port) {
            this.rcClientHost = host;
            this.rcClientBroadcast = bcast;
            this.rcClientTcpPort = port;
        }

        @Override
        public void run() {
            try {
                String rcsUDL = "cMsg:rcs://" + this.rcClientHost + ":" + this.rcClientTcpPort + "/" + this.rcClientBroadcast;
                cMsg server = new cMsg(rcsUDL, "rc server", "udp trial");
                server.connect();
                server.start();
                rcCallback cb22 = new rcCallback();
                cMsgSubscriptionHandle unsub = server.subscribe("subby", "typey", cb22, "1st sub");
                starCallback starCb = new starCallback();
                cMsgSubscriptionHandle unsub2 = server.subscribe("*", "*", starCb, "2nd sub");
                cMsgMessage msg = new cMsgMessage();
                msg.setSubject("rcSubject");
                msg.setType("rcType");
                int loops = 5;
                while (loops-- > 0) {
                    System.out.println("Send msg " + (loops + 1) + " to rc client");
                    msg.setUserInt(loops + 1);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    server.send(msg);
                }
                server.unsubscribe(unsub);
                server.unsubscribe(unsub2);
                server.disconnect();
                System.out.println("\n\n\nNow wait 2 seconds and connect again\n\n\n");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cMsg server2 = new cMsg(rcsUDL, "rc server", "udp trial");
                server2.connect();
                server2.start();
                server2.subscribe("subby", "typey", cb22, "3rd sub");
                server2.subscribe("*", "*", starCb, "4th sub");
                loops = 5;
                while (loops-- > 0) {
                    System.out.println("Send msg " + (loops + 1) + " to rc client");
                    msg.setUserInt(loops + 1);
                    server2.send(msg);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }

    class ConnectDisconnectThread
    extends Thread {
        String rcClientHost;
        String rcClientBroadcast;
        int rcClientTcpPort;

        ConnectDisconnectThread(String ip, String bcast, int port) {
            this.rcClientHost = ip;
            this.rcClientBroadcast = bcast;
            this.rcClientTcpPort = port;
        }

        @Override
        public void run() {
            try {
                String rcsUDL = "cMsg:rcs://" + this.rcClientHost + ":" + this.rcClientTcpPort + "/" + this.rcClientBroadcast;
                cMsg server = new cMsg(rcsUDL, "rc server", "connect/disconnect trial");
                server.connect();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                server.disconnect();
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }

    class starCallback
    extends cMsgCallbackAdapter {
        starCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            String s = (String)userObject;
            System.out.println("Running star cb, msg sub = " + msg.getSubject() + ", type " + msg.getType() + ", text = " + msg.getText() + ", for " + s);
        }
    }

    class rcCallback
    extends cMsgCallbackAdapter {
        rcCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            String s = (String)userObject;
            System.out.println("Running regular cb, msg sub = " + msg.getSubject() + ", type " + msg.getType() + ", text = " + msg.getText() + ", for " + s);
        }
    }

    class MulticastCallback
    extends cMsgCallbackAdapter {
        MulticastCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            String host = msg.getSenderHost();
            int port = msg.getUserInt();
            String name = msg.getSender();
            String broadcast = "255.255.255.255";
            cMsgPayloadItem item = msg.getPayloadItem("IpAddresses");
            if (item != null) {
                try {
                    host = item.getStringArray()[0];
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            if ((item = msg.getPayloadItem("BroadcastAddresses")) != null) {
                try {
                    broadcast = item.getStringArray()[0];
                }
                catch (cMsgException cMsgException3) {
                    // empty catch block
                }
            }
            System.out.println("Running RC Multicast domain callback, host = " + host + ", bcast = " + broadcast + ", port = " + port + ", name = " + name);
            System.out.println("Starting RC Server domain server");
            RcServerReconnectThread rcserver = new RcServerReconnectThread(host, broadcast, port);
            rcserver.start();
        }
    }
}

