/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.util.List;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;

class cMsgMulticastListeningThread
extends Thread {
    cMsgNameServer server;
    private int serverTcpPort;
    private int serverUdpPort;
    private String serverPassword;
    private MulticastSocket multicastSocket;
    private int debug;
    private boolean killThread;

    void killThread() {
        this.killThread = true;
        this.interrupt();
        this.multicastSocket.close();
    }

    public cMsgMulticastListeningThread(cMsgNameServer nameServer, int port, int multicastPort, MulticastSocket socket, String password, int debug) {
        this.server = nameServer;
        this.multicastSocket = socket;
        this.serverTcpPort = port;
        this.serverUdpPort = multicastPort;
        this.serverPassword = password;
        this.debug = debug;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DatagramPacket sendPacket;
        DatagramPacket packet;
        byte[] buf;
        block31: {
            if (this.debug >= 4) {
                System.out.println(">>     MC: Running cMsgNameserver Multicast Listening Thread");
            }
            buf = new byte[1024];
            packet = new DatagramPacket(buf, 1024);
            sendPacket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(this.serverTcpPort);
                out.writeInt(this.serverUdpPort);
                int i = 0;
                List<InterfaceAddress> ifAddrs = cMsgUtilities.getAllIpInfo();
                int addrCount = ifAddrs.size();
                String[] ipAddrs = new String[addrCount];
                String[] broadcastAddrs = new String[addrCount];
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address bAddr;
                    try {
                        bAddr = (Inet4Address)ifAddr.getBroadcast();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    broadcastAddrs[i] = bAddr.getHostAddress();
                    ipAddrs[i++] = ifAddr.getAddress().getHostAddress();
                }
                out.writeInt(addrCount);
                for (int j = 0; j < addrCount; ++j) {
                    try {
                        out.writeInt(ipAddrs[j].length());
                        out.write(ipAddrs[j].getBytes("US-ASCII"));
                        out.writeInt(broadcastAddrs[j].length());
                        out.write(broadcastAddrs[j].getBytes("US-ASCII"));
                        continue;
                    }
                    catch (UnsupportedEncodingException ifAddr) {
                        // empty catch block
                    }
                }
                out.flush();
                out.close();
                byte[] outBuf = baos.toByteArray();
                sendPacket = new DatagramPacket(outBuf, outBuf.length);
            }
            catch (IOException e) {
                if (this.debug < 2) break block31;
                System.out.println("I/O Error: " + e);
            }
        }
        this.server.listeningThreadsStartedSignal.countDown();
        try {
            while (true) {
                if (this.killThread) {
                    return;
                }
                packet.setLength(1024);
                this.multicastSocket.receive(packet);
                if (this.debug >= 4) {
                    System.out.println("RECEIVED CMSG DOMAIN MULTICAST PACKET !!!");
                }
                if (this.killThread) {
                    return;
                }
                InetAddress clientAddress = packet.getAddress();
                int clientUdpPort = packet.getPort();
                if (packet.getLength() < 20) continue;
                int magicInt1 = cMsgUtilities.bytesToInt(buf, 0);
                int magicInt2 = cMsgUtilities.bytesToInt(buf, 4);
                int magicInt3 = cMsgUtilities.bytesToInt(buf, 8);
                if (magicInt1 != cMsgNetworkConstants.magicNumbers[0] || magicInt2 != cMsgNetworkConstants.magicNumbers[1] || magicInt3 != cMsgNetworkConstants.magicNumbers[2]) continue;
                int version = cMsgUtilities.bytesToInt(buf, 12);
                if (version != 5) {
                    System.out.println("multicast packet: bad version (" + version + ") != expected (" + 5 + ")");
                    continue;
                }
                int msgType = cMsgUtilities.bytesToInt(buf, 16);
                int passwordLen = cMsgUtilities.bytesToInt(buf, 20);
                if (msgType != 1 || packet.getLength() < 20 + passwordLen) continue;
                String pswd = null;
                if (passwordLen > 0) {
                    try {
                        pswd = new String(buf, 24, passwordLen, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (this.serverPassword != null) {
                    if (pswd == null || !this.serverPassword.equals(pswd)) {
                        if (this.debug < 4) continue;
                        System.out.println("REJECTING PASSWORD: server's does not match client's (" + pswd + ")");
                        continue;
                    }
                } else if (pswd != null) {
                    if (this.debug < 4) continue;
                    System.out.println("Client password (" + pswd + ") does not match server's (null), reject packet");
                    continue;
                }
                if (this.debug >= 4) {
                    System.out.println("packet passes all tests, send response");
                }
                try {
                    sendPacket.setAddress(clientAddress);
                    sendPacket.setPort(clientUdpPort);
                    this.multicastSocket.send(sendPacket);
                }
                catch (IOException e) {
                    if (this.debug < 2) continue;
                    System.out.println("I/O Error: " + e);
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (this.debug < 2) return;
            System.out.println("cMsgBroadcastListenThread: I/O ERROR in cMsg multicast server");
            System.out.println("                         : close multicast socket, port = " + this.multicastSocket.getLocalPort());
            return;
        }
        finally {
            this.multicastSocket.close();
        }
    }
}

