/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgClientData;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgDomainServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgDomainServerSelect;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerBridge;
import org.jlab.coda.cMsg.cMsgException;

class cMsgMonitorClient
extends Thread {
    private cMsgNameServer server;
    private StringBuilder xml;
    private ByteBuffer outBuffer;
    private ByteBuffer outBuffer2;
    private ByteBuffer inBuffer;
    private int debug;
    private final int readTimeout = 3000;
    private final long updatePeriod = 2000L;
    private final long deadTime = 120000L;
    private boolean monitoringOff;
    private ConcurrentHashMap<cMsgClientData, String> clients2register;
    private ConcurrentHashMap<cMsgClientData, Object> clients;
    private Selector selector;
    private ThreadPoolExecutor readingThreadPool;
    private volatile boolean killThreads;

    public static ByteBuffer copyBuffer(ByteBuffer original) {
        int pos = original.position();
        int lim = original.limit();
        ByteBuffer clone = ByteBuffer.allocateDirect(original.capacity());
        original.rewind();
        clone.put(original);
        clone.position(pos).limit(lim);
        return clone;
    }

    void shutdown() {
        this.readingThreadPool.shutdownNow();
        this.killThreads = true;
        this.interrupt();
    }

    public cMsgMonitorClient(cMsgNameServer server, int debug) throws IOException {
        this.debug = debug;
        this.server = server;
        this.monitoringOff = server.monitoringOff;
        this.outBuffer = ByteBuffer.allocateDirect(4096);
        this.outBuffer2 = ByteBuffer.allocateDirect(1024);
        this.inBuffer = ByteBuffer.allocateDirect(2048);
        this.xml = new StringBuilder(1000);
        this.clients = new ConcurrentHashMap(500);
        this.clients2register = new ConcurrentHashMap(100);
        this.readingThreadPool = new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.selector = Selector.open();
        ReadMonitorData rd = new ReadMonitorData();
        rd.start();
        WriteMonitorData wr = new WriteMonitorData();
        wr.start();
    }

    void addClient(cMsgClientData info, cMsgDomainServerSelect dss) {
        this.clients2register.put(info, "");
        this.clients.put(info, dss);
        this.selector.wakeup();
        info.updateTime = System.currentTimeMillis();
    }

    void addClient(cMsgClientData info, cMsgDomainServer ds) {
        this.clients2register.put(info, "");
        this.clients.put(info, ds);
        this.selector.wakeup();
        info.updateTime = System.currentTimeMillis();
    }

    void removeClient(cMsgClientData info) {
        this.clients2register.remove(info);
        this.clients.remove(info);
    }

    private int readSocketBytes(ByteBuffer buffer, SocketChannel channel, int bytes, int timeout, boolean returnOnZero) throws TimeoutException, IOException {
        if (bytes <= 0) {
            return 0;
        }
        int count = 0;
        long t1 = System.currentTimeMillis();
        buffer.clear();
        buffer.limit(bytes);
        while (count < bytes) {
            int n = channel.read(buffer);
            if (n < 0) {
                throw new IOException("readSocketBytes: client's socket is dead");
            }
            if ((count += n) >= bytes) break;
            if (count == 0 && returnOnZero) {
                return 0;
            }
            long t2 = System.currentTimeMillis();
            if (t2 - t1 >= (long)timeout) {
                if (this.debug >= 4) {
                    System.out.println("    readSocketBytes: timed out, read " + count + " out of " + bytes + " bytes");
                }
                throw new TimeoutException("readSocketBytes: timed out trying to read " + bytes + " bytes, read only " + count);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return count;
    }

    private void readAndDumpMonitorInfo(cMsgClientData cd) throws IOException {
        int n;
        do {
            this.inBuffer.clear();
            n = cd.keepAliveChannel.read(this.inBuffer);
            if (n < 1) {
                return;
            }
            cd.updateTime = System.currentTimeMillis();
        } while (n >= this.inBuffer.capacity());
    }

    private void readMonitorInfo(cMsgClientData cd, int timeout) throws TimeoutException, cMsgException, IOException {
        int n;
        while ((n = this.readSocketBytes(this.inBuffer, cd.keepAliveChannel, 4, timeout, true)) != 0) {
            this.inBuffer.flip();
            int size = this.inBuffer.getInt();
            if (size > this.inBuffer.capacity()) {
                this.inBuffer = ByteBuffer.allocateDirect(size + 512);
            } else if (size < 0) {
                throw new cMsgException("Internal cMsg keepalive protocol error from " + cd.getName());
            }
            if (size <= 0) continue;
            this.inBuffer.clear();
            this.readSocketBytes(this.inBuffer, cd.keepAliveChannel, size, timeout, false);
            this.inBuffer.flip();
            size = this.inBuffer.getInt();
            cd.monData.isJava = this.inBuffer.getInt() == 1;
            cd.monData.pendingSubAndGets = this.inBuffer.getInt();
            cd.monData.pendingSendAndGets = this.inBuffer.getInt();
            cd.monData.clientTcpSends = this.inBuffer.getLong();
            cd.monData.clientUdpSends = this.inBuffer.getLong();
            cd.monData.clientSyncSends = this.inBuffer.getLong();
            cd.monData.clientSendAndGets = this.inBuffer.getLong();
            cd.monData.clientSubAndGets = this.inBuffer.getLong();
            cd.monData.clientSubscribes = this.inBuffer.getLong();
            cd.monData.clientUnsubscribes = this.inBuffer.getLong();
            byte[] buf = new byte[size];
            this.inBuffer.get(buf, 0, size);
            cd.monData.monXML = new String(buf, 0, size, "US-ASCII");
            cd.updateTime = System.currentTimeMillis();
        }
        return;
    }

    private void writeMonitorInfo(cMsgClientData cd, boolean isServer) throws IOException {
        ByteBuffer outBuf;
        if (cd.kaBuffer != null) {
            outBuf = cd.kaBuffer;
        } else if (isServer) {
            outBuf = this.outBuffer2;
            outBuf.rewind();
        } else {
            outBuf = this.outBuffer;
            outBuf.rewind();
        }
        int totalBytesWritten = 0;
        int tries = 0;
        while (outBuf.hasRemaining()) {
            int bytesWritten = cd.keepAliveChannel.write(outBuf);
            if ((totalBytesWritten += bytesWritten) >= outBuf.limit()) continue;
            if (!cd.keepAliveChannel.isOpen()) {
                throw new IOException("Keepalive channel to client is closed");
            }
            if (++tries % 1000 == 0) {
                System.out.println("writeMonitorInfo: monitor data write to " + cd.getName() + " cannot finish, try later");
                if (cd.kaBuffer == null) {
                    cd.kaBuffer = cMsgMonitorClient.copyBuffer(outBuf);
                }
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        cd.kaBuffer = null;
    }

    private void emptySendBuffers() {
        this.outBuffer.clear();
        this.outBuffer.putInt(0);
        this.outBuffer.putInt(0);
        this.outBuffer2.clear();
        this.outBuffer2.putInt(0);
        this.outBuffer2.putInt(0);
        this.outBuffer.flip();
        this.outBuffer2.flip();
    }

    private void fillSendBuffers() {
        this.updateMonitorXML();
        int dataLength = this.server.fullMonitorXML.length();
        while (true) {
            String passwd;
            int totalLength = dataLength + 12;
            int count = 0;
            for (cMsgClientData cd : this.server.nameServers.values()) {
                passwd = cd.getPassword();
                if (passwd == null) {
                    passwd = "";
                }
                totalLength += 16 + cd.getServerHost().length() + passwd.length();
                ++count;
            }
            int size1 = count;
            if (totalLength > this.outBuffer.capacity()) {
                this.outBuffer = ByteBuffer.allocateDirect(totalLength + 2048);
            }
            this.outBuffer.clear();
            try {
                this.outBuffer.putInt(dataLength);
                this.outBuffer.put(this.server.fullMonitorXML.getBytes("US-ASCII"));
                this.outBuffer.putInt(1);
                int size2 = this.server.nameServers.size();
                this.outBuffer.putInt(size2);
                if (size2 <= 0) break;
                count = 0;
                for (cMsgClientData cd : this.server.nameServers.values()) {
                    this.outBuffer.putInt(cd.getServerPort());
                    this.outBuffer.putInt(cd.getServerMulticastPort());
                    this.outBuffer.putInt(cd.getServerHost().length());
                    passwd = cd.getPassword();
                    if (passwd == null) {
                        passwd = "";
                    }
                    this.outBuffer.putInt(passwd.length());
                    this.outBuffer.put(cd.getServerHost().getBytes("US-ASCII"));
                    this.outBuffer.put(passwd.getBytes("US-ASCII"));
                    ++count;
                }
                if (count == size2 && size1 == size2) break;
                System.out.println("\n !!! cMsgMonitorClient: inconsistency!!! try again");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
                break;
            }
        }
        if ((dataLength = this.server.nsMonitorXML.length()) + 8 > this.outBuffer2.capacity()) {
            this.outBuffer2 = ByteBuffer.allocateDirect(dataLength + 1024);
        }
        this.outBuffer2.clear();
        this.outBuffer2.putInt(dataLength);
        try {
            this.outBuffer2.put(this.server.nsMonitorXML.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.outBuffer2.putInt(0);
        this.outBuffer.flip();
        this.outBuffer2.flip();
    }

    private boolean clientDead(cMsgClientData cd) {
        return System.currentTimeMillis() - cd.updateTime > 120000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMonitorXML() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        this.xml.delete(0, this.xml.capacity());
        this.xml.append("\n  <server  name=\"");
        this.xml.append(this.server.serverName);
        this.xml.append("\"  host=\"");
        this.xml.append(this.server.getHost());
        this.xml.append("\"  tcpPort=\"");
        this.xml.append(this.server.getPort());
        this.xml.append("\"  domainPort=\"");
        this.xml.append(this.server.getDomainPort());
        this.xml.append("\"  multicastPort=\"");
        this.xml.append(this.server.getMulticastPort());
        this.xml.append("\" >\n");
        String indent1 = "      ";
        for (cMsgDomainServer ds : this.server.domainServers.keySet()) {
            if (ds.info.isServer()) continue;
            String sd = ds.info.getSubdomain();
            this.xml.append("\n    <client  name=\"");
            this.xml.append(ds.info.getName());
            this.xml.append("\"  subdomain=\"");
            this.xml.append(sd);
            this.xml.append("\">\n");
            this.xml.append(indent1);
            this.xml.append("<timeConnected>");
            this.xml.append(dateFormat.format(ds.info.monData.birthday));
            this.xml.append("</timeConnected>\n");
            String ns = ds.info.getNamespace();
            if (ns != null) {
                ns = ns.substring(1, ns.length());
                this.xml.append(indent1);
                this.xml.append("<namespace>");
                this.xml.append(ns);
                this.xml.append("</namespace>\n");
            }
            if (sd != null && sd.equalsIgnoreCase("cmsg") && ds.info.monData.monXML != null) {
                this.xml.append(indent1);
                this.xml.append("<sendStats");
                this.xml.append("  tcpSends=\"");
                this.xml.append(ds.info.monData.clientTcpSends);
                this.xml.append("\"  udpSends=\"");
                this.xml.append(ds.info.monData.clientUdpSends);
                this.xml.append("\"  syncSends=\"");
                this.xml.append(ds.info.monData.clientSyncSends);
                this.xml.append("\"  sendAndGets=\"");
                this.xml.append(ds.info.monData.clientSendAndGets);
                this.xml.append("\" />\n");
                this.xml.append(indent1);
                this.xml.append("<subStats");
                this.xml.append("   subscribes=\"");
                this.xml.append(ds.info.monData.clientSubscribes);
                this.xml.append("\"  unsubscribes=\"");
                this.xml.append(ds.info.monData.clientUnsubscribes);
                this.xml.append("\"  subAndGets=\"");
                this.xml.append(ds.info.monData.clientSubAndGets);
                this.xml.append("\" />\n");
                this.xml.append(ds.info.monData.monXML);
            } else {
                this.xml.append(indent1);
                this.xml.append("<sendStats");
                this.xml.append("  tcpSends=\"");
                this.xml.append(ds.info.monData.tcpSends);
                this.xml.append("\"  udpSends=\"");
                this.xml.append(ds.info.monData.udpSends);
                this.xml.append("\"  syncSends=\"");
                this.xml.append(ds.info.monData.syncSends);
                this.xml.append("\"  sendAndGets=\"");
                this.xml.append(ds.info.monData.sendAndGets);
                this.xml.append("\" />\n");
                this.xml.append(indent1);
                this.xml.append("<subStats");
                this.xml.append("  subscribes=\"");
                this.xml.append(ds.info.monData.subscribes);
                this.xml.append("\"  unsubscribes=\"");
                this.xml.append(ds.info.monData.unsubscribes);
                this.xml.append("\"  subAndGets=\"");
                this.xml.append(ds.info.monData.subAndGets);
                this.xml.append("\" />\n");
            }
            this.xml.append("    </client>\n");
        }
        for (cMsgDomainServerSelect dss : this.server.domainServersSelect.keySet()) {
            for (cMsgClientData cd : dss.clients.keySet()) {
                if (cd.isServer()) continue;
                String sd = cd.getSubdomain();
                this.xml.append("\n    <client  name=\"");
                this.xml.append(cd.getName());
                this.xml.append("\"  subdomain=\"");
                this.xml.append(sd);
                this.xml.append("\">\n");
                this.xml.append(indent1);
                this.xml.append("<timeConnected>");
                this.xml.append(dateFormat.format(cd.monData.birthday));
                this.xml.append("</timeConnected>\n");
                String ns = cd.getNamespace();
                if (ns != null) {
                    ns = ns.substring(1, ns.length());
                    this.xml.append(indent1);
                    this.xml.append("<namespace>");
                    this.xml.append(ns);
                    this.xml.append("</namespace>\n");
                }
                if (sd != null && sd.equalsIgnoreCase("cmsg") && cd.monData.monXML != null) {
                    this.xml.append(indent1);
                    this.xml.append("<sendStats");
                    this.xml.append("  tcpSends=\"");
                    this.xml.append(cd.monData.clientTcpSends);
                    this.xml.append("\"  udpSends=\"");
                    this.xml.append(cd.monData.clientUdpSends);
                    this.xml.append("\"  syncSends=\"");
                    this.xml.append(cd.monData.clientSyncSends);
                    this.xml.append("\"  sendAndGets=\"");
                    this.xml.append(cd.monData.clientSendAndGets);
                    this.xml.append("\" />\n");
                    this.xml.append(indent1);
                    this.xml.append("<subStats");
                    this.xml.append("   subscribes=\"");
                    this.xml.append(cd.monData.clientSubscribes);
                    this.xml.append("\"  unsubscribes=\"");
                    this.xml.append(cd.monData.clientUnsubscribes);
                    this.xml.append("\"  subAndGets=\"");
                    this.xml.append(cd.monData.clientSubAndGets);
                    this.xml.append("\" />\n");
                    this.xml.append(cd.monData.monXML);
                } else {
                    this.xml.append(indent1);
                    this.xml.append("<sendStats");
                    this.xml.append("  tcpSends=\"");
                    this.xml.append(cd.monData.tcpSends);
                    this.xml.append("\"  udpSends=\"");
                    this.xml.append(cd.monData.udpSends);
                    this.xml.append("\"  syncSends=\"");
                    this.xml.append(cd.monData.syncSends);
                    this.xml.append("\"  sendAndGets=\"");
                    this.xml.append(cd.monData.sendAndGets);
                    this.xml.append("\" />\n");
                    this.xml.append(indent1);
                    this.xml.append("<subStats");
                    this.xml.append("  subscribes=\"");
                    this.xml.append(cd.monData.subscribes);
                    this.xml.append("\"  unsubscribes=\"");
                    this.xml.append(cd.monData.unsubscribes);
                    this.xml.append("\"  subAndGets=\"");
                    this.xml.append(cd.monData.subAndGets);
                    this.xml.append("\" />\n");
                }
                this.xml.append("    </client>\n");
            }
        }
        this.xml.append("\n  </server>\n\n");
        this.server.nsMonitorXML = this.xml.toString();
        this.xml.insert(0, "<cMsgMonitorData  domain=\"cmsg\">\n\n");
        ConcurrentHashMap<String, cMsgServerBridge> concurrentHashMap = this.server.bridges;
        synchronized (concurrentHashMap) {
            for (cMsgServerBridge b : this.server.bridges.values()) {
                this.xml.append(b.client.monitorXML);
            }
        }
        this.xml.append("</cMsgMonitorData>\n");
        this.server.fullMonitorXML = this.xml.toString();
    }

    private class WriteMonitorData
    extends Thread {
        private WriteMonitorData() {
        }

        @Override
        public void run() {
            ((cMsgMonitorClient)cMsgMonitorClient.this).server.preConnectionThreadsStartedSignal.countDown();
            cMsgMonitorClient.this.emptySendBuffers();
            do {
                if (!cMsgMonitorClient.this.monitoringOff) {
                    cMsgMonitorClient.this.fillSendBuffers();
                }
                Iterator it = ((ConcurrentHashMap.KeySetView)cMsgMonitorClient.this.clients.keySet()).iterator();
                while (it.hasNext()) {
                    cMsgClientData cd = (cMsgClientData)it.next();
                    try {
                        cMsgMonitorClient.this.writeMonitorInfo(cd, cd.isServer());
                    }
                    catch (IOException e) {
                        Object dssObject;
                        if (cMsgMonitorClient.this.debug >= 2) {
                            System.out.println("cMsgMonitorClient: IO error, client " + cd.getName() + " is dead at " + new Date());
                        }
                        if ((dssObject = cMsgMonitorClient.this.clients.get(cd)) == null) continue;
                        if (dssObject instanceof cMsgDomainServerSelect) {
                            cMsgDomainServerSelect dss = (cMsgDomainServerSelect)dssObject;
                            dss.deleteClient(cd);
                        } else {
                            cMsgDomainServer ds = (cMsgDomainServer)dssObject;
                            ds.shutdown();
                        }
                        it.remove();
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!cMsgMonitorClient.this.killThreads);
        }
    }

    private class ReadMonitorData
    extends Thread {
        private ReadMonitorData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (cMsgMonitorClient.this.debug >= 4) {
                System.out.println("  cMsgMonitorClient(read): Running Reader Thread");
            }
            ((cMsgMonitorClient)cMsgMonitorClient.this).server.preConnectionThreadsStartedSignal.countDown();
            cMsgClientData clientData = null;
            try {
                while (true) {
                    Iterator<Object> it;
                    int n = cMsgMonitorClient.this.selector.select(1000L);
                    if (cMsgMonitorClient.this.clients2register.size() > 0) {
                        it = ((ConcurrentHashMap.KeySetView)cMsgMonitorClient.this.clients2register.keySet()).iterator();
                        while (it.hasNext()) {
                            clientData = (cMsgClientData)it.next();
                            if (cMsgMonitorClient.this.debug >= 4) {
                                System.out.println("  cMsgMonitorClient(read): Registering client " + clientData.getName() + " with selector");
                            }
                            try {
                                clientData.keepAliveChannel.register(cMsgMonitorClient.this.selector, 1, clientData);
                            }
                            catch (ClosedChannelException closedChannelException) {
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (IllegalBlockingModeException illegalBlockingModeException) {
                                // empty catch block
                            }
                            it.remove();
                        }
                    }
                    if (cMsgMonitorClient.this.killThreads) {
                        System.out.println("    cMsgMonitorClient(read): ending main thread 1");
                        return;
                    }
                    if (n < 1) {
                        cMsgMonitorClient.this.selector.selectedKeys().clear();
                        continue;
                    }
                    it = cMsgMonitorClient.this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey key = (SelectionKey)it.next();
                        if (key.isValid() && key.isReadable()) {
                            clientData = (cMsgClientData)key.attachment();
                            if (clientData == null) {
                                it.remove();
                                continue;
                            }
                            DataReader reader = new DataReader(clientData);
                            cMsgMonitorClient.this.readingThreadPool.execute(reader);
                        }
                        it.remove();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                    break;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            finally {
                try {
                    cMsgMonitorClient.this.selector.close();
                }
                catch (IOException it) {}
            }
        }
    }

    private class DataReader
    implements Runnable {
        cMsgClientData cd;

        public DataReader(cMsgClientData cd) {
            this.cd = cd;
        }

        @Override
        public void run() {
            block14: {
                try {
                    if (cMsgMonitorClient.this.monitoringOff) {
                        cMsgMonitorClient.this.readAndDumpMonitorInfo(this.cd);
                    } else {
                        cMsgMonitorClient.this.readMonitorInfo(this.cd, 3000);
                    }
                }
                catch (TimeoutException timeoutException) {
                }
                catch (cMsgException e) {
                    Object dssObject;
                    if (cMsgMonitorClient.this.debug >= 2) {
                        System.out.println("cMsgMonitorClient: client " + this.cd.getName() + " internal protocol error");
                    }
                    if ((dssObject = cMsgMonitorClient.this.clients.get(this.cd)) != null) {
                        if (dssObject instanceof cMsgDomainServerSelect) {
                            cMsgDomainServerSelect dss = (cMsgDomainServerSelect)dssObject;
                            dss.deleteClient(this.cd);
                        } else {
                            cMsgDomainServer ds = (cMsgDomainServer)dssObject;
                            ds.shutdown();
                        }
                        cMsgMonitorClient.this.removeClient(this.cd);
                        if (cMsgMonitorClient.this.debug >= 1) {
                            System.out.println("Client " + this.cd.getName() + " error reading during keepalive, remove");
                        }
                    }
                }
                catch (IOException e) {
                    Object dssObject;
                    if (cMsgMonitorClient.this.debug >= 2) {
                        System.out.println("cMsgMonitorClient: IO error, client " + this.cd.getName() + " protocol error or is dead");
                    }
                    if ((dssObject = cMsgMonitorClient.this.clients.get(this.cd)) == null) break block14;
                    if (dssObject instanceof cMsgDomainServerSelect) {
                        cMsgDomainServerSelect dss = (cMsgDomainServerSelect)dssObject;
                        dss.deleteClient(this.cd);
                    } else {
                        cMsgDomainServer ds = (cMsgDomainServer)dssObject;
                        ds.shutdown();
                    }
                    cMsgMonitorClient.this.removeClient(this.cd);
                    if (cMsgMonitorClient.this.debug < 1) break block14;
                    System.out.println("Client " + this.cd.getName() + " I/O error in keepalive, remove");
                }
            }
        }
    }
}

