/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.CADomain;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.Monitor;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.DefaultConfiguration;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DOUBLE;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class CA
extends cMsgDomainAdapter {
    private JCALibrary myJCA = null;
    private Context myContext = null;
    private String myChannelName = null;
    private Channel myChannel = null;
    private String myAddrList = "none";
    private Monitor myMonitor = null;
    private ArrayList<SubInfo> mySubList = new ArrayList(10);
    private double myContextPend = 3.0;
    private double myPutPend = 3.0;

    public CA() {
        this.domain = "CA";
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println(e);
            this.host = "unknown";
        }
    }

    @Override
    public synchronized void connect() throws cMsgException {
        Pattern p;
        Matcher m;
        String remainder = null;
        if (this.connected) {
            return;
        }
        if (this.UDLremainder == null) {
            throw new cMsgException("?invalid UDL");
        }
        int ind = this.UDLremainder.indexOf(63);
        if (ind > 0) {
            this.myChannelName = this.UDLremainder.substring(0, ind);
            remainder = this.UDLremainder.substring(ind) + "&";
        } else {
            this.myChannelName = this.UDLremainder;
        }
        this.myJCA = JCALibrary.getInstance();
        DefaultConfiguration conf = new DefaultConfiguration("myContext");
        conf.setAttribute("class", "com.cosylab.epics.caj.CAJContext");
        conf.setAttribute("auto_addr_list", "false");
        if (remainder != null && (m = (p = Pattern.compile("[&\\?]addr_list=(.*?)&", 2)).matcher(remainder)).find()) {
            this.myAddrList = m.group(1);
            conf.setAttribute("addr_list", this.myAddrList);
        }
        try {
            this.myContext = this.myJCA.createContext((Configuration)conf);
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myChannel = this.myContext.createChannel(this.myChannelName);
            this.myContext.pendIO(this.myContextPend);
        }
        catch (CAException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (TimeoutException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        this.connected = true;
    }

    @Override
    public synchronized void disconnect() throws cMsgException {
        if (!this.connected) {
            return;
        }
        try {
            this.connected = false;
            this.myChannel.destroy();
            this.myContext.flushIO();
            this.myContext.destroy();
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public synchronized void send(cMsgMessage msg) throws cMsgException {
        if (!this.connected) {
            throw new cMsgException("Not connected, Call \"connect\" first");
        }
        try {
            this.myChannel.put(Double.parseDouble(msg.getText()));
            this.myContext.pendIO(this.myPutPend);
        }
        catch (CAException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (TimeoutException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public synchronized void flush(int timeout) throws cMsgException {
        if (!this.connected) {
            throw new cMsgException("Not connected, Call \"connect\" first");
        }
        try {
            this.myContext.flushIO();
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage subscribeAndGet(String subject, String type, int timeout) throws cMsgException {
        DBR dbr;
        cMsgMessageFull response = new cMsgMessageFull();
        response.setDomain(this.domain);
        response.setSender(this.myChannelName);
        response.setSenderHost(this.myAddrList);
        response.setSenderTime(new Date());
        response.setReceiver(this.name);
        response.setReceiverHost(this.host);
        response.setReceiverTime(new Date());
        response.setSubject(subject);
        response.setType(type);
        CA cA = this;
        synchronized (cA) {
            if (!this.connected) {
                throw new cMsgException("Not connected, Call \"connect\" first");
            }
            try {
                dbr = this.myChannel.get();
            }
            catch (CAException e) {
                response.setText(null);
                e.printStackTrace();
                return response;
            }
        }
        try {
            this.myContext.pendIO((double)timeout / 1000.0);
            response.setText("" + ((DOUBLE)dbr).getDoubleValue()[0]);
        }
        catch (CAException e) {
            response.setText(null);
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            response.setText(null);
            e.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        if (!this.connected) {
            throw new cMsgException("Not connected, Call \"connect\" first");
        }
        SubInfo info = new SubInfo(subject, type, cb3, userObj);
        ArrayList<SubInfo> arrayList = this.mySubList;
        synchronized (arrayList) {
            this.mySubList.add(info);
        }
        if (this.myMonitor == null) {
            try {
                this.myMonitor = this.myChannel.addMonitor(1, (MonitorListener)new MonitorListenerImpl());
                this.myContext.flushIO();
            }
            catch (CAException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unsubscribe(cMsgSubscriptionHandle obj) throws cMsgException {
        int cnt;
        if (!this.connected) {
            throw new cMsgException("Not connected, Call \"connect\" first");
        }
        SubInfo info = (SubInfo)obj;
        ArrayList<SubInfo> arrayList = this.mySubList;
        synchronized (arrayList) {
            this.mySubList.remove(info);
            cnt = this.mySubList.size();
        }
        if (cnt <= 0) {
            try {
                this.myMonitor.clear();
                this.myMonitor = null;
            }
            catch (CAException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
        }
    }

    private class SubInfo
    implements cMsgSubscriptionHandle {
        String subject;
        String type;
        cMsgCallbackInterface cb;
        Object userObj;

        SubInfo(String s, String t, cMsgCallbackInterface c, Object o) {
            this.subject = s;
            this.type = t;
            this.cb = c;
            this.userObj = o;
        }

        @Override
        public synchronized void pause() {
        }

        @Override
        public synchronized void restart() {
        }

        @Override
        public int getQueueSize() {
            return 0;
        }

        @Override
        public boolean isQueueFull() {
            return false;
        }

        @Override
        public void clearQueue() {
        }

        @Override
        public long getMsgCount() {
            return 0L;
        }

        @Override
        public String getDomain() {
            return CA.this.domain;
        }

        @Override
        public String getSubject() {
            return this.subject;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public cMsgCallbackInterface getCallback() {
            return this.cb;
        }

        @Override
        public Object getUserObject() {
            return this.userObj;
        }
    }

    private class DispatchCB
    extends Thread {
        private SubInfo s;
        private cMsgMessage c;

        DispatchCB(SubInfo s, cMsgMessage c) {
            this.s = s;
            this.c = c;
        }

        @Override
        public void run() {
            this.s.cb.callback(this.c, this.s.userObj);
        }
    }

    private class MonitorListenerImpl
    implements MonitorListener {
        private MonitorListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent event) {
            if (event.getStatus() == CAStatus.NORMAL) {
                cMsgMessageFull cmsg = new cMsgMessageFull();
                cmsg.setDomain(CA.this.domain);
                cmsg.setSender(CA.this.myChannelName);
                cmsg.setSenderHost(CA.this.myAddrList);
                cmsg.setSenderTime(new Date());
                cmsg.setReceiver(CA.this.name);
                cmsg.setReceiverHost(CA.this.host);
                cmsg.setReceiverTime(new Date());
                cmsg.setText("" + ((DOUBLE)event.getDBR()).getDoubleValue()[0]);
                ArrayList arrayList = CA.this.mySubList;
                synchronized (arrayList) {
                    for (SubInfo s : CA.this.mySubList) {
                        cmsg.setSubject(s.subject);
                        cmsg.setType(s.type);
                        new Thread(new DispatchCB(s, cmsg)).start();
                    }
                }
            } else {
                System.err.println("Monitor error: " + event.getStatus());
            }
        }
    }
}

