/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.nio.ByteBuffer;
import org.jlab.coda.cMsg.cMsgException;

public class jniEtTrial {
    private ByteBuffer buffer;
    int memSize;

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public static void main(String[] args) {
        try {
            double freq = 0.0;
            double freqAvg = 0.0;
            long totalT = 0L;
            long totalC = 0L;
            int count = 1000000;
            long ignore = 0L;
            int size = 1024;
            jniEtTrial trial = new jniEtTrial(size);
            trial.init("/tmp/jniEtTrial", size);
            System.out.println("DONE WITH INIT()");
            while (true) {
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < count; ++i) {
                    trial.buffer.clear();
                    trial.getData(size, trial.buffer);
                    trial.buffer.flip();
                    trial.putData(size, 0, trial.buffer);
                }
                long t2 = System.currentTimeMillis();
                if (ignore == 0L) {
                    long deltaT = t2 - t1;
                    freq = (double)size * (double)count / (double)deltaT * 1000.0;
                    freqAvg = (double)(totalC += (long)(size * count)) / (double)(totalT += deltaT) * 1000.0;
                    System.out.println(freq + " Hz, Avg = " + freqAvg + " Hz");
                    continue;
                }
                --ignore;
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    jniEtTrial(int memSize) {
        this.memSize = memSize;
        this.buffer = ByteBuffer.allocate(memSize);
        if (!this.buffer.hasArray()) {
            System.out.println("Buffer does NOT have backing array !!!");
            System.exit(-1);
        }
    }

    public void printData() {
        this.buffer.flip();
        for (int i = 0; i < this.memSize; ++i) {
            System.out.println(this.buffer.get() + " ");
        }
    }

    public native void init(String var1, int var2) throws cMsgException;

    public native void getData(int var1, ByteBuffer var2) throws cMsgException;

    public native void putData(int var1, int var2, ByteBuffer var3) throws cMsgException;

    static {
        try {
            System.loadLibrary("jniTest");
        }
        catch (Error e) {
            System.out.println("error loading libjniTest.so");
            System.exit(-1);
        }
    }
}

