/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class connectTest {
    private String subject = "SUBJECT\"";
    private String type = "TYPE";
    private String name = "connectTest";
    private String description = "java connect tester";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;
    private long count;
    private int delay;
    private int loops = 300;
    private long time1;
    private long time2;

    connectTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                connectTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            connectTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java VardanProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-debug]             turn on printout\n        [-delay]             time in millisec to wait between sends\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            connectTest consumer = new connectTest(args);
            consumer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg connectTest");
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.setDebug(4);
        this.count = 0L;
        coda.connect();
        System.out.print("Connected!, please kill server: ");
        while (coda.isConnected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.print(this.count++ + ", ");
        }
        System.out.println("\nDisconnected from server, try another connect()");
        while (!coda.isConnected()) {
            try {
                coda.connect();
            }
            catch (cMsgException e) {
                System.out.println("Failed reconnecting to server, again in 1 sec");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (coda.isConnected()) {
            System.out.println("Now we are connected to server, try sending a msg");
            cMsgMessage msg = new cMsgMessage();
            msg.setSubject(this.subject);
            msg.setType(this.type);
            coda.send(msg);
            System.out.println("Message was sent, so exit");
        } else {
            System.out.println("Now we are disconnected from server, exit");
        }
    }
}

