/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.util.Map;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class DoubleTestReceiver {
    private String subject1 = "doubleSender";
    private String type1 = "type";
    private String subject2 = "doubleReceiver";
    private String type2 = "type";
    private String name = "payload test receiver";
    private String description = "java producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay = 2000;
    private boolean debug;
    cMsg coda;

    DoubleTestReceiver(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DoubleTestReceiver.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            DoubleTestReceiver.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java DoubleTest\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            DoubleTestReceiver dtr = new DoubleTestReceiver(args);
            dtr.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg double sending test receiver");
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        DoubleReceivingCallback cb_r = new DoubleReceivingCallback();
        cMsgSubscriptionHandle unsub_r = this.coda.subscribe(this.subject2, this.type2, cb_r, null);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    class DoubleReceivingCallback
    extends cMsgCallbackAdapter {
        DoubleReceivingCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (msg.hasPayload()) {
                Map<String, cMsgPayloadItem> map = msg.getPayloadItems();
                for (cMsgPayloadItem it : map.values()) {
                    System.out.println("p item name = " + it.getName());
                }
                cMsgPayloadItem item = msg.getPayloadItem("int");
                try {
                    int i = item.getInt();
                    System.out.println("q2 " + msg.getContext().getQueueSize());
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
            } else {
                int i = msg.getUserInt();
                System.out.println("q2 " + msg.getContext().getQueueSize());
            }
        }
    }
}

