/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgDomainInterface;
import org.jlab.coda.cMsg.common.cMsgShutdownHandlerInterface;

public class cMsg {
    private int debug = 0;
    private String UDL;
    private String name;
    private String description;
    private String UDLremainder;
    private String domain;
    private cMsgDomainInterface connection;

    private cMsg() {
    }

    public cMsg(String UDL, String name, String description) throws cMsgException {
        if (UDL == null || name == null || description == null) {
            throw new cMsgException("a cMsg constructor argument is null");
        }
        if (cMsg.badString(name) || cMsg.badString(UDL) || cMsg.badString(description)) {
            throw new cMsgException("improper character(s) in argument");
        }
        if (name.contains(":")) {
            throw new cMsgException("invalid name - contains \":\"");
        }
        this.UDL = this.processUDLs(UDL);
        this.name = name;
        this.description = description;
        this.connection = this.createDomainConnection();
        this.connection.setUDL(UDL);
        this.connection.setName(name);
        this.connection.setDescription(description);
        this.connection.setUDLRemainder(this.UDLremainder);
        this.connection.setDebug(this.debug);
    }

    public void setDebug(int debug) {
        if (debug != 2 && debug != 4 && debug != 0 && debug != 1 && debug != 3) {
            return;
        }
        this.debug = debug;
        this.connection.setDebug(debug);
    }

    private static boolean badString(String s) {
        if (s == null) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~') {
                return true;
            }
            if (c != '\'' && c != '\"' && c != '`') continue;
            return true;
        }
        return false;
    }

    private String processUDLs(String clientUDL) throws cMsgException {
        int i;
        String[] udlStrings = clientUDL.split(";");
        for (int i2 = 0; i2 < udlStrings.length; ++i2) {
            udlStrings[i2] = udlStrings[i2].trim();
        }
        List<String> l = Arrays.asList(udlStrings);
        LinkedList<String> udlList = new LinkedList<String>(l);
        LinkedHashSet<String> udlSet = new LinkedHashSet<String>();
        String domainName = null;
        int startIndex = 0;
        boolean gotDomain = false;
        while (true) {
            for (i = startIndex; i < udlList.size(); ++i) {
                String udl = udlList.get(i);
                String[] parsedUDL = this.parseUDL(udl);
                if (!parsedUDL[0].equalsIgnoreCase("configFile")) {
                    udlSet.add(parsedUDL[1]);
                    if (!gotDomain) {
                        domainName = parsedUDL[0];
                        gotDomain = true;
                        continue;
                    }
                    if (domainName.equalsIgnoreCase(parsedUDL[0])) continue;
                    throw new cMsgException("All UDLs must belong to the same domain");
                }
                try {
                    int j;
                    String newUDL = this.readConfigFile(parsedUDL[1]);
                    if (newUDL.toLowerCase().contains("configfile://")) {
                        throw new cMsgException("one configFile domain UDL may NOT reference another");
                    }
                    String[] udls = newUDL.split(";");
                    for (j = 0; j < udls.length; ++j) {
                        udls[j] = udls[j].trim();
                    }
                    udlList.remove(i);
                    for (j = 0; j < udls.length; ++j) {
                        udlList.add(i + j, udls[j]);
                    }
                    startIndex = i;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new cMsgException("Cannot read UDL in file", e);
                }
            }
            break;
        }
        if (udlList.size() != udlSet.size()) {
            System.out.println("\nWarning: duplicate UDL(s) removed from the UDL list\n");
        }
        i = 0;
        StringBuffer finalUDL = new StringBuffer(500);
        for (String s : udlSet) {
            finalUDL.append(domainName);
            finalUDL.append("://");
            finalUDL.append(s);
            finalUDL.append(";");
            if (i++ != 0) continue;
            this.UDLremainder = s;
        }
        finalUDL.deleteCharAt(finalUDL.length() - 1);
        this.domain = domainName;
        return finalUDL.toString();
    }

    private String readConfigFile(String fileName) throws IOException, cMsgException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new cMsgException("specified file in UDL does NOT exist");
        }
        if (!file.canRead()) {
            throw new cMsgException("specified file in UDL cannot be read");
        }
        String s = "";
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while (reader.ready() && s.length() < 1 && (s = reader.readLine().trim()) != null) {
        }
        return s;
    }

    private String[] parseUDL(String UDL) throws cMsgException {
        if (UDL == null) {
            throw new cMsgException("invalid UDL");
        }
        Pattern pattern = Pattern.compile("(cMsg)?:?([\\w\\-]+)://(.*)", 2);
        Matcher matcher = pattern.matcher(UDL);
        if (!matcher.matches()) {
            throw new cMsgException("invalid UDL");
        }
        String s0 = matcher.group(1);
        String s1 = matcher.group(2);
        String s2 = matcher.group(3);
        if (this.debug >= 4) {
            System.out.println("\nparseUDL: \n  space     = " + s0 + "\n  domain    = " + s1 + "\n  remainder = " + s2);
        }
        if (s1 == null) {
            throw new cMsgException("invalid UDL");
        }
        if (s2 == null) {
            throw new cMsgException("invalid UDL");
        }
        return new String[]{s1, s2};
    }

    private cMsgDomainInterface createDomainConnection() throws cMsgException {
        cMsgException ex;
        cMsgDomainInterface domainConnection;
        String domainConnectionClass = null;
        for (Object obj : System.getProperties().keySet()) {
            String s = (String)obj;
            if (s.contains(".") || !s.equalsIgnoreCase(this.domain)) continue;
            domainConnectionClass = System.getProperty(s);
        }
        if (domainConnectionClass == null) {
            domainConnectionClass = System.getenv("CMSG_DOMAIN");
        }
        if (domainConnectionClass == null) {
            if (this.domain.equalsIgnoreCase("cMsg")) {
                domainConnectionClass = "org.jlab.coda.cMsg.cMsgDomain.client.cMsg";
            } else if (this.domain.equalsIgnoreCase("rc")) {
                domainConnectionClass = "org.jlab.coda.cMsg.RCDomain.RunControl";
            } else if (this.domain.equalsIgnoreCase("emu")) {
                domainConnectionClass = "org.jlab.coda.cMsg.EmuDomain.EmuClient";
            } else if (this.domain.equalsIgnoreCase("rcs")) {
                domainConnectionClass = "org.jlab.coda.cMsg.RCServerDomain.RCServer";
            } else if (this.domain.equalsIgnoreCase("rcm")) {
                domainConnectionClass = "org.jlab.coda.cMsg.RCMulticastDomain.RCMulticast";
            } else if (this.domain.equalsIgnoreCase("TCPS")) {
                domainConnectionClass = "org.jlab.coda.cMsg.TCPSDomain.TCPS";
            } else if (this.domain.equalsIgnoreCase("file")) {
                domainConnectionClass = "org.jlab.coda.cMsg.FileDomain.File";
            } else if (this.domain.equalsIgnoreCase("CA")) {
                domainConnectionClass = "org.jlab.coda.cMsg.CADomain.CA";
            }
        }
        if (domainConnectionClass == null) {
            cMsgException ex2 = new cMsgException("no handler class found");
            ex2.setReturnCode(21);
            throw ex2;
        }
        try {
            domainConnection = (cMsgDomainInterface)Class.forName(domainConnectionClass).newInstance();
        }
        catch (InstantiationException e) {
            ex = new cMsgException("cannot instantiate " + domainConnectionClass + " class");
            ex.setReturnCode(1);
            throw ex;
        }
        catch (IllegalAccessException e) {
            ex = new cMsgException("cannot access " + domainConnectionClass + " class");
            ex.setReturnCode(1);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            ex = new cMsgException("no handler class found");
            ex.setReturnCode(21);
            throw ex;
        }
        return domainConnection;
    }

    public void connect() throws cMsgException {
        this.connection.connect();
    }

    public void disconnect() throws cMsgException {
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public void send(cMsgMessage message) throws cMsgException {
        this.connection.send(message);
    }

    public int syncSend(cMsgMessage message, int timeout) throws cMsgException {
        return this.connection.syncSend(message, timeout);
    }

    public void flush(int timeout) throws cMsgException {
        this.connection.flush(timeout);
    }

    public cMsgMessage subscribeAndGet(String subject, String type, int timeout) throws cMsgException, TimeoutException {
        return this.connection.subscribeAndGet(subject, type, timeout);
    }

    public cMsgMessage sendAndGet(cMsgMessage message, int timeout) throws cMsgException, TimeoutException {
        return this.connection.sendAndGet(message, timeout);
    }

    public cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        return this.connection.subscribe(subject, type, cb3, userObj);
    }

    public void unsubscribe(cMsgSubscriptionHandle handle) throws cMsgException {
        this.connection.unsubscribe(handle);
    }

    public cMsgMessage monitor(String command) throws cMsgException {
        return this.connection.monitor(command);
    }

    public void start() {
        this.connection.start();
    }

    public void stop() {
        this.connection.stop();
    }

    public void shutdownClients(String client, boolean includeMe) throws cMsgException {
        this.connection.shutdownClients(client, includeMe);
    }

    public void shutdownServers(String server, boolean includeMyServer) throws cMsgException {
        this.connection.shutdownClients(server, includeMyServer);
    }

    public void setShutdownHandler(cMsgShutdownHandlerInterface handler) {
        this.connection.setShutdownHandler(handler);
    }

    public cMsgShutdownHandlerInterface getShutdownHandler() {
        return this.connection.getShutdownHandler();
    }

    public String getDomain() {
        return this.connection.getDomain();
    }

    public String getUDL() {
        return this.UDL;
    }

    public void setUDL(String UDL) throws cMsgException {
        this.connection.setUDL(UDL);
    }

    public String getCurrentUDL() {
        return this.connection.getCurrentUDL();
    }

    public String getUDLRemainder() {
        return this.UDLremainder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHost() {
        return this.connection.getHost();
    }

    public String getServerHost() {
        return this.connection.getServerHost();
    }

    public int getServerPort() {
        return this.connection.getServerPort();
    }

    public String getInfo(String s) {
        return this.connection.getInfo(s);
    }

    public boolean isReceiving() {
        return this.connection.isReceiving();
    }
}

