/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class cMsgFindLocalNetworkInfo {
    public static void main(String[] args) {
        Object canonicalIP = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            System.out.println("Canonical host name = " + localHost.getCanonicalHostName());
            System.out.println("Canonical host IP   = " + InetAddress.getByName(localHost.getCanonicalHostName()).getHostAddress());
        }
        catch (UnknownHostException localHost) {
            // empty catch block
        }
        LinkedList<String> ipList = new LinkedList<String>();
        try {
            System.out.println("\nIterating over interfaces:");
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (ni.isUp()) {
                    System.out.println("  On network interface " + ni.getDisplayName() + ":");
                } else {
                    System.out.println("  On network interface " + ni.getDisplayName() + " (down):");
                }
                if (ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    String ipAddr;
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.getAddress().length != 4 || (ipAddr = addr.getHostAddress()).equals(canonicalIP)) continue;
                    ipList.add(addr.getHostAddress());
                    System.out.println("    " + ipAddr);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            InetAddress[] localAddrs;
            System.out.println("\nGetting all IP addresses of canonical host directly:");
            for (InetAddress addr : localAddrs = InetAddress.getAllByName(InetAddress.getLocalHost().getCanonicalHostName())) {
                System.out.println("  " + addr.getHostAddress() + " (name = " + addr.getHostName() + ")");
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

