/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.cMsg.cMsgException;

public class etTest {
    etTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                etTest.usage();
                System.exit(-1);
                continue;
            }
            etTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java etTest\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            etTest tp = new etTest(args);
            tp.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        try {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putInt(1);
            buf.putInt(2);
            buf.putInt(3);
            buf.putInt(4);
            buf.position(8).limit(16);
            ByteBuffer slice = buf.slice();
            slice.order(ByteOrder.LITTLE_ENDIAN);
            buf.position(0).limit(16);
            byte[] bufBack = buf.array();
            System.out.println("buf pos = " + buf.position() + ", lim = " + buf.limit());
            System.out.println("buf backing array, len = " + bufBack.length);
            System.out.println("Data is:");
            System.out.println("" + buf.getInt());
            System.out.println("" + buf.getInt());
            System.out.println("" + buf.getInt());
            System.out.println("" + buf.getInt());
            System.out.println("Backing array offset is " + buf.arrayOffset());
            byte[] sliceBack = slice.array();
            System.out.println("slice pos = " + slice.position() + ", lim = " + slice.limit());
            System.out.println("slice backing array, len = " + sliceBack.length);
            System.out.println("Data is:");
            System.out.println("" + slice.getInt());
            System.out.println("" + slice.getInt());
            System.out.println("Backing array offset is " + slice.arrayOffset());
            if (bufBack == sliceBack) {
                System.out.println("Both backing arrays are the same");
            } else {
                System.out.println("Both backing arrays are the diff");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

