/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class cMsgTestRcServer {
    private String rcClientHost;
    private int rcClientTcpPort;
    private CountDownLatch latch;
    private int count;
    private boolean debug;
    private String UDL;
    private String rcsUDL;

    cMsgTestRcServer(String[] args) {
        this.decodeCommandLine(args);
        this.latch = new CountDownLatch(1);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgTestRcServer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgTestRcServer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgTestRcServer\n        [-u <UDL>]           set UDL to start multicast domain server\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) throws cMsgException {
        cMsgTestRcServer server = new cMsgTestRcServer(args);
        server.run();
    }

    public void run() throws cMsgException {
        System.out.println("Starting RC Multicast Domain test server");
        if (this.UDL == null) {
            this.UDL = "cMsg:rcm:///testExpid?multicastTO=1";
        }
        cMsg cmsg = new cMsg(this.UDL, "multicast listener", "udp trial");
        try {
            cmsg.connect();
        }
        catch (cMsgException e) {
            System.out.println(e.getMessage());
            return;
        }
        MulticastCallback cb3 = new MulticastCallback();
        cmsg.subscribe("sub", "type", cb3, null);
        cmsg.start();
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Starting RC Server Domain test server with UDL: ");
        System.out.println("    " + this.rcsUDL);
        cMsg server = new cMsg(this.rcsUDL, "rc server", "udp trial");
        server.connect();
        server.start();
        rcCallback cb22 = new rcCallback();
        cMsgSubscriptionHandle unsub = server.subscribe("subby", "typey", cb22, null);
        System.out.println("wait 2 sec");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("done waiting");
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject("rcSubject");
        msg.setType("rcType");
        server.send(msg);
        System.out.println("Sent msg (sub = rcSubject, typ = rcType) to rc client, wait 2 sec ...\n");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            msg.setSubject("sAndGSubject");
            msg.setType("sAndGType");
            System.out.println("Call sendAndGet msg (sub = sAndGSubject, typ = sAndGType) to rc client");
            cMsgMessage response = server.sendAndGet(msg, 4000);
            System.out.println("Response msg sub = " + response.getSubject() + ", type = " + response.getType() + ", text = " + response.getText());
            response.payloadPrintout(0);
        }
        catch (TimeoutException e) {
            System.out.println("TIMEOUT");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        server.unsubscribe(unsub);
        server.disconnect();
    }

    class rcCallback
    extends cMsgCallbackAdapter {
        rcCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            cMsgTestRcServer.this.count++;
            System.out.println("Running RC Server domain callback");
            System.out.println("              msg text = " + msg.getText());
            System.out.println("              msg  sub = " + msg.getSubject());
            System.out.println("              msg type = " + msg.getType());
            msg.payloadPrintout(0);
        }
    }

    class MulticastCallback
    extends cMsgCallbackAdapter {
        MulticastCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            cMsgTestRcServer.this.rcClientHost = msg.getSenderHost();
            cMsgTestRcServer.this.rcClientTcpPort = msg.getUserInt();
            System.out.println("Running RC Multicast domain callback, host = " + cMsgTestRcServer.this.rcClientHost + ", port = " + cMsgTestRcServer.this.rcClientTcpPort + ", name = " + msg.getSender());
            cMsgPayloadItem item1 = msg.getPayloadItem("IpAddresses");
            cMsgPayloadItem item2 = msg.getPayloadItem("BroadcastAddresses");
            if (item1 != null && item2 != null) {
                try {
                    String[] ipAddrs = item1.getStringArray();
                    String[] bcAddrs = item2.getStringArray();
                    StringBuilder builder = new StringBuilder(512);
                    for (int i = 0; i < ipAddrs.length; ++i) {
                        builder.append("rcs://");
                        builder.append(ipAddrs[i]);
                        builder.append(":");
                        builder.append(cMsgTestRcServer.this.rcClientTcpPort);
                        builder.append("/");
                        builder.append(bcAddrs[i]);
                        if (i >= ipAddrs.length - 1) continue;
                        builder.append(";");
                    }
                    cMsgTestRcServer.this.rcsUDL = builder.toString();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            cMsgTestRcServer.this.latch.countDown();
        }
    }
}

