/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class VardanServer {
    private String name = "Vardan_Server";
    private String description = "vardan serverr";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;
    private long count;
    cMsg coda;

    VardanServer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                VardanServer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            VardanServer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgConsumer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            VardanServer consumer = new VardanServer(args);
            consumer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running Vardan Server");
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        adminCb cb3 = new adminCb();
        cMsgSubscriptionHandle unsub = this.coda.subscribe("admin", "send", cb3, null);
        long totalT = 0L;
        long totalC = 0L;
        long period = 5000L;
        while (true) {
            this.count = 0L;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double freq = (double)this.count / (double)period * 1000.0;
            double freqAvg = (double)(totalC += this.count) / (double)(totalT += period) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.count + ", " + this.doubleToString(freq, 1) + " Hz, Avg = " + this.doubleToString(freqAvg, 1) + " Hz");
            }
            if (this.coda.isConnected()) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.coda.isConnected()) continue;
            System.out.println("No longer connected to domain server, quitting");
            System.exit(-1);
        }
    }

    class sendingCb
    extends cMsgCallbackAdapter {
        sendingCb() {
        }

        @Override
        public boolean maySkipMessages() {
            return true;
        }

        @Override
        public int getMaximumQueueSize() {
            return 1002;
        }

        @Override
        public int getSkipSize() {
            return 100;
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            VardanServer.this.count++;
            try {
                cMsgMessage message = new cMsgMessage();
                message.setSubject(msg.getText());
                message.setType("data");
                message.setText("blah blah blah");
                VardanServer.this.coda.send(message);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }

    class adminCb
    extends cMsgCallbackAdapter {
        adminCb() {
        }

        @Override
        public boolean maySkipMessages() {
            return true;
        }

        @Override
        public int getMaximumQueueSize() {
            return 1001;
        }

        @Override
        public int getSkipSize() {
            return 100;
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("\nReceived message to admin/send");
            try {
                System.out.println("Subscribe to " + msg.getText() + "/sendone");
                sendingCb cb3 = new sendingCb();
                cMsgSubscriptionHandle unsub = VardanServer.this.coda.subscribe(msg.getText(), "sendone", cb3, null);
                cMsgMessage message = new cMsgMessage();
                message.setSubject(msg.getText());
                message.setType("start");
                System.out.println("Send msg to " + msg.getText() + "/start");
                VardanServer.this.coda.send(message);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }
}

