/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.util.Date;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class DoubleTest {
    private String subject1 = "doubleSender";
    private String type1 = "type";
    private String subject2 = "doubleReceiver";
    private String type2 = "type";
    private String name = "payload tester";
    private String description = "java producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay = 2000;
    private boolean debug;
    cMsg coda;
    cMsg codaSend;

    DoubleTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DoubleTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            DoubleTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java DoubleTest\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            DoubleTest dt = new DoubleTest(args);
            dt.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg double sending test");
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.codaSend = new cMsg(this.UDL, "another sender", this.description);
        this.codaSend.connect();
        this.coda.start();
        DoubleSendingCallback cb_s = new DoubleSendingCallback();
        cMsgSubscriptionHandle unsub_s = this.coda.subscribe(this.subject1, this.type1, cb_s, null);
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setSubject(this.subject1);
        msg.setType(this.type1);
        msg.setUserTime(new Date());
        msg.setNoHistoryAdditions(true);
        while (true) {
            this.coda.send(msg);
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    class DoubleReceivingCallback
    extends cMsgCallbackAdapter {
        DoubleReceivingCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (msg.hasPayload()) {
                cMsgPayloadItem item = msg.getPayloadItem("int");
                try {
                    int i = item.getInt();
                    System.out.println("q2 " + msg.getContext().getQueueSize());
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
            } else {
                int i = msg.getUserInt();
                System.out.println("q2 " + msg.getContext().getQueueSize());
            }
        }
    }

    class DoubleSendingCallback
    extends cMsgCallbackAdapter {
        DoubleSendingCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            cMsgMessageFull message = new cMsgMessageFull();
            message.setSubject(DoubleTest.this.subject2);
            message.setType(DoubleTest.this.type2);
            double d = 0.3333333333333333;
            int i = 2;
            try {
                cMsgPayloadItem item = new cMsgPayloadItem("int", i);
                message.addPayloadItem(item);
                System.out.println("q1 " + msg.getContext().getQueueSize());
                message.setNoHistoryAdditions(true);
                DoubleTest.this.coda.send(message);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean maySkipMessages() {
            return false;
        }

        @Override
        public int getSkipSize() {
            return 1;
        }
    }
}

