/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public final class cMsgPayloadItem
implements Cloneable,
Serializable {
    String name;
    String text;
    private int type;
    private int originalType;
    private String originalText;
    private int count = 1;
    private int noHeaderLen;
    private int endian = 0;
    private int[] endianArray;
    private boolean isSystem;
    private Object item;
    private static final int CMSG_PAYLOAD_NAME_LEN_MAX = 128;
    private static final String EXCLUDED_CHARS = " \t\n`'\"";
    private static final String[] toASCII = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};

    public Object clone() {
        try {
            cMsgPayloadItem result = (cMsgPayloadItem)super.clone();
            if (this.endianArray != null) {
                result.endianArray = (int[])this.endianArray.clone();
            }
            if (this.type == 22) {
                result.item = ((byte[])this.item).clone();
            } else if (this.type == 23) {
                result.item = ((String[])this.item).clone();
            } else if (this.type == 25) {
                result.item = ((double[])this.item).clone();
            } else if (this.type == 24) {
                result.item = ((float[])this.item).clone();
            } else if (this.type == 26) {
                result.item = ((byte[])this.item).clone();
            } else if (this.type == 27) {
                result.item = ((short[])this.item).clone();
            } else if (this.type == 28) {
                result.item = ((int[])this.item).clone();
            } else if (this.type == 29) {
                result.item = ((long[])this.item).clone();
            } else if (this.type == 33) {
                result.item = ((BigInteger[])this.item).clone();
            } else if (this.type == 21) {
                result.item = ((cMsgMessage)this.item).clone();
            } else if (this.type == 34) {
                cMsgMessage[] msgs = (cMsgMessage[])this.item;
                result.item = new cMsgMessage[this.count];
                for (int i = 0; i < msgs.length; ++i) {
                    ((cMsgMessage[])result.item)[i] = (cMsgMessage)msgs[i].clone();
                }
            } else if (this.type == 35) {
                byte[][] bb = (byte[][])this.item;
                result.item = new byte[this.count][];
                for (int i = 0; i < bb.length; ++i) {
                    ((byte[][])result.item)[i] = (byte[])bb[i].clone();
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public cMsgPayloadItem copy() {
        return (cMsgPayloadItem)this.clone();
    }

    static int numDigits(long number) {
        int digits = 1;
        long step = 10L;
        if (number < 0L) {
            ++digits;
            number *= -1L;
        }
        while (step <= number) {
            ++digits;
            step *= 10L;
        }
        return digits;
    }

    static int numDigits(BigInteger number) {
        int digits = 1;
        BigInteger step = BigInteger.TEN;
        BigInteger minus1 = new BigInteger("-1");
        if (number.compareTo(BigInteger.ZERO) < 0) {
            ++digits;
            number = number.multiply(minus1);
        }
        while (step.compareTo(number) <= 0) {
            ++digits;
            step = step.multiply(BigInteger.TEN);
        }
        return digits;
    }

    private static void validName(String name, boolean isSystem) throws cMsgException {
        if (name == null) {
            throw new cMsgException("name argument is null");
        }
        for (char c : EXCLUDED_CHARS.toCharArray()) {
            if (name.indexOf(c) <= -1) continue;
            throw new cMsgException("name contains illegal character \"" + c + "\"");
        }
        if (name.length() > 128) {
            throw new cMsgException("name too long, 128 chars allowed");
        }
        if (!isSystem && name.toLowerCase().startsWith("cmsg")) {
            throw new cMsgException("names may not start with \"cmsg\"");
        }
    }

    static boolean validSystemName(String name) {
        if (name == null) {
            return false;
        }
        for (char c : EXCLUDED_CHARS.toCharArray()) {
            if (name.indexOf(c) <= -1) continue;
            return false;
        }
        if (name.length() > 128) {
            return false;
        }
        return name.toLowerCase().startsWith("cmsg");
    }

    private static int checkEndian(int endian) throws cMsgException {
        if (endian != 0 && endian != 1 && endian != 2 && endian != 3) {
            throw new cMsgException("endian value must be cMsgConstants.Big/Little/Local/NotLocal");
        }
        if (endian == 1 || endian == 3) {
            return 1;
        }
        return 0;
    }

    private static void zerosToIntStr(StringBuilder sb, int zeros) {
        sb.append("Z");
        sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
        sb.append(toASCII[zeros >> 16 & 0xFF]);
        sb.append(toASCII[zeros >> 8 & 0xFF]);
        sb.append(toASCII[zeros & 0xFF]);
    }

    private static void zerosToLongStr(StringBuilder sb, int zeros) {
        sb.append("Z00000000");
        sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
        sb.append(toASCII[zeros >> 16 & 0xFF]);
        sb.append(toASCII[zeros >> 8 & 0xFF]);
        sb.append(toASCII[zeros & 0xFF]);
    }

    private static void longToStr(StringBuilder sb, long l) {
        sb.append(toASCII[(int)(l >> 56 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 48 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 40 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 32 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 24 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 16 & 0xFFL)]);
        sb.append(toASCII[(int)(l >> 8 & 0xFFL)]);
        sb.append(toASCII[(int)(l & 0xFFL)]);
    }

    private static final void intToStr(StringBuilder sb, int i) {
        sb.append(toASCII[i >> 24 & 0xFF]);
        sb.append(toASCII[i >> 16 & 0xFF]);
        sb.append(toASCII[i >> 8 & 0xFF]);
        sb.append(toASCII[i & 0xFF]);
    }

    public cMsgPayloadItem(String name, String s) throws cMsgException {
        if (s == null) {
            throw new cMsgException("cannot add null payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addString(name, s, false);
    }

    cMsgPayloadItem(String name, String s, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addString(name, s, isSystem);
    }

    cMsgPayloadItem(String name, String s, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addString(name, s, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, String[] s) throws cMsgException {
        if (s == null || s.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (String val : s) {
            if (val != null) continue;
            throw new cMsgException("string array contains null, cannot add payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addString(name, s, false);
    }

    cMsgPayloadItem(String name, String[] s, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addString(name, s, isSystem);
    }

    cMsgPayloadItem(String name, String[] s, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addString(name, s, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, byte[] b, int end) throws cMsgException {
        if (b == null) {
            throw new cMsgException("cannot add null payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.endian = cMsgPayloadItem.checkEndian(end);
        this.addBinary(name, b, false);
    }

    cMsgPayloadItem(String name, byte[] b, int end, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.endian = cMsgPayloadItem.checkEndian(end);
        this.addBinary(name, b, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, byte[][] b, int[] end) throws cMsgException {
        if (b == null || b.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (byte[] array : b) {
            if (array != null) continue;
            throw new cMsgException("array of byte arrays contains null, cannot add payload item");
        }
        cMsgPayloadItem.validName(name, false);
        if (b.length > end.length) {
            throw new cMsgException("need an endian value for each byte array");
        }
        this.endianArray = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            this.endianArray[i] = cMsgPayloadItem.checkEndian(end[i]);
        }
        this.addBinary(name, b, false);
    }

    public cMsgPayloadItem(String name, byte[][] b) throws cMsgException {
        if (b == null || b.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (byte[] array : b) {
            if (array != null) continue;
            throw new cMsgException("array of byte arrays contains null, cannot add payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.endianArray = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            this.endianArray[i] = 0;
        }
        this.addBinary(name, b, false);
    }

    cMsgPayloadItem(String name, byte[][] b, int[] end, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        if (b.length > end.length) {
            throw new cMsgException("need an endian value for each byte array");
        }
        this.endianArray = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            this.endianArray[i] = cMsgPayloadItem.checkEndian(end[i]);
        }
        this.addBinary(name, b, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, cMsgMessage msg) throws cMsgException {
        if (msg == null) {
            throw new cMsgException("cannot add null payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addMessage(name, msg, false);
    }

    cMsgPayloadItem(String name, cMsgMessage msg, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addMessage(name, msg, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, cMsgMessage[] msgs) throws cMsgException {
        if (msgs == null || msgs.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (cMsgMessage msg : msgs) {
            if (msg != null) continue;
            throw new cMsgException("array of messages contains null, cannot add payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addMessage(name, msgs, false);
    }

    cMsgPayloadItem(String name, cMsgMessage[] msgs, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addMessage(name, msgs, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, byte b) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addByte(name, b, false);
    }

    cMsgPayloadItem(String name, byte b, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addByte(name, b, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, short s) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addShort(name, s, false);
    }

    cMsgPayloadItem(String name, short s, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addShort(name, s, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, int i) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addInt(name, i, false);
    }

    cMsgPayloadItem(String name, int i, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addInt(name, i, isSystem);
    }

    cMsgPayloadItem(String name, int i, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addInt(name, i, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, long l) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addLong(name, l, false);
    }

    cMsgPayloadItem(String name, long l, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addLong(name, l, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, BigInteger big) throws cMsgException {
        if (big == null) {
            throw new cMsgException("cannot add null payload item");
        }
        cMsgPayloadItem.validName(name, false);
        if (big.compareTo(new BigInteger("18446744073709551615")) > 0 || big.compareTo(BigInteger.ZERO) < 0) {
            throw new cMsgException("number must fit in an unsigned, 64-bit int");
        }
        this.addNumber(name, big, 20, false);
    }

    cMsgPayloadItem(String name, BigInteger big, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addBigInt(name, big, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, byte[] b) throws cMsgException {
        if (b == null || b.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addByte(name, b, false, true);
    }

    cMsgPayloadItem(String name, byte[] b, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addByte(name, b, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, short[] s) throws cMsgException {
        if (s == null || s.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addShort(name, s, false, true);
    }

    cMsgPayloadItem(String name, short[] s, String txt, int noHeadLen, boolean isSystem, boolean unsigned) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addShort(name, s, txt, isSystem, unsigned, noHeadLen);
    }

    public cMsgPayloadItem(String name, int[] i) throws cMsgException {
        if (i == null || i.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addInt(name, i, false, true);
    }

    cMsgPayloadItem(String name, int[] i, String txt, int noHeadLen, boolean isSystem, boolean unsigned) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addInt(name, i, txt, isSystem, unsigned, noHeadLen);
    }

    public cMsgPayloadItem(String name, long[] l) throws cMsgException {
        if (l == null || l.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addLong(name, l, false, true);
    }

    cMsgPayloadItem(String name, long[] l, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addLong(name, l, isSystem, false);
    }

    cMsgPayloadItem(String name, long[] l, String txt, int noHeadLen, boolean isSystem, boolean unsigned) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addLong(name, l, txt, isSystem, unsigned, noHeadLen);
    }

    public cMsgPayloadItem(String name, BigInteger[] bigs) throws cMsgException {
        if (bigs == null || bigs.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (BigInteger big : bigs) {
            if (big != null) continue;
            throw new cMsgException("array of BigIntegers contains null, cannot add payload item");
        }
        cMsgPayloadItem.validName(name, false);
        for (BigInteger bi : bigs) {
            if (bi.compareTo(new BigInteger("18446744073709551615")) <= 0 && bi.compareTo(BigInteger.ZERO) >= 0) continue;
            throw new cMsgException("number must fit in an unsigned, 64-bit int");
        }
        this.addNumber(name, (Number)bigs, 33, false);
    }

    cMsgPayloadItem(String name, BigInteger[] bigs, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addBigInt(name, bigs, txt, isSystem, noHeadLen);
    }

    public <T extends Number> cMsgPayloadItem(String name, T[] ta) throws cMsgException {
        int typ;
        if (ta == null || ta.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        for (T t : ta) {
            if (t != null) continue;
            throw new cMsgException("array of BigIntegers contains null, cannot add payload item");
        }
        String s = ta[0].getClass().getName();
        System.out.println("class = " + s);
        cMsgPayloadItem.validName(name, false);
        if (s.equals("java.lang.Byte")) {
            typ = 26;
            System.out.println("Got type = Byte !!");
        } else if (s.equals("java.lang.Short")) {
            typ = 27;
            System.out.println("Got type = Short !!");
        } else if (s.equals("java.lang.Integer")) {
            typ = 28;
        } else if (s.equals("java.lang.Long")) {
            typ = 29;
        } else if (s.equals("java.lang.Float")) {
            typ = 24;
        } else if (s.equals("java.lang.Double")) {
            typ = 25;
        } else {
            throw new cMsgException("Type T[]" + s + " not allowed");
        }
        this.addNumber(name, (T)ta, typ, false);
    }

    public cMsgPayloadItem(String name, float f) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addFloat(name, f, false);
    }

    cMsgPayloadItem(String name, float f, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addFloat(name, f, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, double d) throws cMsgException {
        cMsgPayloadItem.validName(name, false);
        this.addDouble(name, d, false);
    }

    cMsgPayloadItem(String name, double d, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addDouble(name, d, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, float[] f) throws cMsgException {
        if (f == null || f.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addFloat(name, f, false, true);
    }

    cMsgPayloadItem(String name, float[] f, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addFloat(name, f, txt, isSystem, noHeadLen);
    }

    public cMsgPayloadItem(String name, double[] d) throws cMsgException {
        if (d == null || d.length < 1) {
            throw new cMsgException("cannot add null/empty payload item");
        }
        cMsgPayloadItem.validName(name, false);
        this.addDouble(name, d, false, true);
    }

    cMsgPayloadItem(String name, double[] d, String txt, int noHeadLen, boolean isSystem) throws cMsgException {
        cMsgPayloadItem.validName(name, isSystem);
        this.addDouble(name, d, txt, isSystem, noHeadLen);
    }

    private void addString(String name, String val, boolean isSystem) {
        this.item = val;
        this.type = 10;
        this.name = name;
        this.isSystem = isSystem;
        this.noHeaderLen = cMsgPayloadItem.numDigits(val.length()) + val.length() + 2;
        StringBuffer buf = new StringBuffer(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(" ");
        buf.append(isSystem ? 1 : 0);
        buf.append(" ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        buf.append(val.length());
        buf.append("\n");
        buf.append(val);
        buf.append("\n");
        this.text = buf.toString();
    }

    private void addString(String name, String val, String txt, boolean isSystem, int noHeadLen) {
        this.item = val;
        this.type = 10;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addString(String name, String[] vals, boolean isSystem) {
        this.item = vals.clone();
        this.count = vals.length;
        this.type = 23;
        this.name = name;
        this.isSystem = isSystem;
        StringBuilder sb = new StringBuilder(200);
        for (String val : vals) {
            sb.append(val.length());
            sb.append("\n");
            sb.append(val);
            sb.append("\n");
        }
        this.noHeaderLen = sb.length();
        StringBuffer buf = new StringBuffer(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(" ");
        buf.append(isSystem ? 1 : 0);
        buf.append(" ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        buf.append((CharSequence)sb);
        this.text = buf.toString();
    }

    private void addString(String name, String[] vals, String txt, boolean isSystem, int noHeadLen) {
        this.item = vals;
        this.count = vals.length;
        this.type = 23;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addBinary(String name, byte[] bin, boolean isSystem) {
        this.item = bin.clone();
        this.type = 22;
        this.name = name;
        this.isSystem = isSystem;
        String encodedBin = cMsgMessage.b64Encoder.encodeToString(bin);
        this.noHeaderLen += cMsgPayloadItem.numDigits(encodedBin.length()) + cMsgPayloadItem.numDigits(bin.length) + encodedBin.length() + 4;
        StringBuffer buf = new StringBuffer(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(isSystem ? " 1 1 " : " 1 0 ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        buf.append(encodedBin.length());
        buf.append(" ");
        buf.append(bin.length);
        buf.append(" ");
        buf.append(this.endian);
        buf.append("\n");
        buf.append(encodedBin);
        this.text = buf.toString();
    }

    private void addBinary(String name, byte[] bin, String txt, boolean isSystem, int noHeadLen) {
        this.item = bin;
        this.type = 22;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addBinary(String name, byte[][] bin, boolean isSystem) {
        byte[][] b = new byte[bin.length][];
        for (int i = 0; i < bin.length; ++i) {
            b[i] = (byte[])bin[i].clone();
        }
        this.item = b;
        this.count = b.length;
        this.type = 35;
        this.name = name;
        this.isSystem = isSystem;
        this.noHeaderLen = 0;
        String[] encodedStrs = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            encodedStrs[i] = cMsgMessage.b64Encoder.encodeToString(b[i]);
            this.noHeaderLen += cMsgPayloadItem.numDigits(encodedStrs[i].length()) + cMsgPayloadItem.numDigits(b[i].length) + encodedStrs[i].length() + 4;
        }
        StringBuffer buf = new StringBuffer(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(isSystem ? " 1 " : " 0 ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        for (int i = 0; i < this.count; ++i) {
            buf.append(encodedStrs[i].length());
            buf.append(" ");
            buf.append(b[i].length);
            buf.append(" ");
            buf.append(this.endianArray[i]);
            buf.append("\n");
            buf.append(encodedStrs[i]);
        }
        this.text = buf.toString();
    }

    private void addBinary(String name, byte[][] bin, String txt, boolean isSystem, int noHeadLen) {
        this.item = bin;
        this.count = bin.length;
        this.type = 35;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void systemStringToBuf(String name, StringBuilder buf, String s) {
        int len = cMsgPayloadItem.numDigits(s.length()) + s.length() + 2;
        buf.append(name);
        buf.append(" ");
        buf.append(10);
        buf.append(" 1 1 ");
        buf.append(len);
        buf.append("\n");
        buf.append(s.length());
        buf.append("\n");
        buf.append(s);
        buf.append("\n");
    }

    private void addMessage(String name, cMsgMessage msg, String txt, boolean isSystem, int noHeadLen) {
        this.item = msg;
        this.type = 21;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addMessage(String name, cMsgMessage msg, boolean isSystem) {
        this.item = msg.clone();
        this.type = 21;
        this.name = name;
        this.isSystem = isSystem;
        int size = 0;
        String payloadRep = msg.getItemsText();
        if (payloadRep != null) {
            size += payloadRep.length();
        }
        if (msg.getText() != null) {
            size += msg.getText().length();
        }
        size = (int)((double)size + (double)msg.getByteArrayLength() * 1.4);
        int fieldCount = 0;
        StringBuilder buf = new StringBuilder(size + 2048);
        if (msg.getDomain() != null) {
            this.systemStringToBuf("cMsgDomain", buf, msg.getDomain());
            ++fieldCount;
        }
        if (msg.getSubject() != null) {
            this.systemStringToBuf("cMsgSubject", buf, msg.getSubject());
            ++fieldCount;
        }
        if (msg.getType() != null) {
            this.systemStringToBuf("cMsgType", buf, msg.getType());
            ++fieldCount;
        }
        if (msg.getText() != null) {
            this.systemStringToBuf("cMsgText", buf, msg.getText());
            ++fieldCount;
        }
        if (msg.getSender() != null) {
            this.systemStringToBuf("cMsgSender", buf, msg.getSender());
            ++fieldCount;
        }
        if (msg.getSenderHost() != null) {
            this.systemStringToBuf("cMsgSenderHost", buf, msg.getSenderHost());
            ++fieldCount;
        }
        if (msg.getReceiver() != null) {
            this.systemStringToBuf("cMsgReceiver", buf, msg.getReceiver());
            ++fieldCount;
        }
        if (msg.getReceiverHost() != null) {
            this.systemStringToBuf("cMsgReceiverHost", buf, msg.getReceiverHost());
            ++fieldCount;
        }
        StringBuilder sb = new StringBuilder(100);
        cMsgPayloadItem.intToStr(sb, msg.getVersion());
        sb.append(" ");
        cMsgPayloadItem.intToStr(sb, msg.getInfo());
        sb.append(" ");
        cMsgPayloadItem.intToStr(sb, msg.reserved);
        sb.append(" ");
        cMsgPayloadItem.intToStr(sb, msg.getByteArrayLength());
        sb.append(" ");
        cMsgPayloadItem.intToStr(sb, msg.getUserInt());
        sb.append("\n");
        buf.append("cMsgInts ");
        buf.append(28);
        buf.append(" 5 1 ");
        buf.append(sb.length());
        buf.append("\n");
        buf.append((CharSequence)sb);
        ++fieldCount;
        sb.delete(0, sb.length());
        long t = msg.getUserTime().getTime();
        cMsgPayloadItem.longToStr(sb, t / 1000L);
        sb.append(" ");
        cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
        sb.append(" ");
        t = msg.getSenderTime().getTime();
        cMsgPayloadItem.longToStr(sb, t / 1000L);
        sb.append(" ");
        cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
        sb.append(" ");
        t = msg.getReceiverTime().getTime();
        cMsgPayloadItem.longToStr(sb, t / 1000L);
        sb.append(" ");
        cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
        sb.append("\n");
        buf.append("cMsgTimes ");
        buf.append(29);
        buf.append(" 6 1 ");
        buf.append(sb.length());
        buf.append("\n");
        buf.append((CharSequence)sb);
        ++fieldCount;
        int byteArrayLen = msg.getByteArrayLength();
        if (byteArrayLen > 0) {
            byte[] bites;
            if (msg.getByteArrayOffset() == 0 && byteArrayLen == msg.getByteArrayLengthFull()) {
                bites = msg.getByteArray();
            } else {
                bites = new byte[byteArrayLen];
                System.arraycopy(msg.getByteArray(), msg.getByteArrayOffset(), bites, 0, byteArrayLen);
            }
            String encodedBin = cMsgMessage.b64Encoder.encodeToString(bites);
            int len = cMsgPayloadItem.numDigits(encodedBin.length()) + cMsgPayloadItem.numDigits(msg.getByteArrayLength()) + encodedBin.length() + 4;
            buf.append("cMsgBinary ");
            buf.append(22);
            buf.append(" 1 1 ");
            buf.append(len);
            buf.append("\n");
            buf.append(encodedBin.length());
            buf.append(" ");
            buf.append(msg.getByteArrayLength());
            buf.append(" ");
            buf.append(msg.getByteArrayEndian());
            buf.append("\n");
            buf.append(encodedBin);
            ++fieldCount;
        }
        Collection<cMsgPayloadItem> c = msg.getPayloadItems().values();
        for (cMsgPayloadItem it : c) {
            buf.append(it.text);
            ++fieldCount;
        }
        this.noHeaderLen = buf.length() + cMsgPayloadItem.numDigits(fieldCount) + 1;
        StringBuilder buf2 = new StringBuilder(this.noHeaderLen + 100);
        buf2.append(name);
        buf2.append(" ");
        buf2.append(this.type);
        buf2.append(" ");
        buf2.append(this.count);
        buf2.append(" ");
        buf2.append(isSystem ? 1 : 0);
        buf2.append(" ");
        buf2.append(this.noHeaderLen);
        buf2.append("\n");
        buf2.append(fieldCount);
        buf2.append("\n");
        buf2.append((CharSequence)buf);
        this.text = buf2.toString();
    }

    private void addMessage(String name, cMsgMessage[] msgs, String txt, boolean isSystem, int noHeadLen) {
        this.item = msgs;
        this.count = msgs.length;
        this.type = 34;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addMessage(String name, cMsgMessage[] msgs, boolean isSystem) {
        cMsgMessage[] m = new cMsgMessage[msgs.length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (cMsgMessage)msgs[i].clone();
        }
        this.item = m;
        this.count = m.length;
        this.type = 34;
        this.name = name;
        this.isSystem = isSystem;
        int[] fieldCount = new int[this.count];
        Arrays.fill(fieldCount, 2);
        int size = 2048;
        for (int i = 0; i < this.count; ++i) {
            if (msgs[i].getItemsText() != null) {
                size += msgs[i].getItemsText().length();
            }
            if (msgs[i].getText() != null) {
                size += msgs[i].getText().length();
            }
            size = (int)((double)size + ((double)msgs[i].getByteArrayLength() * 1.4 + 1024.0));
            if (msgs[i].getDomain() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getSubject() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getType() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getText() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getSender() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getSenderHost() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getReceiver() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getDomain() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getReceiverHost() != null) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            if (msgs[i].getByteArrayLength() > 0) {
                int n = i;
                fieldCount[n] = fieldCount[n] + 1;
            }
            int n = i;
            fieldCount[n] = fieldCount[n] + msgs[i].getPayloadSize();
        }
        StringBuilder buf = new StringBuilder(size);
        StringBuilder sb = new StringBuilder(100);
        int j = 0;
        for (cMsgMessage msg : msgs) {
            buf.append(fieldCount[j++]);
            buf.append("\n");
            if (msg.getDomain() != null) {
                this.systemStringToBuf("cMsgDomain", buf, msg.getDomain());
            }
            if (msg.getSubject() != null) {
                this.systemStringToBuf("cMsgSubject", buf, msg.getSubject());
            }
            if (msg.getType() != null) {
                this.systemStringToBuf("cMsgType", buf, msg.getType());
            }
            if (msg.getText() != null) {
                this.systemStringToBuf("cMsgText", buf, msg.getText());
            }
            if (msg.getSender() != null) {
                this.systemStringToBuf("cMsgSender", buf, msg.getSender());
            }
            if (msg.getSenderHost() != null) {
                this.systemStringToBuf("cMsgSenderHost", buf, msg.getSenderHost());
            }
            if (msg.getReceiver() != null) {
                this.systemStringToBuf("cMsgReceiver", buf, msg.getReceiver());
            }
            if (msg.getReceiverHost() != null) {
                this.systemStringToBuf("cMsgReceiverHost", buf, msg.getReceiverHost());
            }
            sb.delete(0, sb.length());
            cMsgPayloadItem.intToStr(sb, msg.getVersion());
            sb.append(" ");
            cMsgPayloadItem.intToStr(sb, msg.getInfo());
            sb.append(" ");
            cMsgPayloadItem.intToStr(sb, msg.reserved);
            sb.append(" ");
            cMsgPayloadItem.intToStr(sb, msg.getByteArrayLength());
            sb.append(" ");
            cMsgPayloadItem.intToStr(sb, msg.getUserInt());
            sb.append("\n");
            buf.append("cMsgInts ");
            buf.append(28);
            buf.append(" 5 1 ");
            buf.append(sb.length());
            buf.append("\n");
            buf.append((CharSequence)sb);
            sb.delete(0, sb.length());
            long t = msg.getUserTime().getTime();
            cMsgPayloadItem.longToStr(sb, t / 1000L);
            sb.append(" ");
            cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
            sb.append(" ");
            t = msg.getSenderTime().getTime();
            cMsgPayloadItem.longToStr(sb, t / 1000L);
            sb.append(" ");
            cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
            sb.append(" ");
            t = msg.getReceiverTime().getTime();
            cMsgPayloadItem.longToStr(sb, t / 1000L);
            sb.append(" ");
            cMsgPayloadItem.longToStr(sb, (t - t / 1000L * 1000L) * 1000000L);
            sb.append("\n");
            buf.append("cMsgTimes ");
            buf.append(29);
            buf.append(" 6 1 ");
            buf.append(sb.length());
            buf.append("\n");
            buf.append((CharSequence)sb);
            int byteArrayLen = msg.getByteArrayLength();
            if (byteArrayLen > 0) {
                byte[] bites;
                if (msg.getByteArrayOffset() == 0 && byteArrayLen == msg.getByteArrayLengthFull()) {
                    bites = msg.getByteArray();
                } else {
                    bites = new byte[byteArrayLen];
                    System.arraycopy(msg.getByteArray(), msg.getByteArrayOffset(), bites, 0, byteArrayLen);
                }
                String encodedBin = cMsgMessage.b64Encoder.encodeToString(bites);
                int len = cMsgPayloadItem.numDigits(encodedBin.length()) + cMsgPayloadItem.numDigits(msg.getByteArrayLength()) + encodedBin.length() + 4;
                buf.append("cMsgBinary ");
                buf.append(22);
                buf.append(" 1 1 ");
                buf.append(len);
                buf.append("\n");
                buf.append(encodedBin.length());
                buf.append(" ");
                buf.append(msg.getByteArrayLength());
                buf.append(" ");
                buf.append(msg.getByteArrayEndian());
                buf.append("\n");
                buf.append(encodedBin);
            }
            Collection<cMsgPayloadItem> c = msg.getPayloadItems().values();
            for (cMsgPayloadItem it : c) {
                buf.append(it.text);
            }
        }
        this.noHeaderLen = buf.length();
        StringBuilder buf2 = new StringBuilder(this.noHeaderLen + 100);
        buf2.append(name);
        buf2.append(" ");
        buf2.append(this.type);
        buf2.append(" ");
        buf2.append(this.count);
        buf2.append(" ");
        buf2.append(isSystem ? 1 : 0);
        buf2.append(" ");
        buf2.append(this.noHeaderLen);
        buf2.append("\n");
        buf2.append((CharSequence)buf);
        this.text = buf2.toString();
    }

    private <T extends Number> void addNumber(String name, T t, int type, boolean isSystem) {
        this.item = t;
        this.type = type;
        this.addScalar(name, t.toString(), isSystem);
    }

    private void addBigInt(String name, BigInteger big, String txt, boolean isSystem, int noHeadLen) {
        this.item = big;
        this.type = 20;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addByte(String name, byte b, boolean isSystem) {
        this.item = b;
        this.type = 13;
        this.addScalar(name, Byte.valueOf(b).toString(), isSystem);
    }

    private void addByte(String name, byte b, String txt, boolean isSystem, int noHeadLen) {
        this.item = b;
        this.type = 13;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addShort(String name, short s, boolean isSystem) {
        this.item = s;
        this.type = 14;
        this.addScalar(name, Short.valueOf(s).toString(), isSystem);
    }

    private void addShort(String name, short s, String txt, boolean isSystem, int noHeadLen) {
        this.item = s;
        this.type = 14;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addInt(String name, int i, boolean isSystem) {
        this.item = i;
        this.type = 15;
        this.addScalar(name, Integer.valueOf(i).toString(), isSystem);
    }

    private void addInt(String name, int i, String txt, boolean isSystem, int noHeadLen) {
        this.item = i;
        this.type = 15;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addLong(String name, long l, boolean isSystem) {
        this.item = l;
        this.type = 16;
        this.addScalar(name, Long.valueOf(l).toString(), isSystem);
    }

    private void addLong(String name, long l, String txt, boolean isSystem, int noHeadLen) {
        this.item = l;
        this.type = 16;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addFloat(String name, float f, boolean isSystem) {
        this.item = Float.valueOf(f);
        this.type = 11;
        StringBuilder sb = new StringBuilder(8);
        cMsgPayloadItem.intToStr(sb, Float.floatToIntBits(f));
        this.addScalar(name, sb, isSystem);
    }

    private void addFloat(String name, float f, String txt, boolean isSystem, int noHeadLen) {
        this.item = Float.valueOf(f);
        this.type = 11;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addDouble(String name, double d, boolean isSystem) {
        this.item = d;
        this.type = 12;
        StringBuilder sb = new StringBuilder(16);
        cMsgPayloadItem.longToStr(sb, Double.doubleToLongBits(d));
        this.addScalar(name, sb, isSystem);
    }

    private void addDouble(String name, double d, String txt, boolean isSystem, int noHeadLen) {
        this.item = d;
        this.type = 12;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addScalar(String name, String val, boolean isSystem) {
        this.name = name;
        this.isSystem = isSystem;
        this.noHeaderLen = val.length() + 1;
        StringBuilder buf = new StringBuilder(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(" ");
        buf.append(isSystem ? 1 : 0);
        buf.append(" ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        buf.append(val);
        buf.append("\n");
        this.text = buf.toString();
    }

    private void addScalar(String name, StringBuilder val, boolean isSystem) {
        this.name = name;
        this.isSystem = isSystem;
        this.noHeaderLen = val.length() + 1;
        StringBuilder buf = new StringBuilder(this.noHeaderLen + 100);
        buf.append(name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(" ");
        buf.append(isSystem ? 1 : 0);
        buf.append(" ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        buf.append((CharSequence)val);
        buf.append("\n");
        this.text = buf.toString();
    }

    private <T extends Number> void addNumber(String name, T[] t, int type, boolean isSystem) {
        if (type == 26) {
            byte[] b = new byte[t.length];
            for (int j = 0; j < t.length; ++j) {
                b[j] = (Byte)t[j];
            }
            this.addByte(name, b, isSystem, false);
        } else if (type == 27) {
            short[] s = new short[t.length];
            for (int j = 0; j < t.length; ++j) {
                s[j] = (Short)t[j];
            }
            this.addShort(name, s, isSystem, false);
        } else if (type == 28) {
            int[] i = new int[t.length];
            for (int j = 0; j < t.length; ++j) {
                i[j] = (Integer)t[j];
            }
            this.addInt(name, i, isSystem, false);
        } else if (type == 29) {
            long[] l = new long[t.length];
            for (int j = 0; j < t.length; ++j) {
                l[j] = (Long)t[j];
            }
            this.addLong(name, l, isSystem, false);
        } else if (type == 24) {
            float[] f = new float[t.length];
            for (int j = 0; j < t.length; ++j) {
                f[j] = ((Float)t[j]).floatValue();
            }
            this.addFloat(name, f, isSystem, false);
        } else if (type == 25) {
            double[] d = new double[t.length];
            for (int j = 0; j < t.length; ++j) {
                d[j] = (Double)t[j];
            }
            this.addDouble(name, d, isSystem, false);
        } else if (type == 33) {
            this.addBigInt(name, (BigInteger[])t, isSystem);
        }
    }

    private void addByte(String name, byte[] b, String txt, boolean isSystem, int noHeadLen) {
        this.item = b;
        this.count = b.length;
        this.type = 26;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addByte(String name, byte[] b, boolean isSystem, boolean copy) {
        this.item = copy ? b.clone() : (Object)b;
        this.count = b.length;
        this.type = 26;
        this.name = name;
        this.isSystem = isSystem;
        this.noHeaderLen = 3 * this.count;
        StringBuilder sb = new StringBuilder(this.noHeaderLen + 100);
        for (int i = 0; i < this.count; ++i) {
            sb.append(toASCII[b[i] & 0xFF]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.addArray(sb);
    }

    private void addShort(String name, short[] s, String txt, boolean isSystem, boolean unsigned, int noHeadLen) {
        if (unsigned) {
            this.originalText = txt;
            this.originalType = 30;
            this.addShort(name, s, isSystem, false);
            return;
        }
        this.item = s;
        this.count = s.length;
        this.type = 27;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addShort(String name, short[] s, boolean isSystem, boolean copy) {
        this.item = copy ? s.clone() : (Object)s;
        this.count = s.length;
        this.type = 27;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 5 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int i = 0; i < this.count; ++i) {
            short j16 = s[i];
            if (j16 == 0) {
                if (++zeros < 4095 && i < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("0000");
                } else {
                    sb.append("Z");
                    sb.append(toASCII[zeros >> 8 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (i < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[j16 >> 8 & 0xFF]);
            sb.append(toASCII[j16 & 0xFF]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 5 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addInt(String name, int[] i, String txt, boolean isSystem, boolean unsigned, int noHeadLen) {
        if (unsigned) {
            this.originalText = txt;
            this.originalType = 31;
            this.addInt(name, i, isSystem, false);
            return;
        }
        this.item = i;
        this.count = i.length;
        this.type = 28;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addInt(String name, int[] i, boolean isSystem, boolean copy) {
        this.item = copy ? i.clone() : (Object)i;
        this.count = i.length;
        this.type = 28;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 9 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int j = 0; j < this.count; ++j) {
            int j32 = i[j];
            if (j32 == 0) {
                if (++zeros < 0xFFFFFFF && j < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("00000000");
                } else {
                    sb.append("Z");
                    sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros >> 16 & 0xFF]);
                    sb.append(toASCII[zeros >> 8 & 0xFF]);
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (j < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[j32 >> 24 & 0xFF]);
            sb.append(toASCII[j32 >> 16 & 0xFF]);
            sb.append(toASCII[j32 >> 8 & 0xFF]);
            sb.append(toASCII[j32 & 0xFF]);
            if (j < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 9 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addLong(String name, long[] l, String txt, boolean isSystem, boolean unsigned, int noHeadLen) {
        if (unsigned) {
            this.originalText = txt;
            this.originalType = 32;
            this.addLong(name, l, isSystem, false);
            return;
        }
        this.item = l;
        this.count = l.length;
        this.type = 29;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addLong(String name, long[] l, boolean isSystem, boolean copy) {
        this.item = copy ? l.clone() : (Object)l;
        this.count = l.length;
        this.type = 29;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 17 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int i = 0; i < this.count; ++i) {
            long j64 = l[i];
            if (j64 == 0L) {
                if (++zeros < 0xFFFFFFF && i < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("0000000000000000");
                } else {
                    sb.append("Z00000000");
                    sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros >> 16 & 0xFF]);
                    sb.append(toASCII[zeros >> 8 & 0xFF]);
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (i < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[(int)(j64 >> 56 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 48 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 40 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 32 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 24 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 16 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 8 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 & 0xFFL)]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 17 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addBigInt(String name, BigInteger[] bigs, String txt, boolean isSystem, int noHeadLen) {
        this.item = bigs;
        this.count = bigs.length;
        this.type = 33;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addBigInt(String name, BigInteger[] bigs, boolean isSystem) {
        this.item = bigs.clone();
        this.count = bigs.length;
        this.type = 33;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 17 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int i = 0; i < this.count; ++i) {
            long j64 = bigs[i].longValue();
            if (j64 == 0L) {
                if (++zeros < 0xFFFFFFF && i < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("0000000000000000");
                } else {
                    sb.append("Z00000000");
                    sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros >> 16 & 0xFF]);
                    sb.append(toASCII[zeros >> 8 & 0xFF]);
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (i < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[(int)(j64 >> 56 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 48 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 40 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 32 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 24 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 16 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 8 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 & 0xFFL)]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 17 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addFloat(String name, float[] f, String txt, boolean isSystem, int noHeadLen) {
        this.item = f;
        this.count = f.length;
        this.type = 24;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addFloat(String name, float[] f, boolean isSystem, boolean copy) {
        this.item = copy ? f.clone() : (Object)f;
        this.count = f.length;
        this.type = 24;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 9 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int i = 0; i < this.count; ++i) {
            int j32 = Float.floatToIntBits(f[i]);
            if (j32 == 0 || j32 == Integer.MIN_VALUE) {
                if (++zeros < 0xFFFFFFF && i < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("00000000");
                } else {
                    sb.append("Z");
                    sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros >> 16 & 0xFF]);
                    sb.append(toASCII[zeros >> 8 & 0xFF]);
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (i < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[j32 >> 24 & 0xFF]);
            sb.append(toASCII[j32 >> 16 & 0xFF]);
            sb.append(toASCII[j32 >> 8 & 0xFF]);
            sb.append(toASCII[j32 & 0xFF]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 9 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addDouble(String name, double[] d, String txt, boolean isSystem, int noHeadLen) {
        this.item = d;
        this.count = d.length;
        this.type = 25;
        this.name = name;
        this.isSystem = isSystem;
        this.text = txt;
        this.noHeaderLen = noHeadLen;
    }

    private void addDouble(String name, double[] d, boolean isSystem, boolean copy) {
        this.item = copy ? d.clone() : (Object)d;
        this.count = d.length;
        this.type = 25;
        this.name = name;
        this.isSystem = isSystem;
        int lenGuess = 17 * this.count;
        StringBuilder sb = new StringBuilder(lenGuess + 100);
        int zeros = 0;
        int suppressed = 0;
        boolean thisOneZero = false;
        for (int i = 0; i < this.count; ++i) {
            long j64 = Double.doubleToLongBits(d[i]);
            if (j64 == 0L || j64 == Long.MIN_VALUE) {
                if (++zeros < 0xFFFFFFF && i < this.count - 1) continue;
                thisOneZero = true;
            }
            if (zeros > 0) {
                suppressed += zeros - 1;
                if (zeros == 1) {
                    sb.append("0000000000000000");
                } else {
                    sb.append("Z00000000");
                    sb.append(toASCII[zeros >> 24 & 0xFF].charAt(1));
                    sb.append(toASCII[zeros >> 16 & 0xFF]);
                    sb.append(toASCII[zeros >> 8 & 0xFF]);
                    sb.append(toASCII[zeros & 0xFF]);
                }
                if (thisOneZero) {
                    if (i < this.count - 1) {
                        sb.append(" ");
                        zeros = 0;
                        thisOneZero = false;
                        continue;
                    }
                    sb.append("\n");
                    break;
                }
                sb.append(" ");
                zeros = 0;
                thisOneZero = false;
            }
            sb.append(toASCII[(int)(j64 >> 56 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 48 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 40 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 32 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 24 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 16 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 >> 8 & 0xFFL)]);
            sb.append(toASCII[(int)(j64 & 0xFFL)]);
            if (i < this.count - 1) {
                sb.append(" ");
                continue;
            }
            sb.append("\n");
        }
        this.noHeaderLen = 17 * (this.count - suppressed);
        this.addArray(sb);
    }

    private void addArray(StringBuilder sb) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.name);
        buf.append(" ");
        buf.append(this.type);
        buf.append(" ");
        buf.append(this.count);
        buf.append(" ");
        buf.append(this.isSystem ? 1 : 0);
        buf.append(" ");
        buf.append(this.noHeaderLen);
        buf.append("\n");
        sb.insert(0, buf);
        this.text = sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getItem() {
        return this.item;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public int getCount() {
        return this.count;
    }

    public int getEndian() {
        return this.endian;
    }

    public int[] getEndianArray() {
        return this.endianArray;
    }

    public String getString() throws cMsgException {
        if (this.type == 10) {
            return (String)this.item;
        }
        throw new cMsgException("Wrong type");
    }

    public String[] getStringArray() throws cMsgException {
        if (this.type == 23) {
            return (String[])((String[])this.item).clone();
        }
        throw new cMsgException("Wrong type");
    }

    public byte[] getBinary() throws cMsgException {
        if (this.type == 22) {
            return (byte[])((byte[])this.item).clone();
        }
        throw new cMsgException("Wrong type");
    }

    public byte[][] getBinaryArray() throws cMsgException {
        if (this.type == 35) {
            byte[][] b = new byte[this.count][];
            for (int i = 0; i < this.count; ++i) {
                b[i] = (byte[])((byte[][])this.item)[i].clone();
            }
            return b;
        }
        throw new cMsgException("Wrong type");
    }

    public cMsgMessage getMessage() throws cMsgException {
        if (this.type == 21) {
            return (cMsgMessage)((cMsgMessage)this.item).clone();
        }
        throw new cMsgException("Wrong type");
    }

    public cMsgMessage[] getMessageArray() throws cMsgException {
        if (this.type == 34) {
            cMsgMessage[] m = new cMsgMessage[this.count];
            for (int i = 0; i < this.count; ++i) {
                m[i] = (cMsgMessage)((cMsgMessage[])this.item)[i].clone();
            }
            return m;
        }
        throw new cMsgException("Wrong type");
    }

    public byte getByte() throws cMsgException {
        BigInteger b;
        if (this.type == 13) {
            return (Byte)this.item;
        }
        if (this.type == 14 || this.type == 17) {
            short l = (Short)this.item;
            if (l <= 127 && l >= -128) {
                return (byte)l;
            }
        } else if (this.type == 15 || this.type == 18) {
            int l = (Integer)this.item;
            if (l <= 127 && l >= -128) {
                return (byte)l;
            }
        } else if (this.type == 16 || this.type == 19) {
            long l = (Long)this.item;
            if (l <= 127L && l >= -128L) {
                return (byte)l;
            }
        } else if (this.type == 20 && (b = (BigInteger)this.item).compareTo(new BigInteger("127")) <= 0) {
            return b.byteValue();
        }
        throw new cMsgException("Wrong type");
    }

    public short getShort() throws cMsgException {
        BigInteger b;
        if (this.type == 13) {
            return ((Byte)this.item).byteValue();
        }
        if (this.type == 14 || this.type == 17) {
            return (Short)this.item;
        }
        if (this.type == 15 || this.type == 18) {
            int l = (Integer)this.item;
            if (l <= Short.MAX_VALUE && l >= Short.MIN_VALUE) {
                return (short)l;
            }
        } else if (this.type == 16 || this.type == 19) {
            long l = (Long)this.item;
            if (l <= 32767L && l >= -32768L) {
                return (short)l;
            }
        } else if (this.type == 20 && (b = (BigInteger)this.item).compareTo(new BigInteger("32767")) <= 0) {
            return b.shortValue();
        }
        throw new cMsgException("Wrong type");
    }

    public int getInt() throws cMsgException {
        BigInteger b;
        if (this.type == 13) {
            return ((Byte)this.item).byteValue();
        }
        if (this.type == 14 || this.type == 17) {
            return ((Short)this.item).shortValue();
        }
        if (this.type == 15 || this.type == 18) {
            return (Integer)this.item;
        }
        if (this.type == 19 || this.type == 16) {
            long l = (Long)this.item;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
        } else if (this.type == 20 && (b = (BigInteger)this.item).compareTo(new BigInteger("2147483647")) <= 0) {
            return b.intValue();
        }
        throw new cMsgException("Wrong type");
    }

    public long getLong() throws cMsgException {
        BigInteger b;
        if (this.type == 13) {
            return ((Byte)this.item).byteValue();
        }
        if (this.type == 14 || this.type == 17) {
            return ((Short)this.item).shortValue();
        }
        if (this.type == 15 || this.type == 18) {
            return ((Integer)this.item).intValue();
        }
        if (this.type == 16 || this.type == 19) {
            return (Long)this.item;
        }
        if (this.type == 20 && (b = (BigInteger)this.item).compareTo(new BigInteger("9223372036854775807")) <= 0) {
            return b.longValue();
        }
        throw new cMsgException("Wrong type");
    }

    public BigInteger getBigInt() throws cMsgException {
        if (this.type == 13) {
            return new BigInteger(this.item.toString());
        }
        if (this.type == 14 || this.type == 17) {
            return new BigInteger(this.item.toString());
        }
        if (this.type == 15 || this.type == 18) {
            return new BigInteger(this.item.toString());
        }
        if (this.type == 16 || this.type == 19) {
            return new BigInteger(this.item.toString());
        }
        if (this.type == 20) {
            return (BigInteger)this.item;
        }
        throw new cMsgException("Wrong type");
    }

    public byte[] getByteArray() throws cMsgException {
        if (this.type == 26) {
            return (byte[])((byte[])this.item).clone();
        }
        if (this.type == 27 || this.type == 30) {
            short[] S = (short[])this.item;
            byte[] b = new byte[S.length];
            for (int j = 0; j < S.length; ++j) {
                if (S[j] > 127 || S[j] < -128) {
                    throw new cMsgException("Cannot retrieve item as byte array, values out-of-range");
                }
                b[j] = (byte)S[j];
            }
            return b;
        }
        if (this.type == 28 || this.type == 31) {
            int[] I = (int[])this.item;
            byte[] b = new byte[I.length];
            for (int j = 0; j < I.length; ++j) {
                if (I[j] > 127 || I[j] < -128) {
                    throw new cMsgException("Cannot retrieve item as byte array, values out-of-range");
                }
                b[j] = (byte)I[j];
            }
            return b;
        }
        if (this.type == 29 || this.type == 32) {
            long[] L = (long[])this.item;
            byte[] b = new byte[L.length];
            for (int j = 0; j < L.length; ++j) {
                if (L[j] > 127L || L[j] < -128L) {
                    throw new cMsgException("Cannot retrieve item as byte array, values out-of-range");
                }
                b[j] = (byte)L[j];
            }
            return b;
        }
        if (this.type == 33) {
            BigInteger[] big = (BigInteger[])this.item;
            BigInteger max = new BigInteger("127");
            int j = 0;
            byte[] b = new byte[big.length];
            for (BigInteger bigI : big) {
                if (bigI.compareTo(max) > 0) {
                    throw new cMsgException("Cannot retrieve item as byte array, values out-of-range");
                }
                b[j++] = bigI.byteValue();
            }
            return b;
        }
        throw new cMsgException("Wrong type");
    }

    public short[] getShortArray() throws cMsgException {
        if (this.type == 26) {
            byte[] B = (byte[])this.item;
            short[] s = new short[B.length];
            for (int j = 0; j < B.length; ++j) {
                s[j] = B[j];
            }
            return s;
        }
        if (this.type == 27 || this.type == 30) {
            return (short[])((short[])this.item).clone();
        }
        if (this.type == 28 || this.type == 31) {
            int[] I = (int[])this.item;
            short[] s = new short[I.length];
            for (int j = 0; j < I.length; ++j) {
                if (I[j] > Short.MAX_VALUE || I[j] < Short.MIN_VALUE) {
                    throw new cMsgException("Cannot retrieve item as short array, values out-of-range");
                }
                s[j] = (short)I[j];
            }
            return s;
        }
        if (this.type == 29 || this.type == 32) {
            long[] L = (long[])this.item;
            short[] s = new short[L.length];
            for (int j = 0; j < L.length; ++j) {
                if (L[j] > 32767L || L[j] < -32768L) {
                    throw new cMsgException("Cannot retrieve item as short array, values out-of-range");
                }
                s[j] = (short)L[j];
            }
            return s;
        }
        if (this.type == 33) {
            BigInteger[] big = (BigInteger[])this.item;
            BigInteger max = new BigInteger("32767");
            int j = 0;
            short[] s = new short[big.length];
            for (BigInteger bigI : big) {
                if (bigI.compareTo(max) > 0) {
                    throw new cMsgException("Cannot retrieve item as short array, values out-of-range");
                }
                s[j++] = bigI.shortValue();
            }
            return s;
        }
        throw new cMsgException("Wrong type");
    }

    public int[] getIntArray() throws cMsgException {
        if (this.type == 26) {
            byte[] B = (byte[])this.item;
            int[] i = new int[B.length];
            for (int j = 0; j < B.length; ++j) {
                i[j] = B[j];
            }
            return i;
        }
        if (this.type == 27 || this.type == 30) {
            short[] S = (short[])this.item;
            int[] i = new int[S.length];
            for (int j = 0; j < S.length; ++j) {
                i[j] = S[j];
            }
            return i;
        }
        if (this.type == 28 || this.type == 31) {
            return (int[])((int[])this.item).clone();
        }
        if (this.type == 29 || this.type == 32) {
            long[] L = (long[])this.item;
            int[] i = new int[L.length];
            for (int j = 0; j < L.length; ++j) {
                if (L[j] > Integer.MAX_VALUE || L[j] < Integer.MIN_VALUE) {
                    throw new cMsgException("Cannot retrieve item as int array, values out-of-range");
                }
                i[j] = (int)L[j];
            }
            return i;
        }
        if (this.type == 33) {
            BigInteger[] big = (BigInteger[])this.item;
            BigInteger max = new BigInteger("2147483647");
            int j = 0;
            int[] i = new int[big.length];
            for (BigInteger bigI : big) {
                if (bigI.compareTo(max) > 0) {
                    throw new cMsgException("Cannot retrieve item as int array, values out-of-range");
                }
                i[j++] = bigI.intValue();
            }
            return i;
        }
        throw new cMsgException("Wrong type");
    }

    public long[] getLongArray() throws cMsgException {
        if (this.type == 26) {
            byte[] B = (byte[])this.item;
            long[] l = new long[B.length];
            for (int i = 0; i < B.length; ++i) {
                l[i] = B[i];
            }
            return l;
        }
        if (this.type == 27 || this.type == 30) {
            short[] S = (short[])this.item;
            long[] l = new long[S.length];
            for (int i = 0; i < S.length; ++i) {
                l[i] = S[i];
            }
            return l;
        }
        if (this.type == 28 || this.type == 31) {
            int[] I = (int[])this.item;
            long[] l = new long[I.length];
            for (int i = 0; i < I.length; ++i) {
                l[i] = I[i];
            }
            return l;
        }
        if (this.type == 29 || this.type == 32) {
            return (long[])((long[])this.item).clone();
        }
        if (this.type == 33) {
            BigInteger[] big = (BigInteger[])this.item;
            BigInteger max = new BigInteger("9223372036854775807");
            int i = 0;
            long[] l = new long[big.length];
            for (BigInteger bigI : big) {
                if (bigI.compareTo(max) > 0) {
                    throw new cMsgException("Cannot retrieve item as long array, values out-of-range");
                }
                l[i++] = bigI.longValue();
            }
            return l;
        }
        throw new cMsgException("Wrong type");
    }

    public BigInteger[] getBigIntArray() throws cMsgException {
        if (this.type == 26) {
            byte[] B = (byte[])this.item;
            BigInteger[] bi = new BigInteger[B.length];
            for (int i = 0; i < B.length; ++i) {
                bi[i] = new BigInteger("" + B[i]);
            }
            return bi;
        }
        if (this.type == 27 || this.type == 30) {
            short[] S = (short[])this.item;
            BigInteger[] bi = new BigInteger[S.length];
            for (int i = 0; i < S.length; ++i) {
                bi[i] = new BigInteger("" + S[i]);
            }
            return bi;
        }
        if (this.type == 28 || this.type == 31) {
            int[] I = (int[])this.item;
            BigInteger[] bi = new BigInteger[I.length];
            for (int i = 0; i < I.length; ++i) {
                bi[i] = new BigInteger("" + I[i]);
            }
            return bi;
        }
        if (this.type == 29 || this.type == 32) {
            long[] L = (long[])this.item;
            BigInteger[] bi = new BigInteger[L.length];
            for (int i = 0; i < L.length; ++i) {
                bi[i] = new BigInteger("" + L[i]);
            }
            return bi;
        }
        if (this.type == 33) {
            BigInteger[] bi = new BigInteger[this.count];
            for (int i = 0; i < this.count; ++i) {
                bi[i] = ((BigInteger[])this.item)[i];
            }
            return bi;
        }
        throw new cMsgException("Wrong type");
    }

    public float getFloat() throws cMsgException {
        Double l;
        if (this.type == 11) {
            return ((Float)this.item).floatValue();
        }
        if (this.type == 12 && (l = (Double)this.item) <= 3.4028234663852886E38 && l >= -3.4028234663852886E38) {
            return l.floatValue();
        }
        throw new cMsgException("Wrong type");
    }

    public double getDouble() throws cMsgException {
        if (this.type == 11) {
            return ((Float)this.item).floatValue();
        }
        if (this.type == 12) {
            return (Double)this.item;
        }
        throw new cMsgException("Wrong type");
    }

    public float[] getFloatArray() throws cMsgException {
        if (this.type == 24) {
            return (float[])((float[])this.item).clone();
        }
        if (this.type == 25) {
            double[] D = (double[])this.item;
            float[] f = new float[D.length];
            for (int i = 0; i < D.length; ++i) {
                if (D[i] > 3.4028234663852886E38 || D[i] < -3.4028234663852886E38) {
                    throw new cMsgException("Cannot retrieve item as float array, values out-of-range");
                }
                f[i] = (float)D[i];
            }
            return f;
        }
        throw new cMsgException("Wrong type");
    }

    public double[] getDoubleArray() throws cMsgException {
        if (this.type == 24) {
            float[] F = (float[])this.item;
            double[] d = new double[F.length];
            for (int i = 0; i < F.length; ++i) {
                d[i] = F[i];
            }
            return d;
        }
        if (this.type == 25) {
            return (double[])((double[])this.item).clone();
        }
        throw new cMsgException("Wrong type");
    }
}

