/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.Monitor;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.DefaultConfiguration;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DOUBLE;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class CA
extends cMsgSubdomainAdapter {
    private cMsgClientInfo myClientInfo;
    private String myUDLRemainder;
    private cMsgDeliverMessageInterface myDeliverer;
    private Context myContext = null;
    private String myChannelName = null;
    private Channel myChannel = null;
    private Monitor myMonitor = null;
    private String mySubscribeType;
    private String mySubscribeSubject;
    private ArrayList<Integer> mySubscribeIdList = new ArrayList(10);
    private double myContextPend = 3.0;
    private double myGetPend = 3.0;
    private double myPutPend = 3.0;
    private int mySenderId = 0;
    private static int senderCount = 0;
    private static String host = null;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public boolean hasSubscribeAndGet() {
        return true;
    }

    @Override
    public boolean hasSubscribe() {
        return true;
    }

    @Override
    public boolean hasUnsubscribe() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) {
        this.myUDLRemainder = UDLRemainder;
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        Matcher m;
        Pattern p;
        String remainder = null;
        this.myClientInfo = info;
        this.mySenderId = ++senderCount;
        this.myDeliverer = info.getDeliverer();
        int ind = this.myUDLRemainder.indexOf("?");
        if (ind > 0) {
            p = Pattern.compile("^(.+?)(\\?)(.*)$");
            m = p.matcher(this.myUDLRemainder);
            m.find();
            this.myChannelName = this.myUDLRemainder.substring(0, ind);
            remainder = this.myUDLRemainder.substring(ind) + "&";
        } else {
            this.myChannelName = this.myUDLRemainder;
        }
        JCALibrary myJCA = JCALibrary.getInstance();
        DefaultConfiguration conf = new DefaultConfiguration("myContext");
        conf.setAttribute("class", "com.cosylab.epics.caj.CAJContext");
        conf.setAttribute("auto_addr_list", "false");
        if (remainder != null && (m = (p = Pattern.compile("[&\\?]addr_list=(.*?)&", 2)).matcher(remainder)).find()) {
            conf.setAttribute("addr_list", m.group(1));
        }
        try {
            this.myContext = myJCA.createContext((Configuration)conf);
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myChannel = this.myContext.createChannel(this.myChannelName);
            this.myContext.pendIO(this.myContextPend);
        }
        catch (CAException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (TimeoutException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        try {
            this.myChannel.put(Double.parseDouble(msg.getText()));
            this.myContext.pendIO(this.myPutPend);
        }
        catch (CAException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (TimeoutException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        this.handleSendRequest(msg);
        return 0;
    }

    @Override
    public void handleSubscribeAndGetRequest(String subject, String type, int id) throws cMsgException {
        cMsgMessageFull response = new cMsgMessageFull();
        response.setDomain("cMsg");
        response.setSender("CA");
        response.setUserInt(this.mySenderId);
        response.setSenderHost(host);
        response.setSenderTime(new Date());
        response.setReceiver(this.myClientInfo.getName());
        response.setReceiverHost(this.myClientInfo.getClientHost());
        response.setReceiverTime(new Date());
        response.setSubject(subject);
        response.setType(type);
        try {
            DBR dbr = this.myChannel.get();
            this.myContext.pendIO(this.myGetPend);
            response.setText("" + ((DOUBLE)dbr).getDoubleValue()[0]);
        }
        catch (CAException e) {
            response.setText(null);
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            response.setText(null);
            e.printStackTrace();
        }
        try {
            this.myDeliverer.deliverMessage(response, 21);
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSubscribeRequest(String subject, String type, int receiverSubscribeId) throws cMsgException {
        ArrayList<Integer> arrayList = this.mySubscribeIdList;
        synchronized (arrayList) {
            this.mySubscribeIdList.add(receiverSubscribeId);
        }
        if (this.myMonitor == null) {
            this.mySubscribeType = "double";
            this.mySubscribeSubject = this.myChannelName;
            try {
                this.myMonitor = this.myChannel.addMonitor(1, (MonitorListener)new MonitorListenerImpl());
                this.myContext.flushIO();
            }
            catch (CAException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnsubscribeRequest(String subject, String type, int receiverSubscribeId) throws cMsgException {
        ArrayList<Integer> arrayList = this.mySubscribeIdList;
        synchronized (arrayList) {
            this.mySubscribeIdList.remove(receiverSubscribeId);
            if (this.myMonitor != null && this.mySubscribeIdList.isEmpty()) {
                try {
                    this.myMonitor.clear();
                    this.myMonitor = null;
                }
                catch (CAException e) {
                    e.printStackTrace();
                    cMsgException ce = new cMsgException(e.toString());
                    ce.setReturnCode(1);
                    throw ce;
                }
            }
        }
    }

    @Override
    public void handleClientShutdown() throws cMsgException {
        try {
            this.myChannel.destroy();
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myContext.flushIO();
            this.myContext.destroy();
        }
        catch (CAException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    static {
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println(e);
            host = "unknown";
        }
    }

    private class MonitorListenerImpl
    implements MonitorListener {
        private MonitorListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent event) {
            if (event.getStatus() == CAStatus.NORMAL) {
                cMsgMessageFull cmsg = new cMsgMessageFull();
                cmsg.setDomain("cMsg");
                cmsg.setSender("CA");
                cmsg.setUserInt(CA.this.mySenderId);
                cmsg.setSenderHost(host);
                cmsg.setSenderTime(new Date());
                cmsg.setReceiver(CA.this.myClientInfo.getName());
                cmsg.setReceiverHost(CA.this.myClientInfo.getClientHost());
                cmsg.setReceiverTime(new Date());
                cmsg.setSubject(CA.this.mySubscribeSubject);
                cmsg.setType(CA.this.mySubscribeType);
                cmsg.setText("" + ((DOUBLE)event.getDBR()).getDoubleValue()[0]);
                ArrayList arrayList = CA.this.mySubscribeIdList;
                synchronized (arrayList) {
                    try {
                        CA.this.myDeliverer.deliverMessage(cmsg, 21);
                    }
                    catch (cMsgException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            System.err.println("Monitor error: " + event.getStatus());
        }
    }
}

