/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgClientData;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgHolder;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerBridge;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSendAndGetter;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSubscribeAndGetter;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSubscribeInfo;
import org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgNotifier;
import org.jlab.coda.cMsg.common.cMsgSubdomainInterface;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class cMsgDomainServer
extends Thread {
    static String domainType = "cMsg";
    private cMsgNameServer nameServer;
    private int debug;
    private int tempThreadsMax = 3;
    private int permanentCommandHandlingThreads = 1;
    cMsgClientData info;
    private DataInputStream in;
    private boolean noUdp;
    private DatagramSocket udpSocket;
    private LinkedBlockingQueue<cMsgHolder> requestQueue;
    private LinkedBlockingQueue<cMsgHolder> sequentialQueue;
    private static final int NORMAL = 0;
    private static final int SEQUENTIAL = 1;
    private ConcurrentLinkedQueue<Thread> requestThreads;
    private ClientHandler clientHandlerThread;
    private UdpSendHandler udpHandlerThread;
    private AtomicInteger tempThreads = new AtomicInteger();
    private ThreadPoolExecutor subAndGetThreadPool;
    private ThreadPoolExecutor sendAndGetThreadPool;
    AtomicBoolean calledShutdown = new AtomicBoolean();
    private ConcurrentHashMap<Integer, cMsgServerSendAndGetter> sendAndGetters;
    volatile boolean killSpawnedThreads;

    public void killSpawnedThreads() {
        this.killSpawnedThreads = true;
    }

    public int getUdpPort() {
        if (this.noUdp) {
            return -1;
        }
        return this.udpSocket.getLocalPort();
    }

    public cMsgSubdomainInterface getSubdomainHandler() {
        return this.info.subdomainHandler;
    }

    private void printSizes() {
        System.out.println("\n\nSIZES:");
        System.out.println("     request cue    = " + this.requestQueue.size());
        System.out.println("     sequential cue = " + this.sequentialQueue.size());
        System.out.println("     sendAndGetters = " + this.sendAndGetters.size());
        System.out.println();
        this.nameServer.printSizes();
        cMsg.printStaticSizes();
        System.out.println();
        if (this.info.cMsgSubdomainHandler != null) {
            this.info.cMsgSubdomainHandler.printSizes();
        }
    }

    public cMsgDomainServer(cMsgNameServer nameServer, cMsgClientData info, boolean noUdp, int debug) throws cMsgException {
        this.info = info;
        this.noUdp = noUdp;
        this.debug = debug;
        this.nameServer = nameServer;
        this.requestQueue = new LinkedBlockingQueue(100);
        this.sequentialQueue = new LinkedBlockingQueue(50);
        this.requestThreads = new ConcurrentLinkedQueue();
        this.sendAndGetters = new ConcurrentHashMap(10);
        class RejectHandler
        implements RejectedExecutionHandler {
            RejectHandler() {
            }

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.start();
            }
        }
        this.subAndGetThreadPool = new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RejectHandler());
        this.sendAndGetThreadPool = new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RejectHandler());
        if (!noUdp) {
            try {
                this.udpSocket = new DatagramSocket();
                this.udpSocket.setReceiveBufferSize(65536);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                cMsgException e = new cMsgException("Exiting Server: cannot create UDP listening socket");
                e.setReturnCode(12);
                throw e;
            }
            info.setDomainUdpPort(this.udpSocket.getLocalPort());
        }
    }

    void startThreads() throws IOException {
        this.info.getDeliverer().createClientConnection(this.info.getMessageChannel(), true);
        ByteChannel bc = cMsgUtilities.wrapChannel(this.info.getMessageChannel());
        this.in = new DataInputStream(new BufferedInputStream(Channels.newInputStream(bc), 65536));
        this.clientHandlerThread = new ClientHandler();
        if (!this.noUdp) {
            this.udpHandlerThread = new UdpSendHandler();
        }
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        if (this.info.calledSubdomainShutdown.compareAndSet(false, true)) {
            try {
                this.info.subdomainHandler.handleClientShutdown();
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.killSpawnedThreads = true;
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.clientHandlerThread != null) {
            this.clientHandlerThread.interrupt();
        }
        if (this.udpHandlerThread != null) {
            this.udpHandlerThread.interrupt();
            if (!this.udpSocket.isClosed()) {
                this.udpSocket.close();
            }
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.requestQueue.clear();
        this.sequentialQueue.clear();
        if (this.info.getDeliverer() != null) {
            this.info.getDeliverer().close();
        }
        try {
            this.info.keepAliveChannel.close();
            this.info.getMessageChannel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Thread thread : this.requestThreads) {
            thread.interrupt();
        }
        if (!this.info.isServer()) {
            this.nameServer.subscribeLock.lock();
            try {
                ConcurrentHashMap<String, cMsgServerBridge> concurrentHashMap = this.nameServer.bridges;
                synchronized (concurrentHashMap) {
                    for (cMsgServerBridge b : this.nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        for (cMsgServerSubscribeInfo sub : this.nameServer.subscriptions) {
                            if (sub.info != this.info) continue;
                            try {
                                if (sub.isSubscribed()) {
                                    b.unsubscribe(sub.subject, sub.type, sub.namespace);
                                }
                                for (Map.Entry<Integer, cMsgCallbackAdapter> entry : sub.getSubAndGetters().entrySet()) {
                                    b.unsubscribeAndGet(sub.subject, sub.type, sub.namespace, entry.getValue());
                                }
                            }
                            catch (IOException iOException) {
                            }
                        }
                    }
                }
                Iterator<cMsgServerSubscribeInfo> iterator = this.nameServer.subscriptions.iterator();
                while (iterator.hasNext()) {
                    cMsgServerSubscribeInfo sub = iterator.next();
                    if (sub.info != this.info) continue;
                    iterator.remove();
                }
            }
            finally {
                this.nameServer.subscribeLock.unlock();
            }
        }
        cMsgServerBridge b = this.nameServer.bridges.remove(this.info.getName());
        if (b != null) {
            b.client.cleanup();
        }
        cMsgClientData cMsgClientData2 = this.nameServer.nameServers.remove(this.info.getName());
        if (this.debug >= 4) {
            if (b != null && cMsgClientData2 != null) {
                System.out.println(">>    DS: DELETED server client FROM BRIDGES AND NAMESERVERS");
            } else {
                System.out.println(">>    DS: COULD NOT DELETE Client FROM BRIDGES AND/OR NAMESERVERS");
            }
        }
        this.subAndGetThreadPool.shutdownNow();
        this.sendAndGetThreadPool.shutdownNow();
        this.nameServer.domainServers.remove(this);
    }

    private class RequestQueueThread
    extends Thread {
        boolean permanent;

        RequestQueueThread() {
            this(false);
        }

        RequestQueueThread(boolean permanent) {
            this.permanent = permanent;
            if (!permanent) {
                cMsgDomainServer.this.tempThreads.getAndIncrement();
            }
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            block17: while (!cMsgDomainServer.this.killSpawnedThreads && !Thread.currentThread().isInterrupted()) {
                cMsgHolder holder = null;
                if (this.permanent) {
                    try {
                        holder = (cMsgHolder)cMsgDomainServer.this.requestQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (holder == null) {
                        continue;
                    }
                } else {
                    try {
                        holder = (cMsgHolder)cMsgDomainServer.this.requestQueue.poll(500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (holder == null) {
                        cMsgDomainServer.this.tempThreads.getAndDecrement();
                        return;
                    }
                }
                try {
                    switch (holder.request) {
                        case 5: {
                            cMsgDomainServer.this.info.subdomainHandler.handleSendRequest(holder.message);
                            continue block17;
                        }
                        case 6: {
                            ++cMsgDomainServer.this.info.monData.syncSends;
                            int answer = cMsgDomainServer.this.info.subdomainHandler.handleSyncSendRequest(holder.message);
                            cMsgDomainServer.this.info.getDeliverer().deliverMessage(answer, holder.ssid, 25);
                            continue block17;
                        }
                        case 11: {
                            ++cMsgDomainServer.this.info.monData.sendAndGets;
                            if (cMsgDomainServer.this.info.cMsgSubdomainHandler == null) {
                                cMsgDomainServer.this.info.subdomainHandler.handleSendAndGetRequest(holder.message);
                                continue block17;
                            }
                            this.handleCmsgSubdomainSendAndGet(holder);
                            continue block17;
                        }
                        case 12: {
                            cMsgDomainServer.this.info.subdomainHandler.handleUnSendAndGetRequest(holder.id);
                            continue block17;
                        }
                        case 9: {
                            ++cMsgDomainServer.this.info.monData.subAndGets;
                            if (cMsgDomainServer.this.info.cMsgSubdomainHandler == null) {
                                cMsgDomainServer.this.info.subdomainHandler.handleSubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                                continue block17;
                            }
                            this.handleCmsgSubdomainSubscribeAndGet(holder);
                            continue block17;
                        }
                        case 10: {
                            cMsgDomainServer.this.info.subdomainHandler.handleUnsubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                            if (cMsgDomainServer.this.info.cMsgSubdomainHandler == null) continue block17;
                            this.handleCmsgSubdomainUnsubscribeAndGet(holder);
                            continue block17;
                        }
                        case 44: {
                            cMsgDomainServer.this.info.cMsgSubdomainHandler.handleServerSendAndGetRequest(holder.message, holder.namespace);
                            continue block17;
                        }
                        case 45: {
                            cMsgDomainServer.this.info.cMsgSubdomainHandler.handleUnSendAndGetRequest(holder.id);
                            continue block17;
                        }
                    }
                    if (cMsgDomainServer.this.debug < 3) continue;
                    System.out.println("dServer requestThread: can't understand your message " + cMsgDomainServer.this.info.getName());
                    continue;
                }
                catch (cMsgException e) {
                    if (cMsgDomainServer.this.debug < 2) continue;
                    System.out.println("dServer requestThread: thread picking commands off queue has died from cMsg error");
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    if (cMsgDomainServer.this.debug < 2) continue;
                    System.out.println("dServer requestThread: thread picking commands off queue has died from IO error");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }

        private void handleCmsgSubdomainSendAndGet(cMsgHolder holder) throws cMsgException {
            if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.standAlone || ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() < 1) {
                cMsgDomainServer.this.info.subdomainHandler.handleSendAndGetRequest(holder.message);
                return;
            }
            holder.namespace = cMsgDomainServer.this.info.getNamespace();
            cMsgNotifier notifier = new cMsgNotifier();
            notifier.id = holder.message.getSenderToken();
            notifier.latch = new CountDownLatch(1);
            notifier.client = cMsgDomainServer.this.info;
            int smId = cMsgDomainServer.this.info.cMsgSubdomainHandler.handleServerSendAndGetRequest(holder.message, holder.namespace, notifier);
            cMsgCallbackAdapter cb3 = cMsgServerBridge.getSendAndGetCallback(holder.message.getSenderToken(), smId);
            for (cMsgServerBridge b : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values()) {
                if (b.getCloudStatus() != 0) continue;
                try {
                    if (notifier.latch.getCount() < 1L) break;
                    b.sendAndGet(holder.message, holder.namespace, cb3);
                }
                catch (IOException e) {
                    if (cMsgDomainServer.this.debug < 3) continue;
                    System.out.println(">>    DS: requestThread: error on sendAndGet with server " + b.serverName);
                    e.printStackTrace();
                }
            }
            cMsgServerSendAndGetter getter = new cMsgServerSendAndGetter(cMsgDomainServer.this.nameServer, notifier, cMsgDomainServer.this.sendAndGetters);
            cMsgDomainServer.this.sendAndGetters.put(notifier.id, getter);
            cMsgDomainServer.this.sendAndGetThreadPool.execute(getter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainSubscribeAndGet(cMsgHolder holder) throws cMsgException {
            boolean localOnly = true;
            cMsgCallbackAdapter cb3 = null;
            cMsgNotifier notifier = null;
            cMsgServerSubscribeInfo sub2 = null;
            holder.namespace = cMsgDomainServer.this.info.getNamespace();
            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.lock();
            try {
                if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.standAlone || ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() < 1) {
                    cMsgDomainServer.this.info.subdomainHandler.handleSubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                } else {
                    localOnly = false;
                    notifier = new cMsgNotifier();
                    notifier.id = holder.id;
                    notifier.latch = new CountDownLatch(1);
                    notifier.client = cMsgDomainServer.this.info;
                    cb3 = cMsgServerBridge.getSubAndGetCallback();
                    for (cMsgServerBridge b : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            if (notifier.latch.getCount() < 1L) break;
                            b.subscribeAndGet(holder.subject, holder.type, holder.namespace, cb3);
                        }
                        catch (IOException e) {
                            if (cMsgDomainServer.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot subscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                    cMsgDomainServer.this.info.cMsgSubdomainHandler.handleServerSubscribeAndGetRequest(holder.subject, holder.type, notifier);
                }
                boolean subscriptionExists = false;
                for (cMsgServerSubscribeInfo sub2 : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions) {
                    if (sub2.info != cMsgDomainServer.this.info || !sub2.namespace.equals(cMsgDomainServer.this.info.getNamespace()) || !sub2.subject.equals(holder.subject) || !sub2.type.equals(holder.type)) continue;
                    subscriptionExists = true;
                    break;
                }
                if (subscriptionExists) {
                    sub2.addSubAndGetter(holder.id, cb3);
                } else {
                    sub2 = new cMsgServerSubscribeInfo(holder.subject, holder.type, holder.namespace, cMsgDomainServer.this.info, holder.id, cb3);
                    ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions.add(sub2);
                }
            }
            finally {
                ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
            }
            if (!localOnly) {
                cMsgServerSubscribeAndGetter getter = new cMsgServerSubscribeAndGetter(cMsgDomainServer.this.nameServer, notifier, cb3, ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions, sub2);
                cMsgDomainServer.this.subAndGetThreadPool.execute(getter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainUnsubscribeAndGet(cMsgHolder holder) {
            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub2 = null;
                for (cMsgServerSubscribeInfo sub2 : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions) {
                    if (sub2.info != cMsgDomainServer.this.info || !sub2.namespace.equals(cMsgDomainServer.this.info.getNamespace()) || !sub2.subject.equals(holder.subject) || !sub2.type.equals(holder.type)) continue;
                    sub2.removeSubAndGetter(holder.id);
                    break;
                }
                if (sub2 != null && sub2.numberOfSubscribers() < 1) {
                    ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions.remove(sub2);
                }
            }
            finally {
                ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
            }
        }
    }

    private class SequentialQueueThread
    extends Thread {
        SequentialQueueThread() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            block22: while (!cMsgDomainServer.this.killSpawnedThreads && !Thread.currentThread().isInterrupted()) {
                cMsgHolder holder = null;
                try {
                    holder = (cMsgHolder)cMsgDomainServer.this.sequentialQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (holder == null) continue;
                try {
                    switch (holder.request) {
                        case 46: {
                            cMsgDomainServer.this.info.subdomainHandler.handleShutdownClientsRequest(holder.client, holder.include);
                            break;
                        }
                        case 3: {
                            cMsgDomainServer.this.info.subdomainHandler.handleShutdownClientsRequest(holder.client, holder.include);
                            if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() <= 0) continue block22;
                            Iterator<cMsgServerBridge> iterator = ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block22;
                                cMsgServerBridge b = iterator.next();
                                if (b.getCloudStatus() != 0) continue;
                                b.shutdownClients(holder.client, holder.include);
                            }
                        }
                        case 4: {
                            if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() > 0) {
                                for (cMsgServerBridge b : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values()) {
                                    if (b.getCloudStatus() != 0 || !cMsgSubscription.matches(holder.client, b.serverName, true)) continue;
                                    b.shutdownServer();
                                }
                            }
                            if (!holder.include || !cMsgSubscription.matches(holder.client, cMsgDomainServer.this.nameServer.getServerName(), true)) continue block22;
                            cMsgDomainServer.this.nameServer.shutdown();
                            break;
                        }
                        case 40: {
                            cMsgClientData cMsgClientData2 = cMsgDomainServer.this.info;
                            cMsgClientData2.cMsgSubdomainHandler.registrationUnlock();
                            break;
                        }
                        case 39: {
                            cMsg cfr_ignored_0 = cMsgDomainServer.this.info.cMsgSubdomainHandler;
                            boolean gotLock = cMsg.registrationLock(holder.delay);
                            int answer = gotLock ? 1 : 0;
                            cMsgDomainServer.this.info.getDeliverer().deliverMessage(answer, 0, 28);
                            break;
                        }
                        case 42: {
                            try {
                                cMsgDomainServer.this.nameServer.cloudUnlock();
                            }
                            catch (Exception e) {
                                System.out.println("CANNOT UNLOCK CLOUD");
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 41: {
                            boolean gotLock = cMsgDomainServer.this.nameServer.cloudLock(holder.delay);
                            int answer = gotLock ? 1 : 0;
                            cMsgDomainServer.this.info.getDeliverer().deliverMessage(answer, 0, 27);
                            break;
                        }
                        case 43: {
                            this.setCloudStatus(holder.id);
                            break;
                        }
                        case 38: {
                            cMsgClientData cMsgClientData3 = cMsgDomainServer.this.info;
                            cMsgDomainServer.this.info.getDeliverer().deliverMessage(cMsgClientData3.cMsgSubdomainHandler.getClientNamesAndNamespaces(), 26);
                            break;
                        }
                        case 7: {
                            ++cMsgDomainServer.this.info.monData.subscribes;
                            cMsgDomainServer.this.info.subdomainHandler.handleSubscribeRequest(holder.subject, holder.type, holder.id);
                            if (cMsgDomainServer.this.info.cMsgSubdomainHandler == null) continue block22;
                            this.handleCmsgSubdomainSubscribe(holder);
                            break;
                        }
                        case 8: {
                            ++cMsgDomainServer.this.info.monData.unsubscribes;
                            cMsgDomainServer.this.info.subdomainHandler.handleUnsubscribeRequest(holder.subject, holder.type, holder.id);
                            if (cMsgDomainServer.this.info.cMsgSubdomainHandler == null) continue block22;
                            this.handleCmsgSubdomainUnsubscribe(holder);
                            break;
                        }
                        case 30: {
                            cMsgDomainServer.this.info.cMsgSubdomainHandler.handleServerSubscribeRequest(holder.subject, holder.type, holder.namespace);
                            break;
                        }
                        case 31: {
                            cMsgDomainServer.this.info.cMsgSubdomainHandler.handleServerUnsubscribeRequest(holder.subject, holder.type, holder.namespace);
                            break;
                        }
                        default: {
                            if (cMsgDomainServer.this.debug < 3) continue block22;
                            System.out.println("dServer lockThread: can't understand your message " + cMsgDomainServer.this.info.getName());
                        }
                    }
                    continue;
                }
                catch (cMsgException e) {
                    if (cMsgDomainServer.this.debug < 2) continue;
                    System.out.println("dServer lockThread: thread picking commands off queue has died from cMsg error");
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    if (cMsgDomainServer.this.debug < 2) continue;
                    System.out.println("dServer lockThread: thread picking commands off queue has died from IO error");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setCloudStatus(int status) {
            if (status != 0) {
                return;
            }
            cMsgServerBridge bridge = ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.get(cMsgDomainServer.this.info.getName());
            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.lock();
            try {
                if (bridge != null) {
                    bridge.setCloudStatus(status);
                    if (cMsgDomainServer.this.debug >= 4) {
                        System.out.println("    DS: " + bridge.serverName + " has joined the cloud");
                    }
                } else {
                    String alternateName;
                    String name = cMsgDomainServer.this.info.getName();
                    String sPort = name.substring(name.lastIndexOf(":") + 1);
                    int n = name.indexOf(".");
                    if (n > -1) {
                        alternateName = name.substring(0, n) + ":" + (String)sPort;
                    } else {
                        try {
                            alternateName = name.substring(0, name.lastIndexOf(":"));
                            alternateName = InetAddress.getByName(alternateName).getCanonicalHostName();
                            alternateName = alternateName + ":" + (String)sPort;
                        }
                        catch (UnknownHostException e) {
                            if (cMsgDomainServer.this.debug >= 2) {
                                System.out.println("    DS: cannot find bridge to server " + bridge.serverName);
                            }
                            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
                            return;
                        }
                    }
                    bridge = ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.get(alternateName);
                    if (bridge != null) {
                        bridge.setCloudStatus(status);
                        if (cMsgDomainServer.this.debug >= 4) {
                            System.out.println("    DS: " + bridge.serverName + " has joined the cloud");
                        }
                    } else {
                        if (cMsgDomainServer.this.debug >= 2) {
                            System.out.println("    DS: cannot find bridge to server " + bridge.serverName);
                        }
                        return;
                    }
                }
                for (cMsgServerSubscribeInfo sub : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions) {
                    try {
                        if (sub.isSubscribed()) {
                            bridge.subscribe(sub.subject, sub.type, sub.namespace);
                        }
                        for (Map.Entry entry : sub.getSubAndGetters().entrySet()) {
                            bridge.subscribeAndGet(sub.subject, sub.type, sub.namespace, (cMsgCallbackInterface)entry.getValue());
                        }
                    }
                    catch (IOException e) {
                        if (cMsgDomainServer.this.debug < 3) continue;
                        System.out.println("dServer requestThread: cannot subscribe with server " + bridge.serverName);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainSubscribe(cMsgHolder holder) throws cMsgException {
            holder.namespace = cMsgDomainServer.this.info.getNamespace();
            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub2 = null;
                if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() > 0) {
                    for (cMsgServerBridge b : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            b.subscribe(holder.subject, holder.type, holder.namespace);
                        }
                        catch (IOException e) {
                            if (cMsgDomainServer.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot subscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                }
                boolean subExists = false;
                for (cMsgServerSubscribeInfo sub2 : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions) {
                    if (sub2.info != cMsgDomainServer.this.info || !sub2.namespace.equals(holder.namespace) || !sub2.subject.equals(holder.subject) || !sub2.type.equals(holder.type)) continue;
                    subExists = true;
                    break;
                }
                if (subExists) {
                    sub2.addSubscription();
                } else {
                    sub2 = new cMsgServerSubscribeInfo(holder.subject, holder.type, holder.namespace, cMsgDomainServer.this.info);
                    ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions.add(sub2);
                }
            }
            finally {
                ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainUnsubscribe(cMsgHolder holder) {
            ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub2 = null;
                if (((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.size() > 0) {
                    for (cMsgServerBridge b : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            b.unsubscribe(holder.subject, holder.type, cMsgDomainServer.this.info.getNamespace());
                        }
                        catch (IOException e) {
                            if (cMsgDomainServer.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot unsubscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                }
                for (cMsgServerSubscribeInfo sub2 : ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions) {
                    if (sub2.info != cMsgDomainServer.this.info || !sub2.namespace.equals(cMsgDomainServer.this.info.getNamespace()) || !sub2.subject.equals(holder.subject) || !sub2.type.equals(holder.type)) continue;
                    sub2.removeSubscription();
                    break;
                }
                if (sub2 != null && sub2.numberOfSubscribers() < 1) {
                    ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscriptions.remove(sub2);
                }
            }
            finally {
                ((cMsgDomainServer)cMsgDomainServer.this).nameServer.subscribeLock.unlock();
            }
        }
    }

    private class ClientHandler
    extends Thread {
        byte[] bytes = new byte[20000];

        ClientHandler() {
            for (int i = 0; i < cMsgDomainServer.this.permanentCommandHandlingThreads; ++i) {
                cMsgDomainServer.this.requestThreads.add(new RequestQueueThread(true));
            }
            cMsgDomainServer.this.requestThreads.add(new SequentialQueueThread());
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (cMsgDomainServer.this.killSpawnedThreads) {
                        return;
                    }
                    int size = cMsgDomainServer.this.in.readInt();
                    int msgId = cMsgDomainServer.this.in.readInt();
                    cMsgHolder holder = null;
                    boolean requestType = false;
                    switch (msgId) {
                        case 5: {
                            ++cMsgDomainServer.this.info.monData.tcpSends;
                        }
                        case 6: {
                            holder = this.readSendInfo();
                            break;
                        }
                        case 9: 
                        case 10: {
                            holder = this.readSubscribeInfo();
                            break;
                        }
                        case 11: 
                        case 44: {
                            holder = this.readGetInfo();
                            break;
                        }
                        case 12: 
                        case 45: {
                            holder = this.readUngetInfo();
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 30: 
                        case 31: {
                            holder = this.readSubscribeInfo();
                            requestType = true;
                            break;
                        }
                        case 13: {
                            break;
                        }
                        case 1: {
                            if (!cMsgDomainServer.this.calledShutdown.compareAndSet(false, true)) return;
                            if (cMsgDomainServer.this.debug >= 1) {
                                System.out.println("Client " + cMsgDomainServer.this.info.getName() + " called disconnect");
                            }
                            cMsgDomainServer.this.shutdown();
                            return;
                        }
                        case 47: {
                            cMsgDomainServer.this.nameServer.shutdown();
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 46: {
                            holder = this.readShutdownInfo();
                            requestType = true;
                            break;
                        }
                        case 39: 
                        case 41: {
                            int delay = cMsgDomainServer.this.in.readInt();
                            holder = new cMsgHolder();
                            holder.delay = delay;
                            requestType = true;
                            break;
                        }
                        case 40: 
                        case 42: {
                            holder = new cMsgHolder();
                            requestType = true;
                            break;
                        }
                        case 43: {
                            int status = cMsgDomainServer.this.in.readInt();
                            holder = new cMsgHolder();
                            holder.id = status;
                            requestType = true;
                            break;
                        }
                        case 38: {
                            holder = new cMsgHolder();
                            requestType = true;
                            break;
                        }
                        default: {
                            if (cMsgDomainServer.this.debug >= 3) {
                                System.out.println("dServer handleClient: can't understand your message " + cMsgDomainServer.this.info.getName());
                            }
                            if (!cMsgDomainServer.this.calledShutdown.compareAndSet(false, true)) return;
                            cMsgDomainServer.this.shutdown();
                            return;
                        }
                    }
                    if (holder != null) {
                        holder.request = msgId;
                        try {
                            if (!requestType) {
                                cMsgDomainServer.this.requestQueue.put(holder);
                            } else {
                                cMsgDomainServer.this.sequentialQueue.put(holder);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (cMsgDomainServer.this.requestQueue.remainingCapacity() >= 20 || cMsgDomainServer.this.tempThreads.get() >= cMsgDomainServer.this.tempThreadsMax) continue;
                    new RequestQueueThread();
                    continue;
                    break;
                }
            }
            catch (InterruptedIOException ex) {
                if (cMsgDomainServer.this.debug < 2) return;
                System.out.println(">>    DS: command-reading thread has been interrupted, quit");
                return;
            }
            catch (IOException ex) {
                if (cMsgDomainServer.this.debug < 2) return;
                System.out.println(">>    DS: command-reading thd's client (" + cMsgDomainServer.this.info.getName() + ") connection is dead, IO error");
                return;
            }
            finally {
                if (cMsgDomainServer.this.calledShutdown.compareAndSet(false, true)) {
                    cMsgDomainServer.this.shutdown();
                }
            }
        }

        private cMsgHolder readSendInfo() throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            int ssid = cMsgDomainServer.this.in.readInt();
            msg.setUserInt(cMsgDomainServer.this.in.readInt());
            msg.setSysMsgId(cMsgDomainServer.this.in.readInt());
            msg.setSenderToken(cMsgDomainServer.this.in.readInt());
            msg.setInfo(cMsgDomainServer.this.in.readInt() | 0x10);
            msg.setExpandedPayload(false);
            long time = (long)cMsgDomainServer.this.in.readInt() << 32 | (long)cMsgDomainServer.this.in.readInt() & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)cMsgDomainServer.this.in.readInt() << 32 | (long)cMsgDomainServer.this.in.readInt() & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            int lengthSubject = cMsgDomainServer.this.in.readInt();
            int lengthType = cMsgDomainServer.this.in.readInt();
            int lengthPayloadTxt = cMsgDomainServer.this.in.readInt();
            int lengthText = cMsgDomainServer.this.in.readInt();
            int lengthBinary = cMsgDomainServer.this.in.readInt();
            int stringBytesToRead = lengthSubject + lengthType + lengthPayloadTxt + lengthText;
            int offset = 0;
            if (stringBytesToRead > this.bytes.length) {
                this.bytes = new byte[stringBytesToRead];
            }
            cMsgDomainServer.this.in.readFully(this.bytes, 0, stringBytesToRead);
            msg.setSubject(new String(this.bytes, offset, lengthSubject, "US-ASCII"));
            msg.setType(new String(this.bytes, offset += lengthSubject, lengthType, "US-ASCII"));
            offset += lengthType;
            if (lengthPayloadTxt > 0) {
                msg.setPayloadText(new String(this.bytes, offset, lengthPayloadTxt, "US-ASCII"));
                offset += lengthPayloadTxt;
            }
            msg.setText(new String(this.bytes, offset, lengthText, "US-ASCII"));
            offset += lengthText;
            if (lengthBinary > 0) {
                byte[] b = new byte[lengthBinary];
                cMsgDomainServer.this.in.readFully(b, 0, lengthBinary);
                try {
                    msg.setByteArrayNoCopy(b, 0, lengthBinary);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            msg.setVersion(5);
            msg.setDomain(domainType);
            msg.setReceiver("cMsg domain server");
            msg.setReceiverHost(cMsgDomainServer.this.info.getDomainHost());
            msg.setReceiverTime(new Date());
            msg.setSender(cMsgDomainServer.this.info.getName());
            msg.setSenderHost(cMsgDomainServer.this.info.getClientHost());
            return new cMsgHolder(msg, ssid);
        }

        private cMsgHolder readGetInfo() throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            cMsgDomainServer.this.in.skipBytes(4);
            msg.setUserInt(cMsgDomainServer.this.in.readInt());
            msg.setSenderToken(cMsgDomainServer.this.in.readInt());
            msg.setInfo(cMsgDomainServer.this.in.readInt() | 0x10);
            msg.setExpandedPayload(false);
            long time = (long)cMsgDomainServer.this.in.readInt() << 32 | (long)cMsgDomainServer.this.in.readInt() & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)cMsgDomainServer.this.in.readInt() << 32 | (long)cMsgDomainServer.this.in.readInt() & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            int lengthSubject = cMsgDomainServer.this.in.readInt();
            int lengthType = cMsgDomainServer.this.in.readInt();
            int lengthNamespace = cMsgDomainServer.this.in.readInt();
            int lengthPayloadTxt = cMsgDomainServer.this.in.readInt();
            int lengthText = cMsgDomainServer.this.in.readInt();
            int lengthBinary = cMsgDomainServer.this.in.readInt();
            int stringBytesToRead = lengthSubject + lengthType + lengthNamespace + lengthPayloadTxt + lengthText;
            int offset = 0;
            if (stringBytesToRead > this.bytes.length) {
                this.bytes = new byte[stringBytesToRead];
            }
            cMsgDomainServer.this.in.readFully(this.bytes, 0, stringBytesToRead);
            msg.setSubject(new String(this.bytes, offset, lengthSubject, "US-ASCII"));
            msg.setType(new String(this.bytes, offset += lengthSubject, lengthType, "US-ASCII"));
            offset += lengthType;
            String ns = null;
            if (lengthNamespace > 0) {
                ns = new String(this.bytes, offset, lengthNamespace, "US-ASCII");
                offset += lengthNamespace;
            }
            if (lengthPayloadTxt > 0) {
                msg.setPayloadText(new String(this.bytes, offset, lengthPayloadTxt, "US-ASCII"));
                offset += lengthPayloadTxt;
            }
            msg.setText(new String(this.bytes, offset, lengthText, "US-ASCII"));
            offset += lengthText;
            if (lengthBinary > 0) {
                byte[] b = new byte[lengthBinary];
                cMsgDomainServer.this.in.readFully(b, 0, lengthBinary);
                try {
                    msg.setByteArrayNoCopy(b, 0, lengthBinary);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            msg.setVersion(5);
            msg.setGetRequest(true);
            msg.setDomain(domainType);
            msg.setReceiver("cMsg domain server");
            msg.setReceiverHost(cMsgDomainServer.this.info.getDomainHost());
            msg.setReceiverTime(new Date());
            msg.setSender(cMsgDomainServer.this.info.getName());
            msg.setSenderHost(cMsgDomainServer.this.info.getClientHost());
            cMsgHolder h = new cMsgHolder(msg);
            h.namespace = ns;
            return h;
        }

        private cMsgHolder readSubscribeInfo() throws IOException {
            int lengthNamespace;
            int lengthType;
            cMsgHolder holder = new cMsgHolder();
            holder.id = cMsgDomainServer.this.in.readInt();
            int lengthSubject = cMsgDomainServer.this.in.readInt();
            int bytesToRead = lengthSubject + (lengthType = cMsgDomainServer.this.in.readInt()) + (lengthNamespace = cMsgDomainServer.this.in.readInt());
            if (bytesToRead > this.bytes.length) {
                this.bytes = new byte[bytesToRead];
            }
            cMsgDomainServer.this.in.readFully(this.bytes, 0, bytesToRead);
            holder.subject = new String(this.bytes, 0, lengthSubject, "US-ASCII");
            holder.type = new String(this.bytes, lengthSubject, lengthType, "US-ASCII");
            if (lengthNamespace > 0) {
                holder.namespace = new String(this.bytes, lengthSubject + lengthType, lengthNamespace, "US-ASCII");
            }
            return holder;
        }

        private cMsgHolder readShutdownInfo() throws IOException {
            int flag = cMsgDomainServer.this.in.readInt();
            int lengthClient = cMsgDomainServer.this.in.readInt();
            if (lengthClient > this.bytes.length) {
                this.bytes = new byte[lengthClient];
            }
            cMsgDomainServer.this.in.readFully(this.bytes, 0, lengthClient);
            String client = new String(this.bytes, 0, lengthClient, "US-ASCII");
            return new cMsgHolder(client, flag == 1);
        }

        private cMsgHolder readUngetInfo() throws IOException {
            cMsgHolder holder = new cMsgHolder();
            holder.id = cMsgDomainServer.this.in.readInt();
            return holder;
        }
    }

    private class UdpSendHandler
    extends Thread {
        byte[] buf = new byte[65487];
        int bufIndex;

        UdpSendHandler() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            DatagramPacket packet = new DatagramPacket(this.buf, 65487);
            try {
                while (true) {
                    if (cMsgDomainServer.this.killSpawnedThreads) {
                        return;
                    }
                    packet.setLength(65487);
                    cMsgDomainServer.this.udpSocket.receive(packet);
                    if (cMsgDomainServer.this.killSpawnedThreads) {
                        return;
                    }
                    if (cMsgUtilities.bytesToInt(this.buf, 0) != cMsgNetworkConstants.magicNumbers[0] || cMsgUtilities.bytesToInt(this.buf, 4) != cMsgNetworkConstants.magicNumbers[1] || cMsgUtilities.bytesToInt(this.buf, 8) != cMsgNetworkConstants.magicNumbers[2]) {
                        if (cMsgDomainServer.this.debug < 3) continue;
                        System.out.println("DS udpSendHandler: received bogus udp packet");
                        continue;
                    }
                    this.bufIndex = 12;
                    int msgId = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
                    if (msgId != 5) {
                        if (cMsgDomainServer.this.debug >= 3) {
                            System.out.println("DS udpSendHandler: can't understand your message " + cMsgDomainServer.this.info.getName());
                        }
                        if (!cMsgDomainServer.this.calledShutdown.compareAndSet(false, true)) return;
                        cMsgDomainServer.this.shutdown();
                        return;
                    }
                    if (!cMsgDomainServer.this.udpSocket.isConnected()) {
                        cMsgDomainServer.this.udpSocket.connect(packet.getAddress(), packet.getPort());
                    }
                    ++cMsgDomainServer.this.info.monData.udpSends;
                    cMsgHolder holder = this.readSendInfo();
                    holder.request = msgId;
                    try {
                        cMsgDomainServer.this.requestQueue.put(holder);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (cMsgDomainServer.this.requestQueue.remainingCapacity() >= 10 || cMsgDomainServer.this.tempThreads.get() >= cMsgDomainServer.this.tempThreadsMax) continue;
                    new RequestQueueThread();
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                if (cMsgDomainServer.this.debug < 2) return;
                System.out.println("dServer udpSendHandler: I/O ERROR in domain server, udp receiver");
                return;
            }
            finally {
                if (!cMsgDomainServer.this.udpSocket.isClosed()) {
                    cMsgDomainServer.this.udpSocket.close();
                }
            }
        }

        private cMsgHolder readSendInfo() throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            this.bufIndex += 4;
            msg.setUserInt(cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4));
            msg.setSysMsgId(cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4));
            msg.setSenderToken(cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4));
            msg.setInfo(cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4) | 0x10);
            msg.setExpandedPayload(false);
            long time = (long)cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4) << 32 | (long)cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4) & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4) << 32 | (long)cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4) & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            int lengthSubject = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
            int lengthType = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
            int lengthPayloadTxt = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
            int lengthText = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
            int lengthBinary = cMsgUtilities.bytesToInt(this.buf, this.bufIndex += 4);
            msg.setSubject(new String(this.buf, this.bufIndex += 4, lengthSubject, "US-ASCII"));
            msg.setType(new String(this.buf, this.bufIndex += lengthSubject, lengthType, "US-ASCII"));
            if (lengthPayloadTxt > 0) {
                msg.setPayloadText(new String(this.buf, this.bufIndex += lengthType, lengthPayloadTxt, "US-ASCII"));
            }
            msg.setText(new String(this.buf, this.bufIndex += lengthPayloadTxt, lengthText, "US-ASCII"));
            if (lengthBinary > 0) {
                try {
                    msg.setByteArray(this.buf, this.bufIndex += lengthText, lengthBinary);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            msg.setVersion(5);
            msg.setDomain(domainType);
            msg.setReceiver("cMsg domain server");
            msg.setReceiverHost(cMsgDomainServer.this.info.getDomainHost());
            msg.setReceiverTime(new Date());
            msg.setSender(cMsgDomainServer.this.info.getName());
            msg.setSenderHost(cMsgDomainServer.this.info.getClientHost());
            return new cMsgHolder(msg);
        }
    }
}

