/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsg;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgClientListeningThread;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgSendAndGetCallbackThread;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class cMsgServerClient
extends cMsg {
    private cMsgNameServer nameServer;
    ConcurrentHashMap<Integer, cMsgSendAndGetCallbackThread> serverSendAndGets;
    ConcurrentHashMap<Integer, Future<Boolean>> serverSendAndGetCancel;
    cMsgGetHelper clientNamesHelper;
    String[] clientNamesAndNamespaces;
    cMsgGetHelper cloudLockHelper;
    AtomicBoolean gotCloudLock = new AtomicBoolean(false);
    cMsgGetHelper registrationLockHelper;
    AtomicBoolean gotRegistrationLock = new AtomicBoolean(false);
    private ThreadPoolExecutor sendAndGetCallbackThreadPool;

    public void printSizes() {
        System.out.println("              cli send&Gets         = " + this.serverSendAndGets.size());
        System.out.println("              cli send&Gets cancels = " + this.serverSendAndGetCancel.size());
    }

    public cMsgServerClient(cMsgNameServer nameServer) throws cMsgException {
        this.nameServer = nameServer;
        this.clientNamesHelper = new cMsgGetHelper();
        this.cloudLockHelper = new cMsgGetHelper();
        this.registrationLockHelper = new cMsgGetHelper();
        this.serverSendAndGets = new ConcurrentHashMap(20);
        this.serverSendAndGetCancel = new ConcurrentHashMap(20);
        this.sendAndGetCallbackThreadPool = new ThreadPoolExecutor(1, 5, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RejectHandler());
    }

    public void cleanup() {
        this.sendAndGetCallbackThreadPool.shutdownNow();
        this.serverSendAndGets.clear();
        this.serverSendAndGetCancel.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> connect(int fromNsTcpPort, int fromNsMulticastPort, boolean isOriginator, String cloudPassword, String clientPassword, boolean multicasting) throws cMsgException {
        HashSet<String> serverSet = null;
        this.connectLock.lock();
        try {
            DataOutputStream kaOut;
            block39: {
                List<Object> orderedIpList;
                if (this.connected) {
                    HashSet<String> hashSet = null;
                    return hashSet;
                }
                this.currentParsedUDL = this.parseUDL(this.UDL);
                this.useFailovers = false;
                if (multicasting) {
                    this.connectWithMulticast();
                    orderedIpList = cMsgUtilities.orderIPAddresses(this.ipList, this.broadList, this.currentParsedUDL.preferredSubnet);
                } else {
                    orderedIpList = new ArrayList<String>(1);
                    orderedIpList.add(this.currentParsedUDL.nameServerHost);
                }
                Socket nsSocket = null;
                IOException ex = null;
                for (String string : orderedIpList) {
                    try {
                        nsSocket = new Socket(string, this.currentParsedUDL.nameServerTcpPort);
                        this.currentParsedUDL.nameServerHost = string;
                        nsSocket.setTcpNoDelay(true);
                        break;
                    }
                    catch (IOException e) {
                        ex = e;
                    }
                }
                if (nsSocket == null) {
                    throw new cMsgException("connect: cannot create socket to name server", ex);
                }
                if (multicasting) {
                    try {
                        String canonicalHost = InetAddress.getByName(this.currentParsedUDL.nameServerHost).getCanonicalHostName();
                        this.name = canonicalHost + ":" + this.currentParsedUDL.nameServerTcpPort;
                    }
                    catch (UnknownHostException e) {
                        this.name = this.currentParsedUDL.nameServerHost + ":" + this.currentParsedUDL.nameServerTcpPort;
                    }
                }
                try {
                    serverSet = this.talkToNameServerFromServer(nsSocket, this.nameServer.getCloudStatus(), fromNsTcpPort, fromNsMulticastPort, isOriginator, cloudPassword, clientPassword);
                }
                catch (IOException e) {
                    try {
                        nsSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new cMsgException("connect: cannot talk to name server");
                }
                try {
                    nsSocket.close();
                }
                catch (IOException e) {
                    if (this.debug < 2) break block39;
                    System.out.println("connect: cannot close channel to name server, continue on");
                }
            }
            try {
                this.domainOutSocket = new Socket(this.currentParsedUDL.nameServerHost, this.domainServerPort);
                this.domainOutSocket.setTcpNoDelay(true);
                this.domainOutSocket.setSendBufferSize(131072);
                this.domainOut = new DataOutputStream(new BufferedOutputStream(this.domainOutSocket.getOutputStream(), 131072));
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                this.domainOut.writeInt(this.uniqueClientKey);
                this.domainOut.writeInt(1);
                this.domainOut.flush();
                if (this.domainOutSocket.getInputStream().read() < 1) {
                    throw new IOException("failed to create message channel to domain server");
                }
            }
            catch (IOException e) {
                try {
                    if (this.domainOutSocket != null) {
                        this.domainOutSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new cMsgException("cannot create message channel to domain server", e);
            }
            try {
                this.keepAliveSocket = new Socket(this.currentParsedUDL.nameServerHost, this.domainServerPort);
                this.keepAliveSocket.setTcpNoDelay(true);
                kaOut = new DataOutputStream(new BufferedOutputStream(this.keepAliveSocket.getOutputStream()));
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                kaOut.writeInt(this.uniqueClientKey);
                kaOut.writeInt(2);
                kaOut.flush();
                if (this.keepAliveSocket.getInputStream().read() < 1) {
                    throw new IOException("failed to create keepalive channel to domain server");
                }
            }
            catch (IOException iOException) {
                try {
                    this.domainOutSocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    if (this.keepAliveSocket != null) {
                        this.keepAliveSocket.close();
                    }
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                throw new cMsgException("cannot create keepAlive channel to domain server", iOException);
            }
            try {
                this.listeningThread = new cMsgClientListeningThread(this, this.domainOutSocket);
                this.listeningThread.start();
                this.keepAliveThread = new cMsg.KeepAlive(this.keepAliveSocket);
                this.keepAliveThread.start();
                this.updateServerThread = new cMsg.UpdateServer(kaOut);
                this.updateServerThread.start();
            }
            catch (IOException iOException) {
                if (this.listeningThread != null) {
                    this.listeningThread.killThread();
                }
                if (this.keepAliveThread != null) {
                    this.keepAliveThread.killThread();
                }
                if (this.updateServerThread != null) {
                    this.updateServerThread.killThread();
                }
                throw new cMsgException("cannot launch threads", iOException);
            }
            this.connected = true;
        }
        finally {
            this.connectLock.unlock();
        }
        return serverSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int serverSendAndGet(cMsgMessage message, String namespace, cMsgCallbackInterface cb3) throws IOException {
        int id = 0;
        String subject = message.getSubject();
        String type = message.getType();
        String text = message.getText();
        String payloadTxt = message.getPayloadText();
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            id = this.uniqueId.getAndIncrement();
            cMsgSendAndGetCallbackThread thd = new cMsgSendAndGetCallbackThread(cb3, namespace);
            Future<Boolean> future = this.sendAndGetCallbackThreadPool.submit(thd);
            this.serverSendAndGets.put(id, thd);
            this.serverSendAndGetCancel.put(id, future);
            int binaryLength = message.getByteArrayLength();
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(60 + subject.length() + type.length() + namespace.length() + payloadTxt.length() + text.length() + binaryLength);
                this.domainOut.writeInt(44);
                this.domainOut.writeInt(0);
                this.domainOut.writeInt(message.getUserInt());
                this.domainOut.writeInt(id);
                this.domainOut.writeInt(message.getInfo() | 1);
                long now = new Date().getTime();
                this.domainOut.writeInt((int)(now >>> 32));
                this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
                this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
                this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
                this.domainOut.writeInt(subject.length());
                this.domainOut.writeInt(type.length());
                this.domainOut.writeInt(namespace.length());
                this.domainOut.writeInt(payloadTxt.length());
                this.domainOut.writeInt(text.length());
                this.domainOut.writeInt(binaryLength);
                try {
                    this.domainOut.write(subject.getBytes("US-ASCII"));
                    this.domainOut.write(type.getBytes("US-ASCII"));
                    this.domainOut.write(namespace.getBytes("US-ASCII"));
                    this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                    this.domainOut.write(text.getBytes("US-ASCII"));
                    if (binaryLength > 0) {
                        this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.notConnectLock.unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverUnSendAndGet(int id) throws IOException {
        if (!this.connected) {
            throw new IOException("not connected to server");
        }
        cMsgSendAndGetCallbackThread thd = this.serverSendAndGets.remove(id);
        Future<Boolean> future = this.serverSendAndGetCancel.remove(id);
        if (thd == null) {
            return;
        }
        future.cancel(true);
        this.socketLock.lock();
        try {
            this.domainOut.writeInt(8);
            this.domainOut.writeInt(45);
            this.domainOut.writeInt(id);
            this.domainOut.flush();
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void serverSubscribe(String subject, String type, String namespace, cMsgCallbackInterface cb, Object userObj) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serverUnsubscribe(String subject, String type, String namespace, cMsgCallbackInterface cb, Object userObj) throws IOException {
        block26: {
            oldSub = null;
            cbThread = null;
            this.notConnectLock.lock();
            this.subscribeLock.lock();
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            if (namespace == null) {
                namespace = "/default";
            }
            foundMatch = false;
            id = 0;
            var10_10 = this.subscriptions;
            synchronized (var10_10) {
                for (cMsgSubscription sub : this.subscriptions.keySet()) {
                    if (!sub.getSubject().equals(subject) || !sub.getType().equals(type) || !sub.getNamespace().equals(namespace)) continue;
                    for (cMsgCallbackThread cbt : sub.getCallbacks()) {
                        if (cbt.getCallback() != cb || cbt.getUserObject() != userObj) continue;
                        foundMatch = true;
                        cbThread = cbt;
                        cbt.setCount(cbt.getCount() - 1);
                        if (cbt.getCount() <= 0) break;
                        // MONITOREXIT @DISABLED, blocks:[0, 17, 18, 10] lbl26 : MonitorExitStatement: MONITOREXIT : var10_10
                        this.subscribeLock.unlock();
                        this.notConnectLock.unlock();
                        return;
                    }
                    if (foundMatch) ** break block25
                    break block26;
                }
                break block27;
            }
        }
        this.subscribeLock.unlock();
        this.notConnectLock.unlock();
        return;
        {
            block27: {
                if (sub.numberOfCallbacks() > 1) {
                    if (Thread.currentThread() == cbThread) {
                        cbThread.dieNow(false);
                    } else {
                        cbThread.dieNow(true);
                    }
                    sub.getCallbacks().remove(cbThread);
                    // MONITOREXIT @DISABLED, blocks:[22, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var10_10
                    this.subscribeLock.unlock();
                    this.notConnectLock.unlock();
                    return;
                }
                ** try [egrp 4[TRYBLOCK] [13 : 332->368)] { 
lbl48:
                // 1 sources

                id = sub.getIntVal();
                oldSub = sub;
            }
            ** if (foundMatch) goto lbl53
        }
lbl52:
        // 1 sources

        return;
lbl53:
        // 1 sources

        this.socketLock.lock();
        try {
            this.domainOut.writeInt(20 + subject.length() + type.length() + namespace.length());
            this.domainOut.writeInt(31);
            this.domainOut.writeInt(id);
            this.domainOut.writeInt(subject.length());
            this.domainOut.writeInt(type.length());
            this.domainOut.writeInt(namespace.length());
            try {
                this.domainOut.write(subject.getBytes("US-ASCII"));
                this.domainOut.write(type.getBytes("US-ASCII"));
                this.domainOut.write(namespace.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException var10_11) {
                // empty catch block
            }
            this.domainOut.flush();
        }
        finally {
            this.socketLock.unlock();
        }
        var10_10 = this.subscriptions;
        synchronized (var10_10) {
            cbThread.dieNow(false);
            oldSub.getCallbacks().remove(cbThread);
            this.subscriptions.remove(oldSub);
            return;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                this.subscribeLock.unlock();
                this.notConnectLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverShutdownClients(String client, boolean includeMe) throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            if (client == null) {
                client = new String("");
            }
            int flag = includeMe ? 1 : 0;
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(12 + client.length());
                this.domainOut.writeInt(46);
                this.domainOut.writeInt(flag);
                this.domainOut.writeInt(client.length());
                try {
                    this.domainOut.write(client.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    public void serverShutdown() throws IOException {
        this.connectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(47);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.connectLock.unlock();
        }
    }

    HashSet<String> talkToNameServerFromServer(Socket socket, int cloudStatus, int fromNSTcpPort, int fromNSMulticastPort, boolean isOriginator, String cloudPassword, String clientPassword) throws IOException, cMsgException {
        byte[] buf = new byte[512];
        DataInputStream in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
        out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
        out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
        out.writeInt(34);
        out.writeInt(5);
        out.writeInt(1);
        out.writeInt(0);
        out.writeByte(cloudStatus);
        out.writeByte(isOriginator ? 1 : 0);
        out.writeInt(fromNSTcpPort);
        out.writeInt(fromNSMulticastPort);
        out.writeInt(this.host.length());
        if (cloudPassword == null) {
            cloudPassword = "";
        }
        out.writeInt(cloudPassword.length());
        if (clientPassword == null) {
            clientPassword = "";
        }
        out.writeInt(clientPassword.length());
        try {
            out.write(this.host.getBytes("US-ASCII"));
            out.write(cloudPassword.getBytes("US-ASCII"));
            out.write(clientPassword.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        out.flush();
        int error = in.readInt();
        if (error != 0) {
            int len = in.readInt();
            if (len > buf.length) {
                buf = new byte[len + 100];
            }
            in.readFully(buf, 0, len);
            String err = new String(buf, 0, len, "US-ASCII");
            cMsgException ex = new cMsgException("Error from server: " + err);
            ex.setReturnCode(error);
            throw ex;
        }
        this.uniqueClientKey = in.readInt();
        this.domainServerPort = in.readInt();
        int hostLength = in.readInt();
        if (hostLength > buf.length) {
            buf = new byte[hostLength];
        }
        in.readFully(buf, 0, hostLength);
        this.domainServerHost = new String(buf, 0, hostLength, "US-ASCII");
        if (this.debug >= 4) {
            System.out.println("        << CL: domain server host = " + this.domainServerHost + ", port = " + this.domainServerPort);
        }
        HashSet<String> s = null;
        int numServers = in.readInt();
        if (numServers > 0) {
            s = new HashSet<String>(numServers);
            for (int i = 0; i < numServers; ++i) {
                int serverNameLength = in.readInt();
                byte[] bytes = new byte[serverNameLength];
                in.readFully(bytes, 0, serverNameLength);
                String serverName = new String(bytes, 0, serverNameLength, "US-ASCII");
                s.add(serverName);
                if (this.debug < 4) continue;
                System.out.println("  server = " + serverName);
            }
        }
        this.hasSend = true;
        this.hasSyncSend = true;
        this.hasSubscribeAndGet = true;
        this.hasSendAndGet = true;
        this.hasSubscribe = true;
        this.hasUnsubscribe = true;
        this.hasShutdown = true;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cloudLock(int delay) throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(8);
                this.domainOut.writeInt(41);
                this.domainOut.writeInt(delay);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
            try {
                cMsgGetHelper cMsgGetHelper2 = this.cloudLockHelper;
                synchronized (cMsgGetHelper2) {
                    this.cloudLockHelper.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cloudLockHelper.getErrorCode() != 0) {
                throw new IOException("cloudLock abort");
            }
        }
        finally {
            this.notConnectLock.unlock();
        }
        return this.gotCloudLock.get();
    }

    public void cloudUnlock() throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(42);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registrationLock(int delay) throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(8);
                this.domainOut.writeInt(39);
                this.domainOut.writeInt(delay);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
            try {
                cMsgGetHelper cMsgGetHelper2 = this.registrationLockHelper;
                synchronized (cMsgGetHelper2) {
                    this.registrationLockHelper.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.registrationLockHelper.getErrorCode() != 0) {
                throw new IOException("registrationLock abort");
            }
        }
        finally {
            this.notConnectLock.unlock();
        }
        return this.gotRegistrationLock.get();
    }

    public void registrationUnlock() throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(40);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    public void thisServerCloudStatus(int status) throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(8);
                this.domainOut.writeInt(43);
                this.domainOut.writeInt(status);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClientNamesAndNamespaces() throws IOException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(38);
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
            try {
                cMsgGetHelper cMsgGetHelper2 = this.clientNamesHelper;
                synchronized (cMsgGetHelper2) {
                    this.clientNamesHelper.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.clientNamesHelper.getErrorCode() != 0) {
                throw new IOException("getClientNamesAndNamespaces abort");
            }
        }
        finally {
            this.notConnectLock.unlock();
        }
        return this.clientNamesAndNamespaces;
    }

    class RejectHandler
    implements RejectedExecutionHandler {
        RejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
        }
    }
}

