/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgServerFinder;

public class cMsgPlatformSpy
implements Runnable {
    String expid;
    String enviromentalExpid;
    cMsgServerFinder finder;
    boolean debug;

    cMsgPlatformSpy(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgPlatformSpy.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-x")) {
                this.expid = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.debug = true;
                continue;
            }
            cMsgPlatformSpy.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgPlatformSpy\n        [-x <expid>]         platform expid to search for\n        [-d]                 turn on debug printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        cMsgPlatformSpy spy = new cMsgPlatformSpy(args);
        spy.run();
    }

    @Override
    public void run() {
        this.enviromentalExpid = System.getenv("EXPID");
        if (this.expid == null) {
            this.expid = this.enviromentalExpid;
        }
        this.finder = new cMsgServerFinder();
        this.finder.setPassword(this.expid);
        while (true) {
            this.finder.findRcServers();
            cMsgMessage[] msgs = this.finder.getRcServers();
            if (msgs != null) {
                try {
                    for (cMsgMessage msg : msgs) {
                        if (msg.getPayloadItem("host") == null || msg.getPayloadItem("expid") == null) continue;
                        String h = msg.getPayloadItem("host").getString();
                        String e = msg.getPayloadItem("expid").getString();
                        if (cMsgUtilities.isHostLocal(h) || !e.equals(this.expid)) continue;
                        System.out.println("Warning! Detected conflicting platform running on the host = " + h + " with EXPID = " + e);
                    }
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

