/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class cMsgGateway {
    private static String subject = "*";
    private static String type = "*";
    private static cMsg cmsg1;
    private static cMsg cmsg2;
    private static String name1;
    private static String name2;
    private static String UDL1;
    private static String UDL2;
    private static String descr1;
    private static String descr2;
    private static int count1;
    private static int count2;
    private static boolean done;
    private static boolean debug;
    private static int delay;

    public static void main(String[] args) {
        cMsgGateway.decode_command_line(args);
        if (UDL1.equals(UDL2)) {
            System.out.println("Gateway from cMsg system to itself is unnecessary");
            System.exit(-1);
        }
        try {
            cmsg1 = new cMsg(UDL1, name1, descr1);
            cmsg2 = new cMsg(UDL2, name2, descr2);
            cmsg1.connect();
            cmsg2.connect();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            cmsg1.subscribe(subject, type, new cb1(), null);
            cmsg2.subscribe(subject, type, new cb2(), null);
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        cmsg1.start();
        cmsg2.start();
        try {
            while (!done && cmsg1.isConnected() && cmsg2.isConnected()) {
                Thread.sleep(1L);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        cmsg1.stop();
        cmsg2.stop();
        try {
            cmsg1.disconnect();
            cmsg2.disconnect();
        }
        catch (Exception e) {
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgGateway\n        [-name1 <name>]            name of client connected to udl1\n        [-name2 <name>]            name of client connected to udl2\n        [-udl1 <udl>]              UDL for first cmsg connection\n        [-udl2 <udl>]              UDL for second cmsg connection\n        [-descr1 <description>]    string describing client connected to udl1\n        [-descr2 <description>]    string describing client connected to udl2\n        [-subject <subject>]       subject of messages to cross post\n        [-type <type>]             type of messages to cross post\n        [-debug]                   enable debug output\n        [-h]                       print this help\n");
    }

    private static void decode_command_line(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgGateway.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-subject")) {
                subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-type")) {
                type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-name1")) {
                name1 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-udl1")) {
                UDL1 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-descr1")) {
                descr1 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-name2")) {
                name2 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-udl2")) {
                UDL2 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-descr2")) {
                descr2 = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            cMsgGateway.usage();
            System.exit(-1);
        }
    }

    static {
        name1 = "cMsgGateway";
        name2 = "cMsgGateway";
        UDL1 = "cMsg://localhost/cMsg/myNameSpace";
        UDL2 = "cMsg://localhost/cMsg/myNameSpace";
        descr1 = "Generic cMsg Gateway";
        descr2 = "Generic cMsg Gateway";
        count1 = 0;
        count2 = 0;
        done = false;
        debug = false;
        delay = 500;
    }

    static class cb2
    extends cMsgCallbackAdapter {
        cb2() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            count2++;
            if (!msg.getSender().equals(name2)) {
                try {
                    cmsg1.send(msg);
                }
                catch (cMsgException e) {
                    System.out.println("?unable to send message using cmsg1");
                }
            }
            if (debug) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
        }
    }

    static class cb1
    extends cMsgCallbackAdapter {
        cb1() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            count1++;
            if (!msg.getSender().equals(name1)) {
                try {
                    cmsg2.send(msg);
                }
                catch (cMsgException e) {
                    System.out.println("?unable to send message using cmsg2");
                }
            }
            if (debug) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
        }
    }
}

