/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCServerDomain;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.cMsg.RCServerDomain.RCServer;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class rcListeningThread
extends Thread {
    private static AtomicInteger startingTcpPort = new AtomicInteger(45300);
    private String domainType = "rcs";
    private RCServer server;
    int tcpPort;
    int udpPort;
    private ServerSocketChannel serverChannel;
    private DatagramChannel udpChannel;
    private SocketChannel tcpChannel;
    private DataInputStream in;
    private int debug;
    private boolean killThread;
    final CountDownLatch startLatch = new CountDownLatch(1);
    private Thread.UncaughtExceptionHandler exitHandler;

    void killThread() {
        this.killThread = true;
        this.interrupt();
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public rcListeningThread(RCServer server) throws cMsgException {
        this.server = server;
        this.debug = server.getDebug();
        this.udpPort = server.localUdpPort;
        this.createTCPServerChannel();
        this.createUDPServerChannel();
        this.setDaemon(true);
        this.exitHandler = new MyExitHandler();
        this.setUncaughtExceptionHandler(this.exitHandler);
    }

    private void createUDPServerChannel() throws cMsgException {
        try {
            this.udpChannel = DatagramChannel.open();
            DatagramSocket udpSocket = this.udpChannel.socket();
            if (this.udpPort > 0) {
                try {
                    udpSocket.bind(new InetSocketAddress(this.udpPort));
                }
                catch (SocketException e) {
                    udpSocket.bind(new InetSocketAddress(0));
                }
            } else {
                udpSocket.bind(new InetSocketAddress(0));
            }
            this.udpPort = udpSocket.getLocalPort();
            udpSocket.setReuseAddress(true);
            udpSocket.setReceiveBufferSize(65536);
        }
        catch (IOException ex) {
            if (this.udpChannel != null) {
                try {
                    this.udpChannel.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            cMsgException e = new cMsgException("rcListeningThread: cannot create UDP server socket", ex);
            e.setReturnCode(12);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTCPServerChannel() throws cMsgException {
        ServerSocket listeningSocket;
        try {
            this.serverChannel = ServerSocketChannel.open();
            listeningSocket = this.serverChannel.socket();
            listeningSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            if (this.serverChannel != null) {
                try {
                    this.serverChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new cMsgException("rcListeningThread: cannot create TCP server socket", e);
        }
        AtomicInteger atomicInteger = startingTcpPort;
        synchronized (atomicInteger) {
            if (startingTcpPort.incrementAndGet() < 45300) {
                startingTcpPort.set(45300);
            }
            if (startingTcpPort.get() == 45700) {
                startingTcpPort.set(47200);
            }
            this.tcpPort = startingTcpPort.get();
            while (true) {
                try {
                    listeningSocket.bind(new InetSocketAddress(this.tcpPort));
                }
                catch (IOException ex) {
                    if (this.tcpPort < 65535) {
                        ++this.tcpPort;
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        this.serverChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.tcpPort = 0;
                    ex.printStackTrace();
                    throw new cMsgException("connect: cannot find port to listen on", ex);
                }
                break;
            }
            startingTcpPort.set(this.tcpPort + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block96: {
            if (this.debug >= 4) {
                System.out.println("Running Client Listening Thread:");
            }
            dataBuffer = null;
            tcpBuffer = ByteBuffer.allocateDirect(16384);
            udpBuffer = ByteBuffer.allocateDirect(65536);
            readingSize = true;
            okToParseMsg = false;
            bytesRead = 0;
            size = 0;
            msgId = 0;
            selector = null;
            try {
                selector = Selector.open();
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(selector, 16);
                try {
                    this.udpChannel.configureBlocking(false);
                    this.udpChannel.register(selector, 1, "UDP");
                }
                catch (IOException var14_10) {
                    // empty catch block
                }
                var14_11 = this;
                synchronized (var14_11) {
                    this.notifyAll();
                }
lbl29:
                // 3 sources

                while (true) {
                    n = selector.select(2000L);
                    if (n >= 1) ** GOTO lbl128
                    if (this.killThread) {
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (IOException ex) {
                System.out.println("rcListenThread: I/O ERROR in rc server");
                System.out.println("rcListenThread: close TCP server socket, port = " + this.tcpChannel.socket().getLocalPort());
                ex.printStackTrace();
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException var14_14) {
                    // empty catch block
                }
                try {
                    if (this.tcpChannel != null) {
                        this.tcpChannel.close();
                    }
                }
                catch (IOException var14_15) {
                    // empty catch block
                }
                try {
                    if (this.udpChannel != null) {
                        this.udpChannel.close();
                    }
                }
                catch (IOException var14_16) {
                    // empty catch block
                }
                try {
                    this.serverChannel.close();
                }
                catch (IOException var14_17) {
                    // empty catch block
                }
                try {
                    selector.close();
                }
                catch (IOException var14_18) {}
                break block96;
            }
            catch (Throwable var21_44) {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException var22_45) {
                    // empty catch block
                }
                try {
                    if (this.tcpChannel != null) {
                        this.tcpChannel.close();
                    }
                }
                catch (IOException var22_46) {
                    // empty catch block
                }
                try {
                    if (this.udpChannel != null) {
                        this.udpChannel.close();
                    }
                }
                catch (IOException var22_47) {
                    // empty catch block
                }
                try {
                    this.serverChannel.close();
                }
                catch (IOException var22_48) {
                    // empty catch block
                }
                try {
                    selector.close();
                    throw var21_44;
                }
                catch (IOException var22_49) {
                    // empty catch block
                }
                throw var21_44;
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException var15_24) {
                // empty catch block
            }
            try {
                if (this.tcpChannel != null) {
                    this.tcpChannel.close();
                }
            }
            catch (IOException var15_25) {
                // empty catch block
            }
            try {
                if (this.udpChannel != null) {
                    this.udpChannel.close();
                }
            }
            catch (IOException var15_26) {
                // empty catch block
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException var15_27) {
                // empty catch block
            }
            try {
                selector.close();
                return;
            }
            catch (IOException var15_28) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                selector.selectedKeys().clear();
                ** GOTO lbl29
lbl128:
                // 1 sources

                if (!this.killThread) ** GOTO lbl-1000
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException var15_29) {
                // empty catch block
            }
            try {
                if (this.tcpChannel != null) {
                    this.tcpChannel.close();
                }
            }
            catch (IOException var15_30) {
                // empty catch block
            }
            try {
                if (this.udpChannel != null) {
                    this.udpChannel.close();
                }
            }
            catch (IOException var15_31) {
                // empty catch block
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException var15_32) {
                // empty catch block
            }
            try {
                selector.close();
                return;
            }
            catch (IOException var15_33) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                it = selector.selectedKeys().iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    ** continue;
                    key = it.next();
                    if (key.isValid()) {
                        if (key.isAcceptable()) {
                            server = (ServerSocketChannel)key.channel();
                            channel = server.accept();
                            channel.configureBlocking(false);
                            socket = channel.socket();
                            socket.setTcpNoDelay(true);
                            socket.setReceiveBufferSize(65535);
                            socket.setSendBufferSize(65535);
                            if (this.debug >= 4) {
                                System.out.println("rcListeningThread: new connection");
                            }
                            channel.register(selector, 1, "TCP");
                            this.tcpChannel = channel;
                            this.in = new DataInputStream(new BufferedInputStream(this.tcpChannel.socket().getInputStream(), 65536));
                            tcpBuffer.clear();
                            tcpBuffer.limit(8);
                            readingSize = true;
                            this.startLatch.countDown();
                        } else if (key.isReadable()) {
                            channelType = (String)key.attachment();
                            if (channelType.equals("TCP")) {
                                readChannel = (SocketChannel)key.channel();
                                if (readingSize) {
                                    try {
                                        bytes = readChannel.read(tcpBuffer);
                                    }
                                    catch (IOException e) {
                                        key.cancel();
                                        it.remove();
                                        continue;
                                    }
                                    if (bytes == -1) {
                                        key.cancel();
                                        it.remove();
                                        continue;
                                    }
                                    if (tcpBuffer.position() > 7) {
                                        tcpBuffer.flip();
                                        size = tcpBuffer.getInt();
                                        msgId = tcpBuffer.getInt();
                                        if (size > 1500) {
                                            // empty if block
                                        }
                                        if (size - 4 > tcpBuffer.capacity()) {
                                            tcpBuffer = ByteBuffer.allocateDirect(size - 4);
                                        }
                                        tcpBuffer.clear();
                                        tcpBuffer.limit(size - 4);
                                        readingSize = false;
                                        bytesRead = 0;
                                    }
                                }
                                if (!readingSize) {
                                    try {
                                        bytes = readChannel.read(tcpBuffer);
                                    }
                                    catch (IOException ex) {
                                        key.cancel();
                                        it.remove();
                                        continue;
                                    }
                                    if (bytes == -1) {
                                        key.cancel();
                                        it.remove();
                                        continue;
                                    }
                                    if ((bytesRead += bytes) >= size - 4) {
                                        tcpBuffer.flip();
                                        dataBuffer = tcpBuffer;
                                        okToParseMsg = true;
                                    }
                                }
                                this.tcpChannel = readChannel;
                            } else {
                                block97: {
                                    udpBuffer.clear();
                                    readChannel = (DatagramChannel)key.channel();
                                    try {
                                        senderAddress = readChannel.receive(udpBuffer);
                                        if (senderAddress == null) {
                                            System.out.println("rcListeningThread: " + this.server.getName() + " nothing to read in udp channel");
                                            it.remove();
                                        }
                                        break block97;
                                    }
                                    catch (IOException e) {
                                        System.out.println("rcListeningThread: " + this.server.getName() + " IO error reading udp packet");
                                        it.remove();
                                    }
                                    continue;
                                }
                                udpBuffer.flip();
                                if (udpBuffer.limit() < 20) {
                                    System.out.println("rcListeningThread: " + this.server.getName() + " udp packet is too small, " + udpBuffer.limit());
                                    it.remove();
                                    continue;
                                }
                                m1 = udpBuffer.getInt();
                                m2 = udpBuffer.getInt();
                                m3 = udpBuffer.getInt();
                                if (m1 != cMsgNetworkConstants.magicNumbers[0] || m2 != cMsgNetworkConstants.magicNumbers[1] || m3 != cMsgNetworkConstants.magicNumbers[2]) {
                                    System.out.println("rcListeningThread: " + this.server.getName() + " received bogus udp packet (bad magic ints)");
                                    it.remove();
                                    continue;
                                }
                                size = udpBuffer.getInt();
                                msgId = udpBuffer.getInt();
                                if (16 + size > udpBuffer.limit()) {
                                    System.out.println("rcListeningThread: " + this.server.getName() + " not enough data in packet (" + udpBuffer.limit() + ") to read complete msg (" + (16 + size) + "), ignore it");
                                    it.remove();
                                    continue;
                                }
                                dataBuffer = udpBuffer;
                                okToParseMsg = true;
                                this.udpChannel = readChannel;
                            }
                            if (okToParseMsg) {
                                switch (msgId) {
                                    case 21: {
                                        msg = this.readIncomingMessageNB(dataBuffer);
                                        this.runCallbacks(msg);
                                        break;
                                    }
                                    case 20: {
                                        msg = this.readIncomingMessageNB(dataBuffer);
                                        msg.setGetResponse(true);
                                        this.wakeGets(msg);
                                        break;
                                    }
                                }
                                bytesRead = 0;
                                readingSize = true;
                                okToParseMsg = false;
                                tcpBuffer.clear();
                                tcpBuffer.limit(8);
                            }
                        }
                    }
                    it.remove();
                }
            }
        }
        System.out.println("rcListeningThread: " + this.server.getName() + " quit TCP/UDP listening thread");
    }

    private cMsgMessageFull readIncomingMessageNB(ByteBuffer buffer) {
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setVersion(buffer.getInt());
        msg.setUserInt(buffer.getInt());
        msg.setInfo(buffer.getInt() | 0x10 | 0x40);
        msg.setSenderToken(buffer.getInt());
        long time = buffer.getLong();
        msg.setSenderTime(new Date(time));
        time = buffer.getLong();
        msg.setUserTime(new Date(time));
        int lengthSender = buffer.getInt();
        int lengthSubject = buffer.getInt();
        int lengthType = buffer.getInt();
        int lengthPayloadTxt = buffer.getInt();
        int lengthText = buffer.getInt();
        int lengthBinary = buffer.getInt();
        Charset cs = Charset.forName("ASCII");
        CharBuffer chBuf = cs.decode(buffer);
        msg.setSender(chBuf.subSequence(0, lengthSender).toString());
        int len = lengthSender;
        msg.setSubject(chBuf.subSequence(len, len + lengthSubject).toString());
        msg.setType(chBuf.subSequence(len += lengthSubject, len + lengthType).toString());
        len += lengthType;
        if (lengthPayloadTxt > 0) {
            String s = chBuf.subSequence(len, len + lengthPayloadTxt).toString();
            len += lengthPayloadTxt;
            try {
                msg.setFieldsFromText(s, 2);
            }
            catch (cMsgException e) {
                System.out.println("msg payload is in the wrong format: " + e.getMessage());
            }
        }
        if (lengthText > 0) {
            msg.setText(chBuf.subSequence(len, len + lengthText).toString());
            len += lengthText;
        }
        if (lengthBinary > 0) {
            byte[] array = new byte[lengthBinary];
            buffer.position(buffer.position() + len);
            buffer.get(array, 0, lengthBinary);
            msg.setByteArrayNoCopy(array);
        }
        msg.setDomain(this.domainType);
        msg.setReceiver(this.server.getName());
        msg.setReceiverHost(this.server.getHost());
        msg.setReceiverTime(new Date());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallbacks(cMsgMessageFull msg) {
        Set<cMsgSubscription> set;
        boolean delivered = false;
        if (this.server.subscribeAndGets.size() > 0) {
            Iterator<cMsgSubscription> i = this.server.subscribeAndGets.values().iterator();
            while (i.hasNext()) {
                cMsgSubscription sub = i.next();
                if (sub.matches(msg.getSubject(), msg.getType())) {
                    sub.setTimedOut(false);
                    sub.setMessage(msg.copy());
                    cMsgSubscription cMsgSubscription2 = sub;
                    synchronized (cMsgSubscription2) {
                        sub.notify();
                    }
                    delivered = true;
                }
                i.remove();
            }
        }
        if ((set = this.server.subscriptions).size() > 0) {
            if (!this.server.isReceiving()) {
                if (this.debug >= 4) {
                    System.out.println("rc runCallbacks: all subscription callbacks have been stopped");
                }
                return;
            }
            Set<cMsgSubscription> set2 = set;
            synchronized (set2) {
                for (cMsgSubscription sub : set) {
                    if (!sub.matches(msg.getSubject(), msg.getType())) continue;
                    for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                        cbThread.sendMessage(msg);
                        delivered = true;
                    }
                }
            }
        }
        if (!delivered) {
            System.out.println("rc runCallbacks: no callbacks to deliver msg to (sub = " + msg.getSubject() + ", typ = " + msg.getType() + ") from rc client " + msg.getSender());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeGets(cMsgMessageFull msg) {
        cMsgGetHelper helper = this.server.sendAndGets.remove(msg.getSenderToken());
        if (helper == null) {
            System.out.println("wakeGets: originating sendAndGet not in table, discard response");
            return;
        }
        helper.setTimedOut(false);
        helper.setMessage(msg);
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.notify();
        }
    }

    private class MyExitHandler
    implements Thread.UncaughtExceptionHandler {
        private MyExitHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.println("rcListeningThread: invoke listening thread EXIT HANDLER to close sockets");
            try {
                if (rcListeningThread.this.in != null) {
                    rcListeningThread.this.in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (rcListeningThread.this.tcpChannel != null) {
                    rcListeningThread.this.tcpChannel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (rcListeningThread.this.udpChannel != null) {
                    rcListeningThread.this.udpChannel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                rcListeningThread.this.serverChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

