/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCMulticastDomain;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.jlab.coda.cMsg.RCMulticastDomain.RCMulticast;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class rcListeningThread
extends Thread {
    private String domainType = "rcm";
    private RCMulticast server;
    private int multicastPort;
    private MulticastSocket multicastSocket;
    private NetworkInterface networkInterface;
    private int debug;
    private volatile boolean killThread;

    void killThread() {
        this.killThread = true;
        this.interrupt();
    }

    private void printNI(NetworkInterface ni) {
        System.out.println("\n\nInterface name = " + ni.getName());
        System.out.println("Interface display name = " + ni.getDisplayName());
        int counter = 1;
        List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
        for (InterfaceAddress ifAddr : inAddrs) {
            System.out.println("interface address #" + counter++ + ":");
            InetAddress addr = ifAddr.getAddress();
            System.out.println("    host address = " + addr.getHostAddress());
            System.out.println("    canonical host name = " + addr.getCanonicalHostName());
            System.out.println("    host name = " + addr.getHostName());
            System.out.println("    toString() = " + addr.toString());
            byte[] b = addr.getAddress();
            for (int i = 0; i < b.length; ++i) {
                int bb = b[i] & 0xFF;
                System.out.println("addr byte = " + bb + ", 0x" + Integer.toHexString(bb));
            }
            InetAddress baddr = ifAddr.getBroadcast();
            if (baddr == null) continue;
            System.out.println("broadcast addr = " + baddr.getHostAddress());
        }
    }

    public rcListeningThread(RCMulticast server, int port) throws cMsgException {
        try {
            this.multicastPort = port;
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName("239.210.0.0"), this.multicastPort);
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp()) continue;
                try {
                    this.multicastSocket.joinGroup(sa, ni);
                }
                catch (IOException e) {
                    System.out.println("Error joining multicast group over " + ni.getName());
                }
            }
            this.multicastSocket.setReceiveBufferSize(65535);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.setTimeToLive(32);
        }
        catch (IOException e) {
            throw new cMsgException("Port " + this.multicastPort + " is taken", e);
        }
        this.server = server;
        this.debug = server.getDebug();
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DatagramPacket sendPacket;
        byte[] outBuf;
        DatagramPacket packet;
        byte[] buf;
        block59: {
            if (this.debug >= 4) {
                System.out.println("Running RC Multicast Listening Thread");
            }
            buf = new byte[2048];
            packet = new DatagramPacket(buf, 2048);
            outBuf = null;
            sendPacket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(5);
                out.writeInt(this.multicastPort);
                out.writeInt(this.server.getHost().length());
                out.writeInt(this.server.expid.length());
                try {
                    out.write(this.server.getHost().getBytes("US-ASCII"));
                    out.write(this.server.expid.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                List<InterfaceAddress> ipInfo = cMsgUtilities.getAllIpInfo();
                out.writeInt(ipInfo.size());
                try {
                    for (InterfaceAddress ia : ipInfo) {
                        String ip = ia.getAddress().getHostAddress();
                        out.writeInt(ip.length());
                        out.write(ip.getBytes("US-ASCII"));
                        ip = ia.getBroadcast().getHostAddress();
                        out.writeInt(ip.length());
                        out.write(ip.getBytes("US-ASCII"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                out.close();
                outBuf = baos.toByteArray();
                baos.close();
            }
            catch (IOException e) {
                if (this.debug < 2) break block59;
                System.out.println("I/O Error: " + e);
            }
        }
        rcListeningThread e = this;
        synchronized (e) {
            this.notifyAll();
        }
        try {
            block39: while (true) {
                ArrayList<String> broadList;
                ArrayList<String> ipList;
                int listLen;
                if (this.killThread) {
                    return;
                }
                packet.setLength(2048);
                this.multicastSocket.receive(packet);
                if (this.debug >= 4) {
                    System.out.println("     ***** RECEIVED RC DOMAIN MULTICAST PACKET from " + packet.getAddress().getHostName());
                }
                if (this.killThread) {
                    return;
                }
                InetAddress multicasterAddress = packet.getAddress();
                String multicasterHost = multicasterAddress.getHostName();
                int multicasterUdpPort = packet.getPort();
                if (packet.getLength() < 16) {
                    if (this.debug < 3) continue;
                    System.out.println("RC multicast listener: got multicast packet that's too small");
                    continue;
                }
                int magic1 = cMsgUtilities.bytesToInt(buf, 0);
                int magic2 = cMsgUtilities.bytesToInt(buf, 4);
                int magic3 = cMsgUtilities.bytesToInt(buf, 8);
                if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                    if (this.debug < 3) continue;
                    System.out.println("RC multicast listener: got multicast packet with bad magic #s");
                    continue;
                }
                int version = cMsgUtilities.bytesToInt(buf, 12);
                if (version != 5) {
                    if (this.debug < 3) continue;
                    System.out.println("RC multicast listener: got cMsg packet version " + version + " which does NOT match version " + 5 + ", so ignore");
                    continue;
                }
                int msgType = cMsgUtilities.bytesToInt(buf, 16);
                switch (msgType) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 8: {
                        continue block39;
                    }
                    case 16: {
                        break;
                    }
                    default: {
                        continue block39;
                    }
                }
                int multicasterTcpPort = cMsgUtilities.bytesToInt(buf, 20);
                int senderId = cMsgUtilities.bytesToInt(buf, 24);
                int nameLen = cMsgUtilities.bytesToInt(buf, 28);
                int expidLen = cMsgUtilities.bytesToInt(buf, 32);
                int pos = 36;
                String multicasterName = null;
                try {
                    multicasterName = new String(buf, pos, nameLen, "US-ASCII");
                    pos += nameLen;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                String multicasterExpid = null;
                try {
                    multicasterExpid = new String(buf, pos, expidLen, "US-ASCII");
                    pos += expidLen;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (this.debug >= 4) {
                    System.out.println("RC multicast listener: multicaster's host = " + multicasterHost + ", UDP port = " + multicasterUdpPort + ", TCP port = " + multicasterTcpPort + ", name = " + multicasterName + ", expid = " + multicasterExpid + ", this server udp = " + this.server.udpPort + ", is local host = " + cMsgUtilities.isHostLocal(multicasterHost) + ", version = " + version + ", id # = " + senderId);
                }
                if (!this.server.expid.equalsIgnoreCase(multicasterExpid) && msgType != 16) {
                    if (this.debug < 4) continue;
                    System.out.println("RC multicast listener: conflicting EXPID's, ignoring");
                    continue;
                }
                if (msgType == 4 && multicasterUdpPort == this.server.localTempPort) continue;
                int packetCounter = 1;
                if (msgType == 16) {
                    try {
                        sendPacket = new DatagramPacket(outBuf, outBuf.length, multicasterAddress, multicasterUdpPort);
                        this.multicastSocket.send(sendPacket);
                    }
                    catch (IOException e2) {
                        System.out.println("I/O Error: " + e2);
                    }
                    continue;
                }
                if (msgType == 2) {
                    listLen = cMsgUtilities.bytesToInt(buf, pos);
                    pos += 4;
                    ipList = new ArrayList<String>(listLen);
                    broadList = new ArrayList<String>(listLen);
                } else {
                    if (this.debug >= 4) {
                        System.out.println("RC multicast listener: another RC multicast server probing this one");
                    }
                    if (!this.server.acceptingClients) {
                        this.server.respondingHost = multicasterHost;
                        this.server.multicastResponse.countDown();
                        return;
                    }
                    cMsgUtilities.intToBytes(cMsgNetworkConstants.magicNumbers[0], buf, 0);
                    cMsgUtilities.intToBytes(cMsgNetworkConstants.magicNumbers[1], buf, 4);
                    cMsgUtilities.intToBytes(cMsgNetworkConstants.magicNumbers[2], buf, 8);
                    cMsgUtilities.intToBytes(5, buf, 12);
                    cMsgUtilities.intToBytes(8, buf, 16);
                    DatagramPacket pkt = new DatagramPacket(buf, 16, multicasterAddress, this.server.udpPort);
                    this.multicastSocket.send(pkt);
                    continue;
                }
                for (int i = 0; i < listLen; ++i) {
                    try {
                        int stringLen = cMsgUtilities.bytesToInt(buf, pos);
                        String ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                        ipList.add(ss);
                        pos += stringLen;
                        stringLen = cMsgUtilities.bytesToInt(buf, pos);
                        ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                        broadList.add(ss);
                        pos += stringLen;
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                packetCounter = cMsgUtilities.bytesToInt(buf, pos);
                System.out.println("RC multicast listener: got client packet #" + packetCounter);
                if (!this.server.acceptingClients || !this.server.hasSubscription || !this.server.isReceiving()) continue;
                if (this.debug >= 4) {
                    System.out.println("RC multicast listener: client " + multicasterName + " is now connected");
                }
                cMsgMessageFull msg = new cMsgMessageFull();
                msg.setSenderHost(multicasterHost);
                msg.setUserInt(multicasterTcpPort);
                msg.setSender(multicasterName);
                msg.setDomain(this.domainType);
                msg.setReceiver(this.server.getName());
                msg.setReceiverHost(this.server.getHost());
                msg.setReceiverTime(new Date());
                if (ipList.size() > 0) {
                    try {
                        String[] ips2 = new String[ipList.size()];
                        ipList.toArray(ips2);
                        cMsgPayloadItem pItem2 = new cMsgPayloadItem("IpAddresses", ips2);
                        msg.addPayloadItem(pItem2);
                    }
                    catch (cMsgException ips2) {
                        // empty catch block
                    }
                }
                if (broadList.size() > 0) {
                    try {
                        String[] ips3 = new String[broadList.size()];
                        broadList.toArray(ips3);
                        cMsgPayloadItem pItem3 = new cMsgPayloadItem("BroadcastAddresses", ips3);
                        msg.addPayloadItem(pItem3);
                    }
                    catch (cMsgException ips3) {
                        // empty catch block
                    }
                }
                try {
                    cMsgPayloadItem pItem4 = new cMsgPayloadItem("SenderId", senderId);
                    msg.addPayloadItem(pItem4);
                }
                catch (cMsgException pItem4) {
                    // empty catch block
                }
                try {
                    cMsgPayloadItem pItem = new cMsgPayloadItem("packetCount", packetCounter);
                    msg.addPayloadItem(pItem);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                this.runCallbacks(msg);
                continue;
                break;
            }
        }
        catch (IOException e3) {
            if (this.debug < 2) return;
            System.out.println("rcMulticastListenThread: I/O ERROR in rc multicast server");
            System.out.println("rcMulticastListenThread: close multicast socket, port = " + this.multicastSocket.getLocalPort());
            return;
        }
        finally {
            if (!this.multicastSocket.isClosed()) {
                this.multicastSocket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallbacks(cMsgMessageFull msg) {
        Set<cMsgSubscription> set;
        Set<cMsgSubscription> set2 = set = this.server.subscriptions;
        synchronized (set2) {
            if (set.size() > 0) {
                if (!this.server.isReceiving()) {
                    if (this.debug >= 4) {
                        System.out.println("runCallbacks: all subscription callbacks have been stopped");
                    }
                    return;
                }
                for (cMsgSubscription sub : set) {
                    for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                        cbThread.sendMessage(msg);
                    }
                }
            }
        }
    }
}

