/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.remoteExec;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class ExecutorInfo {
    private String name;
    private String host;
    private String os;
    private String machine;
    private String processor;
    private String release;
    private ConcurrentHashMap<Integer, Integer> processAndThreadMap = new ConcurrentHashMap(30);

    public ExecutorInfo(String name, String host, String os, String machine, String processor, String release) {
        this.name = name;
        this.host = host;
        this.os = os;
        this.machine = machine;
        this.release = release;
        this.processor = processor;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getOS() {
        return this.os;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getOSRelease() {
        return this.release;
    }

    void addCommanderId(int commanderId, int executorId) {
        if (this.processAndThreadMap.containsKey(commanderId)) {
            System.out.println("addCommanderId: already have commanderId = " + commanderId + " in hashmap");
        }
        this.processAndThreadMap.put(commanderId, executorId);
    }

    Integer removeCommanderId(int commanderId) {
        return this.processAndThreadMap.remove(commanderId);
    }

    Integer getExecutorId(int commanderId) {
        return this.processAndThreadMap.get(commanderId);
    }

    Collection<Integer> getCommanderIds() {
        return this.processAndThreadMap.keySet();
    }

    void clearIds() {
        this.processAndThreadMap.clear();
    }
}

