/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.remoteExec;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.remoteExec.CallbackState;
import org.jlab.coda.cMsg.remoteExec.CommandCallback;
import org.jlab.coda.cMsg.remoteExec.CommandReturn;
import org.jlab.coda.cMsg.remoteExec.CommandType;
import org.jlab.coda.cMsg.remoteExec.ConstructorInfo;
import org.jlab.coda.cMsg.remoteExec.ExecutorInfo;
import org.jlab.coda.cMsg.remoteExec.ExecutorSecurity;
import org.jlab.coda.cMsg.remoteExec.InfoType;

public class Commander {
    static final String allSubjectType = ".all";
    static final String remoteExecSubjectType = "cMsgRemoteExec";
    private String udl;
    private String myName;
    private String description;
    private cMsg cmsgConnection;
    private String password;
    private int passwordLength;
    private AtomicInteger uniqueId = new AtomicInteger(1);
    private ConcurrentHashMap<String, ExecutorInfo> executors = new ConcurrentHashMap();
    private Map<Integer, CommandReturn> cmdReturns = Collections.synchronizedMap(new HashMap());

    public Commander(String udl, String name, String description, String password) throws cMsgException {
        if (password != null) {
            if (password.length() > 16) {
                throw new cMsgException("Password must be <= 16 characters");
            }
            this.password = ExecutorSecurity.encrypt(password);
            this.passwordLength = password.length();
        }
        this.connectToServer(udl, name, description);
        this.findExecutors(500);
    }

    public boolean reconnectToServer() throws cMsgException {
        if (this.cmsgConnection.isConnected()) {
            return false;
        }
        this.connectToServer(this.udl, this.myName, this.description);
        return true;
    }

    public void connectToServer(String udl, String name, String description) throws cMsgException {
        if (this.cmsgConnection != null && this.cmsgConnection.isConnected()) {
            try {
                this.cmsgConnection.disconnect();
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.cmsgConnection = new cMsg(udl, name, description);
        this.cmsgConnection.connect();
        this.cmsgConnection.start();
        this.udl = udl;
        this.myName = name;
        this.description = description;
        System.out.println("Subscribe to sub = " + InfoType.REPORTING.getValue() + ", typ = " + remoteExecSubjectType);
        this.cmsgConnection.subscribe(this.myName, remoteExecSubjectType, new CommandResponseCallback(), null);
        this.cmsgConnection.subscribe(allSubjectType, remoteExecSubjectType, new CommandResponseCallback(), null);
    }

    public void findExecutors(int milliseconds) throws cMsgException {
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        this.executors.clear();
        try {
            cMsgMessage msg = new cMsgMessage();
            msg.setHistoryLengthMax(0);
            msg.setSubject(remoteExecSubjectType);
            msg.setType(allSubjectType);
            if (this.password != null) {
                System.out.println("Sending password = " + this.password);
                cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
                cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
                msg.addPayloadItem(item0);
                msg.addPayloadItem(item1);
            }
            cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.IDENTIFY.getValue());
            cMsgPayloadItem item3 = new cMsgPayloadItem("commander", this.myName);
            msg.addPayloadItem(item2);
            msg.addPayloadItem(item3);
            this.cmsgConnection.send(msg);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Collection<ExecutorInfo> getExecutors() {
        return this.executors.values();
    }

    public void kill(ExecutorInfo exec, boolean killProcesses) throws cMsgException {
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        Collection<Integer> commanderIds = exec.getCommanderIds();
        for (Integer id : commanderIds) {
            CommandReturn cmdRet = this.cmdReturns.remove(id);
            if (cmdRet == null) continue;
            cmdRet.setCallbackState(CallbackState.KILLED);
        }
        exec.clearIds();
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(exec.getName());
        if (this.password != null) {
            cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
            cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
            msg.addPayloadItem(item0);
            msg.addPayloadItem(item1);
        }
        cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.DIE.getValue());
        cMsgPayloadItem item3 = new cMsgPayloadItem("killProcesses", killProcesses ? 1 : 0);
        msg.addPayloadItem(item2);
        msg.addPayloadItem(item3);
        this.cmsgConnection.send(msg);
    }

    public void killAll(boolean killProcesses) throws cMsgException {
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        for (ExecutorInfo exec : this.executors.values()) {
            Collection<Integer> commanderIds = exec.getCommanderIds();
            for (Integer id : commanderIds) {
                CommandReturn cmdRet = this.cmdReturns.remove(id);
                if (cmdRet == null) continue;
                cmdRet.setCallbackState(CallbackState.KILLED);
            }
            exec.clearIds();
        }
        this.cmdReturns.clear();
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(allSubjectType);
        if (this.password != null) {
            cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
            cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
            msg.addPayloadItem(item0);
            msg.addPayloadItem(item1);
        }
        cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.DIE.getValue());
        cMsgPayloadItem item3 = new cMsgPayloadItem("killProcesses", killProcesses ? 1 : 0);
        msg.addPayloadItem(item2);
        msg.addPayloadItem(item3);
        this.cmsgConnection.send(msg);
    }

    public void stop(ExecutorInfo exec, CommandReturn commandReturn) throws cMsgException {
        this.stop(exec, commandReturn.getId());
    }

    public void stop(ExecutorInfo exec, int commandId) throws cMsgException {
        Integer execId;
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        CommandReturn cmdRet = this.cmdReturns.remove(commandId);
        if (cmdRet != null) {
            System.out.println("set to stopped in stop");
            cmdRet.setCallbackState(CallbackState.STOPPED);
        }
        if ((execId = exec.removeCommanderId(commandId)) == null) {
            return;
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(exec.getName());
        if (this.password != null) {
            cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
            cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
            msg.addPayloadItem(item0);
            msg.addPayloadItem(item1);
        }
        cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.STOP.getValue());
        cMsgPayloadItem item3 = new cMsgPayloadItem("id", execId);
        msg.addPayloadItem(item2);
        msg.addPayloadItem(item3);
        this.cmsgConnection.send(msg);
    }

    public void stopAll(ExecutorInfo exec) throws cMsgException {
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        Collection<Integer> commanderIds = exec.getCommanderIds();
        for (Integer id : commanderIds) {
            CommandReturn cmdRet = this.cmdReturns.remove(id);
            if (cmdRet == null) continue;
            cmdRet.setCallbackState(CallbackState.STOPPED);
        }
        exec.clearIds();
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(exec.getName());
        if (this.password != null) {
            cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
            cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
            msg.addPayloadItem(item0);
            msg.addPayloadItem(item1);
        }
        cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.STOP_ALL.getValue());
        msg.addPayloadItem(item2);
        this.cmsgConnection.send(msg);
    }

    public void stopAll() throws cMsgException {
        if (!this.cmsgConnection.isConnected()) {
            throw new cMsgException("not connect to cMsg server");
        }
        for (ExecutorInfo exec : this.executors.values()) {
            Collection<Integer> commanderIds = exec.getCommanderIds();
            for (Integer id : commanderIds) {
                CommandReturn cmdRet = this.cmdReturns.remove(id);
                if (cmdRet == null) continue;
                cmdRet.setCallbackState(CallbackState.STOPPED);
            }
            exec.clearIds();
        }
        this.cmdReturns.clear();
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(allSubjectType);
        if (this.password != null) {
            cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
            cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
            msg.addPayloadItem(item0);
            msg.addPayloadItem(item1);
        }
        cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.STOP_ALL.getValue());
        msg.addPayloadItem(item2);
        this.cmsgConnection.send(msg);
    }

    public void cancelCallback(CommandReturn commandReturn) {
        this.cmdReturns.remove(commandReturn.getId());
        commandReturn.unregisterCallback();
    }

    public CommandReturn startProcess(ExecutorInfo exec, String cmd, boolean monitor, CommandCallback callback, Object userObject) throws cMsgException {
        try {
            return this.startProcess(exec, cmd, monitor, false, callback, userObject, 2000);
        }
        catch (TimeoutException e) {
            throw new cMsgException(e);
        }
    }

    public CommandReturn startProcess(ExecutorInfo exec, String cmd, boolean monitor, int timeout) throws cMsgException, TimeoutException {
        return this.startProcess(exec, cmd, monitor, true, null, null, timeout);
    }

    CommandReturn startProcess(ExecutorInfo exec, String cmd, boolean monitor, boolean wait, CommandCallback callback, Object userObject, int timeout) throws cMsgException, TimeoutException {
        if (exec == null || cmd == null) {
            throw new cMsgException("argument(s) is(are) null");
        }
        int myId = this.uniqueId.incrementAndGet();
        CommandReturn cmdRet = new CommandReturn(this, exec, CallbackState.NONE);
        if (callback != null) {
            cmdRet.registerCallback(callback, userObject);
            cmdRet.setCallbackState(CallbackState.PENDING);
            this.cmdReturns.put(myId, cmdRet);
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(exec.getName());
        try {
            if (this.password != null) {
                cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
                cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
                msg.addPayloadItem(item0);
                msg.addPayloadItem(item1);
            }
            cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.START_PROCESS.getValue());
            msg.addPayloadItem(item2);
            cMsgPayloadItem item3 = new cMsgPayloadItem("command", ExecutorSecurity.encrypt(cmd));
            msg.addPayloadItem(item3);
            cMsgPayloadItem item4 = new cMsgPayloadItem("commandLen", cmd.length());
            msg.addPayloadItem(item4);
            cMsgPayloadItem item5 = new cMsgPayloadItem("monitor", monitor ? 1 : 0);
            msg.addPayloadItem(item5);
            cMsgPayloadItem item6 = new cMsgPayloadItem("wait", wait ? 1 : 0);
            msg.addPayloadItem(item6);
            cMsgPayloadItem item7 = new cMsgPayloadItem("commander", this.myName);
            msg.addPayloadItem(item7);
            cMsgPayloadItem item8 = new cMsgPayloadItem("id", myId);
            msg.addPayloadItem(item8);
        }
        catch (cMsgException item2) {
            // empty catch block
        }
        cMsgMessage returnMsg = this.cmsgConnection.sendAndGet(msg, timeout);
        if (returnMsg.hasPayload()) {
            String err = null;
            cMsgPayloadItem item = returnMsg.getPayloadItem("error");
            if (item != null) {
                err = item.getString();
            }
            if (err != null) {
                boolean immediateError = false;
                item = returnMsg.getPayloadItem("immediateError");
                if (item != null) {
                    boolean bl = immediateError = item.getInt() != 0;
                }
                if (immediateError && cmdRet.getCallbackState() == CallbackState.PENDING) {
                    cmdRet.setCallbackState(CallbackState.ERROR);
                }
            }
            boolean terminated = false;
            item = returnMsg.getPayloadItem("terminated");
            if (item != null) {
                terminated = item.getInt() != 0;
            }
            int processId = 0;
            if (!terminated) {
                item = returnMsg.getPayloadItem("id");
                if (item == null) {
                    throw new cMsgException("startProcess: internal protocol error 1");
                }
                processId = item.getInt();
                exec.addCommanderId(myId, processId);
            } else {
                boolean killed = false;
                item = returnMsg.getPayloadItem("killed");
                if (item != null) {
                    killed = item.getInt() != 0;
                    System.out.println("startProcess: Executor set to killed");
                    cmdRet.setCallbackState(CallbackState.KILLED);
                }
                if (!killed && (item = returnMsg.getPayloadItem("stopped")) != null) {
                    System.out.println("startProcess: Executor set to stopped");
                    cmdRet.setCallbackState(CallbackState.STOPPED);
                }
            }
            String output = null;
            if (monitor && (item = returnMsg.getPayloadItem("output")) != null) {
                output = item.getString();
            }
            cmdRet.setValues(myId, processId, err != null, terminated, output, err);
            return cmdRet;
        }
        throw new cMsgException("startProcess: internal protocol error 2");
    }

    CommandReturn startThread(ExecutorInfo exec, String className, CommandCallback callback, Object userObject, ConstructorInfo constructorArgs) throws cMsgException {
        try {
            return this.startThread(exec, className, false, callback, userObject, 2000, constructorArgs);
        }
        catch (TimeoutException e) {
            throw new cMsgException(e);
        }
    }

    public CommandReturn startThread(ExecutorInfo exec, String className, int timeout, ConstructorInfo constructorArgs) throws cMsgException, TimeoutException {
        return this.startThread(exec, className, true, null, null, timeout, constructorArgs);
    }

    CommandReturn startThread(ExecutorInfo exec, String className, boolean wait, CommandCallback callback, Object userObject, int timeout, ConstructorInfo constructorArgs) throws cMsgException, TimeoutException {
        if (exec == null || className == null) {
            throw new cMsgException("argument(s) is(are) null");
        }
        int myId = this.uniqueId.incrementAndGet();
        CommandReturn cmdRet = new CommandReturn(this, exec, CallbackState.NONE);
        if (callback != null) {
            cmdRet.registerCallback(callback, userObject);
            cmdRet.setCallbackState(CallbackState.PENDING);
            this.cmdReturns.put(myId, cmdRet);
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setHistoryLengthMax(0);
        msg.setSubject(remoteExecSubjectType);
        msg.setType(exec.getName());
        try {
            if (this.password != null) {
                cMsgPayloadItem item0 = new cMsgPayloadItem("p", this.password);
                cMsgPayloadItem item1 = new cMsgPayloadItem("pl", this.passwordLength);
                msg.addPayloadItem(item0);
                msg.addPayloadItem(item1);
            }
            cMsgPayloadItem item2 = new cMsgPayloadItem("commandType", CommandType.START_THREAD.getValue());
            msg.addPayloadItem(item2);
            cMsgPayloadItem item3 = new cMsgPayloadItem("className", ExecutorSecurity.encrypt(className));
            msg.addPayloadItem(item3);
            cMsgPayloadItem item4 = new cMsgPayloadItem("classNameLen", className.length());
            msg.addPayloadItem(item4);
            cMsgPayloadItem item5 = new cMsgPayloadItem("wait", wait ? 1 : 0);
            msg.addPayloadItem(item5);
            cMsgPayloadItem item6 = new cMsgPayloadItem("commander", this.myName);
            msg.addPayloadItem(item6);
            cMsgPayloadItem item7 = new cMsgPayloadItem("id", myId);
            msg.addPayloadItem(item7);
            if (constructorArgs != null) {
                cMsgPayloadItem item8 = new cMsgPayloadItem("args", constructorArgs.createMessageFromArgs());
                msg.addPayloadItem(item8);
            }
        }
        catch (cMsgException item2) {
            // empty catch block
        }
        cMsgMessage returnMsg = this.cmsgConnection.sendAndGet(msg, timeout);
        if (returnMsg.hasPayload()) {
            cMsgPayloadItem item = msg.getPayloadItem("error");
            if (item != null) {
                String err = item.getString();
                if (cmdRet.getCallbackState() == CallbackState.PENDING) {
                    cmdRet.setCallbackState(CallbackState.ERROR);
                }
                cmdRet.setValues(myId, 0, true, true, null, err);
                return cmdRet;
            }
            boolean terminated = false;
            item = returnMsg.getPayloadItem("terminated");
            if (item != null) {
                terminated = item.getInt() != 0;
            }
            int threadId = 0;
            if (!terminated) {
                item = returnMsg.getPayloadItem("id");
                if (item == null) {
                    throw new cMsgException("startThread: internal protocol error");
                }
                threadId = item.getInt();
                exec.addCommanderId(myId, threadId);
            } else {
                boolean killed = false;
                item = returnMsg.getPayloadItem("killed");
                if (item != null) {
                    killed = item.getInt() != 0;
                    cmdRet.setCallbackState(CallbackState.KILLED);
                }
                if (!killed && (item = returnMsg.getPayloadItem("stopped")) != null) {
                    cmdRet.setCallbackState(CallbackState.STOPPED);
                }
            }
            cmdRet.setValues(myId, threadId, false, false, null, null);
            return cmdRet;
        }
        throw new cMsgException("startThread: internal protocol error");
    }

    private static String inputStr(String s) {
        String aLine = "";
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(s);
        System.out.flush();
        try {
            aLine = input.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aLine;
    }

    private static String[] decodeCommandLine(String[] args) {
        String[] stuff = new String[3];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-n")) {
                stuff[1] = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                stuff[0] = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-p")) continue;
            stuff[2] = args[i + 1];
            ++i;
        }
        return stuff;
    }

    public static List<String> xtermGeometry(int count, int widthChars, int heightChars) {
        Rectangle rec = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int xInit = 0;
        int yInit = 25;
        int screenWidth = rec.width - xInit;
        int screenHeight = rec.height - yInit;
        int xtermHeight = 27 + 14 * heightChars;
        int xtermWidth = 30 + 6 * widthChars;
        int startX = xInit;
        int startY = yInit;
        boolean stillRoomY = true;
        boolean stillRoomX = true;
        String geoSize = widthChars + "x" + heightChars;
        ArrayList<String> geoList = new ArrayList<String>(count);
        while (stillRoomY || stillRoomX) {
            String geo = geoSize + "+" + startX + "+" + startY;
            geoList.add(geo);
            startY += xtermHeight;
            if (--count < 1) break;
            if (startY > screenHeight - xtermHeight) {
                stillRoomY = false;
            }
            if (startX > screenWidth - xtermWidth) {
                stillRoomX = false;
            }
            if (!stillRoomX || stillRoomY) continue;
            if ((startX += xtermWidth) > screenWidth - xtermWidth) {
                stillRoomX = false;
                continue;
            }
            startY = yInit;
            stillRoomY = true;
        }
        return geoList;
    }

    public CommandReturn startXterm(ExecutorInfo exec, String cmd, String geometry, String title) throws cMsgException {
        Pattern pattern;
        Matcher matcher;
        if (cmd != null && (matcher = (pattern = Pattern.compile("[\\s]+")).matcher(cmd)).find()) {
            throw new cMsgException("No white space allowed in command");
        }
        String realCmd = "xterm -sb";
        if (geometry != null) {
            realCmd = realCmd + " -geometry " + geometry;
        }
        if (title != null) {
            realCmd = realCmd + " -T " + title;
        }
        if (cmd != null && cmd.length() > 0) {
            realCmd = realCmd + " -hold -e " + cmd + ";bash";
        }
        return this.startProcess(exec, realCmd, false, null, null);
    }

    public List<CommandReturn> startWindows(ExecutorInfo exec, String title, int count, int widthChars, int heightChars) throws cMsgException {
        List<String> geometries = Commander.xtermGeometry(count, widthChars, heightChars);
        ArrayList<CommandReturn> returnList = new ArrayList<CommandReturn>(geometries.size());
        for (String geo : geometries) {
            returnList.add(this.startXterm(exec, null, geo, title));
        }
        return returnList;
    }

    public List<CommandReturn> startCommandInWindows(List<ExecutorInfo> executors, String command, int widthChars, int heightChars) throws cMsgException {
        List<String> geometries = Commander.xtermGeometry(executors.size(), widthChars, heightChars);
        ArrayList<CommandReturn> returnList = new ArrayList<CommandReturn>(executors.size());
        for (int i = 0; i < executors.size(); ++i) {
            returnList.add(this.startXterm(executors.get(i), command, geometries.get(i), executors.get(i).getName()));
        }
        return returnList;
    }

    public List<CommandReturn> startCommandsInWindows(List<ExecutorInfo> executors, List<String> commands, int widthChars, int heightChars) throws cMsgException {
        List<String> geometries = Commander.xtermGeometry(executors.size(), widthChars, heightChars);
        ArrayList<CommandReturn> returnList = new ArrayList<CommandReturn>(executors.size());
        for (int i = 0; i < executors.size(); ++i) {
            returnList.add(this.startXterm(executors.get(i), commands.get(i), geometries.get(i), executors.get(i).getName()));
        }
        return returnList;
    }

    public static void main0(String[] args) {
        try {
            String[] arggs = Commander.decodeCommandLine(args);
            System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
            Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
            Collection<ExecutorInfo> execList = cmdr.getExecutors();
            for (ExecutorInfo info : execList) {
                System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
            }
            if (execList.size() > 0) {
                cmdr.startCommandInWindows(new ArrayList<ExecutorInfo>(execList), "ls", 85, 8);
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main1(String[] args) {
        try {
            String[] arggs = Commander.decodeCommandLine(args);
            System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
            Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
            Collection<ExecutorInfo> execList = cmdr.getExecutors();
            for (ExecutorInfo info : execList) {
                System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
            }
            if (execList.size() > 0) {
                ArrayList<ExecutorInfo> list = new ArrayList<ExecutorInfo>(execList);
                List<CommandReturn> retList = cmdr.startWindows(list.get(0), list.get(0).getName(), 20, 85, 8);
                for (CommandReturn ret : retList) {
                    ret.stop();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main2(String[] args) {
        block5: {
            try {
                String[] arggs = Commander.decodeCommandLine(args);
                System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
                Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
                Collection<ExecutorInfo> execList = cmdr.getExecutors();
                for (ExecutorInfo info : execList) {
                    System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
                }
                if (execList.size() <= 0) break block5;
                ConstructorInfo exThrCon = new ConstructorInfo();
                ConstructorInfo recCon = new ConstructorInfo();
                ConstructorInfo dimCon = new ConstructorInfo();
                dimCon.addPrimitiveArg("int", "1");
                dimCon.addPrimitiveArg("int", "2");
                recCon.addReferenceArg("java.awt.Dimension", dimCon);
                exThrCon.addReferenceArg("java.awt.Rectangle", recCon);
                ArrayList<ExecutorInfo> list = new ArrayList<ExecutorInfo>(execList);
                class MyCB
                implements CommandCallback {
                    MyCB() {
                    }

                    @Override
                    public void callback(Object userObject, CommandReturn commandReturn) {
                        System.out.println("Callback was run");
                    }
                }
                CommandReturn ret = cmdr.startThread(list.get(0), "org.jlab.coda.cMsg.remoteExec.ExampleThread", new MyCB(), null, exThrCon);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cmdr.stop(list.get(0), ret);
            }
            catch (cMsgException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static void main3(String[] args) {
        block6: {
            try {
                String[] arggs = Commander.decodeCommandLine(args);
                System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
                Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
                Collection<ExecutorInfo> execList = cmdr.getExecutors();
                for (ExecutorInfo info : execList) {
                    System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
                }
                if (execList.size() <= 0) break block6;
                ConstructorInfo serverCon = new ConstructorInfo();
                serverCon.addPrimitiveArg("int", "47000");
                serverCon.addPrimitiveArg("int", "47001");
                serverCon.addPrimitiveArg("int", "47000");
                serverCon.addPrimitiveArg("boolean", "true");
                serverCon.addPrimitiveArg("boolean", "true");
                serverCon.addReferenceArg("java.lang.String", null);
                serverCon.addReferenceArg("java.lang.String", null);
                serverCon.addReferenceArg("java.lang.String", null);
                serverCon.addPrimitiveArg("int", "4");
                serverCon.addPrimitiveArg("int", "10");
                ArrayList<ExecutorInfo> list = new ArrayList<ExecutorInfo>(execList);
                class MyCB
                implements CommandCallback {
                    MyCB() {
                    }

                    @Override
                    public void callback(Object userObject, CommandReturn commandReturn) {
                        System.out.println("Callback was run");
                    }
                }
                CommandReturn ret = cmdr.startThread(list.get(0), "org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer", new MyCB(), null, serverCon);
                if (ret.callbackCancelled()) {
                    System.out.println("Error: " + ret.getError());
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ret.stop();
            }
            catch (cMsgException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static void main4(String[] args) {
        block7: {
            boolean killAtOnce = true;
            try {
                String[] arggs = Commander.decodeCommandLine(args);
                System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
                Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
                Collection<ExecutorInfo> execList = cmdr.getExecutors();
                for (ExecutorInfo info : execList) {
                    System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
                }
                if (!killAtOnce) {
                    for (ExecutorInfo info : execList) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.println("Killing Executor " + info.getName());
                        cmdr.kill(info, true);
                    }
                    break block7;
                }
                System.out.println("Killing all Executors at once");
                cmdr.killAll(true);
            }
            catch (cMsgException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String[] arggs = Commander.decodeCommandLine(args);
            System.out.println("Starting Commander with:\n  name = " + arggs[1] + "\n  udl = " + arggs[0]);
            Commander cmdr = new Commander(arggs[0], arggs[1], "commander", arggs[2]);
            Collection<ExecutorInfo> execList = cmdr.getExecutors();
            for (ExecutorInfo info : execList) {
                System.out.println("Found executor: name = " + info.getName() + " running on " + info.getOS());
            }
            while (true) {
                CommandReturn ret;
                ExecutorInfo info;
                String in = Commander.inputStr("% ");
                try {
                    cmdr.findExecutors(500);
                    execList = cmdr.getExecutors();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                class MyCB
                implements CommandCallback {
                    MyCB() {
                    }

                    @Override
                    public void callback(Object userObject, CommandReturn ret) {
                        System.out.println("In callback:");
                        if (ret.hasError()) {
                            System.out.println("  Error = " + ret.getError());
                        }
                        if (ret.getOutput() != null) {
                            System.out.println("  Output =");
                            System.out.println(ret.getOutput());
                        }
                    }
                }
                if (execList.size() > 0 && (ret = cmdr.startProcess(info = new ArrayList<ExecutorInfo>(execList).get(0), in, true, new MyCB(), null)).callbackCancelled() && ret.hasError()) {
                    System.out.println("Error: " + ret.getError());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    private class CommandResponseCallback
    extends cMsgCallbackAdapter {
        private CommandResponseCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (msg.hasPayload()) {
                try {
                    cMsgPayloadItem item = msg.getPayloadItem("returnType");
                    String returnType = null;
                    if (item != null && (returnType = item.getString()) == null) {
                        System.out.println("Reject message, bad format");
                        return;
                    }
                    InfoType type = InfoType.getInfoType(returnType);
                    if (type == null) {
                        System.out.println("Reject message, return type not recognized");
                        return;
                    }
                    switch (type) {
                        case THREAD_END: 
                        case PROCESS_END: {
                            System.out.println("Received msg --------> thread/process ended");
                            item = msg.getPayloadItem("id");
                            if (item == null) {
                                System.out.println("Reject message, no commander id");
                                return;
                            }
                            int id = item.getInt();
                            for (ExecutorInfo exec : Commander.this.executors.values()) {
                                exec.removeCommanderId(id);
                            }
                            CommandReturn cmdRet = (CommandReturn)Commander.this.cmdReturns.remove(id);
                            if (cmdRet == null) break;
                            cmdRet.lock();
                            item = msg.getPayloadItem("error");
                            if (item != null) {
                                cmdRet.setError(item.getString());
                            }
                            if ((item = msg.getPayloadItem("output")) != null) {
                                cmdRet.setOutput(item.getString());
                            }
                            if ((item = msg.getPayloadItem("stopped")) != null) {
                                System.out.println("send msg set to stopped, caught in callback");
                                cmdRet.setCallbackStateIfLocked(CallbackState.STOPPED);
                            }
                            if ((item = msg.getPayloadItem("killed")) != null) {
                                System.out.println("send msg set to killed, caught in callback");
                                cmdRet.setCallbackStateIfLocked(CallbackState.KILLED);
                            }
                            if (cmdRet.getCallbackState() != CallbackState.PENDING) {
                                System.out.println("Reject message, callback not pending");
                                return;
                            }
                            cmdRet.hasTerminated(true);
                            cmdRet.executeCallback();
                            break;
                        }
                        case REPORTING: {
                            String name = null;
                            String os = null;
                            String machine = null;
                            String release = null;
                            String processor = null;
                            String host = null;
                            item = msg.getPayloadItem("name");
                            if (item != null && (name = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            item = msg.getPayloadItem("host");
                            if (item != null && (host = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            item = msg.getPayloadItem("os");
                            if (item != null && (os = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            item = msg.getPayloadItem("machine");
                            if (item != null && (machine = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            item = msg.getPayloadItem("processor");
                            if (item != null && (processor = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            item = msg.getPayloadItem("release");
                            if (item != null && (release = item.getString()) == null) {
                                System.out.println("Reject message, bad format");
                                return;
                            }
                            ExecutorInfo eInfo = new ExecutorInfo(name, host, os, machine, processor, release);
                            Commander.this.executors.put(name, eInfo);
                        }
                    }
                }
                catch (cMsgException e) {
                    System.out.println("Reject message, bad format");
                }
            } else {
                System.out.println("Reject message, no payload");
            }
        }
    }
}

