/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgMessageContextInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class cMsgMessageFull
extends cMsgMessage
implements Serializable {
    public cMsgMessageFull() {
    }

    public static cMsgMessageFull createDeliverableMessage() {
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.sender = "";
        msg.senderHost = "";
        msg.subject = "";
        msg.type = "";
        msg.payloadText = "";
        msg.text = "";
        return msg;
    }

    public cMsgMessageFull(cMsgMessage m) {
        this.setVersion(m.getVersion());
        this.setDomain(m.getDomain());
        this.setSysMsgId(m.getSysMsgId());
        this.setInfo(m.getInfo());
        this.setPayloadText(m.getPayloadText());
        this.setSender(m.getSender());
        this.setSenderHost(m.getSenderHost());
        this.setSenderTime(m.getSenderTime());
        this.setSenderToken(m.getSenderToken());
        this.setUserInt(m.getUserInt());
        this.setUserTime(m.getUserTime());
        this.setReceiver(m.getReceiver());
        this.setReceiverHost(m.getReceiverHost());
        this.setReceiverTime(m.getReceiverTime());
        this.setSubject(m.getSubject());
        this.setType(m.getType());
        this.setText(m.getText());
    }

    public cMsgMessageFull(String XML) throws cMsgException {
        if (XML == null) {
            cMsgException ce = new cMsgException("Null input string");
            ce.setReturnCode(1);
            throw ce;
        }
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setIgnoringComments(true);
        f.setCoalescing(true);
        f.setValidating(false);
        try {
            DocumentBuilder p = f.newDocumentBuilder();
            Document d = p.parse(new ByteArrayInputStream(XML.getBytes()));
            Element e = d.getDocumentElement();
            cMsgMessageFull.fillMsgFromElement(this, e);
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    public cMsgMessageFull(File file) throws cMsgException {
        if (file == null) {
            cMsgException ce = new cMsgException("Null argument");
            ce.setReturnCode(1);
            throw ce;
        }
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setIgnoringComments(true);
        f.setCoalescing(true);
        f.setValidating(false);
        try {
            DocumentBuilder p = f.newDocumentBuilder();
            Document d = p.parse(file);
            Element e = d.getDocumentElement();
            cMsgMessageFull.fillMsgFromElement(this, e);
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    public static cMsgMessage parseXml(String XML) throws cMsgException {
        cMsgMessageFull msg = new cMsgMessageFull();
        ByteArrayInputStream stream = new ByteArrayInputStream(XML.getBytes());
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setIgnoringComments(true);
        f.setCoalescing(true);
        f.setValidating(false);
        try {
            DocumentBuilder p = f.newDocumentBuilder();
            Document d = p.parse(new ByteArrayInputStream(XML.getBytes()));
            Element e = d.getDocumentElement();
            cMsgMessageFull.fillMsgFromElement(msg, e);
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            cMsgException ce = new cMsgException(ex.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        return msg;
    }

    private static void printNode(Node node, String indent) {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                cMsgMessageFull.printNode(doc.getDocumentElement(), "");
                break;
            }
            case 1: {
                String name = node.getNodeName();
                System.out.print(indent + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    System.out.print(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                System.out.println(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        cMsgMessageFull.printNode(children.item(i), indent + "  ");
                    }
                }
                System.out.println(indent + "</" + name + ">");
                break;
            }
            case 3: 
            case 4: {
                System.out.println(node.getNodeValue());
            }
        }
    }

    private static String[] splitArray(String s, int size) {
        String[] sArray = new String[size];
        s = s.trim().replace('\n', ' ');
        for (int i = 0; i < size; ++i) {
            int length = s.length();
            int endIndex = s.indexOf(" ");
            if (endIndex < 0 && (endIndex = s.indexOf("\n")) < 0) {
                endIndex = length;
            }
            sArray[i] = s.substring(0, endIndex);
            s = s.substring(endIndex, length).trim();
        }
        return sArray;
    }

    private static void fillMsgFromElement(cMsgMessageFull msg, Element e) {
        int numElements;
        NodeList nList;
        try {
            msg.setUserTime(dateFormatter.parse(e.getAttribute("userTime")));
            msg.setSenderTime(dateFormatter.parse(e.getAttribute("senderTime")));
            msg.setReceiverTime(dateFormatter.parse(e.getAttribute("receiverTime")));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String s = e.getAttribute("version");
        if (s.length() > 0) {
            msg.setVersion(Integer.parseInt(s));
        }
        if ((s = e.getAttribute("userInt")).length() > 0) {
            msg.setUserInt(Integer.parseInt(s));
        }
        if ((s = e.getAttribute("getRequest")).length() > 0) {
            msg.setGetRequest(Boolean.parseBoolean(s));
        }
        if ((s = e.getAttribute("nullGetResponse")).length() > 0) {
            msg.setNullGetResponse(Boolean.parseBoolean(s));
        }
        if ((s = e.getAttribute("getResponse")).length() > 0) {
            msg.setGetResponse(Boolean.parseBoolean(s));
        }
        if ((s = e.getAttribute("domain")).length() > 0 && !s.equals("(null)")) {
            msg.setDomain(s);
        }
        if ((s = e.getAttribute("sender")).length() > 0 && !s.equals("(null)")) {
            msg.setSender(s);
        }
        if ((s = e.getAttribute("senderHost")).length() > 0 && !s.equals("(null)")) {
            msg.setSenderHost(s);
        }
        if ((s = e.getAttribute("receiver")).length() > 0 && !s.equals("(null)")) {
            msg.setReceiver(s);
        }
        if ((s = e.getAttribute("receiverHost")).length() > 0 && !s.equals("(null)")) {
            msg.setReceiverHost(s);
        }
        if ((s = e.getAttribute("subject")).length() > 0 && !s.equals("(null)")) {
            msg.setSubject(s);
        }
        if ((s = e.getAttribute("type")).length() > 0 && !s.equals("(null)")) {
            msg.setType(s);
        }
        if ((nList = e.getElementsByTagName("text")) != null && (numElements = nList.getLength()) > 0) {
            s = nList.item(0).getFirstChild().getNodeValue();
            msg.setText(s);
        }
        nList = e.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (!nList.item(i).getNodeName().equalsIgnoreCase("binary")) continue;
            Element el = (Element)nList.item(i);
            s = el.getFirstChild().getNodeValue();
            int itemBytes = Integer.parseInt(el.getAttribute("nbytes"));
            int itemEndian = el.getAttribute("endian").equals("big") ? 0 : 1;
            byte[] bytes = b64Decoder.decode(s);
            if (bytes.length != itemBytes) {
                System.out.println("Reconstituted binary array is different size !!!");
            }
            msg.setByteArrayNoCopy(bytes);
            try {
                msg.setByteArrayEndian(itemEndian);
            }
            catch (cMsgException cMsgException2) {}
            break;
        }
        if ((nList = e.getElementsByTagName("payload")) != null && (numElements = nList.getLength()) > 0) {
            cMsgMessageFull.fillPayloadFromElement(msg, nList.item(0));
        }
    }

    private static void fillPayloadFromElement(cMsgMessageFull msg, Node node) {
        int numElements;
        boolean debug = false;
        cMsgPayloadItem payloadItem = null;
        NodeList nList = node.getChildNodes();
        if (nList == null) {
            return;
        }
        int i = numElements = nList.getLength();
        while (i-- > 0) {
            if (nList.item(i).getNodeType() != 1) continue;
            Element el = (Element)nList.item(i);
            String itemType = el.getNodeName();
            String itemName = el.getAttribute("name");
            try {
                int itemBytes;
                int j;
                int bits;
                NodeList aList;
                String[] sArray;
                int itemCount;
                String itemValue;
                if (itemType.equals("string")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    payloadItem = new cMsgPayloadItem(itemName, itemValue);
                    if (debug) {
                        System.out.println("Payload string \"" + itemType + "\", value = " + itemValue);
                    }
                } else if (itemType.equals("string_array")) {
                    if (debug) {
                        System.out.println("Payload string array \"" + itemType + "\"");
                    }
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    int index = 0;
                    sArray = new String[itemCount];
                    aList = el.getChildNodes();
                    if (aList == null) continue;
                    for (int j2 = 0; j2 < aList.getLength(); ++j2) {
                        if (aList.item(j2).getNodeType() != 1) continue;
                        el = (Element)aList.item(j2);
                        itemValue = el.getFirstChild().getNodeValue();
                        sArray[index++] = itemValue;
                        if (!debug) continue;
                        System.out.println("  string = " + itemValue);
                    }
                    payloadItem = new cMsgPayloadItem(itemName, sArray);
                } else if ((itemType.startsWith("uint") || itemType.startsWith("int")) && itemType.endsWith("_array")) {
                    bits = Integer.parseInt(itemType.substring(itemType.indexOf("t") + 1, itemType.indexOf("_")));
                    if (itemType.startsWith("u")) {
                        bits *= 2;
                    }
                    itemValue = el.getFirstChild().getNodeValue();
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    sArray = cMsgMessageFull.splitArray(itemValue, itemCount);
                    if (debug) {
                        System.out.println("Payload int array \"" + itemType + "\", bits = " + bits);
                        for (int j3 = 0; j3 < itemCount; ++j3) {
                            System.out.println("  int" + bits + "[" + j3 + "] = " + sArray[j3]);
                        }
                    }
                    switch (bits) {
                        case 8: {
                            byte[] b = new byte[itemCount];
                            for (int j4 = 0; j4 < itemCount; ++j4) {
                                b[j4] = Byte.parseByte(sArray[j4]);
                            }
                            payloadItem = new cMsgPayloadItem(itemName, b);
                            break;
                        }
                        case 16: {
                            short[] s = new short[itemCount];
                            for (j = 0; j < itemCount; ++j) {
                                s[j] = Short.parseShort(sArray[j]);
                            }
                            payloadItem = new cMsgPayloadItem(itemName, s);
                            break;
                        }
                        case 32: {
                            int[] ii = new int[itemCount];
                            for (int j5 = 0; j5 < itemCount; ++j5) {
                                ii[j5] = Integer.parseInt(sArray[j5]);
                            }
                            payloadItem = new cMsgPayloadItem(itemName, ii);
                            break;
                        }
                        case 64: {
                            long[] l = new long[itemCount];
                            for (int j6 = 0; j6 < itemCount; ++j6) {
                                l[j6] = Long.parseLong(sArray[j6]);
                            }
                            payloadItem = new cMsgPayloadItem(itemName, l);
                            break;
                        }
                        case 128: {
                            BigInteger[] big = new BigInteger[itemCount];
                            for (int j7 = 0; j7 < itemCount; ++j7) {
                                big[j7] = new BigInteger(sArray[j7]);
                            }
                            payloadItem = new cMsgPayloadItem(itemName, big);
                            break;
                        }
                    }
                } else if (itemType.startsWith("uint") || itemType.startsWith("int")) {
                    bits = Integer.parseInt(itemType.substring(itemType.indexOf("t") + 1, itemType.length()));
                    if (itemType.startsWith("u")) {
                        bits *= 2;
                    }
                    itemValue = el.getFirstChild().getNodeValue().trim();
                    switch (bits) {
                        case 8: {
                            byte b = Byte.parseByte(itemValue);
                            payloadItem = new cMsgPayloadItem(itemName, b);
                            break;
                        }
                        case 16: {
                            short s = Short.parseShort(itemValue);
                            payloadItem = new cMsgPayloadItem(itemName, s);
                            break;
                        }
                        case 32: {
                            int ii = Integer.parseInt(itemValue);
                            payloadItem = new cMsgPayloadItem(itemName, ii);
                            break;
                        }
                        case 64: {
                            long l = Long.parseLong(itemValue);
                            payloadItem = new cMsgPayloadItem(itemName, l);
                            break;
                        }
                        case 128: {
                            BigInteger big = new BigInteger(itemValue);
                            payloadItem = new cMsgPayloadItem(itemName, big);
                            break;
                        }
                    }
                    if (debug) {
                        System.out.println("Payload int \"" + itemType + "\", bits = " + bits + ", val = " + itemValue);
                    }
                } else if (itemType.equals("double")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    double d = Double.parseDouble(itemValue);
                    payloadItem = new cMsgPayloadItem(itemName, d);
                    if (debug) {
                        System.out.println("Payload double \"" + itemType + "\", value = " + itemValue);
                    }
                } else if (itemType.equals("float")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    float f = Float.parseFloat(itemValue);
                    payloadItem = new cMsgPayloadItem(itemName, f);
                    if (debug) {
                        System.out.println("Payload float \"" + itemType + "\", value = " + itemValue);
                    }
                } else if (itemType.equals("double_array")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    String[] sArray2 = cMsgMessageFull.splitArray(itemValue, itemCount);
                    if (debug) {
                        System.out.println("Payload double array \"" + itemType + "\"");
                        for (int j8 = 0; j8 < itemCount; ++j8) {
                            System.out.println("  double[" + j8 + "] = " + sArray2[j8]);
                        }
                    }
                    double[] d = new double[itemCount];
                    for (int j9 = 0; j9 < itemCount; ++j9) {
                        d[j9] = Double.parseDouble(sArray2[j9]);
                    }
                    payloadItem = new cMsgPayloadItem(itemName, d);
                } else if (itemType.equals("float_array")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    String[] sArray3 = cMsgMessageFull.splitArray(itemValue, itemCount);
                    if (debug) {
                        System.out.println("Payload float array \"" + itemType + "\"");
                        for (int j10 = 0; j10 < itemCount; ++j10) {
                            System.out.println("  float[" + j10 + "] = " + sArray3[j10]);
                        }
                    }
                    float[] f = new float[itemCount];
                    for (int j11 = 0; j11 < itemCount; ++j11) {
                        f[j11] = Float.parseFloat(sArray3[j11]);
                    }
                    payloadItem = new cMsgPayloadItem(itemName, f);
                } else if (itemType.equals("binary")) {
                    itemValue = el.getFirstChild().getNodeValue();
                    itemBytes = Integer.parseInt(el.getAttribute("nbytes"));
                    int itemEndian = el.getAttribute("endian").equals("big") ? 0 : 1;
                    byte[] bytes = b64Decoder.decode(itemValue);
                    if (bytes.length != itemBytes) {
                        System.out.println("Reconstituted binary array is different size !!!");
                    }
                    payloadItem = new cMsgPayloadItem(itemName, bytes, itemEndian);
                    if (debug) {
                        System.out.println("Payload binary node \"" + itemType + "\", value = \n" + itemValue);
                    }
                } else if (itemType.equals("binary_array")) {
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    int ind = 0;
                    int[] endians = new int[itemCount];
                    byte[][] bArray = new byte[itemCount][];
                    aList = el.getChildNodes();
                    if (aList == null) continue;
                    if (debug) {
                        System.out.println("Payload binary_array node \"" + itemType + "\"");
                    }
                    for (j = 0; j < aList.getLength(); ++j) {
                        if (aList.item(j).getNodeType() != 1) continue;
                        el = (Element)aList.item(j);
                        itemValue = el.getFirstChild().getNodeValue();
                        itemBytes = Integer.parseInt(el.getAttribute("nbytes"));
                        endians[ind] = el.getAttribute("endian").equals("big") ? 0 : 1;
                        bArray[ind] = b64Decoder.decode(itemValue);
                        if (bArray[ind].length != itemBytes) {
                            System.out.println("Reconstituted binary array is different size !!!");
                        }
                        if (debug) {
                            System.out.println("  bin[" + ind + "] = " + itemValue);
                        }
                        ++ind;
                    }
                    payloadItem = new cMsgPayloadItem(itemName, bArray, endians);
                } else if (itemType.equals("cMsgMessage")) {
                    cMsgMessageFull newMsg = new cMsgMessageFull();
                    cMsgMessageFull.fillMsgFromElement(newMsg, el);
                    payloadItem = new cMsgPayloadItem(itemName, newMsg);
                    if (debug) {
                        System.out.println("Payload msg node \"" + itemType + "\"");
                    }
                } else if (itemType.equals("cMsgMessage_array")) {
                    itemCount = Integer.parseInt(el.getAttribute("count"));
                    cMsgMessage[] newMsgs = new cMsgMessageFull[itemCount];
                    int index = 0;
                    aList = el.getChildNodes();
                    if (aList == null) continue;
                    for (int j12 = 0; j12 < aList.getLength(); ++j12) {
                        if (aList.item(j12).getNodeType() != 1) continue;
                        Element el2 = (Element)aList.item(j12);
                        cMsgMessageFull newMsg = new cMsgMessageFull();
                        cMsgMessageFull.fillMsgFromElement(newMsg, el2);
                        newMsgs[index++] = newMsg;
                    }
                    payloadItem = new cMsgPayloadItem(itemName, newMsgs);
                    if (debug) {
                        System.out.println("Payload msg array node \"" + itemType + "\"");
                    }
                } else {
                    if (!debug) continue;
                    System.out.println("Payload unknown node \"" + itemType + "\"");
                    continue;
                }
                msg.addPayloadItem(payloadItem);
            }
            catch (cMsgException e) {
                if (!debug) continue;
                System.out.println("Payload node has bad name \"" + itemName + "\"");
            }
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public cMsgMessageFull copy() {
        return (cMsgMessageFull)this.clone();
    }

    @Override
    public cMsgMessageFull response() throws cMsgException {
        if (!this.isGetRequest()) {
            throw new cMsgException("this message not sent by client calling sendAndGet");
        }
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.subject = "dummy";
        msg.type = "dummy";
        msg.sysMsgId = this.sysMsgId;
        msg.senderToken = this.senderToken;
        msg.info = 2;
        return msg;
    }

    @Override
    public cMsgMessageFull nullResponse() throws cMsgException {
        if (!this.isGetRequest()) {
            throw new cMsgException("this message not sent by client calling sendAndGet");
        }
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.subject = "dummy";
        msg.type = "dummy";
        msg.sysMsgId = this.sysMsgId;
        msg.senderToken = this.senderToken;
        msg.info = 6;
        return msg;
    }

    public void makeResponse(cMsgMessageFull msg) {
        this.sysMsgId = msg.getSysMsgId();
        this.senderToken = msg.getSenderToken();
        this.info = 2;
    }

    public void makeNullResponse(cMsgMessageFull msg) {
        this.sysMsgId = msg.getSysMsgId();
        this.senderToken = msg.getSenderToken();
        this.info = 6;
    }

    public void setSysMsgId(int sysMsgId) {
        this.sysMsgId = sysMsgId;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setGetRequest(boolean getRequest) {
        this.info = getRequest ? this.info | 1 : this.info & 0xFFFFFFFE;
    }

    public void setInfo(int info) {
        this.info = info;
    }

    public void setVersion(int version) {
        if (version < 0) {
            version = 0;
        }
        this.version = version;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setSenderHost(String senderHost) {
        this.senderHost = senderHost;
    }

    public void setSenderTime(Date time) {
        this.senderTime = time.getTime();
    }

    public void setSenderToken(int senderToken) {
        this.senderToken = senderToken;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public void setReceiverHost(String receiverHost) {
        this.receiverHost = receiverHost;
    }

    public void setReceiverTime(Date time) {
        this.receiverTime = time.getTime();
    }

    public void setContext(cMsgMessageContextInterface context) {
        this.context = context;
    }

    public void setNoHistoryAdditions(boolean noHistoryAdditions) {
        this.noHistoryAdditions = noHistoryAdditions;
    }

    public void setPayloadText(String payloadText) {
        this.payloadText = payloadText;
    }

    @Override
    public boolean isNullGetServerResponse() {
        return (this.info & 0x80) == 128;
    }

    @Override
    public void setNullGetServerResponse(boolean ngsr) {
        super.setNullGetServerResponse(ngsr);
    }

    @Override
    public boolean isExpandedPayload() {
        return super.isExpandedPayload();
    }

    @Override
    public void setExpandedPayload(boolean ep) {
        super.setExpandedPayload(ep);
    }

    @Override
    public void expandPayload() {
        super.expandPayload();
    }

    public void compressPayload() {
        if (!this.isExpandedPayload() || this.items.size() < 1) {
            this.setExpandedPayload(false);
            return;
        }
        this.items.clear();
        this.setExpandedPayload(false);
    }

    @Override
    public int setFieldsFromText(String text, int flag) throws cMsgException {
        return super.setFieldsFromText(text, flag);
    }
}

