/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgNotifier;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class cMsg
extends cMsgSubdomainAdapter {
    private static AtomicInteger sysMsgId = new AtomicInteger();
    private static ConcurrentHashMap<String, cMsgClientInfo> servers = new ConcurrentHashMap(20);
    private static Set<cMsgClientInfo> clients = Collections.synchronizedSet(new HashSet(1000));
    private static ConcurrentHashMap<Integer, GetInfo> sendAndGets = new ConcurrentHashMap(100);
    private static ConcurrentHashMap<Integer, DeleteGetInfo> deleteGets = new ConcurrentHashMap(100);
    private static HashSet<cMsgSubscription> subscriptions = new HashSet(5000);
    private static final ReentrantLock registrationLock = new ReentrantLock();
    private static final ReentrantLock subscribeLock = new ReentrantLock();
    private HashSet<cMsgClientInfo> sendToSet = new HashSet(100);
    private int debug = 0;
    private String UDLRemainder;
    private String namespace;
    private String name;
    private cMsgClientInfo myInfo;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    private Lock shutdownLock = this.methodLock.writeLock();
    private Lock operatingLock = this.methodLock.readLock();
    private boolean shutdown;

    public static void printStaticSizes() {
        System.out.println("cMsg subdomain static:");
        System.out.println("     servers       = " + servers.size());
        System.out.println("     clients       = " + clients.size());
        System.out.println("     sendAndGets   = " + sendAndGets.size());
        System.out.println("     deleteGets    = " + deleteGets.size());
        System.out.println("     subscriptions = " + subscriptions.size());
    }

    public void printSizes() {
        System.out.println("cMsg subdomain handler:");
        System.out.println("     sendToSet      = " + this.sendToSet.size());
        System.out.println("     subscriptions:");
        subscribeLock.lock();
        for (cMsgSubscription sub : subscriptions) {
            sub.printSizes();
            System.out.println();
        }
        subscribeLock.unlock();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static boolean registrationLock(int delay) {
        try {
            return registrationLock.tryLock(delay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void registrationUnlock() {
        registrationLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getClientNames() {
        String[] s = new String[clients.size()];
        int i = 0;
        Set<cMsgClientInfo> set = clients;
        synchronized (set) {
            for (cMsgClientInfo ci : clients) {
                s[i++] = ci.getName();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getClientNamesAndNamespaces() {
        String[] s = new String[2 * clients.size()];
        int i = 0;
        Set<cMsgClientInfo> set = clients;
        synchronized (set) {
            for (cMsgClientInfo ci : clients) {
                s[i++] = ci.getName();
                s[i++] = ci.getNamespace();
            }
        }
        return s;
    }

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public boolean hasSubscribeAndGet() {
        return true;
    }

    @Override
    public boolean hasSendAndGet() {
        return true;
    }

    @Override
    public boolean hasSubscribe() {
        return true;
    }

    @Override
    public boolean hasUnsubscribe() {
        return true;
    }

    @Override
    public boolean hasShutdown() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.UDLRemainder = UDLRemainder;
        if (UDLRemainder == null || UDLRemainder.length() < 1) {
            this.namespace = "/default";
            if (this.debug >= 4) {
                System.out.println("setUDLRemainder:  namespace = " + this.namespace);
            }
            return;
        }
        Pattern pattern = Pattern.compile("^([\\w/]*)\\?*.*");
        Matcher matcher = pattern.matcher(UDLRemainder);
        if (!matcher.lookingAt()) {
            throw new cMsgException("invalid namespace");
        }
        String s = matcher.group(1);
        if (s == null) {
            throw new cMsgException("invalid namespace");
        }
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        this.namespace = s.equals("") ? "/default" : "/" + s;
        if (this.debug >= 4) {
            System.out.println("setUDLRemainder:  namespace = " + this.namespace);
        }
    }

    public void setMessageDeliverer(cMsgDeliverMessageInterface deliverer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(String name) {
        Set<cMsgClientInfo> set = clients;
        synchronized (set) {
            for (cMsgClientInfo ci : clients) {
                if (!name.equals(ci.getName())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        if (info == null) {
            cMsgException e = new cMsgException("argument is null");
            e.setReturnCode(4);
            throw e;
        }
        Set<cMsgClientInfo> set = clients;
        synchronized (set) {
            for (cMsgClientInfo ci : clients) {
                if (!info.getName().equals(ci.getName()) || !this.namespace.equals(ci.getNamespace())) continue;
                cMsgException e = new cMsgException("client " + info.getName() + " already exists");
                e.setReturnCode(7);
                throw e;
            }
            clients.add(info);
        }
        this.name = info.getName();
        this.myInfo = info;
        info.setNamespace(this.namespace);
    }

    public void registerServer(cMsgClientInfo info) {
        String clientName = info.getName();
        servers.putIfAbsent(clientName, info);
        this.name = clientName;
        this.myInfo = info;
        info.setNamespace(this.namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void localSend(cMsgMessage message, String namespace) throws cMsgException {
        if (message == null) {
            return;
        }
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            this.sendToSet.clear();
            if (message.isGetResponse()) {
                int id = message.getSysMsgId();
                deleteGets.remove(id);
                GetInfo gi = sendAndGets.remove(id);
                cMsgClientInfo info = null;
                if (gi != null) {
                    info = gi.info;
                }
                if (info != null) {
                    if (gi.notifier != null) {
                        gi.notifier.latch.countDown();
                    }
                    try {
                        info.getDeliverer().deliverMessage(message, 20);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
            subscribeLock.lock();
            try {
                Iterator<cMsgSubscription> it = subscriptions.iterator();
                while (it.hasNext()) {
                    cMsgSubscription sub = it.next();
                    if (!namespace.equalsIgnoreCase(sub.getNamespace()) || !sub.matches(message.getSubject(), message.getType())) continue;
                    this.sendToSet.addAll(sub.getClientSubscribers());
                    this.sendToSet.addAll(sub.getSubAndGetters().keySet());
                    sub.clearSubAndGetters();
                    for (cMsgNotifier notifier : sub.getNotifiers()) {
                        notifier.latch.countDown();
                    }
                    sub.clearNotifiers();
                    if (sub.numberOfSubscribers() >= 1) continue;
                    it.remove();
                }
            }
            finally {
                subscribeLock.unlock();
            }
            for (cMsgClientInfo client : this.sendToSet) {
                try {
                    client.getDeliverer().deliverMessage(message, 21);
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleSendRequest(cMsgMessageFull message) throws cMsgException {
        if (message == null) {
            return;
        }
        this.operatingLock.lock();
        try {
            block24: {
                if (this.shutdown) {
                    throw new cMsgException("subdomain handler is shutdown");
                }
                this.sendToSet.clear();
                if (message.isGetResponse()) {
                    int id = message.getSysMsgId();
                    deleteGets.remove(id);
                    GetInfo gi = sendAndGets.remove(id);
                    Object info = null;
                    if (gi != null) {
                        info = gi.info;
                    }
                    if (info != null) {
                        if (gi.notifier != null) {
                            gi.notifier.latch.countDown();
                        }
                        int flag = ((cMsgClientInfo)info).isServer() ? 22 : 20;
                        try {
                            ((cMsgClientInfo)info).getDeliverer().deliverMessage(message, flag);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
                subscribeLock.lock();
                try {
                    Iterator<cMsgSubscription> it = subscriptions.iterator();
                    while (it.hasNext()) {
                        cMsgSubscription sub = it.next();
                        if (!this.namespace.equalsIgnoreCase(sub.getNamespace()) || !sub.matches(message.getSubject(), message.getType())) continue;
                        this.sendToSet.addAll(sub.getAllSubscribers());
                        this.sendToSet.addAll(sub.getSubAndGetters().keySet());
                        sub.clearSubAndGetters();
                        for (cMsgNotifier notifier : sub.getNotifiers()) {
                            notifier.latch.countDown();
                        }
                        sub.clearNotifiers();
                        if (sub.numberOfSubscribers() >= 1) continue;
                        it.remove();
                    }
                    if (!message.isGetRequest() || !this.sendToSet.isEmpty()) break block24;
                    int id = message.getSysMsgId();
                    deleteGets.remove(id);
                    GetInfo gi = sendAndGets.remove(id);
                    if (gi == null) break block24;
                    cMsgClientInfo info = gi.info;
                    if (gi.notifier != null) {
                        gi.notifier.latch.countDown();
                    }
                    try {
                        message.setNullGetServerResponse(true);
                        info.getDeliverer().deliverMessage(message, 20);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                finally {
                    subscribeLock.unlock();
                }
            }
            for (cMsgClientInfo client : this.sendToSet) {
                try {
                    client.getDeliverer().deliverMessage(message, 21);
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull message) throws cMsgException {
        this.handleSendRequest(message);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSubscribeRequest(String subject, String type, int id) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            boolean subscriptionExists = false;
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(this.namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                if (sub2.containsSubscriber(this.myInfo)) {
                    throw new cMsgException("handleSubscribeRequest: subscription already exists for subject = " + subject + " and type = " + type);
                }
                subscriptionExists = true;
                break;
            }
            if (subscriptionExists) {
                sub2.addSubscriber(this.myInfo);
                sub2.addClientSubscriber(this.myInfo);
            } else {
                sub2 = new cMsgSubscription(subject, type, this.namespace);
                sub2.addSubscriber(this.myInfo);
                sub2.addClientSubscriber(this.myInfo);
                subscriptions.add(sub2);
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServerSubscribeRequest(String subject, String type, String namespace) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            boolean subscriptionExists = false;
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                if (sub2.containsSubscriber(this.myInfo)) {
                    throw new cMsgException("handleServerSubscribeRequest: subscription already exists for subject = " + subject + " and type = " + type);
                }
                subscriptionExists = true;
                break;
            }
            if (subscriptionExists) {
                sub2.addSubscriber(this.myInfo);
            } else {
                sub2 = new cMsgSubscription(subject, type, namespace);
                sub2.addSubscriber(this.myInfo);
                subscriptions.add(sub2);
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnsubscribeRequest(String subject, String type, int id) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(this.namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                sub2.removeSubscriber(this.myInfo);
                sub2.removeClientSubscriber(this.myInfo);
                break;
            }
            if (sub2 != null && sub2.numberOfSubscribers() < 1) {
                subscriptions.remove(sub2);
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServerUnsubscribeRequest(String subject, String type, String namespace) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                sub2.removeSubscriber(this.myInfo);
                break;
            }
            if (sub2 != null && sub2.numberOfSubscribers() < 1) {
                subscriptions.remove(sub2);
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSendAndGetRequest(cMsgMessageFull message) throws cMsgException {
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            int id = sysMsgId.getAndIncrement();
            message.setSysMsgId(id);
            sendAndGets.put(id, new GetInfo(this.myInfo));
            DeleteGetInfo dgi = new DeleteGetInfo(this.name, message.getSenderToken(), id);
            deleteGets.put(id, dgi);
            this.handleSendRequest(message);
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleServerSendAndGetRequest(cMsgMessageFull message, String namespace, cMsgNotifier notifier) throws cMsgException {
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            int id = sysMsgId.getAndIncrement();
            message.setSysMsgId(id);
            sendAndGets.put(id, new GetInfo(this.myInfo, notifier));
            DeleteGetInfo dgi = new DeleteGetInfo(this.name, message.getSenderToken(), id);
            deleteGets.put(id, dgi);
            this.localSend(message, namespace);
            int n = id;
            return n;
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServerSendAndGetRequest(cMsgMessageFull message, String namespace) throws cMsgException {
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            int id = sysMsgId.getAndIncrement();
            message.setSysMsgId(id);
            sendAndGets.put(id, new GetInfo(this.myInfo));
            DeleteGetInfo dgi = new DeleteGetInfo(this.name, message.getSenderToken(), id);
            deleteGets.put(id, dgi);
            this.localSend(message, namespace);
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnSendAndGetRequest(int id) throws cMsgException {
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            int sysId = -1;
            Iterator<DeleteGetInfo> i = deleteGets.values().iterator();
            while (i.hasNext()) {
                DeleteGetInfo dgi = i.next();
                if (!dgi.name.equals(this.name) || dgi.senderToken != id) continue;
                sysId = dgi.sysMsgId;
                i.remove();
                break;
            }
            if (sysId < 0) {
                return;
            }
            GetInfo myInfo = sendAndGets.remove(sysId);
            if (myInfo != null && myInfo.notifier != null) {
                myInfo.notifier.latch.countDown();
            }
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSubscribeAndGetRequest(String subject, String type, int id) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            boolean subscriptionExists = false;
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(this.namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                subscriptionExists = true;
                break;
            }
            if (subscriptionExists) {
                sub2.addSubAndGetter(this.myInfo);
            } else {
                sub2 = new cMsgSubscription(subject, type, this.namespace);
                sub2.addSubAndGetter(this.myInfo);
                subscriptions.add(sub2);
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServerSubscribeAndGetRequest(String subject, String type, cMsgNotifier notifier) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            boolean subscriptionExists = false;
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(this.namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                subscriptionExists = true;
                break;
            }
            if (subscriptionExists) {
                sub2.addSubAndGetter(this.myInfo);
            } else {
                sub2 = new cMsgSubscription(subject, type, this.namespace);
                sub2.addSubAndGetter(this.myInfo);
                subscriptions.add(sub2);
            }
            sub2.addNotifier(notifier);
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnsubscribeAndGetRequest(String subject, String type, int id) throws cMsgException {
        this.operatingLock.lock();
        subscribeLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            boolean subscriptionExists = false;
            cMsgSubscription sub2 = null;
            for (cMsgSubscription sub2 : subscriptions) {
                if (!sub2.getNamespace().equals(this.namespace) || !sub2.getSubject().equals(subject) || !sub2.getType().equals(type)) continue;
                sub2.removeSubAndGetter(this.myInfo);
                subscriptionExists = true;
                break;
            }
            if (!subscriptionExists) {
                return;
            }
            if (sub2.numberOfSubscribers() < 1) {
                subscriptions.remove(sub2);
            }
            for (cMsgNotifier notifier : sub2.getNotifiers()) {
                if (notifier.client != this.myInfo || notifier.id != id) continue;
                notifier.latch.countDown();
                sub2.removeNotifier(notifier);
                break;
            }
        }
        finally {
            subscribeLock.unlock();
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleShutdownClientsRequest(String client, boolean includeMe) throws cMsgException {
        this.operatingLock.lock();
        try {
            if (this.shutdown) {
                throw new cMsgException("subdomain handler is shutdown");
            }
            for (cMsgClientInfo info : clients) {
                String clientName = info.getName();
                if (!includeMe && clientName.equals(this.name) || !cMsgSubscription.matches(client, clientName, true)) continue;
                try {
                    info.getDeliverer().deliverMessage(0, 0, 3);
                }
                catch (IOException e) {
                    if (this.debug < 2) continue;
                    System.out.println("dHandler: cannot tell client " + this.name + " to shutdown");
                }
            }
        }
        finally {
            this.operatingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClientShutdown() {
        if (this.debug >= 3) {
            System.out.println("  CLIENT SHUTDOWN for " + this.name);
        }
        this.shutdownLock.lock();
        try {
            this.shutdown = true;
            clients.remove(this.myInfo);
            servers.remove(this.name);
            int sysId = -1;
            Iterator<DeleteGetInfo> it = deleteGets.values().iterator();
            while (it.hasNext()) {
                DeleteGetInfo dgi = it.next();
                if (dgi.name.equals(this.name)) {
                    sysId = dgi.sysMsgId;
                    it.remove();
                }
                if (sysId <= -1) continue;
                sendAndGets.remove(sysId);
            }
            subscribeLock.lock();
            try {
                Iterator<cMsgSubscription> it2 = subscriptions.iterator();
                while (it2.hasNext()) {
                    cMsgSubscription sub = it2.next();
                    boolean b = sub.removeSubscriber(this.myInfo);
                    b = sub.removeClientSubscriber(this.myInfo);
                    sub.removeSubAndGetter(this.myInfo);
                    Iterator<cMsgNotifier> it22 = sub.getNotifiers().iterator();
                    while (it22.hasNext()) {
                        cMsgNotifier notifier = it22.next();
                        if (notifier.client != this.myInfo) continue;
                        notifier.latch.countDown();
                        it22.remove();
                    }
                    if (sub.numberOfSubscribers() >= 1) continue;
                    it2.remove();
                }
            }
            finally {
                subscribeLock.unlock();
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    private static class DeleteGetInfo {
        String name;
        int senderToken;
        int sysMsgId;

        DeleteGetInfo(String name, int senderToken, int sysMsgId) {
            this.name = name;
            this.senderToken = senderToken;
            this.sysMsgId = sysMsgId;
        }
    }

    private static class GetInfo {
        cMsgClientInfo info;
        cMsgNotifier notifier;

        GetInfo(cMsgClientInfo info) {
            this(info, null);
        }

        GetInfo(cMsgClientInfo info, cMsgNotifier notifier) {
            this.info = info;
            this.notifier = notifier;
        }
    }
}

