/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class TcpServer
extends cMsgSubdomainAdapter {
    private cMsgClientInfo myClientInfo;
    private String myUDLRemainder;
    private cMsgDeliverMessageInterface myDeliverer;
    private String mySrvHost = null;
    private int mySrvPort = 5001;
    private static final int srvFlag = 1;
    private String myName = "tcpserver";
    private String myHost = null;

    @Override
    public boolean hasSendAndGet() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        this.myClientInfo = info;
        this.myDeliverer = info.getDeliverer();
        int ind = this.myUDLRemainder.indexOf("?");
        String s = ind > 0 ? this.myUDLRemainder.substring(0, ind) : this.myUDLRemainder;
        ind = s.indexOf(":");
        if (ind > 0) {
            this.mySrvHost = s.substring(0, ind);
            this.mySrvPort = Integer.parseInt(s.substring(ind));
        } else {
            this.mySrvHost = s;
        }
        try {
            this.myHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println(e);
            this.myHost = "unknown";
        }
    }

    @Override
    public void handleSendAndGetRequest(cMsgMessageFull msg) throws cMsgException {
        BufferedReader response;
        DataOutputStream request;
        Socket socket;
        try {
            socket = new Socket(this.mySrvHost, this.mySrvPort);
            socket.setTcpNoDelay(true);
            request = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            response = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (IOException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            request.writeInt(1);
            request.writeInt(msg.getText().length());
            request.write(msg.getText().getBytes("ASCII"));
            request.writeByte(0);
            request.flush();
            socket.shutdownOutput();
        }
        catch (IOException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        StringBuffer sb = new StringBuffer();
        try {
            String s;
            while ((s = response.readLine()) != null && s.indexOf("value =") < 0) {
                sb.append(s + "\n");
            }
        }
        catch (IOException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        finally {
            try {
                request.close();
                response.close();
                socket.close();
            }
            catch (Exception exception) {}
        }
        try {
            cMsgMessageFull responseMsg = new cMsgMessageFull();
            responseMsg.setSubject(msg.getSubject());
            responseMsg.setType(msg.getType());
            responseMsg.setText(sb.toString());
            responseMsg.setSender(this.myName);
            responseMsg.setSenderHost(this.myHost);
            if (msg.getText().length() <= 0) {
                responseMsg.makeNullResponse(msg);
            } else {
                responseMsg.makeResponse(msg);
            }
            this.myDeliverer.deliverMessage(responseMsg, 20);
        }
        catch (IOException e) {
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }
}

