/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import com.smartsockets.TipcCb;
import com.smartsockets.TipcException;
import com.smartsockets.TipcMsg;
import com.smartsockets.TipcMt;
import com.smartsockets.TipcProcessCb;
import com.smartsockets.TipcSrv;
import com.smartsockets.TipcSvc;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class SmartSockets
extends cMsgSubdomainAdapter {
    private static Map<String, MyInt> subjects = Collections.synchronizedMap(new HashMap(100));
    private static Map<Integer, TipcCb> callbacks = Collections.synchronizedMap(new HashMap(100));
    private cMsgClientInfo myClientInfo;
    private String myUDLRemainder = null;
    private cMsgDeliverMessageInterface myDeliverer;
    private TipcSrv mySrv = null;
    private boolean done = false;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSubscribe() {
        return true;
    }

    @Override
    public boolean hasUnsubscribe() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        String myProject;
        this.myClientInfo = info;
        this.myDeliverer = info.getDeliverer();
        if (this.myUDLRemainder.indexOf("?") > 0) {
            Pattern p = Pattern.compile("^(.+?)(\\?)(.*)$");
            Matcher m = p.matcher(this.myUDLRemainder);
            m.find();
            myProject = m.group(1);
        } else {
            myProject = this.myUDLRemainder;
        }
        try {
            this.mySrv = TipcSvc.createSrv();
            this.mySrv.setOption("ss.project", myProject);
            this.mySrv.setOption("ss.unique_subject", this.myClientInfo.getName());
            this.mySrv.setOption("ss.monitor_ident", this.myClientInfo.getDescription());
            if (!this.mySrv.create()) {
                throw new cMsgException("?unable to connect to server");
            }
        }
        catch (TipcException e) {
            e.printStackTrace();
            System.err.println((Object)e);
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        new MainLoop().start();
    }

    @Override
    public void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        TipcMt mt;
        String type = msg.getType();
        if (type.matches("\\d+")) {
            mt = TipcSvc.lookupMt((int)Integer.parseInt(type));
            if (mt == null) {
                try {
                    mt = TipcSvc.createMt((String)type, (int)Integer.parseInt(type), (String)"verbose");
                }
                catch (TipcException e) {
                    cMsgException ce = new cMsgException("?unable to create message type: " + type);
                    ce.setReturnCode(1);
                    throw ce;
                }
            }
        } else {
            mt = TipcSvc.lookupMt((String)type);
            if (mt == null) {
                cMsgException ce = new cMsgException("?unknown message type: " + type);
                ce.setReturnCode(1);
                throw ce;
            }
        }
        try {
            TipcMsg ssMsg = TipcSvc.createMsg((TipcMt)mt);
            ssMsg.setDest(msg.getSubject());
            ssMsg.setUserProp(msg.getUserInt());
            ssMsg.setSenderTimestamp((double)(msg.getSenderTime().getTime() / 1000L));
            ssMsg.appendStr(msg.getText());
            this.mySrv.send(ssMsg);
            this.mySrv.flush();
        }
        catch (TipcException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.getMessage());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public void handleSubscribeRequest(String subject, String type, int id) throws cMsgException {
        TipcMt mt;
        if (type.matches("\\d+")) {
            mt = TipcSvc.lookupMt((int)Integer.parseInt(type));
            if (mt == null) {
                try {
                    mt = TipcSvc.createMt((String)type, (int)Integer.parseInt(type), (String)"verbose");
                }
                catch (TipcException e) {
                    cMsgException ce = new cMsgException("?unable to create message type: " + type);
                    ce.setReturnCode(1);
                    throw ce;
                }
            }
        } else {
            mt = TipcSvc.lookupMt((String)type);
        }
        if (mt == null) {
            cMsgException ce = new cMsgException("?unknown message type: " + type);
            ce.setReturnCode(1);
            throw ce;
        }
        TipcCb cb3 = this.mySrv.addProcessCb((TipcProcessCb)new ProcessCb(), mt, subject, (Object)id);
        if (cb3 == null) {
            cMsgException ce = new cMsgException("?unable to create callback");
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.mySrv.setSubjectSubscribe(subject, true);
        }
        catch (TipcException e) {
            cMsgException ce = new cMsgException("?unable to subscribe to: " + subject);
            ce.setReturnCode(1);
            throw ce;
        }
        if (subjects.containsKey(subject)) {
            MyInt m = subjects.get(subject);
            ++m.count;
            subjects.put(subject, m);
        } else {
            MyInt m = new MyInt();
            m.count = 1;
            subjects.put(subject, m);
        }
        callbacks.put(id, cb3);
    }

    @Override
    public void handleUnsubscribeRequest(String subject, String type, int id) {
        try {
            if (callbacks.containsKey(id)) {
                this.mySrv.removeProcessCb(callbacks.get(id));
                callbacks.remove(id);
            }
        }
        catch (TipcException e) {
            System.err.println("?unable to unsubscribe from subject " + subject);
        }
        if (subjects.containsKey(subject)) {
            MyInt m = subjects.get(subject);
            --m.count;
            if (m.count >= 1) {
                subjects.put(subject, m);
            } else {
                subjects.remove(subject);
                try {
                    this.mySrv.setSubjectSubscribe(subject, false);
                }
                catch (TipcException e) {
                    System.err.println("?unable to unsubscribe from subject " + subject);
                }
            }
        }
    }

    @Override
    public void handleClientShutdown() throws cMsgException {
        this.done = true;
        System.out.println("...shutdown for client " + this.myClientInfo.getName());
        try {
            this.mySrv.setOption("ss.server_auto_connect", "false");
            this.mySrv.destroy(0);
        }
        catch (TipcException e) {
            System.err.println((Object)e);
        }
    }

    private class MyInt {
        int count;

        private MyInt() {
        }
    }

    private class MainLoop
    extends Thread {
        private MainLoop() {
        }

        @Override
        public void run() {
            try {
                while (!SmartSockets.this.done) {
                    SmartSockets.this.mySrv.mainLoop(0.5);
                }
            }
            catch (TipcException e) {
                System.err.println((Object)e);
            }
            System.out.println("...main loop done");
        }
    }

    private class ProcessCb
    implements TipcProcessCb {
        private ProcessCb() {
        }

        public void process(TipcMsg msg, Object arg) {
            try {
                msg.setCurrent(0);
                cMsgMessageFull cmsg = new cMsgMessageFull();
                cmsg.setDomain("cMsg");
                cmsg.setSysMsgId(msg.getSeqNum());
                cmsg.setSender(msg.getSender());
                cmsg.setSenderHost("unknown");
                cmsg.setSenderTime(new Date((long)msg.getSenderTimestamp() * 1000L));
                cmsg.setReceiver(SmartSockets.this.myClientInfo.getName());
                cmsg.setReceiverHost(SmartSockets.this.myClientInfo.getClientHost());
                cmsg.setReceiverTime(new Date());
                cmsg.setSenderToken((Integer)arg);
                cmsg.setSubject(msg.getDest());
                cmsg.setType(msg.getType().getName());
                cmsg.setText(msg.nextStr());
                cmsg.setUserInt(msg.getUserProp());
                SmartSockets.this.myDeliverer.deliverMessage(cmsg, 21);
            }
            catch (TipcException e) {
                System.err.println((Object)e);
            }
            catch (cMsgException e) {
                System.err.println(e);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }
}

