/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class Queue
extends cMsgSubdomainAdapter {
    private cMsgClientInfo myClientInfo;
    private String myUDLRemainder;
    private cMsgDeliverMessageInterface myDeliverer;
    private String myQueueName = null;
    private String myTableName = null;
    private Connection myCon = null;
    private Statement myStmt = null;
    private PreparedStatement myPStmt = null;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSendAndGet() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        String myDBType;
        String URL2;
        String driver;
        Matcher m;
        Pattern p;
        String account = null;
        String password = null;
        this.myClientInfo = info;
        this.myDeliverer = info.getDeliverer();
        if (this.myUDLRemainder.indexOf("?") > 0) {
            p = Pattern.compile("^(.+?)(\\?.*)$");
            m = p.matcher(this.myUDLRemainder);
            if (!m.find()) {
                cMsgException ce = new cMsgException("?illegal UDL");
                ce.setReturnCode(1);
                throw ce;
            }
        } else {
            cMsgException ce = new cMsgException("?illegal UDL...no remainder");
            ce.setReturnCode(1);
            throw ce;
        }
        this.myQueueName = m.group(1);
        String remainder = m.group(2);
        remainder = remainder + "&";
        p = Pattern.compile("[&\\?]driver=(.*?)&", 2);
        m = p.matcher(remainder);
        try {
            m.find();
            driver = m.group(1);
        }
        catch (IllegalStateException e) {
            cMsgException ce = new cMsgException("?illegal UDL...no driver");
            ce.setReturnCode(1);
            throw ce;
        }
        p = Pattern.compile("[&\\?]url=(.*?)&", 2);
        m = p.matcher(remainder);
        try {
            m.find();
            URL2 = m.group(1);
        }
        catch (IllegalStateException e) {
            cMsgException ce = new cMsgException("?illegal UDL...no URL");
            ce.setReturnCode(1);
            throw ce;
        }
        p = Pattern.compile("[&\\?]account=(.*?)&", 2);
        m = p.matcher(remainder);
        if (m.find()) {
            account = m.group(1);
        }
        if ((m = (p = Pattern.compile("[&\\?]password=(.*?)&", 2)).matcher(remainder)).find()) {
            password = m.group(1);
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("?registerClient: unable to load driver");
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myCon = DriverManager.getConnection(URL2, account, password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("?registerClient: unable to connect to database");
            ce.setReturnCode(1);
            throw ce;
        }
        boolean tableExists = false;
        this.myTableName = "cMsgQueue_" + this.myQueueName;
        try {
            this.myStmt = this.myCon.createStatement();
            DatabaseMetaData dbmeta = this.myCon.getMetaData();
            myDBType = dbmeta.getDatabaseProductName();
            ResultSet dbrs = dbmeta.getTables(null, null, this.myTableName, new String[]{"TABLE"});
            if (dbrs.next()) {
                tableExists = dbrs.getString(3).equalsIgnoreCase(this.myTableName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("?registerClient: unable to get db metadata");
            ce.setReturnCode(1);
            throw ce;
        }
        if (!tableExists) {
            this.createTable(myDBType);
        }
        this.createPreparedStatement(myDBType);
    }

    @Override
    public synchronized void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        String creator = null;
        try {
            cMsgPayloadItem creatorItem = msg.getPayloadItem("cMsgCreator");
            if (creatorItem != null) {
                creator = creatorItem.getString();
            }
        }
        catch (cMsgException e) {
            System.err.println("?Queue domain...message has no creator!");
        }
        msg.compressPayload();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(msg);
            oos.close();
            int i = 1;
            this.myPStmt.setTimestamp(i++, new Timestamp(msg.getReceiverTime().getTime()));
            this.myPStmt.setString(i++, creator);
            this.myPStmt.setString(i++, msg.getSubject());
            this.myPStmt.setString(i++, msg.getType());
            this.myPStmt.setTimestamp(i++, new Timestamp(msg.getUserTime().getTime()));
            this.myPStmt.setInt(i++, msg.getUserInt());
            this.myPStmt.setBytes(i++, baos.toByteArray());
            this.myPStmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new cMsgException("?handleSendRequest: unable to insert into queue");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        try {
            this.handleSendRequest(msg);
            return 0;
        }
        catch (cMsgException e) {
            return 1;
        }
    }

    @Override
    public synchronized void handleSendAndGetRequest(cMsgMessageFull msg) throws cMsgException {
        cMsgMessageFull response = null;
        try {
            byte[] buf;
            this.myStmt.execute("lock tables " + this.myTableName + " write");
            ResultSet rs = this.myStmt.executeQuery("select * from " + this.myTableName + " order by id limit 1");
            if (rs.next() && (buf = rs.getBytes("message")) != null) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
                    response = (cMsgMessageFull)ois.readObject();
                    response.expandPayload();
                    response.makeResponse(msg);
                    this.myStmt.execute("delete from " + this.myTableName + " where id=" + rs.getInt("id"));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            rs.close();
            this.myStmt.execute("unlock tables");
        }
        catch (SQLException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
        if (response == null) {
            response = cMsgMessageFull.createDeliverableMessage();
            response.makeNullResponse(msg);
        }
        try {
            this.myDeliverer.deliverMessage(response, 20);
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public synchronized void handleClientShutdown() throws cMsgException {
        try {
            this.myStmt.close();
            this.myPStmt.close();
            this.myCon.close();
        }
        catch (SQLException e) {
            throw new cMsgException("?queue sub-domain handler shutdown error");
        }
    }

    private void createTable(String type) throws cMsgException {
        block4: {
            System.out.println("Creating new table for queue " + this.myQueueName);
            try {
                if (type.equalsIgnoreCase("mysql")) {
                    String sql = "create table " + this.myTableName + " (id int not null primary key auto_increment,msgTime dateTime, creator varchar(255), subject varchar(255), type varchar(128),  userTime datetime, userInt int, message blob)";
                    this.myStmt.executeUpdate(sql);
                    break block4;
                }
                if (type.equalsIgnoreCase("postgresql")) {
                    String seq = "cMsgQueueSeq_" + this.myQueueName;
                    this.myStmt.executeUpdate("create sequence " + seq);
                    String sql = "create table " + this.myTableName + " (id int not null primary key default nextval('" + seq + "'),msgTime dateTime, creator varchar(255), subject varchar(255), type varchar(128),  userTime datetime, userInt int, message blob)";
                    this.myStmt.executeUpdate(sql);
                    break block4;
                }
                cMsgException ce = new cMsgException("?createTable: unknown database type " + type);
                ce.setReturnCode(1);
                throw ce;
            }
            catch (SQLException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException("?createTable: unable to create table " + this.myTableName);
                ce.setReturnCode(1);
                throw ce;
            }
        }
    }

    private void createPreparedStatement(String type) throws cMsgException {
        String sql = "insert into " + this.myTableName + " (msgTime,creator,subject,type,userTime,userInt,message) values (?,?,?,?,?,?,?)";
        try {
            this.myPStmt = this.myCon.prepareStatement(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("?createPreparedStatement: unable to create prepared statement for " + this.myTableName);
            ce.setReturnCode(1);
            throw ce;
        }
    }
}

