/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgServerClient;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

class cMsgServerBridge {
    private static cMsg subdomainHandler = new cMsg();
    private static SubscribeCallback subCallback = new SubscribeCallback();
    cMsgServerClient client;
    String serverName;
    private AtomicInteger cloudStatus = new AtomicInteger(3);
    private int thisNsTcpPort;
    private int thisNsUdpPort;
    private ConcurrentHashMap<Integer, Integer> idStorage;

    public void printSizes() {
        System.out.println("              ids  = " + this.idStorage.size());
        this.client.printSizes();
    }

    public static cMsgCallbackAdapter getSubAndGetCallback() {
        return subCallback;
    }

    public static cMsgCallbackAdapter getSendAndGetCallback(int id, int sysMsgId) {
        return new SendAndGetCallback(id, sysMsgId);
    }

    public cMsgServerBridge(cMsgNameServer nameServer, String serverName, int thisNsTcpPort, int thisNsUdpPort) throws cMsgException {
        this.serverName = serverName;
        this.thisNsTcpPort = thisNsTcpPort;
        this.thisNsUdpPort = thisNsUdpPort;
        this.idStorage = new ConcurrentHashMap(100);
        String UDL = "cMsg://" + serverName + "/cMsg";
        this.client = new cMsgServerClient(nameServer);
        this.client.setUDL(UDL);
        this.client.setName(serverName);
        this.client.setDescription("server");
        this.client.setUDLRemainder(serverName + "/cMsg");
    }

    public Set<String> connect(boolean isOriginator, String cloudPassword, String clientPassword, boolean multicasting) throws cMsgException {
        this.client.start();
        return this.client.connect(this.thisNsTcpPort, this.thisNsUdpPort, isOriginator, cloudPassword, clientPassword, multicasting);
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    int getCloudStatus() {
        return this.cloudStatus.get();
    }

    void setCloudStatus(int cloudStatus) {
        this.cloudStatus.set(cloudStatus);
    }

    void thisServerCloudStatus(int status) throws IOException {
        this.client.thisServerCloudStatus(status);
    }

    boolean cloudLock(int delay) throws IOException {
        return this.client.cloudLock(delay);
    }

    void cloudUnlock() throws IOException {
        this.client.cloudUnlock();
    }

    boolean registrationLock(int delay) throws IOException {
        return this.client.registrationLock(delay);
    }

    void registrationUnlock() throws IOException {
        this.client.registrationUnlock();
    }

    String[] getClientNamesAndNamespaces() throws IOException {
        return this.client.getClientNamesAndNamespaces();
    }

    public void subscribe(String subject, String type, String namespace) throws IOException {
        this.client.serverSubscribe(subject, type, namespace, subCallback, namespace);
    }

    public void unsubscribe(String subject, String type, String namespace) throws IOException {
        this.client.serverUnsubscribe(subject, type, namespace, subCallback, namespace);
    }

    public void sendAndGet(cMsgMessage msg, String namespace, cMsgCallbackInterface cb3) throws IOException {
        int id = this.client.serverSendAndGet(msg, namespace, cb3);
        this.idStorage.put(msg.getSenderToken(), id);
    }

    public void unSendAndGet(int id) throws IOException {
        Integer newId = this.idStorage.remove(id);
        if (newId == null) {
            return;
        }
        this.client.serverUnSendAndGet(newId);
    }

    public void subscribeAndGet(String subject, String type, String namespace, cMsgCallbackInterface cb3) throws IOException {
        this.client.serverSubscribe(subject, type, namespace, cb3, namespace);
    }

    public void unsubscribeAndGet(String subject, String type, String namespace, cMsgCallbackInterface cb3) throws IOException {
        this.client.serverUnsubscribe(subject, type, namespace, cb3, namespace);
    }

    public void shutdownClients(String clientName, boolean includeMe) throws IOException {
        this.client.serverShutdownClients(clientName, includeMe);
    }

    public void shutdownServer() throws IOException {
        this.client.serverShutdown();
    }

    static class SendAndGetCallback
    extends cMsgCallbackAdapter {
        int id;
        int sysMsgId;
        AtomicBoolean skip = new AtomicBoolean();

        SendAndGetCallback(int id, int sysMsgId) {
            this.id = id;
            this.sysMsgId = sysMsgId;
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (!this.skip.compareAndSet(false, true)) {
                return;
            }
            cMsgMessageFull fullMsg = (cMsgMessageFull)msg;
            String namespace = (String)userObject;
            try {
                if (fullMsg.getText() == null) {
                    fullMsg.setText("");
                }
                fullMsg.setSenderToken(this.id);
                fullMsg.setSysMsgId(this.sysMsgId);
                subdomainHandler.localSend(fullMsg, namespace);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }

    static class SubscribeCallback
    extends cMsgCallbackAdapter {
        SubscribeCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            String namespace = (String)userObject;
            if (msg.getText() == null) {
                msg.setText("");
            }
            try {
                subdomainHandler.localSend(msg, namespace);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }

        @Override
        public int getMaximumQueueSize() {
            return 3000;
        }
    }
}

