/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgClientData;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;

class cMsgConnectionHandler
extends Thread {
    ConcurrentHashMap<Integer, clientInfoStorage> clients = new ConcurrentHashMap(100);
    cMsgNameServer nameServer;
    private ServerSocketChannel serverChannel;
    private AtomicInteger clientKey = new AtomicInteger(0);
    volatile boolean killThisThread;
    int debug;

    public cMsgConnectionHandler(cMsgNameServer nameServer, int debug) {
        this.nameServer = nameServer;
        this.debug = debug;
    }

    void killThread() {
        this.killThisThread = true;
        this.interrupt();
    }

    public synchronized int getUniqueKey() {
        int uniqueKey;
        while (this.clients.containsKey(uniqueKey = this.clientKey.incrementAndGet())) {
        }
        return uniqueKey;
    }

    public void allowConnections(cMsgClientData info) {
        clientInfoStorage storage = new clientInfoStorage();
        storage.info = info;
        this.clients.put(info.clientKey, storage);
    }

    public boolean gotConnections(cMsgClientData info, int secondsToWait) {
        boolean gotConnections = false;
        int clientKey = info.clientKey;
        clientInfoStorage storage = this.clients.get(clientKey);
        if (storage == null) {
            return false;
        }
        try {
            gotConnections = storage.finishedConnectionsLatch.await(secondsToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!gotConnections) {
            this.cleanupConnections(storage);
        } else {
            this.clients.remove(clientKey);
        }
        return gotConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupConnections(clientInfoStorage storage) {
        if (storage == null) {
            return;
        }
        clientInfoStorage clientInfoStorage2 = storage;
        synchronized (clientInfoStorage2) {
            this.clients.remove(storage.info.clientKey);
            storage.timedOut = true;
            if (storage.info.getMessageChannel() != null) {
                try {
                    storage.info.getMessageChannel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (storage.info.keepAliveChannel != null) {
                try {
                    storage.info.keepAliveChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 28[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private clientInfoStorage readIncomingMessage(SelectionKey key) throws IOException, cMsgException {
        int bytesRead;
        int BYTES_TO_READ = 20;
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = (ByteBuffer)key.attachment();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(BYTES_TO_READ);
            key.attach(buffer);
            buffer.clear();
            buffer.limit(BYTES_TO_READ);
        }
        if ((bytesRead = channel.read(buffer)) == -1) {
            throw new IOException("Socket lost connection during read operation");
        }
        if (buffer.position() >= BYTES_TO_READ) {
            buffer.flip();
            int magic1 = buffer.getInt();
            int magic2 = buffer.getInt();
            int magic3 = buffer.getInt();
            if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                throw new cMsgException("Wrong magic numbers sent from client");
            }
            int uniqueClientKey = buffer.getInt();
            clientInfoStorage storage = this.clients.get(uniqueClientKey);
            if (storage == null) {
                throw new cMsgException("Bad key sent from client or timed out");
            }
            int channelType = buffer.getInt();
            if (storage.connectionsMade < 1) {
                storage.messageSocketFirst = channelType == 1;
            }
            buffer.clear();
            buffer.put((byte)9);
            buffer.flip();
            channel.write(buffer);
            return storage;
        }
        return null;
    }

    private class clientInfoStorage {
        int connectionsMade;
        boolean timedOut;
        boolean messageSocketFirst = true;
        cMsgClientData info;
        CountDownLatch finishedConnectionsLatch = new CountDownLatch(1);

        private clientInfoStorage() {
        }
    }
}

