/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.client;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsg;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgSendAndGetCallbackThread;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgServerClient;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class cMsgClientListeningThread
extends Thread {
    private String domainType = "cMsg";
    private cMsg client;
    private cMsgServerClient serverClient;
    private Socket socket;
    DataInputStream in;
    byte[] bytes = new byte[65536];
    private int debug;
    private boolean killThread;

    public void killThread() {
        this.killThread = true;
    }

    public cMsgClientListeningThread(cMsg myClient, Socket sock) throws IOException {
        this.client = myClient;
        this.socket = sock;
        this.debug = this.client.getDebug();
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
        this.setDaemon(true);
        this.setName("cMsg domain client listener");
    }

    public cMsgClientListeningThread(cMsgServerClient myClient, Socket sock) throws IOException {
        this((cMsg)myClient, sock);
        this.serverClient = myClient;
    }

    public synchronized void changeSockets(Socket sock) throws IOException {
        this.socket = sock;
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block14: while (true) {
                if (this.isInterrupted()) {
                    return;
                }
                int size = this.in.readInt();
                int msgId = this.in.readInt();
                switch (msgId) {
                    case 21: {
                        cMsgMessageFull msg = this.readIncomingMessage();
                        this.runCallbacks(msg);
                        continue block14;
                    }
                    case 20: 
                    case 22: {
                        cMsgMessageFull msg = this.readIncomingMessage();
                        msg.setGetResponse(true);
                        if (msgId == 20) {
                            this.wakeGets(msg);
                            continue block14;
                        }
                        this.runServerCallbacks(msg);
                        continue block14;
                    }
                    case 3: {
                        if (this.debug >= 4) {
                            System.out.println("cMsgClientListeningThread: got shutdown from server");
                        }
                        if (this.client.getShutdownHandler() == null) continue block14;
                        this.client.getShutdownHandler().handleShutdown();
                        continue block14;
                    }
                    case 25: {
                        if (this.debug >= 4) {
                            System.out.println("cMsgClientListeningThread: got syncSend response from server");
                        }
                        int response = this.in.readInt();
                        int ssid = this.in.readInt();
                        this.wakeSyncSends(response, ssid);
                        continue block14;
                    }
                    case 26: {
                        if (this.debug >= 4) {
                            System.out.println("cMsgClientListeningThread: got getClientNamesAndNamespaces response from server");
                        }
                        String[] names = this.readClientNamesAndNamespaces();
                        this.wakeGetClientNames(names);
                        continue block14;
                    }
                    case 27: {
                        if (this.debug >= 4) {
                            System.out.println("cMsgClientListeningThread: got clouldLock response from server");
                        }
                        int response = this.in.readInt();
                        this.in.readInt();
                        this.wakeCloudLock(response);
                        continue block14;
                    }
                    case 28: {
                        if (this.debug >= 4) {
                            System.out.println("cMsgClientListeningThread: got registrationLock response from server");
                        }
                        int response = this.in.readInt();
                        this.in.readInt();
                        this.wakeRegistrationLock(response);
                        continue block14;
                    }
                }
                if (this.debug < 3) continue;
                System.out.println("cMsgClientListeningThread: can't understand server message = " + msgId);
            }
        }
        catch (InterruptedIOException e) {
            if (this.debug < 2) return;
            System.out.println("cMsgClientListeningThread: I/O interrupted reading from server");
            return;
        }
        catch (IOException e) {
            if (this.debug < 2) return;
            System.out.println("cMsgClientListeningThread: I/O ERROR reading from server");
            return;
        }
    }

    private cMsgMessageFull readIncomingMessage(byte[] array) throws IOException {
        cMsgMessageFull msg = new cMsgMessageFull();
        int index = 4;
        msg.setVersion(cMsgUtilities.bytesToInt(array, index));
        index += 4;
        msg.setUserInt(cMsgUtilities.bytesToInt(array, index += 4));
        msg.setInfo(cMsgUtilities.bytesToInt(array, index += 4) | 0x10 | 0x40);
        long time = (long)cMsgUtilities.bytesToInt(array, index += 4) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
        msg.setSenderTime(new Date(time));
        time = (long)cMsgUtilities.bytesToInt(array, index += 8) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
        msg.setUserTime(new Date(time));
        msg.setSysMsgId(cMsgUtilities.bytesToInt(array, index += 8));
        msg.setSenderToken(cMsgUtilities.bytesToInt(array, index += 4));
        int lengthSender = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthSenderHost = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthSubject = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthType = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthPayloadTxt = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthText = cMsgUtilities.bytesToInt(array, index += 4);
        int lengthBinary = cMsgUtilities.bytesToInt(array, index += 4);
        msg.setSender(new String(array, index += 4, lengthSender, "US-ASCII"));
        msg.setSenderHost(new String(array, index += lengthSender, lengthSenderHost, "US-ASCII"));
        msg.setSubject(new String(array, index += lengthSenderHost, lengthSubject, "US-ASCII"));
        msg.setType(new String(array, index += lengthSubject, lengthType, "US-ASCII"));
        index += lengthType;
        if (lengthPayloadTxt > 0) {
            String s = new String(array, index, lengthPayloadTxt, "US-ASCII");
            index += lengthPayloadTxt;
            try {
                msg.setFieldsFromText(s, 2);
            }
            catch (cMsgException e) {
                System.out.println("msg payload is in the wrong format: " + e.getMessage());
            }
        }
        if (lengthText > 0) {
            msg.setText(new String(array, index, lengthText, "US-ASCII"));
            index += lengthText;
        }
        if (lengthBinary > 0) {
            try {
                msg.setByteArray(array, index, lengthBinary);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        msg.setDomain(this.domainType);
        msg.setReceiver(this.client.getName());
        msg.setReceiverHost(this.client.getHost());
        msg.setReceiverTime(new Date());
        return msg;
    }

    private cMsgMessageFull readIncomingMessage() throws IOException {
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setVersion(this.in.readInt());
        this.in.skipBytes(4);
        msg.setUserInt(this.in.readInt());
        msg.setInfo(this.in.readInt() | 0x10 | 0x40);
        long time = (long)this.in.readInt() << 32 | (long)this.in.readInt() & 0xFFFFFFFFL;
        msg.setSenderTime(new Date(time));
        time = (long)this.in.readInt() << 32 | (long)this.in.readInt() & 0xFFFFFFFFL;
        msg.setUserTime(new Date(time));
        msg.setSysMsgId(this.in.readInt());
        msg.setSenderToken(this.in.readInt());
        int lengthSender = this.in.readInt();
        int lengthSenderHost = this.in.readInt();
        int lengthSubject = this.in.readInt();
        int lengthType = this.in.readInt();
        int lengthPayloadText = this.in.readInt();
        int lengthText = this.in.readInt();
        int lengthBinary = this.in.readInt();
        int stringBytesToRead = lengthSender + lengthSenderHost + lengthSubject + lengthType + lengthPayloadText + lengthText;
        int offset = 0;
        if (stringBytesToRead > this.bytes.length) {
            this.bytes = new byte[stringBytesToRead];
        }
        this.in.readFully(this.bytes, 0, stringBytesToRead);
        msg.setSender(new String(this.bytes, offset, lengthSender, "US-ASCII"));
        msg.setSenderHost(new String(this.bytes, offset += lengthSender, lengthSenderHost, "US-ASCII"));
        msg.setSubject(new String(this.bytes, offset += lengthSenderHost, lengthSubject, "US-ASCII"));
        msg.setType(new String(this.bytes, offset += lengthSubject, lengthType, "US-ASCII"));
        offset += lengthType;
        if (lengthPayloadText > 0) {
            String s = new String(this.bytes, offset, lengthPayloadText, "US-ASCII");
            offset += lengthPayloadText;
            try {
                msg.setFieldsFromText(s, 2);
            }
            catch (cMsgException e) {
                System.out.println("msg payload is in the wrong format: " + e.getMessage());
            }
        }
        if (lengthText > 0) {
            msg.setText(new String(this.bytes, offset, lengthText, "US-ASCII"));
            offset += lengthText;
        }
        if (lengthBinary > 0) {
            byte[] b = new byte[lengthBinary];
            this.in.readFully(b, 0, lengthBinary);
            try {
                msg.setByteArrayNoCopy(b, 0, lengthBinary);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        msg.setDomain(this.domainType);
        msg.setReceiver(this.client.getName());
        msg.setReceiverHost(this.client.getHost());
        msg.setReceiverTime(new Date());
        return msg;
    }

    private String[] readClientNamesAndNamespaces() throws IOException {
        int offset = 0;
        int stringBytesToRead = 0;
        int numberOfStrings = this.in.readInt();
        int[] lengths = new int[numberOfStrings];
        String[] names = new String[numberOfStrings];
        for (int i = 0; i < numberOfStrings; ++i) {
            lengths[i] = this.in.readInt();
            stringBytesToRead += lengths[i];
        }
        byte[] bytes = new byte[stringBytesToRead];
        this.in.readFully(bytes, 0, stringBytesToRead);
        for (int i = 0; i < numberOfStrings; ++i) {
            names[i] = new String(bytes, offset, lengths[i], "US-ASCII");
            offset += lengths[i];
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallbacks(cMsgMessageFull msg) {
        ConcurrentHashMap<cMsgSubscription, String> map;
        if (this.client.subscribeAndGets.size() > 0) {
            Iterator<cMsgSubscription> i = this.client.subscribeAndGets.values().iterator();
            while (i.hasNext()) {
                cMsgSubscription sub = i.next();
                if (sub.matches(msg.getSubject(), msg.getType())) {
                    sub.setTimedOut(false);
                    sub.setMessage(msg.copy());
                    cMsgSubscription cMsgSubscription2 = sub;
                    synchronized (cMsgSubscription2) {
                        sub.notify();
                    }
                }
                i.remove();
            }
        }
        if ((map = this.client.subscriptions).size() > 0) {
            if (!this.client.isReceiving()) {
                if (this.debug >= 4) {
                    System.out.println("runCallbacks: all subscription callbacks have been stopped");
                }
                return;
            }
            for (cMsgSubscription sub : map.keySet()) {
                if (!sub.matches(msg.getSubject(), msg.getType())) continue;
                for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                    cbThread.sendMessage(msg);
                }
            }
        }
    }

    private void runServerCallbacks(cMsgMessageFull msg) {
        cMsgSendAndGetCallbackThread cbThread = this.serverClient.serverSendAndGets.remove(msg.getSenderToken());
        this.serverClient.serverSendAndGetCancel.remove(msg.getSenderToken());
        if (cbThread == null) {
            return;
        }
        cbThread.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeGets(cMsgMessageFull msg) {
        cMsgGetHelper helper = this.client.sendAndGets.remove(msg.getSenderToken());
        if (helper == null) {
            return;
        }
        helper.setTimedOut(false);
        helper.setMessage(msg);
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeSyncSends(int response, int ssid) {
        cMsgGetHelper helper = this.client.syncSends.remove(ssid);
        if (helper == null) {
            return;
        }
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.setTimedOut(false);
            helper.setIntVal(response);
            helper.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeGetClientNames(String[] names) {
        this.serverClient.clientNamesAndNamespaces = names;
        cMsgGetHelper helper = this.serverClient.clientNamesHelper;
        if (helper == null) {
            return;
        }
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeCloudLock(int response) {
        this.serverClient.gotCloudLock.set(response == 1);
        cMsgGetHelper helper = this.serverClient.cloudLockHelper;
        if (helper == null) {
            return;
        }
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeRegistrationLock(int response) {
        this.serverClient.gotRegistrationLock.set(response == 1);
        cMsgGetHelper helper = this.serverClient.registrationLockHelper;
        if (helper == null) {
            return;
        }
        cMsgGetHelper cMsgGetHelper2 = helper;
        synchronized (cMsgGetHelper2) {
            helper.notify();
        }
    }
}

