/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.cMsgMonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jlab.coda.cMsg.cMsgDomain.cMsgMonitor.MonitorPanel;
import org.jlab.coda.cMsg.cMsgException;

public class Monitor
extends JPanel {
    JTabbedPane tabbedPane;
    private JComboBox comboBox;
    final Map<String, MonitorPanel> monitors = Collections.synchronizedMap(new HashMap(20));

    public Monitor() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        Dimension frameSize = new Dimension(600, 800);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.tabbedPane.setPreferredSize(frameSize);
        this.add((Component)this.tabbedPane, "Center");
        JPanel p = this.makeTopPanel();
        this.add((Component)p, "North");
        this.tabbedPane.addTab("Help", null, this.makeHelpPane(), "help");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("cMsg Monitor");
        Monitor mainPanel = new Monitor();
        frame.getContentPane().add((Component)mainPanel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private JPanel makeTopPanel() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selectedItem = (String)jcb.getSelectedItem();
                int numItems = jcb.getItemCount();
                boolean addNewItem = true;
                if (selectedItem == null || selectedItem.equals("")) {
                    addNewItem = false;
                } else if (numItems == 0) {
                    addNewItem = true;
                } else {
                    for (int i = 0; i < numItems; ++i) {
                        String listItem = (String)jcb.getItemAt(i);
                        if (!listItem.equals(selectedItem)) continue;
                        addNewItem = false;
                        break;
                    }
                }
                if (addNewItem) {
                    jcb.addItem(selectedItem);
                }
            }
        };
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.0f);
        EmptyBorder eb = new EmptyBorder(10, 10, 10, 10);
        BevelBorder bb = new BevelBorder(1);
        CompoundBorder cb3 = new CompoundBorder(eb, bb);
        panel.setBorder(cb3);
        JButton monitorButton = new JButton("Monitor");
        monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorPanel p;
                String udl = (String)Monitor.this.comboBox.getSelectedItem();
                if (Monitor.this.monitors.containsKey(udl)) {
                    return;
                }
                try {
                    p = new MonitorPanel(udl, Monitor.this);
                }
                catch (cMsgException e1) {
                    System.out.println("CANNOT connect to " + udl);
                    JOptionPane.showMessageDialog(new JFrame(), "Cannot connect to " + udl, "Error", 0);
                    return;
                }
                Monitor.this.monitors.put(udl, p);
                Monitor.this.tabbedPane.addTab(udl, null, p, udl);
            }
        });
        JLabel label = new JLabel("  UDL : ");
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.addActionListener(al);
        this.comboBox.addItem("cMsg://localhost/cMsg/myNameSpace");
        JButton removeUDL = new JButton("X");
        removeUDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.comboBox.getSelectedIndex();
                if (index > 0) {
                    Monitor.this.comboBox.removeItemAt(index);
                }
            }
        });
        removeUDL.setAlignmentX(0.0f);
        panel.add(monitorButton);
        panel.add(label);
        panel.add(this.comboBox);
        panel.add(removeUDL);
        return panel;
    }

    private JScrollPane makeHelpPane() {
        JTextArea text = new JTextArea(10, 200);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setTabSize(3);
        text.setEditable(false);
        text.setBorder(new EmptyBorder(20, 20, 20, 20));
        JScrollPane pane = new JScrollPane(text);
        text.append("CONNECTING TO AN CMSG SERVER\nType in the UDL or Universial Domain Locator in the text area above. Then hit the \"Monitor\" button to attempt a connection to the cMsgserver. If the attempt was successful, a new tabbed pane will appear with monitoring information about not only that server but the entire cloud of servers that server may be a part of. The data should be updated every 2 seconds.");
        return pane;
    }
}

