/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class cMsgGetResponder {
    private String subject = "SUBJECT";
    private String type = "TYPE";
    private String name = "getResponder";
    private String description = "java getResponder";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;
    private long count;
    private cMsg coda;

    cMsgGetResponder(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgGetResponder.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgGetResponder.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgGetResponder\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       subscribe to msgs with this subject\n        [-t <type>]          subscribe to msgs with this type\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgGetResponder getResponder = new cMsgGetResponder(args);
            getResponder.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg getResponder subscribed to:\n    subject = " + this.subject + "\n    type    = " + this.type);
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        myCallback cb3 = new myCallback();
        this.coda.subscribe(this.subject, this.type, cb3, null);
        long totalT = 0L;
        long totalC = 0L;
        long period = 5000L;
        while (true) {
            this.count = 0L;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double freq = (double)this.count / (double)period * 1000.0;
            double freqAvg = (double)(totalC += this.count) / (double)(totalT += period) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.count + ", " + cMsgGetResponder.doubleToString(freq, 0) + " Hz, Avg = " + cMsgGetResponder.doubleToString(freqAvg, 0) + " Hz");
            }
            if (this.coda.isConnected()) continue;
            System.out.println("No longer connected to domain server, quitting");
            System.exit(-1);
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            block3: {
                try {
                    if (cMsgGetResponder.this.debug) {
                        System.out.println("Received msg in callback, sending get response!");
                    }
                    cMsgMessage sendMsg = msg.response();
                    sendMsg.setSubject("RESPONDING");
                    sendMsg.setType("TO MESSAGE");
                    sendMsg.setText("responder's text");
                    cMsgGetResponder.this.coda.send(sendMsg);
                    cMsgGetResponder.this.coda.flush(0);
                    cMsgGetResponder.this.count++;
                }
                catch (cMsgException e) {
                    if (!cMsgGetResponder.this.debug) break block3;
                    System.out.println("Received message in callbace NOT generated by a sendAndGet");
                }
            }
        }
    }
}

