/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class cMsgGetConsumer {
    private String subject = "SUBJECT";
    private String type = "TYPE";
    private String name = "getConsumer";
    private String description = "java getConsumer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private String text = "TEXT";
    private char[] textChars;
    private int textSize;
    private int delay;
    private int count = 5000;
    private int timeout = 3000;
    private boolean send;
    private boolean debug;

    cMsgGetConsumer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgGetConsumer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-text")) {
                this.text = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-textsize")) {
                this.textSize = Integer.parseInt(args[i + 1]);
                this.textChars = new char[this.textSize];
                Arrays.fill(this.textChars, 'A');
                this.text = new String(this.textChars);
                System.out.println("text len = " + this.text.length());
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-to")) {
                this.timeout = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-send")) {
                this.send = true;
                continue;
            }
            cMsgGetConsumer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgGetConsumer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of subscription/sent messages\n        [-t <type>]          set type of subscription/sent messages\n        [-c <count>]         set # of messages to get before printing output\n        [-text <text>]       set text of sent messages\n        [-textsize <size>]   set text to 'size' number of ASCII chars (bytes)\n        [-to <time>]         set timeout\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-send]              use sendAndGet instead of subscribeAndGet\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgGetConsumer getConsumer = new cMsgGetConsumer(args);
            getConsumer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg getConsumer sending or subscribed to:\n    subject = " + this.subject + "\n    type    = " + this.type);
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.connect();
        coda.start();
        cMsgMessage sendMsg = new cMsgMessage();
        sendMsg.setSubject(this.subject);
        sendMsg.setType(this.type);
        sendMsg.setText(this.text);
        long totalT = 0L;
        long totalC = 0L;
        while (true) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                cMsgMessage msg;
                try {
                    msg = this.send ? coda.sendAndGet(sendMsg, this.timeout) : coda.subscribeAndGet(this.subject, this.type, this.timeout);
                }
                catch (TimeoutException e) {
                    if (this.send) {
                        System.out.println("Timeout in sendAndGet");
                        continue;
                    }
                    System.out.println("Timeout in subscribeAndGet");
                    continue;
                }
                if (msg == null) {
                    System.out.println("Got null message");
                }
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long t2 = System.currentTimeMillis();
            long deltaT = t2 - t1;
            double freq = (double)this.count / (double)deltaT * 1000.0;
            double freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += deltaT) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.count + ", " + cMsgGetConsumer.doubleToString(freq, 0) + " Hz, Avg = " + cMsgGetConsumer.doubleToString(freqAvg, 0) + " Hz");
            }
            if (coda.isConnected()) continue;
            System.out.println("No longer connected to domain server, quitting");
            System.exit(-1);
        }
    }
}

