/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.TCPSDomain;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;

public class TCPS
extends cMsgDomainAdapter {
    String tcpServerHost;
    int tcpServerPort;
    SocketChannel channel;
    DataOutputStream dataOut;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    Lock connectLock = this.methodLock.writeLock();
    Lock notConnectLock = this.methodLock.readLock();
    Lock socketLock = new ReentrantLock();

    public TCPS() {
        this.domain = "TCPS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws cMsgException {
        this.parseUDL(this.UDL);
        this.connectLock.lock();
        try {
            if (this.connected) {
                return;
            }
            AbstractInterruptibleChannel channel = null;
            try {
                channel = SocketChannel.open(new InetSocketAddress(this.tcpServerHost, this.tcpServerPort));
                Socket socket = ((SocketChannel)channel).socket();
                socket.setTcpNoDelay(true);
                socket.setSendBufferSize(2048);
                this.dataOut = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 2048));
            }
            catch (IOException e) {
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.debug >= 2) {
                    e.printStackTrace();
                }
                throw new cMsgException("connect: cannot create channel to TCPServer");
            }
            this.connected = true;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private void parseUDL(String udl) throws cMsgException {
        if (udl == null) {
            throw new cMsgException("invalid UDL");
        }
        String udlLowerCase = udl.toLowerCase();
        int index = udlLowerCase.indexOf("tcps://");
        if (index < 0) {
            throw new cMsgException("invalid UDL");
        }
        String udlSubstring = udl.substring(index + 7);
        Pattern pattern = Pattern.compile("([\\w\\.\\-]+)?:?(\\d+)?/?(.*)");
        Matcher matcher = pattern.matcher(udlSubstring);
        String udlHost = null;
        String udlPort = null;
        String udlRemainder = null;
        if (matcher.find()) {
            udlHost = matcher.group(1);
            udlPort = matcher.group(2);
            udlRemainder = matcher.group(3);
            if (this.debug >= 4) {
                System.out.println("\nparseUDL: \n  host      = " + udlHost + "\n  port      = " + udlPort + "\n  remainder = " + udlRemainder);
            }
        } else {
            throw new cMsgException("invalid UDL");
        }
        if (udlHost != null) {
            if (udlHost.equalsIgnoreCase("localhost")) {
                try {
                    udlHost = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                if (this.debug >= 3) {
                    System.out.println("parseUDL: TCPServer host given as \"localhost\", substituting " + udlHost);
                }
            } else {
                try {
                    udlHost = InetAddress.getByName(udlHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            this.host = udlHost;
        }
        if (udlPort != null && udlPort.length() > 0) {
            try {
                this.tcpServerPort = Integer.parseInt(udlPort);
            }
            catch (NumberFormatException e) {
                this.tcpServerPort = 45600;
                if (this.debug >= 3) {
                    System.out.println("parseUDL: non-integer port, guessing TCPServer port is " + this.tcpServerPort);
                }
            }
        } else {
            this.tcpServerPort = 45600;
            if (this.debug >= 3) {
                System.out.println("parseUDL: guessing TCPServer port is " + this.tcpServerPort);
            }
        }
        if (this.tcpServerPort < 1024 || this.tcpServerPort > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        this.UDLremainder = udlRemainder == null ? "" : udlRemainder;
    }

    @Override
    public void disconnect() {
        this.connectLock.lock();
        this.connected = false;
        try {
            this.socketLock.lock();
            try {
                this.channel.close();
                this.socketLock.unlock();
            }
            catch (IOException iOException) {
                this.socketLock.unlock();
            }
            catch (Throwable throwable) {
                this.socketLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(cMsgMessage message) throws cMsgException {
        String text = message.getText();
        if (text == null || text.length() < 1) {
            throw new cMsgException("Need to send a command in text field of message");
        }
        try {
            this.notConnectLock.lock();
            this.socketLock.lock();
            try {
                if (!this.connected) {
                    throw new IOException("not connected to server");
                }
                this.dataOut.writeInt(1);
                this.dataOut.writeInt(text.length());
                try {
                    this.dataOut.write(text.getBytes("US-ASCII"));
                    this.dataOut.writeByte(0);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.dataOut.flush();
            }
            finally {
                this.socketLock.unlock();
                this.notConnectLock.unlock();
            }
        }
        catch (IOException e) {
            throw new cMsgException(e.getMessage());
        }
    }
}

