/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.Utilities;

public class ReaderTest {
    static String compositeFile = "/home/timmer/evioTestFiles/xmlTests/composite.evio";
    static String regularXmlFile = "/home/timmer/evioTestFiles/xmlTests/regularEvent.xml";
    static String regularFile = "/home/timmer/evioTestFiles/xmlTests/regularEvent.evio";
    static String regularFile2 = "/home/timmer/evioTestFiles/xmlTests/regularEvent2.evio";
    static String smallXmlFile = "/home/timmer/evioTestFiles/xmlTests/regularEventSmall.xml";
    static String swappedFile = "/home/timmer/evioTestFiles/xmlTests/swappedEvent.evio";
    static String ver2File = "/home/timmer/evioTestFiles/evioV2format.ev";
    static String ver4File = "/home/timmer/evioTestFiles/evioV4format.ev";

    public static void main4(String[] args) {
        try {
            String xml = new String(Files.readAllBytes(Paths.get(regularXmlFile, new String[0])));
            System.out.println("\nXML:\n" + xml);
            System.out.println("Convert XML to EvioEvent:");
            List<EvioEvent> evList = Utilities.toEvents(xml);
            for (EvioEvent ev : evList) {
                System.out.println("\n\nEvioEvent ---> XML:\n" + ev.toXML());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main3(String[] args) {
        boolean hex = false;
        try {
            EvioNode node;
            EvioCompactReader fileReader = new EvioCompactReader(compositeFile);
            int evNum = 1;
            while ((node = fileReader.getScannedEvent(evNum++)) != null) {
                String xml = Utilities.toXML(node, hex);
                System.out.println("\nXML:\n" + xml);
                System.out.println("Convert XML to EvioEvent:");
                List<EvioEvent> evList = Utilities.toEvents(xml);
                System.out.println("\n\nev to XML:\n" + evList.get(0).toXML());
                System.out.println("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean hex = false;
        boolean compact = false;
        try {
            if (!compact) {
                EvioEvent event;
                EvioReader reader = new EvioReader(ver4File, false, true);
                int evNum = 1;
                while ((event = reader.parseNextEvent()) != null) {
                    System.out.println("XML event #" + evNum);
                    ++evNum;
                }
            } else {
                EvioCompactReader fileReader = new EvioCompactReader(ver2File);
                EvioNode node = fileReader.getScannedEvent(1);
                String xml = Utilities.toXML(node, hex);
                System.out.println("\nXML:\n" + xml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        try {
            EvioReader fileReader = new EvioReader(regularFile);
            System.out.println("TRY EvioReader.parseEvent(1)");
            EvioEvent event = fileReader.parseEvent(1);
            System.out.println("\nXML:\n" + event.toXML());
            System.out.println("Rewind ...");
            fileReader.rewind();
            System.out.println("TRY EvioReader.parseNextEvent()");
            event = fileReader.parseNextEvent();
            System.out.println("\nXML:\n" + event.toXML());
            fileReader.rewind();
            System.out.println("----------------------------------------------------------");
            System.out.println("----------------------SWAPPED-----------------------------");
            fileReader = new EvioReader(swappedFile);
            System.out.println("TRY EvioReader.parseEvent(1)");
            event = fileReader.parseEvent(1);
            System.out.println("\nXML:\n" + event.toXML());
            System.out.println("Rewind ...");
            fileReader.rewind();
            System.out.println("TRY EvioReader.parseNextEvent()");
            event = fileReader.parseNextEvent();
            System.out.println("\nXML:\n" + event.toXML());
            fileReader.rewind();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

