/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class GzipCompression {
    GzipCompression() {
    }

    public static void compressFile(File raw, File compressed) throws IOException {
        FileInputStream in = new FileInputStream(raw);
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(compressed));
        GzipCompression.shovelInToOut(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void decompressFile(File compressed, File raw) throws IOException {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(compressed));
        FileOutputStream out = new FileOutputStream(raw);
        GzipCompression.shovelInToOut(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void shovelInToOut(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1000];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void main(String[] args) throws IOException, DataFormatException {
        File compressed = new File("book1out.dfl");
        GzipCompression.compressFile(new File("book1"), compressed);
        GzipCompression.decompressFile(compressed, new File("decompressed.txt"));
    }
}

