/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressionTest {
    public static byte[] compress(byte[] data) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        System.out.println("Original: " + data.length + " Bytes");
        System.out.println("Compressed: " + output.length + " Bytes");
        return output;
    }

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        System.out.println("Original: " + data.length);
        System.out.println("Compressed: " + output.length);
        return output;
    }

    public static void main(String[] args) {
        byte[] originalData = new byte[2048];
        for (int i = 0; i < 2048; ++i) {
            originalData[i] = (byte)(i % 256);
        }
        byte[] original = new byte[]{};
        try {
            System.out.println("Call Deflater:");
            byte[] compressedData = CompressionTest.compress(originalData);
            System.out.println("Call Inflater:");
            original = CompressionTest.decompress(compressedData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 30; ++i) {
            System.out.println("data[" + i + "] = " + original[i]);
        }
        System.out.println("Done compressing and decompressing data");
    }
}

