/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.EvioXMLDictionary;

public final class Utilities {
    public static final int powerOfTwo(int x, boolean roundUp) {
        int y;
        if (x < 0) {
            return -1;
        }
        if (roundUp) {
            --x;
            x |= x >> 1;
            x |= x >> 2;
            x |= x >> 4;
            x |= x >> 8;
            x |= x >> 16;
            return x + 1;
        }
        do {
            y = x;
        } while ((x &= x - 1) != 0);
        return y;
    }

    public static final int generateBaseFileName(String baseName, String runType, StringBuilder newNameBuilder) throws EvioException {
        String baseFileName;
        StringBuffer result;
        Matcher matcher;
        Pattern pattern;
        if (baseName == null || newNameBuilder == null) {
            throw new EvioException("null arg(s)");
        }
        String string = baseName = runType == null ? baseName.replace("%s", "") : baseName.replace("%s", runType);
        if (baseName.contains("$(")) {
            pattern = Pattern.compile("\\$\\((.*?)\\)");
            matcher = pattern.matcher(baseName);
            result = new StringBuffer(100);
            while (matcher.find()) {
                String envVar = matcher.group(1);
                String envVal = System.getenv(envVar);
                if (envVal == null) {
                    envVal = "";
                }
                matcher.appendReplacement(result, envVal);
            }
            matcher.appendTail(result);
            baseFileName = result.toString();
        } else {
            baseFileName = baseName;
        }
        pattern = Pattern.compile("%(\\d*)([xd])");
        matcher = pattern.matcher(baseFileName);
        result = new StringBuffer(100);
        int specifierCount = 0;
        while (matcher.find()) {
            String width = matcher.group(1);
            if (width.length() > 0 && !width.startsWith("0")) {
                String newWidth = "0" + width;
                matcher.appendReplacement(result, "%" + newWidth + matcher.group(2));
            }
            ++specifierCount;
        }
        matcher.appendTail(result);
        baseFileName = result.toString();
        if (specifierCount > 2) {
            throw new EvioException("baseName arg is improperly formatted");
        }
        newNameBuilder.delete(0, newNameBuilder.length()).append(baseFileName);
        return specifierCount;
    }

    public static final String generateFileName(String baseFileName, int specifierCount, int runNumber, long split, int splitNumber) throws IllegalFormatException {
        return Utilities.generateFileName(baseFileName, specifierCount, runNumber, split, splitNumber, 0);
    }

    public static final String generateFileName(String baseFileName, int specifierCount, int runNumber, long split, int splitNumber, int streamId) throws IllegalFormatException {
        String fileName = baseFileName;
        if (split > 0L) {
            if (specifierCount < 1) {
                fileName = baseFileName + "." + splitNumber;
            } else if (specifierCount == 1) {
                fileName = String.format(baseFileName, runNumber);
                fileName = fileName + "." + splitNumber;
            } else {
                fileName = String.format(baseFileName, runNumber, splitNumber);
            }
        } else if (specifierCount == 1) {
            fileName = String.format(baseFileName, runNumber);
        } else if (specifierCount == 2) {
            Pattern pattern = Pattern.compile("(%\\d*[xd])");
            Matcher matcher = pattern.matcher(fileName);
            StringBuffer result = new StringBuffer(100);
            if (matcher.find() && matcher.find()) {
                matcher.appendReplacement(result, "");
                matcher.appendTail(result);
                fileName = result.toString();
            }
            fileName = String.format(fileName, runNumber);
        }
        if (streamId > 0) {
            fileName = fileName + ".strm" + streamId;
        }
        return fileName;
    }

    public static final void bufferToFile(String fileName, ByteBuffer buf, boolean overWriteOK, boolean addBlockHeader) throws IOException, EvioException {
        if (fileName == null || buf == null) {
            throw new EvioException("null arg(s)");
        }
        File file = new File(fileName);
        if (!overWriteOK && file.exists() && file.isFile()) {
            throw new EvioException("File exists but over-writing not permitted, " + file.getPath());
        }
        int limit = buf.limit();
        int position = buf.position();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileChannel fileChannel = fileOutputStream.getChannel();
        if (addBlockHeader) {
            ByteBuffer blockHead = ByteBuffer.allocate(32);
            blockHead.order(buf.order());
            blockHead.putInt(8 + (limit - position) / 4);
            blockHead.putInt(1);
            blockHead.putInt(8);
            blockHead.putInt(1);
            blockHead.putInt(0);
            blockHead.putInt(516);
            blockHead.putInt(0);
            blockHead.putInt(-1059454720);
            blockHead.flip();
            fileChannel.write(blockHead);
        }
        fileChannel.write(buf);
        fileChannel.close();
        buf.limit(limit).position(position);
    }

    public static final void printBuffer(ByteBuffer buf, int position, int words, String label) {
        IntBuffer ibuf;
        if (buf == null) {
            System.out.println("printBuffer: buf arg is null");
            return;
        }
        int origPos = buf.position();
        buf.position(position);
        if (label != null) {
            System.out.println(label + ":");
        }
        words = words > (ibuf = buf.asIntBuffer()).capacity() ? ibuf.capacity() : words;
        for (int i = 0; i < words; ++i) {
            if (i % 5 == 0) {
                System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 5) + ") =  ");
            }
            System.out.print(String.format("%08x", ibuf.get(i)) + "  ");
        }
        System.out.println();
        System.out.println();
        buf.position(origPos);
    }

    public static final void printBufferBytes(ByteBuffer buf, int position, int bytes, String label) {
        if (buf == null) {
            System.out.println("printBuffer: buf arg is null");
            return;
        }
        int origPos = buf.position();
        buf.position(position);
        int n = bytes = bytes > buf.capacity() ? buf.capacity() : bytes;
        if (label != null) {
            System.out.println(label + ":");
        }
        for (int i = 0; i < bytes; ++i) {
            if (i % 20 == 0) {
                System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 20) + ") =  ");
            } else if (i % 4 == 0) {
                System.out.print("  ");
            }
            System.out.print(String.format("%02x", buf.get(i)));
        }
        System.out.println();
        System.out.println();
        buf.position(origPos);
    }

    public static final byte[] bankToBytes(EvioBank bank, ByteOrder order) {
        byte[] bankArray = new byte[bank.getTotalBytes()];
        ByteBuffer firstEventBuf = ByteBuffer.wrap(bankArray);
        firstEventBuf.order(order);
        bank.write(firstEventBuf);
        return bankArray;
    }

    public static final byte[] nodeToByteArray(EvioNode node) {
        ByteBuffer firstEventBuf = node.getStructureBuffer(true);
        return firstEventBuf.array();
    }

    public static final byte[] stringToBank(String string, int tag, int num, ByteOrder order) {
        byte[] rawBytes = BaseStructure.stringsToRawBytes(new String[]{string});
        byte[] bank = new byte[rawBytes.length + 8];
        try {
            ByteDataTransformer.toBytes(new int[]{rawBytes.length / 4 + 1, tag << 16 | DataType.CHARSTAR8.getValue() << 8 | num}, order, bank, 0);
        }
        catch (EvioException e) {
            // empty catch block
        }
        System.arraycopy(rawBytes, 0, bank, 8, rawBytes.length);
        return bank;
    }

    public static final EvioEvent nodeToEvent(EvioNode node) throws EvioException {
        EvioEvent event;
        if (node == null) {
            return null;
        }
        if (node.getTypeObj() != DataType.ALSOBANK && node.getTypeObj() != DataType.BANK) {
            throw new EvioException("node is not a bank");
        }
        int totalLen = node.len + 1 + 8;
        ByteBuffer buf = ByteBuffer.allocate(4 * totalLen);
        ByteBuffer eventBuf = node.getStructureBuffer(true);
        buf.order(eventBuf.order());
        buf.putInt(totalLen);
        buf.putInt(1);
        buf.putInt(8);
        buf.putInt(1);
        buf.putInt(0);
        buf.putInt(516);
        buf.putInt(0);
        buf.putInt(-1059454720);
        buf.put(eventBuf);
        buf.flip();
        try {
            EvioReader reader = new EvioReader(buf);
            event = reader.parseEvent(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EvioException("cannot parse node's buffer");
        }
        return event;
    }

    public static final List<EvioEvent> toEvents(String xmlString) throws EvioException {
        return Utilities.toEvents(xmlString, 0, 0, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final List<EvioEvent> toEvents(String xmlString, int maxEvents, int skip, EvioXMLDictionary dictionary, boolean debug) throws EvioException {
        if (xmlString == null) {
            return null;
        }
        ArrayDeque<EvioXmlLevel> xmlStack = new ArrayDeque<EvioXmlLevel>(10);
        EvioXmlLevel level = null;
        EventBuilder eb = new EventBuilder(null);
        StringReader sReader = new StringReader(xmlString);
        XMLInputFactory f = XMLInputFactory.newInstance();
        ArrayList<EvioEvent> eventList = new ArrayList<EvioEvent>();
        int eventCount = 0;
        boolean eventBeginning = true;
        boolean fileBeginning = true;
        boolean skipEvent = false;
        boolean haveDictionary = dictionary != null;
        try {
            XMLEventReader evReader = f.createXMLEventReader(sReader);
            while (evReader.hasNext()) {
                XMLEvent event = evReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        Attribute attr;
                        if (skipEvent) break;
                        StartElement se = event.asStartElement();
                        String name = se.getName().getLocalPart();
                        if (debug) {
                            System.out.println("START_ELEMENT " + name + ":");
                        }
                        DataType parentDataType = null;
                        if (level != null) {
                            parentDataType = level.dataTypeObj;
                            xmlStack.push(level);
                        }
                        level = new EvioXmlLevel();
                        level.parentDataTypeObj = parentDataType;
                        boolean inDictionary = false;
                        if (haveDictionary) {
                            Integer[] tagNum = dictionary.getTagNum(name);
                            if (tagNum != null) {
                                inDictionary = true;
                                level.tag = tagNum[0];
                                level.num = tagNum[1];
                                if (debug) {
                                    System.out.println("FOUND dict entry(" + name + "): tag = " + level.tag + ", num = " + level.num);
                                }
                            }
                            level.dataTypeObj = dictionary.getType(name);
                        }
                        Iterator<Attribute> it = se.getAttributes();
                        while (it.hasNext()) {
                            attr = it.next();
                            String attrName = attr.getName().getLocalPart();
                            String valStr = attr.getValue();
                            boolean hex = false;
                            if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
                                valStr = valStr.substring(2, valStr.length());
                                hex = true;
                            }
                            try {
                                if (attrName.equalsIgnoreCase("tag")) {
                                    if (hex) {
                                        level.tag = Integer.parseInt(valStr, 16);
                                        continue;
                                    }
                                    level.tag = Integer.parseInt(valStr);
                                    continue;
                                }
                                if (attrName.equalsIgnoreCase("num")) {
                                    if (hex) {
                                        level.num = Integer.parseInt(valStr, 16);
                                        continue;
                                    }
                                    level.num = Integer.parseInt(valStr);
                                    continue;
                                }
                                if (attrName.equalsIgnoreCase("ndata")) {
                                    if (hex) {
                                        level.nData = Integer.parseInt(valStr, 16);
                                        continue;
                                    }
                                    level.nData = Integer.parseInt(valStr);
                                    continue;
                                }
                                if (!attrName.equalsIgnoreCase("data_type")) continue;
                                int typ = hex ? Integer.parseInt(valStr, 16) : Integer.parseInt(valStr);
                                level.dataTypeObj = DataType.getDataType(typ);
                            }
                            catch (NumberFormatException e) {
                                throw new EvioException("attribute has non-numeric value in line " + event.getLocation().getLineNumber());
                            }
                        }
                        if (fileBeginning && !inDictionary && !name.equalsIgnoreCase("evio-data") && !name.equalsIgnoreCase("event")) {
                            throw new EvioException("file must start with <evio-data> or <event>");
                        }
                        if (name.equalsIgnoreCase("evio-data")) {
                            if (!fileBeginning) {
                                throw new EvioException("<evio-data> element must be at file beginning");
                            }
                            level = null;
                            fileBeginning = false;
                            break;
                        }
                        if (eventBeginning) {
                            if (!inDictionary && !name.equalsIgnoreCase("event")) {
                                throw new EvioException("event must start with <event> element, not " + name);
                            }
                            if (maxEvents > 0 && eventCount >= maxEvents + skip) {
                                if (!debug) return eventList;
                                System.out.println("Hit max # events, quitting");
                                return eventList;
                            }
                            if (skip > eventCount++) {
                                if (debug) {
                                    System.out.println("Skipping event #" + eventCount);
                                }
                                level = null;
                                skipEvent = true;
                                fileBeginning = false;
                                break;
                            }
                            attr = se.getAttributeByName(new QName("format"));
                            if (attr != null && !attr.getValue().equalsIgnoreCase("evio")) {
                                level = null;
                                skipEvent = true;
                                fileBeginning = false;
                                break;
                            }
                            int count = 1;
                            attr = se.getAttributeByName(new QName("count"));
                            if (attr != null) {
                                try {
                                    count = Integer.parseInt(attr.getValue());
                                }
                                catch (NumberFormatException e) {
                                    throw new EvioException("attribute has non-numeric value in line " + event.getLocation().getLineNumber());
                                }
                            }
                            eb = new EventBuilder(level.tag, level.dataTypeObj, level.num);
                            eb.getEvent().setEventNumber(count);
                            level.bs = eb.getEvent();
                            eventBeginning = false;
                            fileBeginning = false;
                            break;
                        }
                        if (name.equalsIgnoreCase("bank")) {
                            if (level.dataTypeObj == null) {
                                throw new EvioException("must specify data type at line " + event.getLocation().getLineNumber());
                            }
                            level.bs = new EvioBank(level.tag, level.dataTypeObj, level.num);
                            break;
                        }
                        if (name.equalsIgnoreCase("segment")) {
                            if (level.dataTypeObj == null) {
                                throw new EvioException("must specify data type at line " + event.getLocation().getLineNumber());
                            }
                            level.bs = new EvioSegment(level.tag, level.dataTypeObj);
                            break;
                        }
                        if (name.equalsIgnoreCase("tagsegment")) {
                            if (level.dataTypeObj == null) {
                                throw new EvioException("must specify data type at line " + event.getLocation().getLineNumber());
                            }
                            level.bs = new EvioTagSegment(level.tag, level.dataTypeObj);
                            break;
                        }
                        DataType dataType = Utilities.getDataType(name);
                        if (dataType == null) {
                            if (!inDictionary) throw new EvioException("unknown element, " + name + ", in line " + event.getLocation().getLineNumber());
                            if (level.dataTypeObj == null) {
                                throw new EvioException("dictionary entry for \"" + name + "\" does not specify data type at line " + event.getLocation().getLineNumber());
                            }
                        } else if (level.dataTypeObj == null) {
                            level.dataTypeObj = dataType;
                        } else if (level.dataTypeObj != dataType) {
                            throw new EvioException("mismatching data type: name = " + name + " and data_type = " + (Object)((Object)level.dataTypeObj) + " at line " + event.getLocation().getLineNumber());
                        }
                        if (level.parentDataTypeObj != null) {
                            switch (level.parentDataTypeObj) {
                                case BANK: 
                                case ALSOBANK: {
                                    level.bs = new EvioBank(level.tag, level.dataTypeObj, level.num);
                                    break;
                                }
                                case SEGMENT: 
                                case ALSOSEGMENT: {
                                    level.bs = new EvioSegment(level.tag, level.dataTypeObj);
                                    break;
                                }
                                case TAGSEGMENT: {
                                    level.bs = new EvioTagSegment(level.tag, level.dataTypeObj);
                                    break;
                                }
                                default: {
                                    throw new EvioException("parent container must be bank, seg or tagseg , in line " + event.getLocation().getLineNumber());
                                }
                            }
                        }
                        if (!name.equalsIgnoreCase("composite")) break;
                        Utilities.parseComposite(level, evReader);
                        break;
                    }
                    case 2: {
                        String name = event.asEndElement().getName().getLocalPart();
                        if (debug) {
                            System.out.println("END_ELEMENT " + name);
                        }
                        if (skipEvent) {
                            if (!name.equalsIgnoreCase("event")) break;
                            skipEvent = false;
                            break;
                        }
                        if (xmlStack.size() < 1) {
                            if (name.equalsIgnoreCase("evio-data")) break;
                            eventList.add(eb.getEvent());
                            eventBeginning = true;
                            level = null;
                            break;
                        }
                        EvioXmlLevel upLevel = (EvioXmlLevel)xmlStack.pop();
                        try {
                            eb.addChild(upLevel.bs, level.bs);
                        }
                        catch (EvioException e) {
                            // empty catch block
                        }
                        level = upLevel;
                        break;
                    }
                    case 4: {
                        Characters cs;
                        if (skipEvent || (cs = event.asCharacters()).isWhiteSpace()) break;
                        Utilities.parseData(level, cs.getData(), cs.getLocation());
                        break;
                    }
                    case 7: {
                        if (!debug) break;
                        System.out.println("START_DOCUMENT");
                        break;
                    }
                    case 8: {
                        if (!debug) break;
                        System.out.println("END_DOCUMENT");
                        break;
                    }
                }
            }
            return eventList;
        }
        catch (XMLStreamException e) {
            throw new EvioException(e);
        }
    }

    private static final void parseComposite(EvioXmlLevel level, XMLEventReader evReader) throws EvioException, XMLStreamException {
        String[] formats = new String[level.nData];
        CompositeData[] cdArray = new CompositeData[level.nData];
        CompositeData.Data[] cData = new CompositeData.Data[level.nData];
        int cDataCount = -1;
        int repeats = 1;
        ArrayList<String> strings = new ArrayList<String>();
        DataType dataType = null;
        boolean debug = false;
        boolean lookForFormat = false;
        block11: while (evReader.hasNext()) {
            XMLEvent event = evReader.nextEvent();
            boolean isComp = false;
            switch (event.getEventType()) {
                case 1: {
                    int tag;
                    String valStr;
                    Attribute attr;
                    StartElement se = event.asStartElement();
                    String name = se.getName().getLocalPart();
                    if (debug) {
                        System.out.println("    comp START_ELEMENT " + name + ":");
                    }
                    if (name.equalsIgnoreCase("comp")) {
                        cData[++cDataCount] = new CompositeData.Data();
                        isComp = true;
                    }
                    repeats = 1;
                    try {
                        attr = se.getAttributeByName(new QName("count"));
                        if (attr != null) {
                            repeats = Integer.parseInt(attr.getValue());
                        }
                        if ((attr = se.getAttributeByName(new QName("n"))) != null) {
                            repeats = Integer.parseInt(attr.getValue());
                            cData[cDataCount].addN(repeats);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new EvioException("attribute has non-numeric value in line " + se.getLocation().getLineNumber());
                    }
                    if (name.equalsIgnoreCase("format")) {
                        attr = se.getAttributeByName(new QName("tag"));
                        if (attr != null) {
                            try {
                                valStr = attr.getValue();
                                if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
                                    valStr = valStr.substring(2, valStr.length());
                                    tag = Integer.parseInt(valStr, 16);
                                } else {
                                    tag = Integer.parseInt(valStr);
                                }
                                cData[cDataCount].setFormatTag(tag);
                            }
                            catch (NumberFormatException e) {
                                throw new EvioException("attribute has non-numeric value in line " + se.getLocation().getLineNumber());
                            }
                        }
                        lookForFormat = true;
                        break;
                    }
                    if (name.equalsIgnoreCase("data")) {
                        try {
                            int num;
                            attr = se.getAttributeByName(new QName("tag"));
                            if (attr != null) {
                                valStr = attr.getValue();
                                if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
                                    valStr = valStr.substring(2, valStr.length());
                                    tag = Integer.parseInt(valStr, 16);
                                } else {
                                    tag = Integer.parseInt(valStr);
                                }
                                cData[cDataCount].setDataTag(tag);
                            }
                            if ((attr = se.getAttributeByName(new QName("num"))) == null) continue block11;
                            valStr = attr.getValue();
                            if (valStr.startsWith("0x") || valStr.startsWith("0X")) {
                                valStr = valStr.substring(2, valStr.length());
                                num = Integer.parseInt(valStr, 16);
                            } else {
                                num = Integer.parseInt(valStr);
                            }
                            cData[cDataCount].setDataNum(num);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new EvioException("attribute has non-numeric value in line " + se.getLocation().getLineNumber());
                        }
                    }
                    if (name.equalsIgnoreCase("row") || name.equalsIgnoreCase("repeat") || name.equalsIgnoreCase("paren")) break;
                    if (!isComp && Utilities.getDataType(name) == null) {
                        throw new EvioException("unknown element, " + name + ", in line " + se.getLocation().getLineNumber());
                    }
                    dataType = Utilities.getDataType(name);
                    if (dataType != DataType.CHARSTAR8) break;
                    strings.clear();
                    break;
                }
                case 2: {
                    String name = event.asEndElement().getName().getLocalPart();
                    if (debug) {
                        System.out.println("    comp END_ELEMENT :" + name);
                    }
                    if (name.equalsIgnoreCase("string")) {
                        String[] strs = new String[strings.size()];
                        strings.toArray(strs);
                        cData[cDataCount].addString(strs);
                        break;
                    }
                    if (!name.equalsIgnoreCase("comp") || cDataCount + 1 < level.nData) break;
                    for (int i = 0; i < level.nData; ++i) {
                        cdArray[i] = new CompositeData(formats[i], cData[i]);
                    }
                    level.bs.appendCompositeData(cdArray);
                    return;
                }
                case 4: {
                    Characters cs = event.asCharacters();
                    if (cs.isWhiteSpace()) break;
                    String s = cs.getData();
                    if (debug) {
                        System.out.println("    comp CHARACTERS:");
                        System.out.println("    " + s.trim());
                    }
                    if (lookForFormat) {
                        formats[cDataCount] = s.trim();
                        if (debug) {
                            System.out.println("      Format = " + formats[cDataCount]);
                        }
                        lookForFormat = false;
                        break;
                    }
                    if (dataType == null) {
                        throw new EvioException("Internal error: data type null, line " + cs.getLocation().getLineNumber());
                    }
                    if (dataType == DataType.CHARSTAR8) {
                        strings.add(s);
                        break;
                    }
                    Utilities.parseCompositeData(dataType, repeats, s, cData[cDataCount], cs.getLocation());
                    break;
                }
            }
        }
    }

    private static final void parseData(EvioXmlLevel level, String data, Location location) throws EvioException {
        String[] values = null;
        if (level.dataTypeObj != DataType.CHARSTAR8 && (values = data.trim().split("\\s+")).length != level.nData) {
            throw new EvioException("# data items: attribute = " + level.nData + ", actual = " + values.length + " in line " + location.getLineNumber() + ", col " + location.getColumnNumber());
        }
        try {
            switch (level.dataTypeObj) {
                case UCHAR8: {
                    byte[] bArray = new byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bArray[i] = (byte)Short.parseShort(val, 16);
                            continue;
                        }
                        bArray[i] = (byte)Short.parseShort(val);
                    }
                    try {
                        level.bs.appendByteData(bArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case CHAR8: {
                    byte[] bArray = new byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bArray[i] = Byte.parseByte(val, 16);
                            continue;
                        }
                        bArray[i] = Byte.parseByte(val);
                    }
                    try {
                        level.bs.appendByteData(bArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case USHORT16: {
                    short[] sArray = new short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            sArray[i] = (short)Integer.parseInt(val, 16);
                            continue;
                        }
                        sArray[i] = (short)Integer.parseInt(val);
                    }
                    try {
                        level.bs.appendShortData(sArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case SHORT16: {
                    short[] sArray = new short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            sArray[i] = Short.parseShort(val, 16);
                            continue;
                        }
                        sArray[i] = Short.parseShort(val);
                    }
                    try {
                        level.bs.appendShortData(sArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case UINT32: {
                    int[] iArray = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            iArray[i] = (int)Long.parseLong(val, 16);
                            continue;
                        }
                        iArray[i] = (int)Long.parseLong(val);
                    }
                    try {
                        level.bs.appendIntData(iArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case INT32: {
                    int[] iArray = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            iArray[i] = Integer.parseInt(val, 16);
                            continue;
                        }
                        iArray[i] = Integer.parseInt(val);
                    }
                    try {
                        level.bs.appendIntData(iArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case ULONG64: {
                    long[] lArray = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        BigInteger bg;
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bg = new BigInteger(val, 16);
                        } else {
                            bg = new BigInteger(val);
                        }
                        lArray[i] = bg.longValue();
                    }
                    try {
                        level.bs.appendLongData(lArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case LONG64: {
                    long[] lArray = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            lArray[i] = Long.parseLong(val, 16);
                            continue;
                        }
                        lArray[i] = Long.parseLong(val);
                    }
                    try {
                        level.bs.appendLongData(lArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case FLOAT32: {
                    float[] fArray = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        fArray[i] = Float.parseFloat(values[i]);
                    }
                    try {
                        level.bs.appendFloatData(fArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case DOUBLE64: {
                    double[] dArray = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        dArray[i] = Double.parseDouble(values[i]);
                    }
                    try {
                        level.bs.appendDoubleData(dArray);
                    }
                    catch (EvioException e) {}
                    break;
                }
                case CHARSTAR8: {
                    try {
                        level.bs.appendStringData(data);
                    }
                    catch (EvioException e) {}
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new EvioException(e.getMessage() + " in line " + location.getLineNumber() + ", col " + location.getColumnNumber());
        }
    }

    private static final void parseCompositeData(DataType dataType, int count, String data, CompositeData.Data cData, Location location) throws EvioException {
        String[] values;
        if (dataType != DataType.CHARSTAR8) {
            values = data.trim().split("\\s+");
            if (count != values.length) {
                throw new EvioException("# data items: attribute = " + count + ", actual = " + values.length + " in line " + location.getLineNumber() + ", col " + location.getColumnNumber());
            }
        } else {
            return;
        }
        try {
            switch (dataType) {
                case UCHAR8: {
                    byte[] bArray = new byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bArray[i] = (byte)Short.parseShort(val, 16);
                            continue;
                        }
                        bArray[i] = (byte)Short.parseShort(val);
                    }
                    cData.addUchar(bArray);
                    break;
                }
                case CHAR8: {
                    byte[] bArray = new byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bArray[i] = Byte.parseByte(val, 16);
                            continue;
                        }
                        bArray[i] = Byte.parseByte(val);
                    }
                    cData.addChar(bArray);
                    break;
                }
                case USHORT16: {
                    short[] sArray = new short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            sArray[i] = (short)Integer.parseInt(val, 16);
                            continue;
                        }
                        sArray[i] = (short)Integer.parseInt(val);
                    }
                    cData.addUshort(sArray);
                    break;
                }
                case SHORT16: {
                    short[] sArray = new short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            sArray[i] = Short.parseShort(val, 16);
                            continue;
                        }
                        sArray[i] = Short.parseShort(val);
                    }
                    cData.addShort(sArray);
                    break;
                }
                case UINT32: {
                    int[] iArray = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            iArray[i] = (int)Long.parseLong(val, 16);
                            continue;
                        }
                        iArray[i] = (int)Long.parseLong(val);
                    }
                    cData.addUint(iArray);
                    break;
                }
                case INT32: {
                    int[] iArray = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            iArray[i] = Integer.parseInt(val, 16);
                            continue;
                        }
                        iArray[i] = Integer.parseInt(val);
                    }
                    cData.addInt(iArray);
                    break;
                }
                case ULONG64: {
                    long[] lArray = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        BigInteger bg;
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            bg = new BigInteger(val, 16);
                        } else {
                            bg = new BigInteger(val);
                        }
                        lArray[i] = bg.longValue();
                    }
                    cData.addUlong(lArray);
                    break;
                }
                case LONG64: {
                    long[] lArray = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        String val = values[i];
                        if (val.startsWith("0x") || val.startsWith("0X")) {
                            val = val.substring(2, val.length());
                            lArray[i] = Long.parseLong(val, 16);
                            continue;
                        }
                        lArray[i] = Long.parseLong(val);
                    }
                    cData.addLong(lArray);
                    break;
                }
                case FLOAT32: {
                    float[] fArray = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        fArray[i] = Float.parseFloat(values[i]);
                    }
                    cData.addFloat(fArray);
                    break;
                }
                case DOUBLE64: {
                    double[] dArray = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        dArray[i] = Double.parseDouble(values[i]);
                    }
                    cData.addDouble(dArray);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new EvioException(e.getMessage() + " in line " + location.getLineNumber() + ", col " + location.getColumnNumber());
        }
    }

    public static final DataType getDataType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equalsIgnoreCase("int8")) {
            return DataType.CHAR8;
        }
        if (type.equalsIgnoreCase("uint8")) {
            return DataType.UCHAR8;
        }
        if (type.equalsIgnoreCase("int16")) {
            return DataType.SHORT16;
        }
        if (type.equalsIgnoreCase("uint16")) {
            return DataType.USHORT16;
        }
        if (type.equalsIgnoreCase("int32")) {
            return DataType.INT32;
        }
        if (type.equalsIgnoreCase("uint32")) {
            return DataType.UINT32;
        }
        if (type.equalsIgnoreCase("int64")) {
            return DataType.LONG64;
        }
        if (type.equalsIgnoreCase("uint64")) {
            return DataType.ULONG64;
        }
        if (type.equalsIgnoreCase("long64")) {
            return DataType.LONG64;
        }
        if (type.equalsIgnoreCase("ulong64")) {
            return DataType.ULONG64;
        }
        if (type.equalsIgnoreCase("float32")) {
            return DataType.FLOAT32;
        }
        if (type.equalsIgnoreCase("float64")) {
            return DataType.DOUBLE64;
        }
        if (type.equalsIgnoreCase("double64")) {
            return DataType.DOUBLE64;
        }
        if (type.equalsIgnoreCase("string")) {
            return DataType.CHARSTAR8;
        }
        if (type.equalsIgnoreCase("composite")) {
            return DataType.COMPOSITE;
        }
        if (type.equalsIgnoreCase("unknown32")) {
            return DataType.UNKNOWN32;
        }
        if (type.equalsIgnoreCase("tagsegment")) {
            return DataType.TAGSEGMENT;
        }
        if (type.equalsIgnoreCase("segment")) {
            return DataType.ALSOSEGMENT;
        }
        if (type.equalsIgnoreCase("bank")) {
            return DataType.ALSOBANK;
        }
        return null;
    }

    static final String increaseXmlIndent(String xmlIndent) {
        if (xmlIndent == null) {
            return "   ";
        }
        xmlIndent = xmlIndent + "   ";
        return xmlIndent;
    }

    static final String decreaseXmlIndent(String xmlIndent) {
        if (xmlIndent == null || xmlIndent.length() < 3) {
            return "";
        }
        xmlIndent = xmlIndent.substring(0, xmlIndent.length() - 3);
        return xmlIndent;
    }

    public static final String toXML(EvioNode node, boolean hex) {
        if (node == null) {
            return null;
        }
        StringWriter sWriter = null;
        try {
            sWriter = new StringWriter();
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sWriter);
            String xmlIndent = "";
            Utilities.nodeToString(node, xmlIndent, hex, xmlWriter);
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return sWriter.toString();
    }

    private static final void commonXMLStart(XMLStreamWriter xmlWriter, String xmlElementName, String xmlIndent) {
        try {
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeCharacters(xmlIndent);
            xmlWriter.writeStartElement(xmlElementName);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static final void commonXMLClose(XMLStreamWriter xmlWriter, String xmlIndent) {
        try {
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeCharacters(xmlIndent);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static final void nodeToString(EvioNode node, String xmlIndent, boolean hex, XMLStreamWriter xmlWriter) {
        DataType nodeType = node.getTypeObj();
        DataType dataType = node.getDataTypeObj();
        try {
            if (node.isEvent) {
                int totalLen = node.getLength() + 1;
                xmlIndent = Utilities.increaseXmlIndent(xmlIndent);
                xmlWriter.writeCharacters(xmlIndent);
                xmlWriter.writeComment(" Buffer " + node.getEventNumber() + " contains " + totalLen + " words (" + 4 * totalLen + " bytes)");
                Utilities.commonXMLStart(xmlWriter, "event", xmlIndent);
                xmlWriter.writeAttribute("format", "evio");
                xmlWriter.writeAttribute("count", "" + node.getEventNumber());
                if (node.getDataTypeObj().isStructure()) {
                    xmlWriter.writeAttribute("content", Utilities.getTypeName(dataType));
                }
                xmlWriter.writeAttribute("data_type", String.format("0x%x", node.getDataType()));
                xmlWriter.writeAttribute("tag", "" + node.getTag());
                xmlWriter.writeAttribute("num", "" + node.getNum());
                xmlWriter.writeAttribute("length", "" + node.getLength());
                xmlIndent = Utilities.increaseXmlIndent(xmlIndent);
                for (EvioNode n : node.childNodes) {
                    Utilities.nodeToString(n, xmlIndent, hex, xmlWriter);
                }
                xmlIndent = Utilities.decreaseXmlIndent(xmlIndent);
                Utilities.commonXMLClose(xmlWriter, xmlIndent);
                xmlWriter.writeCharacters("\n");
                xmlIndent = Utilities.decreaseXmlIndent(xmlIndent);
            } else if (dataType.isStructure()) {
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(xmlIndent);
                xmlWriter.writeStartElement(Utilities.getTypeName(nodeType));
                if (node.getDataTypeObj().isStructure()) {
                    xmlWriter.writeAttribute("content", Utilities.getTypeName(dataType));
                }
                xmlWriter.writeAttribute("data_type", String.format("0x%x", node.getDataType()));
                xmlWriter.writeAttribute("tag", "" + node.getTag());
                if (nodeType == DataType.BANK || nodeType == DataType.ALSOBANK) {
                    xmlWriter.writeAttribute("num", "" + node.getNum());
                }
                xmlWriter.writeAttribute("length", "" + node.getLength());
                xmlWriter.writeAttribute("ndata", "" + Utilities.getNumberDataItems(node));
                ArrayList<EvioNode> childNodes = node.getChildNodes();
                if (childNodes != null) {
                    xmlIndent = Utilities.increaseXmlIndent(xmlIndent);
                    for (EvioNode n : childNodes) {
                        Utilities.nodeToString(n, xmlIndent, hex, xmlWriter);
                    }
                    xmlIndent = Utilities.decreaseXmlIndent(xmlIndent);
                }
                Utilities.commonXMLClose(xmlWriter, xmlIndent);
            } else {
                xmlWriter.writeCharacters("\n");
                xmlWriter.writeCharacters(xmlIndent);
                xmlWriter.writeStartElement(Utilities.getTypeName(dataType));
                xmlWriter.writeAttribute("data_type", String.format("0x%x", node.getDataType()));
                xmlWriter.writeAttribute("tag", "" + node.getTag());
                if (nodeType == DataType.BANK || nodeType == DataType.ALSOBANK) {
                    xmlWriter.writeAttribute("num", "" + node.getNum());
                }
                xmlWriter.writeAttribute("length", "" + node.getLength());
                int count = Utilities.getNumberDataItems(node);
                xmlWriter.writeAttribute("ndata", "" + count);
                xmlIndent = Utilities.increaseXmlIndent(xmlIndent);
                Utilities.writeXmlData(node, count, xmlIndent, hex, xmlWriter);
                xmlIndent = Utilities.decreaseXmlIndent(xmlIndent);
                Utilities.commonXMLClose(xmlWriter, xmlIndent);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static final int getNumberDataItems(EvioNode node) {
        int numberDataItems = 0;
        if (node.getDataTypeObj().isStructure()) {
            numberDataItems = node.getDataLength();
        } else {
            DataType type = node.getDataTypeObj();
            switch (type) {
                case UCHAR8: 
                case CHAR8: 
                case UNKNOWN32: {
                    numberDataItems = 4 * node.getDataLength() - node.getPad();
                    break;
                }
                case USHORT16: 
                case SHORT16: {
                    numberDataItems = (4 * node.getDataLength() - node.getPad()) / 2;
                    break;
                }
                case UINT32: 
                case INT32: 
                case FLOAT32: {
                    numberDataItems = node.getDataLength();
                    break;
                }
                case ULONG64: 
                case LONG64: 
                case DOUBLE64: {
                    numberDataItems = node.getDataLength() / 2;
                    break;
                }
                case CHARSTAR8: {
                    String[] s = BaseStructure.unpackRawBytesToStrings(node.bufferNode.buffer, node.dataPos, 4 * node.dataLen);
                    if (s == null) {
                        numberDataItems = 0;
                        break;
                    }
                    numberDataItems = s.length;
                    break;
                }
                case COMPOSITE: {
                    numberDataItems = 1;
                    CompositeData[] compositeData = null;
                    try {
                        byte[] rawBytes = new byte[4 * node.dataLen];
                        ByteBuffer rawBuffer = ByteBuffer.wrap(rawBytes);
                        ByteBuffer buf = node.getByteData(true);
                        rawBuffer.put(buf).order(buf.order());
                        compositeData = CompositeData.parse(rawBytes, rawBuffer.order());
                    }
                    catch (EvioException e) {
                        e.printStackTrace();
                    }
                    if (compositeData == null) break;
                    numberDataItems = compositeData.length;
                    break;
                }
            }
        }
        return numberDataItems;
    }

    private static final String getTypeName(DataType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case CHAR8: {
                return "int8";
            }
            case UCHAR8: {
                return "uint8";
            }
            case SHORT16: {
                return "int16";
            }
            case USHORT16: {
                return "uint16";
            }
            case INT32: {
                return "int32";
            }
            case UINT32: {
                return "uint32";
            }
            case LONG64: {
                return "int64";
            }
            case ULONG64: {
                return "uint64";
            }
            case FLOAT32: {
                return "float32";
            }
            case DOUBLE64: {
                return "float64";
            }
            case CHARSTAR8: {
                return "string";
            }
            case COMPOSITE: {
                return "composite";
            }
            case UNKNOWN32: {
                return "unknown32";
            }
            case TAGSEGMENT: {
                return "tagsegment";
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                return "segment";
            }
            case BANK: 
            case ALSOBANK: {
                return "bank";
            }
        }
        return "unknown";
    }

    private static final void writeXmlData(EvioNode node, int count, String xmlIndent, boolean hex, XMLStreamWriter xmlWriter) {
        DataType dataTypeObj = node.getDataTypeObj();
        if (dataTypeObj.isStructure()) {
            return;
        }
        try {
            String indent = String.format("\n%s", xmlIndent);
            ByteBuffer buf = node.getByteData(true);
            switch (dataTypeObj) {
                case DOUBLE64: {
                    DoubleBuffer dbuf = buf.asDoubleBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%25.17g  ", dbuf.get(i));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case FLOAT32: {
                    FloatBuffer fbuf = buf.asFloatBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 4 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%15.8g  ", Float.valueOf(fbuf.get(i)));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case LONG64: {
                    LongBuffer lbuf = buf.asLongBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%016x  ", lbuf.get(i)) : String.format("%20d  ", lbuf.get(i));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case ULONG64: {
                    LongBuffer lbuf = buf.asLongBuffer();
                    for (int i = 0; i < count; ++i) {
                        String s;
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        if (hex) {
                            s = String.format("0x%016x  ", lbuf.get(i));
                        } else {
                            BigInteger bg = new BigInteger(1, ByteDataTransformer.toBytes(lbuf.get(i), ByteOrder.BIG_ENDIAN));
                            s = String.format("%20s  ", bg.toString());
                        }
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case INT32: {
                    IntBuffer ibuf = buf.asIntBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 4 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%08x  ", ibuf.get(i)) : String.format("%11d  ", ibuf.get(i));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case UINT32: {
                    IntBuffer ibuf = buf.asIntBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 4 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%08x  ", ibuf.get(i)) : String.format("%11d  ", (long)ibuf.get(i) & 0xFFFFFFFFL);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case SHORT16: {
                    ShortBuffer sbuf = buf.asShortBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 8 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%04x  ", sbuf.get(i)) : String.format("%6d  ", sbuf.get(i));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case USHORT16: {
                    ShortBuffer sbuf = buf.asShortBuffer();
                    for (int i = 0; i < count; ++i) {
                        if (i % 8 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%04x  ", sbuf.get(i)) : String.format("%6d  ", sbuf.get(i) & 0xFFFF);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case CHAR8: {
                    for (int i = 0; i < count; ++i) {
                        if (i % 8 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%02x  ", buf.get(i)) : String.format("%4d  ", buf.get(i));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case UCHAR8: 
                case UNKNOWN32: {
                    for (int i = 0; i < count; ++i) {
                        if (i % 8 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = hex ? String.format("0x%02x  ", buf.get(i)) : String.format("%4d  ", (short)buf.get(i) & 0xFF);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case CHARSTAR8: {
                    String[] stringdata = BaseStructure.unpackRawBytesToStrings(node.bufferNode.buffer, node.dataPos, 4 * node.dataLen);
                    if (stringdata == null) break;
                    for (String str : stringdata) {
                        xmlWriter.writeCharacters(indent);
                        xmlWriter.writeCData(str);
                    }
                    break;
                }
                case COMPOSITE: {
                    byte[] rawBytes = new byte[4 * node.dataLen];
                    ByteBuffer rawBuffer = ByteBuffer.wrap(rawBytes);
                    rawBuffer.put(buf).order(buf.order());
                    CompositeData[] compositeData = CompositeData.parse(rawBytes, buf.order());
                    if (compositeData == null) break;
                    for (CompositeData cd : compositeData) {
                        cd.toXML(xmlWriter, xmlIndent, hex);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class EvioXmlLevel {
        int nData;
        int tag = -1;
        int num;
        DataType dataTypeObj;
        DataType parentDataTypeObj;
        BaseStructure bs;

        private EvioXmlLevel() {
        }
    }
}

