/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EvioException;

public class MappedMemoryHandler {
    private int blockCount;
    private int eventCount;
    private int regionCount;
    private ArrayList<int[]> eventPositions = new ArrayList(20000);
    private ArrayList<ByteBuffer> regions = new ArrayList(20);
    private boolean evioErrorCondition;

    public boolean isEvioErrorCondition() {
        return this.evioErrorCondition;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getMapCount() {
        return this.regionCount;
    }

    public ByteBuffer getFirstMap() {
        return this.regions.get(0);
    }

    public ByteBuffer getByteBuffer(int eventNumber) {
        int[] evData = this.eventPositions.get(eventNumber);
        ByteBuffer buf = this.regions.get(evData[0]);
        buf.position(evData[1]);
        return buf;
    }

    public MappedMemoryHandler(FileChannel channel, ByteOrder byteOrder) throws IOException {
        long bytesUsed;
        long remainingSize;
        long prevBytesUsed = -1L;
        long offset = 0L;
        boolean smallFile = remainingSize <= Integer.MAX_VALUE;
        this.regionCount = 0;
        for (remainingSize = channel.size(); remainingSize > 0L; remainingSize -= bytesUsed) {
            if (remainingSize < 32L) {
                System.out.println("MappedMemoryHandler: bad evio format, extra " + remainingSize + " bytes at file end");
                this.evioErrorCondition = true;
                return;
            }
            long sz = Math.min(remainingSize, Integer.MAX_VALUE);
            MappedByteBuffer memoryMapBuf = channel.map(FileChannel.MapMode.READ_ONLY, offset, sz);
            memoryMapBuf.order(byteOrder);
            try {
                bytesUsed = this.generateEventPositions(memoryMapBuf, this.regionCount);
            }
            catch (EvioException e) {
                System.out.println("MappedMemoryHandler: bad evio format, stop parsing file");
                this.regions.add(memoryMapBuf);
                ++this.regionCount;
                this.evioErrorCondition = true;
                return;
            }
            if (smallFile && bytesUsed < remainingSize || bytesUsed == prevBytesUsed) {
                System.out.println("MappedMemoryHandler: bad evio format, likely last block not completely written, bytesUsed = " + bytesUsed + ", prev = " + prevBytesUsed);
                this.regions.add(memoryMapBuf);
                ++this.regionCount;
                this.evioErrorCondition = true;
                return;
            }
            prevBytesUsed = bytesUsed;
            this.regions.add(memoryMapBuf);
            ++this.regionCount;
            offset += bytesUsed;
        }
    }

    public MappedMemoryHandler(ByteBuffer evioBuf) {
        this.regionCount = 1;
        try {
            this.generateEventPositions(evioBuf, 0);
        }
        catch (EvioException e) {
            this.evioErrorCondition = true;
        }
        this.regions.add(evioBuf);
    }

    private long generateEventPositions(ByteBuffer byteBuffer, int regionNumber) throws EvioException {
        boolean firstBlock = true;
        boolean hasDictionary = false;
        int position = 0;
        int bytesLeft = byteBuffer.limit();
        while (bytesLeft > 0) {
            int byteLen;
            if (bytesLeft < 32) {
                return position;
            }
            int byteInfo = byteBuffer.getInt(position + 20);
            int blockSize = byteBuffer.getInt(position + 0);
            int blockHdrSize = byteBuffer.getInt(position + 8);
            int blockEventCount = byteBuffer.getInt(position + 12);
            int magicNum = byteBuffer.getInt(position + 28);
            if (magicNum != -1059454720) {
                throw new EvioException("Bad evio format: block header magic # incorrect");
            }
            if (blockSize < 8 || blockHdrSize < 8) {
                throw new EvioException("Bad evio format: (block: total len = " + blockSize + ", header len = " + blockHdrSize + ")");
            }
            if (4 * blockSize > bytesLeft) {
                return position;
            }
            ++this.blockCount;
            if (regionNumber == 0 && firstBlock) {
                hasDictionary = BlockHeaderV4.hasDictionary(byteInfo);
            }
            position += 4 * blockHdrSize;
            bytesLeft -= 4 * blockHdrSize;
            if (firstBlock && regionNumber == 0 && hasDictionary) {
                byteLen = 4 * (byteBuffer.getInt(position) + 1);
                if (byteLen < 4) {
                    throw new EvioException("Bad evio format: bad bank length");
                }
                position += byteLen;
                bytesLeft -= byteLen;
            }
            firstBlock = false;
            for (int i = 0; i < blockEventCount; ++i) {
                if (bytesLeft < 8) {
                    throw new EvioException("Bad evio format: not enough data to read event (bad bank len?)");
                }
                byteLen = 4 * (byteBuffer.getInt(position) + 1);
                if (byteLen < 4 || (bytesLeft -= byteLen) < 0) {
                    throw new EvioException("Bad evio format: bad bank length");
                }
                this.eventPositions.add(new int[]{regionNumber, position});
                ++this.eventCount;
                position += byteLen;
            }
        }
        return position;
    }
}

