/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioDictionaryEntry;
import org.jlab.coda.jevio.EvioDictionaryEntryType;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.INameProvider;
import org.jlab.coda.jevio.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EvioXMLDictionary
implements INameProvider {
    private static String DICT_TOP_LEVEL = "xmlDict";
    private static String ENTRY = "xmldumpDictEntry";
    private static String ENTRY_ALT = "dictEntry";
    private static String ENTRY_BANK = "bank";
    private static String ENTRY_LEAF = "leaf";
    private static String DESCRIPTION = "description";
    private static String FORMAT = "format";
    private static String TYPE = "type";
    private static String NAME = "name";
    private static String TAG = "tag";
    private static String NUM = "num";
    private static Pattern pattern = Pattern.compile("(\\d+)([ ]*-[ ]*(\\d+))?");
    private String delimiter = ".";
    public LinkedHashMap<EvioDictionaryEntry, String> tagNumMap = new LinkedHashMap(100);
    public LinkedHashMap<EvioDictionaryEntry, String> tagOnlyMap = new LinkedHashMap(20);
    public LinkedHashMap<EvioDictionaryEntry, String> tagRangeMap = new LinkedHashMap(20);
    private LinkedHashMap<String, EvioDictionaryEntry> reverseMap = new LinkedHashMap(100);
    private LinkedHashMap<String, EvioDictionaryEntry> tagNumReverseMap = new LinkedHashMap(100);
    private Node topLevelDoc;
    private String stringRepresentation;
    private String xmlRepresentation;

    public EvioXMLDictionary(File file) {
        this(EvioXMLDictionary.getDomObject(file));
    }

    public EvioXMLDictionary(File file, String delimiter) {
        this(EvioXMLDictionary.getDomObject(file), delimiter);
    }

    public EvioXMLDictionary(String xmlString) {
        this(EvioXMLDictionary.getDomObject(xmlString));
    }

    public EvioXMLDictionary(String xmlString, String delimiter) {
        this(EvioXMLDictionary.getDomObject(xmlString), delimiter);
    }

    public EvioXMLDictionary(Document domDocument) {
        this(domDocument, null);
    }

    public EvioXMLDictionary(Document domDocument, String delimiter) {
        Node topNode;
        NodeList list;
        if (domDocument == null) {
            return;
        }
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
        if ((list = domDocument.getElementsByTagName(DICT_TOP_LEVEL)).getLength() < 1) {
            return;
        }
        this.topLevelDoc = topNode = list.item(0);
        NodeList kidList = topNode.getChildNodes();
        if (kidList.getLength() < 1) {
            return;
        }
        for (int index = 0; index < kidList.getLength(); ++index) {
            NodeList children;
            Matcher matcher;
            Node node = kidList.item(index);
            if (node == null || !node.getNodeName().equalsIgnoreCase(ENTRY) && !node.getNodeName().equalsIgnoreCase(ENTRY_ALT) || !node.hasAttributes()) continue;
            Integer numEnd = null;
            Integer num = null;
            Integer tagEnd = null;
            Integer tag = null;
            boolean isNumRange = false;
            boolean isTagRange = false;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String numStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if (Utilities.getDataType(name) != null || name.equalsIgnoreCase("event") || name.equalsIgnoreCase("evio-data")) {
                System.out.println("IGNORING entry whose name conflicts with reserved strings: " + name);
                continue;
            }
            attrNode = map.getNamedItem(NUM);
            if (attrNode != null) {
                matcher = pattern.matcher(attrNode.getNodeValue());
                if (matcher.matches()) {
                    numStr = matcher.group(1);
                    try {
                        num = Integer.decode(numStr);
                    }
                    catch (NumberFormatException e) {
                        badEntry = true;
                    }
                    String numEndStr = matcher.group(3);
                    if (numEndStr != null) {
                        try {
                            numEnd = Integer.decode(numEndStr);
                            if (numEnd > 0 && !numEnd.equals(num)) {
                                isNumRange = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            badEntry = true;
                        }
                    } else {
                        numEnd = num;
                    }
                } else {
                    badEntry = true;
                }
            }
            if (numStr == null) {
                name = name.replaceAll("%n", "");
            }
            if ((attrNode = map.getNamedItem(TAG)) != null) {
                matcher = pattern.matcher(attrNode.getNodeValue());
                if (matcher.matches()) {
                    tagStr = matcher.group(1);
                    try {
                        tag = Integer.decode(tagStr);
                    }
                    catch (NumberFormatException e) {
                        badEntry = true;
                    }
                    String tagEndStr = matcher.group(3);
                    if (tagEndStr != null) {
                        try {
                            tagEnd = Integer.decode(tagEndStr);
                            if (tagEnd > 0 && !tagEnd.equals(tag)) {
                                isTagRange = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            badEntry = true;
                        }
                    }
                } else {
                    badEntry = true;
                }
            }
            if (isTagRange) {
                if (num != null) {
                    badEntry = true;
                } else {
                    name = name.replaceAll("%t", "");
                }
            } else {
                name = name.replaceAll("%t", tagStr);
            }
            attrNode = map.getNamedItem(TYPE);
            if (attrNode != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry 1: name = " + name);
                continue;
            }
            if (numStr == null && type != null) {
                System.out.println("IGNORING bad type for this dictionary entry: type = " + type);
                type = null;
            }
            if (numStr != null) {
                if (isNumRange && num > numEnd) {
                    int tmp = num;
                    num = numEnd;
                    numEnd = tmp;
                }
                String nameOrig = name;
                for (int n = num.intValue(); n <= numEnd; ++n) {
                    name = nameOrig.replaceAll("%n", n + "");
                    EvioDictionaryEntry key = new EvioDictionaryEntry(tag, n, tagEnd, type, description, format);
                    boolean entryAlreadyExists = true;
                    if (this.reverseMap.containsKey(name)) {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                        continue;
                    }
                    if (!this.tagNumMap.containsKey(key) && !this.tagNumReverseMap.containsKey(name)) {
                        this.tagNumMap.put(key, name);
                        this.tagNumReverseMap.put(name, key);
                        entryAlreadyExists = false;
                    } else {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                    }
                    if (entryAlreadyExists) continue;
                    this.reverseMap.put(name, key);
                }
                continue;
            }
            EvioDictionaryEntry key = new EvioDictionaryEntry(tag, null, tagEnd, type, description, format);
            boolean entryAlreadyExists = true;
            if (this.reverseMap.containsKey(name)) {
                System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                continue;
            }
            if (isTagRange) {
                if (!this.tagRangeMap.containsKey(key)) {
                    this.tagRangeMap.put(key, name);
                    entryAlreadyExists = false;
                } else {
                    System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                }
            } else if (!this.tagOnlyMap.containsKey(key)) {
                this.tagOnlyMap.put(key, name);
                entryAlreadyExists = false;
            } else {
                System.out.println("IGNORING duplicate dictionary entry: name = " + name);
            }
            if (entryAlreadyExists) continue;
            this.reverseMap.put(name, key);
        }
        this.addHierarchicalDictEntries(kidList, null);
    }

    public int size() {
        return this.tagNumMap.size();
    }

    public Map<String, EvioDictionaryEntry> getMap() {
        return Collections.unmodifiableMap(this.reverseMap);
    }

    private void addHierarchicalDictEntries(NodeList kidList, String parentName) {
        if (kidList == null || kidList.getLength() < 1) {
            return;
        }
        for (int i = 0; i < kidList.getLength(); ++i) {
            NodeList children;
            Matcher matcher;
            Node node = kidList.item(i);
            if (node == null) continue;
            boolean isLeaf = node.getNodeName().equalsIgnoreCase(ENTRY_LEAF);
            if (!node.getNodeName().equalsIgnoreCase(ENTRY_BANK) && !isLeaf || !node.hasAttributes()) continue;
            Integer numEnd = null;
            Integer num = null;
            Integer tagEnd = null;
            Integer tag = null;
            boolean isNumRange = false;
            boolean isTagRange = false;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String numStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if ((attrNode = map.getNamedItem(NUM)) != null) {
                matcher = pattern.matcher(attrNode.getNodeValue());
                if (matcher.matches()) {
                    numStr = matcher.group(1);
                    try {
                        num = Integer.decode(numStr);
                    }
                    catch (NumberFormatException e) {
                        badEntry = true;
                    }
                    String numEndStr = matcher.group(3);
                    if (numEndStr != null) {
                        try {
                            numEnd = Integer.decode(numEndStr);
                            if (numEnd > 0 && !numEnd.equals(num)) {
                                isNumRange = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            badEntry = true;
                        }
                    } else {
                        numEnd = num;
                    }
                } else {
                    badEntry = true;
                }
            }
            if (numStr == null) {
                name = name.replaceAll("%n", "");
            }
            if ((attrNode = map.getNamedItem(TAG)) != null) {
                matcher = pattern.matcher(attrNode.getNodeValue());
                if (matcher.matches()) {
                    tagStr = matcher.group(1);
                    try {
                        tag = Integer.decode(tagStr);
                    }
                    catch (NumberFormatException e) {
                        badEntry = true;
                    }
                    String tagEndStr = matcher.group(3);
                    if (tagEndStr != null) {
                        try {
                            tagEnd = Integer.decode(tagEndStr);
                            if (tagEnd > 0) {
                                isTagRange = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            badEntry = true;
                        }
                    }
                } else {
                    badEntry = true;
                }
            }
            if (isTagRange) {
                if (num != null) {
                    badEntry = true;
                } else {
                    name = name.replaceAll("%t", "");
                }
            } else {
                name = name.replaceAll("%t", tagStr);
            }
            attrNode = map.getNamedItem(TYPE);
            if (attrNode != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int j = 0; j < children.getLength(); ++j) {
                    Node childNode = children.item(j);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry 3: name = " + name);
                continue;
            }
            if (numStr == null && type != null) {
                System.out.println("IGNORING bad type for this dictionary entry: type = " + type);
                type = null;
            }
            if (numStr != null) {
                if (isNumRange && num > numEnd) {
                    int tmp = num;
                    num = numEnd;
                    numEnd = tmp;
                }
                String nameOrig = name;
                for (int n = num.intValue(); n <= numEnd; ++n) {
                    name = nameOrig.replaceAll("%n", n + "");
                    if (parentName != null) {
                        name = parentName + this.delimiter + name;
                    }
                    EvioDictionaryEntry parentEntry = null;
                    Node parentNode = node.getParentNode();
                    if (parentNode != null && parentNode.getNodeName().equals("bank")) {
                        parentEntry = (EvioDictionaryEntry)parentNode.getUserData("entry");
                    }
                    EvioDictionaryEntry key = new EvioDictionaryEntry(tag, n, tagEnd, type, description, format, parentEntry);
                    boolean entryAlreadyExists = true;
                    if (this.reverseMap.containsKey(name)) {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                        continue;
                    }
                    if (!this.tagNumMap.containsKey(key) && !this.tagNumReverseMap.containsKey(name)) {
                        this.tagNumMap.put(key, name);
                        this.tagNumReverseMap.put(name, key);
                        entryAlreadyExists = false;
                    } else {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                    }
                    if (entryAlreadyExists) continue;
                    node.setUserData("entry", key, null);
                    this.reverseMap.put(name, key);
                }
            } else {
                if (parentName != null) {
                    name = parentName + this.delimiter + name;
                }
                EvioDictionaryEntry parentEntry = null;
                Node parentNode = node.getParentNode();
                if (parentNode != null && parentNode.getNodeName().equals("bank")) {
                    parentEntry = (EvioDictionaryEntry)parentNode.getUserData("entry");
                }
                EvioDictionaryEntry key = new EvioDictionaryEntry(tag, null, tagEnd, type, description, format, parentEntry);
                boolean entryAlreadyExists = true;
                if (this.reverseMap.containsKey(name)) {
                    System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                } else {
                    if (isTagRange) {
                        if (!this.tagRangeMap.containsKey(key)) {
                            this.tagRangeMap.put(key, name);
                            entryAlreadyExists = false;
                        } else {
                            System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                        }
                    } else if (!this.tagOnlyMap.containsKey(key)) {
                        this.tagOnlyMap.put(key, name);
                        entryAlreadyExists = false;
                    } else {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                    }
                    if (!entryAlreadyExists) {
                        node.setUserData("entry", key, null);
                        this.reverseMap.put(name, key);
                    }
                }
            }
            if (!isLeaf) {
                this.addHierarchicalDictEntries(node.getChildNodes(), name);
                continue;
            }
            if (!node.hasChildNodes()) continue;
            System.out.println("IGNORING children of \"leaf\" element " + name);
        }
    }

    @Override
    public String getName(BaseStructure structure) {
        Integer tag = structure.getHeader().getTag();
        Integer num = structure.getHeader().getNumber();
        if (structure instanceof EvioSegment || structure instanceof EvioTagSegment) {
            num = null;
        }
        return this.getName(tag, num);
    }

    public String getName(Integer tag, Integer num) {
        return this.getName(tag, num, null);
    }

    public String getName(Integer tag, Integer num, Integer tagEnd, Integer pTag, Integer pNum, Integer pTagEnd) {
        if (tag == null) {
            return "???";
        }
        if (pTag == null) {
            return this.getName(tag, num, tagEnd);
        }
        EvioDictionaryEntry parentKey = new EvioDictionaryEntry(pTag, pNum, pTagEnd, null);
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num, tagEnd, null, null, null, parentKey);
        return this.getName(key);
    }

    public String getName(Integer tag, Integer num, Integer tagEnd) {
        if (tag == null) {
            return "???";
        }
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num, tagEnd, null);
        return this.getName(key);
    }

    private String getName(EvioDictionaryEntry key) {
        int tag = key.getTag();
        EvioDictionaryEntryType entryType = key.getEntryType();
        String name = "???";
        block0 : switch (entryType) {
            case TAG_NUM: {
                name = this.tagNumMap.get(key);
                if (name != null) break;
                key = new EvioDictionaryEntry(tag);
            }
            case TAG_ONLY: {
                name = this.tagOnlyMap.get(key);
                if (name != null) break;
                key = new EvioDictionaryEntry(tag, null, key.getTagEnd(), null);
            }
            case TAG_RANGE: {
                name = this.tagRangeMap.get(key);
                if (name != null || entryType == EvioDictionaryEntryType.TAG_RANGE) break;
                for (Map.Entry<EvioDictionaryEntry, String> item : this.tagRangeMap.entrySet()) {
                    EvioDictionaryEntry entry = item.getKey();
                    if (!entry.inRange(tag)) continue;
                    name = item.getValue();
                    break block0;
                }
                break;
            }
        }
        return name;
    }

    private EvioDictionaryEntry entryLookupByData(Integer tag, Integer num, Integer tagEnd) {
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num, tagEnd, null);
        EvioDictionaryEntryType entryType = key.getEntryType();
        EvioDictionaryEntry entry = null;
        block0 : switch (entryType) {
            case TAG_NUM: {
                String name = this.tagNumMap.get(key);
                if (name != null) {
                    entry = this.tagNumReverseMap.get(name);
                    break;
                }
                key = new EvioDictionaryEntry(tag);
            }
            case TAG_ONLY: {
                String n;
                String name = this.tagOnlyMap.get(key);
                if (name != null) {
                    for (Map.Entry<EvioDictionaryEntry, String> item : this.tagOnlyMap.entrySet()) {
                        n = item.getValue();
                        if (!n.equals(name)) continue;
                        entry = item.getKey();
                        break block0;
                    }
                }
                key = new EvioDictionaryEntry(tag, null, tagEnd, null);
            }
            case TAG_RANGE: {
                String n;
                String name = this.tagRangeMap.get(key);
                if (name != null) {
                    for (Map.Entry<EvioDictionaryEntry, String> item : this.tagRangeMap.entrySet()) {
                        n = item.getValue();
                        if (!n.equals(name)) continue;
                        entry = item.getKey();
                        break block0;
                    }
                } else {
                    if (entryType == EvioDictionaryEntryType.TAG_RANGE) break;
                    for (Map.Entry<EvioDictionaryEntry, String> item : this.tagRangeMap.entrySet()) {
                        EvioDictionaryEntry entry2 = item.getKey();
                        if (!entry2.inRange(tag)) continue;
                        entry = entry2;
                        break block0;
                    }
                }
                break;
            }
        }
        return entry;
    }

    private EvioDictionaryEntry entryLookupByName(String name) {
        EvioDictionaryEntry entry = this.reverseMap.get(name);
        if (entry != null) {
            return entry;
        }
        System.out.println("entryLookup: no entry for name = " + name);
        return null;
    }

    public String getDescription(Integer tag, Integer num) {
        return this.getDescription(tag, num, null);
    }

    public String getDescription(Integer tag, Integer num, Integer tagEnd) {
        EvioDictionaryEntry entry = this.entryLookupByData(tag, num, tagEnd);
        if (entry == null) {
            return null;
        }
        return entry.getDescription();
    }

    public String getDescription(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getDescription();
    }

    public String getFormat(int tag, int num) {
        return this.getFormat(tag, num, null);
    }

    public String getFormat(Integer tag, Integer num, Integer tagEnd) {
        EvioDictionaryEntry entry = this.entryLookupByData(tag, num, tagEnd);
        if (entry == null) {
            return null;
        }
        return entry.getFormat();
    }

    public String getFormat(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getFormat();
    }

    public DataType getType(Integer tag, Integer num) {
        return this.getType(tag, num, null);
    }

    public DataType getType(Integer tag, Integer num, Integer tagEnd) {
        EvioDictionaryEntry entry = this.entryLookupByData(tag, num, tagEnd);
        if (entry == null) {
            return null;
        }
        return entry.getType();
    }

    public DataType getType(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getType();
    }

    public Integer[] getTagNum(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry != null) {
            return new Integer[]{entry.getTag(), entry.getNum(), entry.getTagEnd()};
        }
        return null;
    }

    public Integer getTag(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getTag();
    }

    public Integer getTagEnd(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getTagEnd();
    }

    public Integer getNum(String name) {
        EvioDictionaryEntry entry = this.entryLookupByName(name);
        if (entry == null) {
            return null;
        }
        return entry.getNum();
    }

    private static Document getDomObject(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dom;
    }

    private static Document getDomObject(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dom;
    }

    public String toXML() {
        return this.nodeToString(this.topLevelDoc);
    }

    private String nodeToString(Node node) {
        if (this.xmlRepresentation != null) {
            return this.xmlRepresentation;
        }
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer t = transformerFactory.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        this.xmlRepresentation = sw.toString();
        return this.xmlRepresentation;
    }

    public String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        int row = 1;
        StringBuilder sb = new StringBuilder(4096);
        sb.append("-- Dictionary --\n\n");
        for (String name : this.reverseMap.keySet()) {
            EvioDictionaryEntry entry = this.reverseMap.get(name);
            Integer num = entry.getNum();
            Integer tag = entry.getTag();
            Integer tagEnd = entry.getTagEnd();
            switch (entry.getEntryType()) {
                case TAG_RANGE: {
                    sb.append(String.format("%-30s: tag range %d-%d\n", name, tag, tagEnd));
                    break;
                }
                case TAG_ONLY: {
                    sb.append(String.format("%-30s: tag %d\n", name, tag));
                    break;
                }
                case TAG_NUM: {
                    sb.append(String.format("%-30s: tag %d, num %d\n", name, tag, num));
                    break;
                }
            }
            if (row++ % 4 != 0) continue;
            sb.append("\n");
        }
        this.stringRepresentation = sb.toString();
        return this.stringRepresentation;
    }
}

