/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.Environment;
import org.jlab.coda.jevio.EvioFileTest;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;

public class Demo
implements IEvioListener {
    public static void main(String[] args) {
        BitSet bitInfo = new BitSet(24);
        bitInfo.set(3);
        bitInfo.set(5);
        int type = 0;
        for (int i = 0; i < 4; ++i) {
            boolean bitSet = bitInfo.get(i + 2);
            if (!bitSet) continue;
            type |= 1 << i;
        }
        System.out.println("Resulting int = 0x" + Integer.toHexString(type));
    }

    public static void main2(String[] args) {
        System.out.println("Test of EvioReader class.");
        String cwd = Environment.getInstance().getCurrentWorkingDirectory();
        String testEventFile = cwd + File.separator + "testdata" + File.separator + "out.ev";
        String testDictFile = cwd + File.separator + "testdata" + File.separator + "eviodict.xml";
        try {
            File file = new File(testEventFile);
            System.out.println("ev file: " + testEventFile + " size: " + file.length());
            EvioReader reader = new EvioReader(testEventFile);
            reader.getParser().addEvioListener(new Demo());
            NameProvider.setProvider(NameProviderFactory.createNameProvider(new File(testDictFile)));
            EvioFileTest.readAllBlockHeadersTest(reader);
            EvioFileTest.readAllEventsTest(reader);
            EvioFileTest.totalBlockCount(reader);
            EvioFileTest.parseEventsTest(reader, 1);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void startEventParse(BaseStructure evioEvent) {
    }

    @Override
    public void endEventParse(BaseStructure evioEvent) {
    }

    @Override
    public void gotStructure(BaseStructure evioEvent, IEvioStructure structure) {
        BaseStructureHeader header = structure.getHeader();
        System.out.println("------------------");
        System.out.println("" + structure);
        switch (header.getDataType()) {
            case DOUBLE64: {
                double[] doubledata;
                System.out.println("        DOUBLE VALS");
                for (double d : doubledata = structure.getDoubleData()) {
                    System.out.println("         " + d);
                }
                break;
            }
            case INT32: 
            case UINT32: {
                int[] intdata;
                System.out.println("        INT VALS");
                for (int i : intdata = structure.getIntData()) {
                    System.out.println("         " + i);
                }
                break;
            }
            case CHAR8: 
            case UCHAR8: {
                byte[] bytedata;
                System.out.println("        BYTE VALS");
                for (byte i : bytedata = structure.getByteData()) {
                    System.out.println("         " + i);
                }
                break;
            }
        }
    }
}

