/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteOrder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.IEvioWriter;

public abstract class BaseStructureHeader
implements Cloneable,
IEvioWriter {
    protected int length;
    protected int tag;
    protected DataType dataType;
    protected int padding;
    protected int number;

    public BaseStructureHeader() {
    }

    public BaseStructureHeader(int tag, DataType dataType) {
        this(tag, dataType, 0);
    }

    public BaseStructureHeader(int tag, DataType dataType, int num) {
        this.tag = tag;
        this.dataType = dataType;
        this.setNumber(num);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        if (number < 0) {
            number += 256;
        }
        this.number = number & 0xFF;
    }

    public int getDataTypeValue() {
        return this.dataType.getValue();
    }

    void setDataType(int dataType) {
        this.dataType = DataType.getDataType(dataType);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDataTypeName() {
        return this.dataType.name();
    }

    public int getPadding() {
        return this.padding;
    }

    protected void setPadding(int padding) {
        this.padding = padding;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public abstract int getHeaderLength();

    protected abstract void toArray(byte[] var1, int var2, ByteOrder var3);

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public String toString() {
        return String.format("structure length: %d\ndata type:   %s\ntag:         %d\npadding:     %d\n", this.length, this.getDataTypeName(), this.tag, this.padding);
    }

    public byte byteValue(Integer integer) {
        return integer.byteValue();
    }

    public short shortValue(Integer integer) {
        return integer.shortValue();
    }
}

