/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jlab.coda.hipo.RecordRingItem;

public class RecordSupply {
    private ByteOrder order;
    public final RingBuffer<RecordRingItem> ringBuffer;
    private int maxEventCount;
    private int maxBufferSize;
    private int compressionType;
    private int compressionThreadCount = 1;
    private final SequenceBarrier compressBarrier;
    private final Sequence[] compressSeqs;
    private long[] nextCompressSeqs;
    private long[] availableCompressSeqs;
    private final SequenceBarrier writeBarrier;
    private final Sequence writeSeq;
    private long nextWriteSeq;
    private long availableWriteSeq;

    public RecordSupply() {
        this(4, ByteOrder.LITTLE_ENDIAN, 1, 0, 0, 1);
    }

    public RecordSupply(int ringSize, ByteOrder order, int threadCount, int maxEventCount, int maxBufferSize, int compressionType) throws IllegalArgumentException {
        if (ringSize < 1 || Integer.bitCount(ringSize) != 1) {
            throw new IllegalArgumentException("ringSize must be a power of 2");
        }
        if (ringSize < threadCount) {
            throw new IllegalArgumentException("threadCount must be <= ringSize");
        }
        if (compressionType < 0 || compressionType > 3) {
            throw new IllegalArgumentException("compressionType must be 0,1,2,or 3");
        }
        if (threadCount > 0) {
            this.compressionThreadCount = threadCount;
        }
        this.order = order;
        this.maxEventCount = maxEventCount;
        this.maxBufferSize = maxBufferSize;
        this.compressionType = compressionType;
        this.ringBuffer = RingBuffer.createSingleProducer((EventFactory)new RecordFactory(), (int)ringSize, (WaitStrategy)new YieldingWaitStrategy());
        this.compressBarrier = this.ringBuffer.newBarrier(new Sequence[0]);
        this.compressSeqs = new Sequence[this.compressionThreadCount];
        this.nextCompressSeqs = new long[this.compressionThreadCount];
        this.availableCompressSeqs = new long[this.compressionThreadCount];
        Arrays.fill(this.availableCompressSeqs, -1L);
        for (int i = 0; i < this.compressionThreadCount; ++i) {
            this.compressSeqs[i] = new Sequence(-1L);
            this.nextCompressSeqs[i] = this.compressSeqs[i].get() + 1L + (long)i;
        }
        this.writeBarrier = this.ringBuffer.newBarrier(this.compressSeqs);
        this.writeSeq = new Sequence(-1L);
        this.nextWriteSeq = this.writeSeq.get() + 1L;
        this.availableWriteSeq = -1L;
        this.ringBuffer.addGatingSequences(new Sequence[]{this.writeSeq});
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public long getFillLevel() {
        return 100L * (this.ringBuffer.getCursor() - this.ringBuffer.getMinimumGatingSequence()) / (long)this.ringBuffer.getBufferSize();
    }

    public long getLastSequence() {
        return this.ringBuffer.getCursor();
    }

    public RecordRingItem get() {
        long getSequence = this.ringBuffer.next();
        RecordRingItem bufItem = (RecordRingItem)this.ringBuffer.get(getSequence);
        bufItem.reset();
        bufItem.fromProducer(getSequence);
        return bufItem;
    }

    public void publish(RecordRingItem item) {
        if (item == null) {
            return;
        }
        this.ringBuffer.publish(item.getSequence());
    }

    public RecordRingItem getToCompress(int threadNumber) throws InterruptedException {
        RecordRingItem item = null;
        try {
            if (this.availableCompressSeqs[threadNumber] < this.nextCompressSeqs[threadNumber]) {
                this.availableCompressSeqs[threadNumber] = this.compressBarrier.waitFor(this.nextCompressSeqs[threadNumber]);
            }
            item = (RecordRingItem)this.ringBuffer.get(this.nextCompressSeqs[threadNumber]);
            item.fromConsumer(this.nextCompressSeqs[threadNumber], this.compressSeqs[threadNumber]);
            int n = threadNumber;
            this.nextCompressSeqs[n] = this.nextCompressSeqs[n] + (long)this.compressionThreadCount;
        }
        catch (TimeoutException ex) {
            ex.printStackTrace();
        }
        catch (AlertException ex) {
            ex.printStackTrace();
        }
        return item;
    }

    public RecordRingItem getToWrite() throws InterruptedException {
        RecordRingItem item = null;
        try {
            if (this.availableWriteSeq < this.nextWriteSeq) {
                this.availableWriteSeq = this.writeBarrier.waitFor(this.nextWriteSeq);
            }
            item = (RecordRingItem)this.ringBuffer.get(this.nextWriteSeq);
            item.fromConsumer(this.nextWriteSeq++, this.writeSeq);
        }
        catch (TimeoutException ex) {
            ex.printStackTrace();
        }
        catch (AlertException ex) {
            ex.printStackTrace();
        }
        return item;
    }

    public void releaseCompressor(RecordRingItem item) {
        if (item == null) {
            return;
        }
        item.getSequenceObj().set(item.getSequence() + (long)this.compressionThreadCount - 1L);
    }

    public void releaseWriter(RecordRingItem item) {
        if (item == null) {
            return;
        }
        item.getSequenceObj().set(item.getSequence());
    }

    public void release(int threadNum, long sequenceNum) {
        this.compressSeqs[threadNum].set(sequenceNum);
    }

    private final class RecordFactory
    implements EventFactory<RecordRingItem> {
        private RecordFactory() {
        }

        public RecordRingItem newInstance() {
            return new RecordRingItem(RecordSupply.this.order, RecordSupply.this.maxEventCount, RecordSupply.this.maxBufferSize, RecordSupply.this.compressionType);
        }
    }
}

