/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import com.lmax.disruptor.Sequence;
import java.nio.ByteOrder;
import org.jlab.coda.hipo.RecordOutputStream;

public class RecordRingItem {
    private RecordOutputStream record;
    private final ByteOrder order;
    private long sequence;
    private Sequence sequenceObj;
    private volatile boolean splitFileAfterWrite;
    private volatile boolean forceToDisk;
    private volatile boolean lastItem;

    RecordRingItem(ByteOrder order, int maxEventCount, int maxBufferSize, int compressionType) {
        this.order = order;
        this.record = new RecordOutputStream(order, maxEventCount, maxBufferSize, compressionType);
    }

    public void reset() {
        this.record.reset();
        this.sequence = 0L;
        this.sequenceObj = null;
        this.lastItem = false;
        this.forceToDisk = false;
        this.splitFileAfterWrite = false;
    }

    public RecordOutputStream getRecord() {
        return this.record;
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public long getSequence() {
        return this.sequence;
    }

    public Sequence getSequenceObj() {
        return this.sequenceObj;
    }

    public void fromProducer(long seq) {
        this.sequence = seq;
    }

    public void fromConsumer(long seq, Sequence seqObj) {
        this.sequence = seq;
        this.sequenceObj = seqObj;
    }

    public boolean splitFileAfterWrite() {
        return this.splitFileAfterWrite;
    }

    public void splitFileAfterWrite(boolean split) {
        this.splitFileAfterWrite = split;
    }

    public boolean forceToDisk() {
        return this.forceToDisk;
    }

    public void forceToDisk(boolean force) {
        this.forceToDisk = force;
    }

    public boolean isLastItem() {
        return this.lastItem;
    }

    public void setLastItem(boolean last) {
        this.lastItem = last;
    }
}

