/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jlab.coda.hipo.HeaderType;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;

public class FileHeader {
    private static final int[] padValue = new int[]{0, 3, 2, 1};
    public static final int HIPO_FILE_UNIQUE_WORD = 1330661704;
    public static final int EVIO_FILE_UNIQUE_WORD = 1163282767;
    public static final int HEADER_SIZE_WORDS = 14;
    public static final int HEADER_SIZE_BYTES = 56;
    public static final int HEADER_MAGIC = -1059454720;
    static final int HEADER_MAGIC_LE = -1059454720;
    static final int HEADER_MAGIC_BE = Integer.reverseBytes(-1059454720);
    public static final int TRAILER_POSITION_OFFSET = 40;
    public static final int BIT_INFO_OFFSET = 20;
    static final int DICTIONARY_BIT = 256;
    static final int HAS_FIRST_EVENT_BIT = 512;
    static final int TRAILER_WITH_INDEX_BIT = 1024;
    private int fileId = 1330661704;
    private int fileNumber = 1;
    private long userRegister;
    private long trailerPosition;
    private int userIntFirst;
    private int userIntSecond;
    private long position;
    private HeaderType headerType = HeaderType.HIPO_FILE;
    private int entries;
    private int bitInfo = -1;
    private int headerLength = 56;
    private int headerLengthWords = 14;
    private int userHeaderLength;
    private int userHeaderLengthWords;
    private int indexLength;
    private int totalLength = 56;
    private int headerVersion = 6;
    private int headerMagicWord = -1059454720;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private int userHeaderLengthPadding;

    public FileHeader() {
    }

    public FileHeader(boolean isEvio) {
        if (isEvio) {
            this.fileId = 1163282767;
            this.headerType = HeaderType.EVIO_FILE;
        } else {
            this.fileId = 1330661704;
            this.headerType = HeaderType.HIPO_FILE;
        }
    }

    public void copy(FileHeader head) {
        if (head == null) {
            return;
        }
        this.fileId = head.fileId;
        this.fileNumber = head.fileNumber;
        this.userRegister = head.userRegister;
        this.trailerPosition = head.trailerPosition;
        this.userIntFirst = head.userIntFirst;
        this.userIntSecond = head.userIntSecond;
        this.position = head.position;
        this.totalLength = head.totalLength;
        this.headerType = head.headerType;
        this.entries = head.entries;
        this.bitInfo = head.bitInfo;
        this.headerLength = head.headerLength;
        this.headerLengthWords = head.headerLengthWords;
        this.userHeaderLength = head.userHeaderLength;
        this.userHeaderLengthWords = head.userHeaderLengthWords;
        this.indexLength = head.indexLength;
        this.headerMagicWord = head.headerMagicWord;
        this.userHeaderLengthPadding = head.userHeaderLengthPadding;
    }

    public void reset() {
        this.fileNumber = 1;
        this.userRegister = 0L;
        this.trailerPosition = 0L;
        this.userIntFirst = 0;
        this.userIntSecond = 0;
        this.position = 0L;
        this.entries = 0;
        this.bitInfo = -1;
        this.totalLength = 56;
        this.headerLength = 56;
        this.headerLengthWords = 14;
        this.userHeaderLength = 0;
        this.userHeaderLengthWords = 0;
        this.indexLength = 0;
        this.userHeaderLengthPadding = 0;
    }

    private static int getWords(int length) {
        int words = length / 4;
        if (FileHeader.getPadding(length) > 0) {
            ++words;
        }
        return words;
    }

    private static int getPadding(int length) {
        return padValue[length % 4];
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public int getFileId() {
        return this.fileId;
    }

    public long getUserRegister() {
        return this.userRegister;
    }

    public long getTrailerPosition() {
        return this.trailerPosition;
    }

    public int getUserIntFirst() {
        return this.userIntFirst;
    }

    public int getUserIntSecond() {
        return this.userIntSecond;
    }

    public long getPosition() {
        return this.position;
    }

    public int getEntries() {
        return this.entries;
    }

    public int getUserHeaderLength() {
        return this.userHeaderLength;
    }

    public int getUserHeaderLengthWords() {
        return this.userHeaderLengthWords;
    }

    public int getVersion() {
        return this.headerVersion;
    }

    public int getIndexLength() {
        return this.indexLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public int getLength() {
        return this.totalLength;
    }

    public int getBitInfoWord() {
        if (this.bitInfo < 0) {
            this.setBitInfo(false, false, false);
        }
        return this.bitInfo;
    }

    public int setBitInfo(boolean haveFirst, boolean haveDictionary, boolean haveTrailerWithIndex) {
        this.bitInfo = this.headerType.getValue() << 28 | this.userHeaderLengthPadding << 20 | this.headerVersion & 0xFF;
        if (haveFirst) {
            this.bitInfo |= 0x200;
        }
        if (haveDictionary) {
            this.bitInfo |= 0x100;
        }
        if (haveTrailerWithIndex) {
            this.bitInfo |= 0x400;
        }
        return this.bitInfo;
    }

    void setBitInfoWord(int word) {
        this.bitInfo = word;
        this.decodeBitInfoWord(word);
    }

    private void decodeBitInfoWord(int word) {
        this.userHeaderLengthPadding = word >>> 20 & 3;
        this.headerType = HeaderType.getHeaderType(word >>> 28);
        if (this.headerType == null) {
            this.headerType = HeaderType.EVIO_RECORD;
        }
    }

    public boolean hasFirstEvent() {
        return (this.bitInfo & 0x200) != 0;
    }

    public boolean hasDictionary() {
        return (this.bitInfo & 0x100) != 0;
    }

    public boolean hasUserHeader() {
        return this.userHeaderLength > 0;
    }

    public boolean hasIndex() {
        return this.indexLength > 3 && this.indexLength % 4 == 0;
    }

    public boolean hasTrailerWithIndex() {
        return (this.bitInfo & 0x400) != 0;
    }

    public FileHeader setFileNumber(int num) {
        this.fileNumber = num;
        return this;
    }

    public FileHeader setUserRegister(long val) {
        this.userRegister = val;
        return this;
    }

    public FileHeader setUserIntFirst(int val) {
        this.userIntFirst = val;
        return this;
    }

    public FileHeader setUserIntSecond(int val) {
        this.userIntSecond = val;
        return this;
    }

    FileHeader setHeaderType(HeaderType type) {
        this.headerType = type;
        return this;
    }

    public FileHeader setPosition(long pos) {
        this.position = pos;
        return this;
    }

    public FileHeader setIndexLength(int length) {
        this.totalLength -= this.indexLength;
        this.indexLength = length / 4 * 4;
        this.totalLength += this.indexLength;
        return this;
    }

    public FileHeader setEntries(int n) {
        this.entries = n;
        return this;
    }

    public FileHeader setUserHeaderLength(int length) {
        this.totalLength -= this.userHeaderLength + this.userHeaderLengthPadding;
        this.userHeaderLength = length;
        this.userHeaderLengthWords = FileHeader.getWords(length);
        this.userHeaderLengthPadding = FileHeader.getPadding(length);
        this.totalLength += this.userHeaderLength + this.userHeaderLengthPadding;
        return this;
    }

    public FileHeader setHeaderLength(int length) {
        this.headerLength = length;
        this.headerLengthWords = length / 4;
        return this;
    }

    public FileHeader setLength(int length) {
        this.totalLength = length;
        return this;
    }

    public void writeHeader(ByteBuffer buf, int off) throws HipoException {
        if (buf == null || buf.capacity() - off < 56) {
            throw new HipoException("null or too small buf arg");
        }
        buf.putInt(off, this.fileId);
        buf.putInt(4 + off, this.fileNumber);
        buf.putInt(8 + off, this.headerLengthWords);
        buf.putInt(12 + off, this.entries);
        buf.putInt(16 + off, this.indexLength);
        buf.putInt(20 + off, this.getBitInfoWord());
        buf.putInt(24 + off, this.userHeaderLength);
        buf.putInt(28 + off, this.headerMagicWord);
        buf.putLong(32 + off, this.userRegister);
        buf.putLong(40 + off, this.trailerPosition);
        buf.putInt(48 + off, this.userIntFirst);
        buf.putInt(52 + off, this.userIntSecond);
    }

    public void writeHeader(ByteBuffer buffer) throws HipoException {
        this.writeHeader(buffer, 0);
    }

    public static void writeTrailer(byte[] array, int recordNumber, ByteOrder order, byte[] index) throws HipoException {
        FileHeader.writeTrailer(array, 0, recordNumber, order, index);
    }

    public static void writeTrailer(byte[] array, int off, int recordNumber, ByteOrder order, byte[] index) throws HipoException {
        int indexLength = 0;
        int wholeLength = 56;
        if (index != null) {
            indexLength = index.length;
            wholeLength += indexLength;
        }
        if (array == null || array.length < wholeLength) {
            throw new HipoException("null or too small array arg");
        }
        int bitInfo = HeaderType.EVIO_TRAILER.getValue() << 28 | 0x400 | 6;
        try {
            ByteDataTransformer.toBytes(wholeLength, order, array, off);
            ByteDataTransformer.toBytes(recordNumber, order, array, 4 + off);
            ByteDataTransformer.toBytes(14, order, array, 8 + off);
            ByteDataTransformer.toBytes(0, order, array, 12 + off);
            ByteDataTransformer.toBytes(indexLength, order, array, 16 + off);
            ByteDataTransformer.toBytes(bitInfo, order, array, 20 + off);
            ByteDataTransformer.toBytes(0, order, array, 24 + off);
            ByteDataTransformer.toBytes(-1059454720, order, array, 28 + off);
            Arrays.fill(array, 32 + off, 56 + off, (byte)0);
            if (indexLength > 0) {
                System.arraycopy(index, 0, array, 56 + off, indexLength);
            }
        }
        catch (EvioException e) {
            // empty catch block
        }
    }

    public static void writeTrailer(ByteBuffer buf, int off, int recordNumber, ByteOrder order, byte[] index) throws HipoException {
        int indexLength = 0;
        int wholeLength = 56;
        if (index != null) {
            indexLength = index.length;
            wholeLength += indexLength;
        }
        if (buf == null || buf.capacity() - off < wholeLength) {
            throw new HipoException("null or too small buf arg");
        }
        if (buf.hasArray()) {
            FileHeader.writeTrailer(buf.array(), off, recordNumber, order, index);
        } else {
            int bitInfo = HeaderType.EVIO_TRAILER.getValue() << 28 | 0x400 | 6;
            buf.position(off);
            buf.putInt(wholeLength);
            buf.putInt(recordNumber);
            buf.putInt(14);
            buf.putInt(0);
            buf.putInt(bitInfo);
            buf.putInt(0);
            buf.putInt(-1059454720);
            buf.putLong(0L);
            buf.putLong(0L);
            buf.putLong(0L);
            if (indexLength > 0) {
                buf.put(index, 0, indexLength);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readHeader(ByteBuffer buffer, int offset) throws HipoException {
        if (buffer == null || buffer.capacity() - offset < 56) {
            throw new HipoException("null or too small buffer arg");
        }
        this.headerMagicWord = buffer.getInt(28 + offset);
        if (this.headerMagicWord != -1059454720) {
            if (this.headerMagicWord != HEADER_MAGIC_BE) throw new HipoException("buffer arg not in evio/hipo format");
            this.byteOrder = buffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            buffer.order(this.byteOrder);
        } else {
            this.byteOrder = buffer.order();
        }
        int bitInoWord = buffer.getInt(20 + offset);
        int version = bitInoWord & 0xFF;
        if (version < 6) {
            throw new HipoException("buffer is in evio format version " + version);
        }
        this.headerVersion = version;
        this.fileId = buffer.getInt(offset);
        this.fileNumber = buffer.getInt(4 + offset);
        this.headerLengthWords = buffer.getInt(8 + offset);
        this.setHeaderLength(4 * this.headerLengthWords);
        this.entries = buffer.getInt(12 + offset);
        this.indexLength = buffer.getInt(16 + offset);
        this.setIndexLength(this.indexLength);
        this.userHeaderLength = buffer.getInt(24 + offset);
        this.setUserHeaderLength(this.userHeaderLength);
        this.userRegister = buffer.getLong(32 + offset);
        this.trailerPosition = buffer.getLong(40 + offset);
        this.userIntFirst = buffer.getInt(48 + offset);
        this.userIntSecond = buffer.getInt(52 + offset);
    }

    public void readHeader(ByteBuffer buffer) throws HipoException {
        this.readHeader(buffer, 0);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("%24s : %d\n", "version", this.headerVersion));
        str.append(String.format("%24s : %d\n", "file #", this.fileNumber));
        str.append(String.format("%24s : %8d / %8d / %8d\n", "user header length", this.userHeaderLength, this.userHeaderLengthWords, this.userHeaderLengthPadding));
        str.append(String.format("%24s : %d\n", "header length", this.headerLength));
        str.append(String.format("%24s : 0x%X\n", "magic word", this.headerMagicWord));
        Integer bitInfo = this.getBitInfoWord();
        str.append(String.format("%24s : %s\n", "bit info word", Integer.toBinaryString(bitInfo)));
        str.append(String.format("%24s : %d\n", "record entries", this.entries));
        str.append(String.format("%24s : %d\n", "  index length", this.indexLength));
        str.append(String.format("%24s : %d\n", "trailer position", this.trailerPosition));
        str.append(String.format("%24s : %d\n", "user register", this.userRegister));
        str.append(String.format("%24s : %d\n", "user int #1", this.userIntFirst));
        str.append(String.format("%24s : %d\n", "user int #2", this.userIntSecond));
        return str.toString();
    }

    private static String padLeft(String original, String pad, int upTo) {
        int npadding = upTo - original.length();
        StringBuilder str = new StringBuilder();
        if (npadding > 0) {
            for (int i = 0; i < npadding; ++i) {
                str.append(pad);
            }
        }
        str.append(original);
        return str.toString();
    }

    public static void byteBufferBinaryString(ByteBuffer buffer) {
        int nwords = buffer.array().length / 4;
        for (int i = 0; i < nwords; ++i) {
            int value = buffer.getInt(i * 4);
            System.out.println(String.format("  word %4d : %36s  0x%8s : %18d", i, FileHeader.padLeft(Integer.toBinaryString(value), "0", 32), FileHeader.padLeft(Integer.toHexString(value), "0", 8), value));
        }
    }

    public static void main(String[] args) {
        FileHeader header = new FileHeader();
        header.setUserHeaderLength(459);
        header.setIndexLength(324);
        header.setUserRegister(123123123123123L);
        header.setUserIntFirst(1234567);
        header.setUserIntSecond(4567890);
        header.setFileNumber(23);
        header.setEntries(3245);
        header.setHeaderLength(14);
        System.out.println(header);
        byte[] array = new byte[56];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            header.writeHeader(buffer);
        }
        catch (HipoException e) {
            // empty catch block
        }
        FileHeader header2 = new FileHeader();
        try {
            header2.readHeader(buffer);
            System.out.println(header2);
        }
        catch (HipoException e) {
            e.printStackTrace();
        }
    }
}

