/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.coda.hipo.FileEventIndex;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.hipo.RecordInputStream;

public class BufferReader {
    private final List<RecordPosition> recordPositions = new ArrayList<RecordPosition>();
    private final RecordInputStream inputRecordStream = new RecordInputStream();
    private int currentRecordLoaded;
    private String dictionaryXML;
    private FileEventIndex eventIndex = new FileEventIndex();
    private RecordHeader firstHeader;
    private ByteBuffer dataBuffer;
    private int bufOffset;
    private int bufLimit;
    private int arrayOffset;

    public BufferReader(ByteBuffer buf) {
        this.setBuffer(buf);
    }

    public void setBuffer(ByteBuffer buf) {
        this.dataBuffer = buf;
        this.bufOffset = buf.position();
        this.bufLimit = buf.limit();
        if (buf.hasArray()) {
            this.arrayOffset = buf.arrayOffset();
        }
        this.scanBuffer();
    }

    public String getDictionary() {
        this.extractDictionary();
        return this.dictionaryXML;
    }

    public boolean hasDictionary() {
        return this.firstHeader.hasDictionary();
    }

    public int getEventCount() {
        return this.eventIndex.getMaxEvents();
    }

    public int getRecordCount() {
        return this.recordPositions.size();
    }

    public byte[] getNextEvent() throws HipoException {
        if (!this.eventIndex.canAdvance()) {
            return null;
        }
        if (this.eventIndex.advance()) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public byte[] getPrevEvent() throws HipoException {
        if (!this.eventIndex.canRetreat()) {
            return null;
        }
        if (this.eventIndex.retreat()) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public byte[] getEvent(int index) throws HipoException {
        if (index < 0 || index >= this.eventIndex.getMaxEvents()) {
            return null;
        }
        if (this.eventIndex.setEvent(index)) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public ByteBuffer getEvent(ByteBuffer buffer, int index) throws HipoException {
        if (index < 0 || index >= this.eventIndex.getMaxEvents()) {
            return null;
        }
        if (this.eventIndex.setEvent(index)) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(buffer, this.eventIndex.getRecordEventNumber());
    }

    public boolean hasNext() {
        return this.eventIndex.canAdvance();
    }

    public boolean hasPrev() {
        return this.eventIndex.canAdvance();
    }

    public int getRecordEventCount() {
        return this.inputRecordStream.getEntries();
    }

    public int getCurrentRecord() {
        return this.currentRecordLoaded;
    }

    public RecordInputStream getCurrentRecordStream() {
        return this.inputRecordStream;
    }

    public boolean readRecord(int index) throws HipoException {
        if (index >= 0 && index < this.recordPositions.size()) {
            RecordPosition pos = this.recordPositions.get(index);
            this.inputRecordStream.readRecord(this.dataBuffer, pos.getPosition());
            this.currentRecordLoaded = index;
            return true;
        }
        return false;
    }

    private void extractDictionary() {
        if (this.dictionaryXML != null || !this.firstHeader.hasDictionary()) {
            return;
        }
        int userLen = this.firstHeader.getUserHeaderLength();
        if (userLen < 12) {
            return;
        }
        int pos = this.bufOffset + this.firstHeader.getHeaderLength() + this.firstHeader.getIndexLength();
        if (this.dataBuffer.hasArray()) {
            try {
                this.dictionaryXML = new String(this.dataBuffer.array(), this.arrayOffset + pos, userLen, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            this.dataBuffer.position(pos);
            byte[] userBytes = new byte[userLen];
            this.dataBuffer.get(userBytes, 0, userLen);
            try {
                this.dictionaryXML = new String(userBytes, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    private void scanBuffer() {
        try {
            int offset;
            RecordHeader recordHeader = new RecordHeader();
            int maximumPos = this.bufLimit - 56;
            this.recordPositions.clear();
            for (int recordPosition = this.bufOffset; recordPosition < maximumPos; recordPosition += offset) {
                recordHeader.readHeader(this.dataBuffer, recordPosition);
                if (recordPosition == this.bufOffset) {
                    this.firstHeader = recordHeader;
                }
                offset = recordHeader.getLength();
                RecordPosition pos = new RecordPosition(recordPosition, offset, recordHeader.getEntries());
                this.recordPositions.add(pos);
                this.eventIndex.addEventSize(recordHeader.getEntries());
            }
        }
        catch (HipoException ex) {
            Logger.getLogger(BufferReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void show() {
        System.out.println(" ***** FILE: (info), RECORDS = " + this.recordPositions.size() + " *****");
        for (RecordPosition entry : this.recordPositions) {
            System.out.println(entry);
        }
    }

    public static void main(String[] args) {
        ByteBuffer buf = ByteBuffer.allocate(1000);
        BufferReader reader = new BufferReader(buf);
        byte[] eventarray = new byte[0x100000];
        ByteBuffer eventBuffer = ByteBuffer.wrap(eventarray);
        for (int i = 0; i < reader.getRecordCount(); ++i) {
            try {
                reader.readRecord(i);
                Thread.sleep(100L);
                int nevents = reader.getRecordCount();
                for (int k = 0; k < nevents; ++k) {
                    reader.getEvent(eventBuffer, k);
                }
                System.out.println("---> read record " + i);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(BufferReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static class RecordPosition {
        private int position;
        private int length;
        private int count;

        RecordPosition(int pos) {
            this.position = pos;
        }

        RecordPosition(int pos, int len, int cnt) {
            this.position = pos;
            this.length = len;
            this.count = cnt;
        }

        public RecordPosition setPosition(int pos) {
            this.position = pos;
            return this;
        }

        public RecordPosition setLength(int len) {
            this.length = len;
            return this;
        }

        public RecordPosition setCount(int cnt) {
            this.count = cnt;
            return this;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLength() {
            return this.length;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return String.format(" POSITION = %16d, LENGTH = %12d, COUNT = %8d", this.position, this.length, this.count);
        }
    }
}

