/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.Utilities;

public class CompactBuilderTest {
    int[] int1;
    byte[] byte1;
    short[] short1;
    long[] long1;
    float[] float1;
    double[] double1;
    String[] string1;
    int runLoops = 2;
    int bufferLoops = 20000;
    int dataElementCount = 3;
    int skip = 0;
    int bufSize = 200000;
    boolean oldEvio = false;
    boolean useBuf = false;
    ByteBuffer buffer;
    String writeFileName;
    String writeFileName1 = "/daqfs/home/timmer/coda/evioTestFiles/compactEvioBuild.ev";
    String writeFileName0 = "/daqfs/home/timmer/coda/evioTestFiles/compactEvioBuildOld.ev";
    String writeFileName2 = "/daqfs/home/timmer/coda/evioTestFiles/compactEvioNode.ev";
    ByteOrder order = ByteOrder.BIG_ENDIAN;

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                CompactBuilderTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-count")) {
                this.dataElementCount = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-loops")) {
                this.bufferLoops = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-size")) {
                this.bufSize = Integer.parseInt(args[i + 1]);
                System.out.println("SET buf size to " + this.bufSize);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-runs")) {
                this.runLoops = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skip")) {
                this.skip = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                this.writeFileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-little")) {
                this.order = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            if (args[i].equalsIgnoreCase("-old")) {
                this.oldEvio = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-buf")) {
                this.useBuf = true;
                continue;
            }
            CompactBuilderTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java CompactBuilderTest\n        [-count <elements>]  number of data elements of each type\n        [-loops <loops>]     number of times to loop\n        [-size <buf size>]   use buffer of this size (bytes)\n        [-runs <runs>]       number of runs\n        [-skip <skip>]       number of runs to skip before finding avg\n        [-f <file>]          output to file\n        [-little]            use little endian buffer\n        [-old]               use old (orig) evio interface\n        [-buf]               use buffer (not array) in new interface\n        [-h]                 print this help\n");
    }

    public CompactBuilderTest(String[] args) {
        this.decodeCommandLine(args);
        int tag = 1;
        int num = 1;
        byte[] array = new byte[this.bufSize];
        this.buffer = ByteBuffer.wrap(array);
        this.buffer.order(this.order);
        System.out.println("Running with:");
        System.out.println("  arraySize = " + this.dataElementCount);
        System.out.println("    bufSize = " + this.bufSize);
        System.out.println("      loops = " + this.bufferLoops);
        System.out.println("       runs = " + this.runLoops);
        System.out.println("     useBuf = " + this.useBuf);
        System.out.println("   old evio = " + this.oldEvio);
        this.setDataSize(this.dataElementCount);
        if (this.oldEvio) {
            this.createObjectEvents(tag, num);
        } else {
            this.createCompactEvents(tag, num, this.useBuf);
        }
    }

    public static void main(String[] args) {
        new CompactBuilderTest(args);
    }

    void setDataSize(int elementCount) {
        this.int1 = new int[elementCount];
        this.byte1 = new byte[elementCount];
        this.short1 = new short[elementCount];
        this.long1 = new long[elementCount];
        this.float1 = new float[elementCount];
        this.double1 = new double[elementCount];
        this.string1 = new String[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            this.int1[i] = i + 1;
            this.byte1[i] = (byte)((i + 1) % 127);
            this.short1[i] = (short)((i + 1) % Short.MAX_VALUE);
            this.long1[i] = i + 1;
            this.float1[i] = i + 1;
            this.double1[i] = i + 1;
            this.string1[i] = String.valueOf(i + 1);
        }
    }

    public EvioNode readFile(String filename, int tag, int num) {
        EvioNode node = null;
        try {
            EvioCompactReader reader = new EvioCompactReader(filename);
            ByteBuffer mappedBuf = reader.getByteBuffer();
            ByteBuffer arrayBuf = ByteBuffer.allocate(mappedBuf.capacity());
            arrayBuf.put(mappedBuf);
            arrayBuf.clear();
            System.out.println("arrayBuf has array = " + arrayBuf.hasArray());
            EvioCompactReader reader2 = new EvioCompactReader(arrayBuf);
            List<EvioNode> returnList = reader.searchEvent(1, tag, num);
            if (returnList.size() < 1) {
                System.out.println("GOT NOTHING IN SEARCH for ev 1, tag = " + tag + ", num = " + num);
                return null;
            }
            System.out.println("Found " + returnList.size() + " structs");
            node = returnList.get(0);
            return node;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void insertEvioNode(EvioNode node, int tag, int num, boolean useBuf) {
        try {
            long total = 0L;
            for (int j = 0; j < this.runLoops; ++j) {
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < this.bufferLoops; ++i) {
                    CompactEventBuilder builder = new CompactEventBuilder(this.buffer);
                    builder.openBank(tag, num, DataType.BANK);
                    builder.addEvioNode(node);
                    builder.closeAll();
                    if (i != 0 || this.writeFileName == null) continue;
                    builder.toFile(this.writeFileName);
                }
                long t2 = System.currentTimeMillis();
                System.out.println("Time = " + (t2 - t1) + " milliseconds");
                if (j < this.skip) continue;
                System.out.println("Total Time = " + (total += t2 - t1) + " milliseconds");
            }
            System.out.println("Avg Time = " + total / (long)(this.runLoops - this.skip) + " milliseconds");
            System.out.println("runs used = " + (this.runLoops - this.skip));
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public void createCompactEvents(int tag, int num, boolean useBuf) {
        try {
            for (int j = 0; j < this.runLoops; ++j) {
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < this.bufferLoops; ++i) {
                    CompactEventBuilder builder = new CompactEventBuilder(this.buffer);
                    builder.openBank(tag, num, DataType.BANK);
                    builder.openBank(tag + 1, num + 1, DataType.BANK);
                    builder.openBank(tag + 2, num + 2, DataType.INT32);
                    builder.addIntData(this.int1);
                    builder.closeStructure();
                    builder.openBank(tag + 3, num + 3, DataType.CHAR8);
                    builder.addByteData(this.byte1);
                    builder.closeStructure();
                    builder.openBank(tag + 4, num + 4, DataType.SHORT16);
                    builder.addShortData(this.short1);
                    builder.closeStructure();
                    builder.openBank(tag + 40, num + 40, DataType.LONG64);
                    builder.addLongData(this.long1);
                    builder.closeStructure();
                    builder.openBank(tag + 5, num + 5, DataType.FLOAT32);
                    builder.addFloatData(this.float1);
                    builder.closeStructure();
                    builder.openBank(tag + 6, num + 6, DataType.DOUBLE64);
                    builder.addDoubleData(this.double1);
                    builder.closeStructure();
                    builder.closeStructure();
                    builder.openBank(tag + 14, num + 14, DataType.SEGMENT);
                    builder.openSegment(tag + 8, DataType.INT32);
                    builder.addIntData(this.int1);
                    builder.closeStructure();
                    builder.openSegment(tag + 9, DataType.CHAR8);
                    builder.addByteData(this.byte1);
                    builder.closeStructure();
                    builder.openSegment(tag + 10, DataType.SHORT16);
                    builder.addShortData(this.short1);
                    builder.closeStructure();
                    builder.openSegment(tag + 40, DataType.LONG64);
                    builder.addLongData(this.long1);
                    builder.closeStructure();
                    builder.openSegment(tag + 11, DataType.FLOAT32);
                    builder.addFloatData(this.float1);
                    builder.closeStructure();
                    builder.openSegment(tag + 12, DataType.DOUBLE64);
                    builder.addDoubleData(this.double1);
                    builder.closeStructure();
                    builder.closeStructure();
                    builder.openBank(tag + 15, num + 15, DataType.TAGSEGMENT);
                    builder.openTagSegment(tag + 16, DataType.INT32);
                    builder.addIntData(this.int1);
                    builder.closeStructure();
                    builder.openTagSegment(tag + 17, DataType.CHAR8);
                    builder.addByteData(this.byte1);
                    builder.closeStructure();
                    builder.openTagSegment(tag + 18, DataType.SHORT16);
                    builder.addShortData(this.short1);
                    builder.closeStructure();
                    builder.openTagSegment(tag + 40, DataType.LONG64);
                    builder.addLongData(this.long1);
                    builder.closeStructure();
                    builder.openTagSegment(tag + 19, DataType.FLOAT32);
                    builder.addFloatData(this.float1);
                    builder.closeStructure();
                    builder.openTagSegment(tag + 20, DataType.DOUBLE64);
                    builder.addDoubleData(this.double1);
                    builder.closeStructure();
                    builder.closeAll();
                    if (i != 0 || this.writeFileName == null) continue;
                    builder.toFile(this.writeFileName);
                }
                long t2 = System.currentTimeMillis();
                System.out.println("Time = " + (t2 - t1) + " milliseconds");
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public void createLittleCompactEvent(int tag, int num, boolean useBuf) {
        try {
            CompactEventBuilder builder = new CompactEventBuilder(this.buffer);
            builder.openBank(tag, num, DataType.BANK);
            builder.openBank(tag + 1, num + 1, DataType.BANK);
            builder.openBank(tag + 2, num + 2, DataType.INT32);
            builder.addIntData(this.int1);
            builder.closeStructure();
            builder.closeAll();
            if (this.writeFileName != null) {
                builder.toFile(this.writeFileName);
            }
            System.out.println("DONE");
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public void createObjectEvents(int tag, int num) {
        try {
            for (int j = 0; j < this.runLoops; ++j) {
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < this.bufferLoops; ++i) {
                    EventBuilder builder = new EventBuilder(tag, DataType.BANK, num);
                    EvioEvent event = builder.getEvent();
                    EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, num + 1);
                    builder.addChild(event, bankBanks);
                    EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, num + 2);
                    bankInts.appendIntData(this.int1);
                    builder.addChild(bankBanks, bankInts);
                    EvioBank bankBytes = new EvioBank(tag + 3, DataType.CHAR8, num + 3);
                    bankBytes.appendByteData(this.byte1);
                    builder.addChild(bankBanks, bankBytes);
                    EvioBank bankShorts = new EvioBank(tag + 4, DataType.SHORT16, num + 4);
                    bankShorts.appendShortData(this.short1);
                    builder.addChild(bankBanks, bankShorts);
                    EvioBank bankLongs = new EvioBank(tag + 40, DataType.LONG64, num + 40);
                    bankLongs.appendLongData(this.long1);
                    builder.addChild(bankBanks, bankLongs);
                    EvioBank bankFloats = new EvioBank(tag + 5, DataType.FLOAT32, num + 5);
                    bankFloats.appendFloatData(this.float1);
                    builder.addChild(bankBanks, bankFloats);
                    EvioBank bankDoubles = new EvioBank(tag + 6, DataType.DOUBLE64, num + 6);
                    bankDoubles.appendDoubleData(this.double1);
                    builder.addChild(bankBanks, bankDoubles);
                    EvioBank bankSegs = new EvioBank(tag + 14, DataType.SEGMENT, num + 14);
                    builder.addChild(event, bankSegs);
                    EvioSegment segInts = new EvioSegment(tag + 8, DataType.INT32);
                    segInts.appendIntData(this.int1);
                    builder.addChild(bankSegs, segInts);
                    EvioSegment segBytes = new EvioSegment(tag + 9, DataType.CHAR8);
                    segBytes.appendByteData(this.byte1);
                    builder.addChild(bankSegs, segBytes);
                    EvioSegment segShorts = new EvioSegment(tag + 10, DataType.SHORT16);
                    segShorts.appendShortData(this.short1);
                    builder.addChild(bankSegs, segShorts);
                    EvioSegment segLongs = new EvioSegment(tag + 40, DataType.LONG64);
                    segLongs.appendLongData(this.long1);
                    builder.addChild(bankSegs, segLongs);
                    EvioSegment segFloats = new EvioSegment(tag + 11, DataType.FLOAT32);
                    segFloats.appendFloatData(this.float1);
                    builder.addChild(bankSegs, segFloats);
                    EvioSegment segDoubles = new EvioSegment(tag + 12, DataType.DOUBLE64);
                    segDoubles.appendDoubleData(this.double1);
                    builder.addChild(bankSegs, segDoubles);
                    EvioBank bankTsegs = new EvioBank(tag + 15, DataType.TAGSEGMENT, num + 15);
                    builder.addChild(event, bankTsegs);
                    EvioTagSegment tsegInts = new EvioTagSegment(tag + 16, DataType.INT32);
                    tsegInts.appendIntData(this.int1);
                    builder.addChild(bankTsegs, tsegInts);
                    EvioTagSegment tsegBytes = new EvioTagSegment(tag + 17, DataType.CHAR8);
                    tsegBytes.appendByteData(this.byte1);
                    builder.addChild(bankTsegs, tsegBytes);
                    EvioTagSegment tsegShorts = new EvioTagSegment(tag + 18, DataType.SHORT16);
                    tsegShorts.appendShortData(this.short1);
                    builder.addChild(bankTsegs, tsegShorts);
                    EvioTagSegment tsegLongs = new EvioTagSegment(tag + 40, DataType.LONG64);
                    tsegLongs.appendLongData(this.long1);
                    builder.addChild(bankTsegs, tsegLongs);
                    EvioTagSegment tsegFloats = new EvioTagSegment(tag + 19, DataType.FLOAT32);
                    tsegFloats.appendFloatData(this.float1);
                    builder.addChild(bankTsegs, tsegFloats);
                    EvioTagSegment tsegDoubles = new EvioTagSegment(tag + 20, DataType.DOUBLE64);
                    tsegDoubles.appendDoubleData(this.double1);
                    builder.addChild(bankTsegs, tsegDoubles);
                    event.write(this.buffer);
                    try {
                        this.buffer.flip();
                        if (i == 0 && this.writeFileName != null) {
                            Utilities.bufferToFile(this.writeFileName, this.buffer, true, true);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.buffer.clear();
                }
                long t2 = System.currentTimeMillis();
                System.out.println("Time = " + (t2 - t1) + " milliseconds");
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

