/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.StructureType;

public class EvioSegment
extends BaseStructure {
    public static final String ELEMENT_NAME = "segment";

    public EvioSegment() {
        this(new SegmentHeader());
    }

    public EvioSegment(SegmentHeader segmentHeader) {
        super(segmentHeader);
    }

    public EvioSegment(int tag, DataType dataType) {
        this(new SegmentHeader(tag, dataType));
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.SEGMENT;
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter) {
        this.toXML(xmlWriter, false);
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter, boolean hex) {
        try {
            this.commonXMLStart(xmlWriter);
            if (this.header.dataType.isStructure()) {
                xmlWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xmlWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType.getValue()));
            xmlWriter.writeAttribute("tag", "" + this.header.tag);
            xmlWriter.writeAttribute("length", "" + this.header.length);
            xmlWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xmlWriter, hex);
            this.decreaseXmlIndent();
            this.commonXMLClose(xmlWriter, hex);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

