/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.StructureType;

public class EvioBank
extends BaseStructure
implements Cloneable {
    public static final String ELEMENT_NAME = "bank";
    protected transient Object attachment;

    public EvioBank() {
        super(new BankHeader());
    }

    public EvioBank(BankHeader bankHeader) {
        super(bankHeader);
    }

    public EvioBank(int tag, DataType dataType, int num) {
        this(new BankHeader(tag, dataType, num));
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.BANK;
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter) {
        this.toXML(xmlWriter, false);
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter, boolean hex) {
        try {
            this.commonXMLStart(xmlWriter);
            if (this.header.dataType.isStructure()) {
                xmlWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xmlWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType.getValue()));
            xmlWriter.writeAttribute("tag", "" + this.header.tag);
            xmlWriter.writeAttribute("num", "" + this.header.number);
            xmlWriter.writeAttribute("length", "" + this.header.length);
            xmlWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xmlWriter, hex);
            this.decreaseXmlIndent();
            this.commonXMLClose(xmlWriter, hex);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }

    byte[] toArray() {
        byte[] bArray = new byte[this.rawBytes.length + this.header.getHeaderLength() * 4];
        this.header.toArray(bArray, 0, this.byteOrder);
        System.arraycopy(this.rawBytes, 0, bArray, this.header.getHeaderLength() * 4, this.rawBytes.length);
        return bArray;
    }

    @Override
    public Object clone() {
        EvioBank bank = (EvioBank)super.clone();
        bank.attachment = null;
        return bank;
    }
}

